/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.spark.SparkUpgradeException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.NoopFilters;
import org.apache.spark.sql.catalyst.OrderedFilters;
import org.apache.spark.sql.catalyst.StructFilters;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.BadRecordException;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t-h\u0001\u0002\u001a4\u0001\u0001C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t)\u0002\u0011\t\u0011)A\u0005\u001d\"AQ\u000b\u0001BC\u0002\u0013\u0005a\u000b\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003X\u0011!a\u0006A!A!\u0002\u0013i\u0006\"B8\u0001\t\u0003\u0001\b\"B8\u0001\t\u00031\b\"B8\u0001\t\u0003QX\u0001\u0002@\u0001\t}D\u0011\"a\u0007\u0001\u0005\u0004%I!!\b\t\u0011\u0005U\u0002\u0001)A\u0005\u0003?Aq!a\u000e\u0001\t\u0013\tI\u0004C\u0005\u0002B\u0001\u0011\r\u0011\"\u0003\u0002D!9\u0011Q\t\u0001!\u0002\u0013q\u0005\"CA$\u0001\t\u0007I\u0011AA%\u0011!\t\t\u0007\u0001Q\u0001\n\u0005-\u0003\"CA2\u0001\t\u0007I\u0011BA3\u0011!\tI\b\u0001Q\u0001\n\u0005\u001d\u0004\"CA>\u0001\t\u0007I\u0011BA?\u0011!\t)\t\u0001Q\u0001\n\u0005}\u0004BCAD\u0001!\u0015\r\u0011\"\u0003\u0002\n\"Q\u0011q\u0013\u0001\t\u0006\u0004%I!!#\t\u0015\u0005e\u0005\u0001#b\u0001\n\u0013\tY\nC\u0005\u0002$\u0002\u0011\r\u0011\"\u0003\u0002&\"A\u0011q\u0016\u0001!\u0002\u0013\t9\u000bC\u0005\u00022\u0002\u0011\r\u0011\"\u0003\u0002:!A\u00111\u0017\u0001!\u0002\u0013\tY\u0004C\u0005\u00026\u0002\u0011\r\u0011\"\u0003\u0002:!A\u0011q\u0017\u0001!\u0002\u0013\tY\u0004C\u0004\u0002:\u0002!I!a/\t\u0013\u0005-\u0007A1A\u0005\n\u00055\u0007\u0002CAk\u0001\u0001\u0006I!a4\t\u0013\u0005]\u0007A1A\u0005\n\u0005e\u0007\u0002CAu\u0001\u0001\u0006I!a7\t\u000f\u0005-\b\u0001\"\u0001\u0002n\"I!\u0011\u0001\u0001\u0012\u0002\u0013\u0005!1\u0001\u0005\b\u00053\u0001A\u0011\u0002B\u000e\u0011%\u0011i\u0003\u0001b\u0001\n\u0003\u0011y\u0003\u0003\u0005\u0003@\u0001\u0001\u000b\u0011\u0002B\u0019\u0011%\u0011\t\u0005\u0001b\u0001\n\u0013\u0011\u0019\u0005\u0003\u0005\u0003T\u0001\u0001\u000b\u0011\u0002B#\u0011\u001d\u0011)\u0006\u0001C\u0005\u0005/:\u0001B!\u00184\u0011\u00039$q\f\u0004\beMB\ta\u000eB1\u0011\u0019yG\u0006\"\u0001\u0003d!9!Q\r\u0017\u0005\u0002\t\u001d\u0004b\u0002BEY\u0011\u0005!1\u0012\u0005\b\u0005CcC\u0011\u0002BR\u0011\u001d\u0011Y\u000e\fC\u0001\u0005;\u0014q\"\u00168jm>\u001c\u0017\u000e^=QCJ\u001cXM\u001d\u0006\u0003iU\n1aY:w\u0015\t1t'\u0001\u0005dCR\fG._:u\u0015\tA\u0014(A\u0002tc2T!AO\u001e\u0002\u000bM\u0004\u0018M]6\u000b\u0005qj\u0014AB1qC\u000eDWMC\u0001?\u0003\ry'oZ\u0002\u0001'\r\u0001\u0011i\u0012\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\u0005![U\"A%\u000b\u0005)K\u0014\u0001C5oi\u0016\u0014h.\u00197\n\u00051K%a\u0002'pO\u001eLgnZ\u0001\u000bI\u0006$\u0018mU2iK6\f\u0007CA(S\u001b\u0005\u0001&BA)8\u0003\u0015!\u0018\u0010]3t\u0013\t\u0019\u0006K\u0001\u0006TiJ,8\r\u001e+za\u0016\faB]3rk&\u0014X\rZ*dQ\u0016l\u0017-A\u0004paRLwN\\:\u0016\u0003]\u0003\"\u0001W-\u000e\u0003MJ!AW\u001a\u0003\u0015\r\u001bfk\u00149uS>t7/\u0001\u0005paRLwN\\:!\u0003\u001d1\u0017\u000e\u001c;feN\u00042A\u00184j\u001d\tyFM\u0004\u0002aG6\t\u0011M\u0003\u0002c\u007f\u00051AH]8pizJ\u0011\u0001R\u0005\u0003K\u000e\u000bq\u0001]1dW\u0006<W-\u0003\u0002hQ\n\u00191+Z9\u000b\u0005\u0015\u001c\u0005C\u00016n\u001b\u0005Y'B\u000178\u0003\u001d\u0019x.\u001e:dKNL!A\\6\u0003\r\u0019KG\u000e^3s\u0003\u0019a\u0014N\\5u}Q)\u0011O]:ukB\u0011\u0001\f\u0001\u0005\u0006\u001b\u001a\u0001\rA\u0014\u0005\u0006)\u001a\u0001\rA\u0014\u0005\u0006+\u001a\u0001\ra\u0016\u0005\u00069\u001a\u0001\r!\u0018\u000b\u0005c^D\u0018\u0010C\u0003N\u000f\u0001\u0007a\nC\u0003U\u000f\u0001\u0007a\nC\u0003V\u000f\u0001\u0007q\u000bF\u0002rwvDQ\u0001 \u0005A\u00029\u000baa]2iK6\f\u0007\"B+\t\u0001\u00049&A\u0004,bYV,7i\u001c8wKJ$XM\u001d\t\b\u0005\u0006\u0005\u0011QAA\u000b\u0013\r\t\u0019a\u0011\u0002\n\rVt7\r^5p]F\u0002B!a\u0002\u0002\u00109!\u0011\u0011BA\u0006!\t\u00017)C\u0002\u0002\u000e\r\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\t\u0003'\u0011aa\u0015;sS:<'bAA\u0007\u0007B\u0019!)a\u0006\n\u0007\u0005e1IA\u0002B]f\fQ\u0002^8lK:Le\u000eZ3y\u0003J\u0014XCAA\u0010!\u0015\u0011\u0015\u0011EA\u0013\u0013\r\t\u0019c\u0011\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003O\t\t$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003\u0011a\u0017M\\4\u000b\u0005\u0005=\u0012\u0001\u00026bm\u0006LA!a\r\u0002*\t9\u0011J\u001c;fO\u0016\u0014\u0018A\u0004;pW\u0016t\u0017J\u001c3fq\u0006\u0013(\u000fI\u0001\u000eG>dW/\u001c8QeVt\u0017N\\4\u0016\u0005\u0005m\u0002c\u0001\"\u0002>%\u0019\u0011qH\"\u0003\u000f\t{w\u000e\\3b]\u0006a\u0001/\u0019:tK\u0012\u001c6\r[3nCV\ta*A\u0007qCJ\u001cX\rZ*dQ\u0016l\u0017\rI\u0001\ni>\\WM\\5{KJ,\"!a\u0013\u0011\t\u00055\u0013QL\u0007\u0003\u0003\u001fR1\u0001NA)\u0015\u0011\t\u0019&!\u0016\u0002\u000fA\f'o]3sg*!\u0011qKA-\u0003%)h.\u001b<pG&$\u0018P\u0003\u0002\u0002\\\u0005\u00191m\\7\n\t\u0005}\u0013q\n\u0002\n\u0007N4\b+\u0019:tKJ\f!\u0002^8lK:L'0\u001a:!\u0003-\u0011X-];je\u0016$'k\\<\u0016\u0005\u0005\u001d\u0004#\u0002\"\u0002j\u00055\u0014bAA6\u0007\n!1k\\7f!\u0011\ty'!\u001e\u000e\u0005\u0005E$bAA:k\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\t9(!\u001d\u0003%\u001d+g.\u001a:jG&sG/\u001a:oC2\u0014vn^\u0001\re\u0016\fX/\u001b:fIJ{w\u000fI\u0001\u0007]>\u0014vn^:\u0016\u0005\u0005}db\u0001\"\u0002\u0002&\u0019\u00111Q\"\u0002\t9{g.Z\u0001\b]>\u0014vn^:!\u0003I!\u0018.\\3ti\u0006l\u0007OR8s[\u0006$H/\u001a:\u0016\u0005\u0005-\u0005\u0003BAG\u0003'k!!a$\u000b\u0007\u0005EU'\u0001\u0003vi&d\u0017\u0002BAK\u0003\u001f\u0013!\u0003V5nKN$\u0018-\u001c9G_Jl\u0017\r\u001e;fe\u0006)B/[7fgR\fW\u000e\u001d(U5\u001a{'/\\1ui\u0016\u0014\u0018!\u00043bi\u00164uN]7biR,'/\u0006\u0002\u0002\u001eB!\u0011QRAP\u0013\u0011\t\t+a$\u0003\u001b\u0011\u000bG/\u001a$pe6\fG\u000f^3s\u0003)\u00197O\u001e$jYR,'o]\u000b\u0003\u0003O\u0003B!!+\u0002,6\tQ'C\u0002\u0002.V\u0012Qb\u0015;sk\u000e$h)\u001b7uKJ\u001c\u0018aC2tm\u001aKG\u000e^3sg\u0002\nQ%\u001a8bE2,\u0007+\u0019:tS:<g)\u00197mE\u0006\u001c7NR8s)&lWm\u001d;b[B$\u0016\u0010]3\u0002M\u0015t\u0017M\u00197f!\u0006\u00148/\u001b8h\r\u0006dGNY1dW\u001a{'\u000fV5nKN$\u0018-\u001c9UsB,\u0007%\u0001\u0011f]\u0006\u0014G.\u001a)beNLgn\u001a$bY2\u0014\u0017mY6G_J$\u0015\r^3UsB,\u0017!I3oC\ndW\rU1sg&twMR1mY\n\f7m\u001b$pe\u0012\u000bG/\u001a+za\u0016\u0004\u0013aD4fi\u000e+(O]3oi&s\u0007/\u001e;\u0016\u0005\u0005u\u0006\u0003BA`\u0003\u000fl!!!1\u000b\u0007E\u000b\u0019MC\u0002\u0002Ff\na!\u001e8tC\u001a,\u0017\u0002BAe\u0003\u0003\u0014!\"\u0016+GqM#(/\u001b8h\u0003=1\u0018\r\\;f\u0007>tg/\u001a:uKJ\u001cXCAAh!\u0015\u0011\u0015\u0011EAi!\r\t\u0019.C\u0007\u0002\u0001\u0005\u0001b/\u00197vK\u000e{gN^3si\u0016\u00148\u000fI\u0001\u000eI\u0016\u001c\u0017.\\1m!\u0006\u00148/\u001a:\u0016\u0005\u0005m\u0007c\u0002\"\u0002\u0002\u0005\u0015\u0011Q\u001c\t\u0005\u0003?\f)/\u0004\u0002\u0002b*!\u00111]A\u0017\u0003\u0011i\u0017\r\u001e5\n\t\u0005\u001d\u0018\u0011\u001d\u0002\u000b\u0005&<G)Z2j[\u0006d\u0017A\u00043fG&l\u0017\r\u001c)beN,'\u000fI\u0001\u000e[\u0006\\WmQ8om\u0016\u0014H/\u001a:\u0015\u0011\u0005E\u0017q^Az\u0003{Dq!!=$\u0001\u0004\t)!\u0001\u0003oC6,\u0007bBA{G\u0001\u0007\u0011q_\u0001\tI\u0006$\u0018\rV=qKB\u0019q*!?\n\u0007\u0005m\bK\u0001\u0005ECR\fG+\u001f9f\u0011%\typ\tI\u0001\u0002\u0004\tY$\u0001\u0005ok2d\u0017M\u00197f\u0003]i\u0017m[3D_:4XM\u001d;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0006)\"\u00111\bB\u0004W\t\u0011I\u0001\u0005\u0003\u0003\f\tUQB\u0001B\u0007\u0015\u0011\u0011yA!\u0005\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\n\u0007\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t]!Q\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00048vY2\u001c\u0016MZ3ECR,X\u000e\u0006\u0006\u0003\u001e\t\r\"q\u0005B\u0015\u0005W!B!!\u0006\u0003 !9!\u0011E\u0013A\u0002\u0005E\u0017!C2p]Z,'\u000f^3s\u0011\u001d\u0011)#\na\u0001\u0003\u000b\tQ\u0001Z1uk6Dq!!=&\u0001\u0004\t)\u0001C\u0004\u0002\u0000\u0016\u0002\r!a\u000f\t\u000bU+\u0003\u0019A,\u0002\u000bA\f'o]3\u0016\u0005\tE\u0002c\u0002\"\u0002\u0002\u0005\u0015!1\u0007\t\u0006\u0005\nU\"\u0011H\u0005\u0004\u0005o\u0019%AB(qi&|g\u000e\u0005\u0003\u0002*\nm\u0012b\u0001B\u001fk\tY\u0011J\u001c;fe:\fGNU8x\u0003\u0019\u0001\u0018M]:fA\u0005Aq-\u001a;U_.,g.\u0006\u0002\u0003FAI!Ia\u0012\u0003L\t5\u0013QA\u0005\u0004\u0005\u0013\u001a%!\u0003$v]\u000e$\u0018n\u001c83!\u0015\u0011\u0015\u0011EA\u0003!\r\u0011%qJ\u0005\u0004\u0005#\u001a%aA%oi\u0006Iq-\u001a;U_.,g\u000eI\u0001\bG>tg/\u001a:u)\u0011\u0011\u0019D!\u0017\t\u000f\tm#\u00061\u0001\u0003L\u00051Ao\\6f]N\fq\"\u00168jm>\u001c\u0017\u000e^=QCJ\u001cXM\u001d\t\u000312\u001a\"\u0001L!\u0015\u0005\t}\u0013A\u0004;pW\u0016t\u0017N_3TiJ,\u0017-\u001c\u000b\u000b\u0005S\u0012yGa \u0003\u0004\n\u0015\u0005#\u00020\u0003l\t-\u0013b\u0001B7Q\nA\u0011\n^3sCR|'\u000fC\u0004\u0003r9\u0002\rAa\u001d\u0002\u0017%t\u0007/\u001e;TiJ,\u0017-\u001c\t\u0005\u0005k\u0012Y(\u0004\u0002\u0003x)!!\u0011PA\u0017\u0003\tIw.\u0003\u0003\u0003~\t]$aC%oaV$8\u000b\u001e:fC6DqA!!/\u0001\u0004\tY$\u0001\ttQ>,H\u000e\u001a#s_BDU-\u00193fe\"9\u0011q\t\u0018A\u0002\u0005-\u0003b\u0002BD]\u0001\u0007\u0011QA\u0001\tK:\u001cw\u000eZ5oO\u0006Y\u0001/\u0019:tKN#(/Z1n))\u0011iIa$\u0003\u0012\nU%q\u0014\t\u0006=\n-$\u0011\b\u0005\b\u0005cz\u0003\u0019\u0001B:\u0011\u0019\u0011\u0019j\fa\u0001c\u00061\u0001/\u0019:tKJDqAa&0\u0001\u0004\u0011I*A\u0007iK\u0006$WM]\"iK\u000e\\WM\u001d\t\u00041\nm\u0015b\u0001BOg\t\u00012i\u0015,IK\u0006$WM]\"iK\u000e\\WM\u001d\u0005\u0006y>\u0002\rAT\u0001\u000eG>tg/\u001a:u'R\u0014X-Y7\u0016\t\t\u0015&Q\u0017\u000b\u000b\u0005O\u0013)Ma2\u0003J\neG\u0003\u0002BU\u0005\u0003\u0014RAa+B\u0005_3aA!,1\u0001\t%&\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004#\u00020\u0003l\tE\u0006\u0003\u0002BZ\u0005kc\u0001\u0001B\u0004\u00038B\u0012\rA!/\u0003\u0003Q\u000bBAa/\u0002\u0016A\u0019!I!0\n\u0007\t}6IA\u0004O_RD\u0017N\\4\t\u000f\tU\u0003\u00071\u0001\u0003DB9!)!\u0001\u0003L\tE\u0006b\u0002B9a\u0001\u0007!1\u000f\u0005\b\u0003\u000f\u0002\u0004\u0019AA&\u0011\u001d\u0011Y\r\ra\u0001\u0005\u001b\fA\u0002[1oI2,\u0007*Z1eKJ\u0004RA\u0011Bh\u0005'L1A!5D\u0005%1UO\\2uS>t\u0007\u0007E\u0002C\u0005+L1Aa6D\u0005\u0011)f.\u001b;\t\u000f\t\u001d\u0005\u00071\u0001\u0002\u0006\u0005i\u0001/\u0019:tK&#XM]1u_J$\"B!$\u0003`\n\u0015(q\u001dBu\u0011\u001d\u0011\t/\ra\u0001\u0005G\fQ\u0001\\5oKN\u0004RA\u0018B6\u0003\u000bAaAa%2\u0001\u0004\t\bb\u0002BLc\u0001\u0007!\u0011\u0014\u0005\u0006yF\u0002\rA\u0014")
public class UnivocityParser
implements Logging {
    private TimestampFormatter timestampFormatter;
    private TimestampFormatter timestampNTZFormatter;
    private DateFormatter dateFormatter;
    private final StructType dataSchema;
    private final StructType requiredSchema;
    private final CSVOptions options;
    private final Integer[] tokenIndexArr;
    private final StructType parsedSchema;
    private final CsvParser tokenizer;
    private final Some<GenericInternalRow> requiredRow;
    private final None$ noRows;
    private final StructFilters csvFilters;
    private final boolean enableParsingFallbackForTimestampType;
    private final boolean enableParsingFallbackForDateType;
    private final Function1<String, Object>[] valueConverters;
    private final Function1<String, BigDecimal> decimalParser;
    private final Function1<String, Option<InternalRow>> parse;
    private final Function2<String[], Object, String> getToken;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Iterator<InternalRow> parseIterator(Iterator<String> lines, UnivocityParser parser, CSVHeaderChecker headerChecker, StructType schema) {
        return UnivocityParser$.MODULE$.parseIterator(lines, parser, headerChecker, schema);
    }

    public static Iterator<InternalRow> parseStream(InputStream inputStream, UnivocityParser parser, CSVHeaderChecker headerChecker, StructType schema) {
        return UnivocityParser$.MODULE$.parseStream(inputStream, parser, headerChecker, schema);
    }

    public static Iterator<String[]> tokenizeStream(InputStream inputStream, boolean shouldDropHeader, CsvParser tokenizer, String encoding) {
        return UnivocityParser$.MODULE$.tokenizeStream(inputStream, shouldDropHeader, tokenizer, encoding);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public CSVOptions options() {
        return this.options;
    }

    private Integer[] tokenIndexArr() {
        return this.tokenIndexArr;
    }

    private boolean columnPruning() {
        return this.options().isColumnPruningEnabled() && !this.requiredSchema.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)UnivocityParser.$anonfun$columnPruning$1(x$1)));
    }

    private StructType parsedSchema() {
        return this.parsedSchema;
    }

    public CsvParser tokenizer() {
        return this.tokenizer;
    }

    private Some<GenericInternalRow> requiredRow() {
        return this.requiredRow;
    }

    private None$ noRows() {
        return this.noRows;
    }

    private TimestampFormatter timestampFormatter$lzycompute() {
        UnivocityParser univocityParser = this;
        synchronized (univocityParser) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.timestampFormatter = TimestampFormatter$.MODULE$.apply(this.options().timestampFormatInRead(), this.options().zoneId(), this.options().locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampFormatter() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.timestampFormatter$lzycompute() : this.timestampFormatter;
    }

    private TimestampFormatter timestampNTZFormatter$lzycompute() {
        UnivocityParser univocityParser = this;
        synchronized (univocityParser) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(this.options().timestampNTZFormatInRead(), this.options().zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true, true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.timestampNTZFormatter;
    }

    private TimestampFormatter timestampNTZFormatter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.timestampNTZFormatter$lzycompute() : this.timestampNTZFormatter;
    }

    private DateFormatter dateFormatter$lzycompute() {
        UnivocityParser univocityParser = this;
        synchronized (univocityParser) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.dateFormatter = DateFormatter$.MODULE$.apply(this.options().dateFormatInRead(), this.options().locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.dateFormatter;
    }

    private DateFormatter dateFormatter() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.dateFormatter$lzycompute() : this.dateFormatter;
    }

    private StructFilters csvFilters() {
        return this.csvFilters;
    }

    private boolean enableParsingFallbackForTimestampType() {
        return this.enableParsingFallbackForTimestampType;
    }

    private boolean enableParsingFallbackForDateType() {
        return this.enableParsingFallbackForDateType;
    }

    private UTF8String getCurrentInput() {
        String currentContent = this.tokenizer().getContext().currentParsedContent();
        return currentContent == null ? null : UTF8String.fromString((String)StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(currentContent)));
    }

    private Function1<String, Object>[] valueConverters() {
        return this.valueConverters;
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    public Function1<String, Object> makeConverter(String name, DataType dataType, boolean nullable) {
        Function1<String, Object> function1;
        DataType dataType2 = dataType;
        if (dataType2 instanceof ByteType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$2 -> BoxesRunTime.boxToByte((byte)StringOps$.MODULE$.toByte$extension(Predef$.MODULE$.augmentString(x$2))));
        } else if (dataType2 instanceof ShortType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$3 -> BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(x$3))));
        } else if (dataType2 instanceof IntegerType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$4))));
        } else if (dataType2 instanceof LongType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$5))));
        } else if (dataType2 instanceof FloatType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x0$1 -> {
                Float f;
                String string = x0$1;
                String string2 = this.options().nanValue();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    f = BoxesRunTime.boxToFloat((float)Float.NaN);
                } else {
                    String string4 = this.options().negativeInf();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        f = BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY);
                    } else {
                        String string6 = this.options().positiveInf();
                        String string7 = string;
                        f = !(string6 != null ? !string6.equals(string7) : string7 != null) ? BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY) : BoxesRunTime.boxToFloat((float)StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(string)));
                    }
                }
                return f;
            });
        } else if (dataType2 instanceof DoubleType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x0$2 -> {
                Double d;
                String string = x0$2;
                String string2 = this.options().nanValue();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    d = BoxesRunTime.boxToDouble((double)Double.NaN);
                } else {
                    String string4 = this.options().negativeInf();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        d = BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY);
                    } else {
                        String string6 = this.options().positiveInf();
                        String string7 = string;
                        d = !(string6 != null ? !string6.equals(string7) : string7 != null) ? BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY) : BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(string)));
                    }
                }
                return d;
            });
        } else if (dataType2 instanceof BooleanType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$6))));
        } else if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> Decimal$.MODULE$.apply((BigDecimal)this.decimalParser().apply(datum), decimalType.precision(), decimalType.scale()));
        } else if (dataType2 instanceof DateType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> {
                Object object;
                try {
                    object = BoxesRunTime.boxToInteger((int)this.dateFormatter().parse(datum));
                }
                catch (Throwable throwable) {
                    Throwable e;
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        e = (Throwable)option.get();
                        if (!this.enableParsingFallbackForDateType()) {
                            throw e;
                        }
                    } else {
                        throw throwable;
                    }
                    UTF8String str = DateTimeUtils$.MODULE$.cleanLegacyTimestampStr(UTF8String.fromString((String)datum));
                    Object object2 = DateTimeUtils$.MODULE$.stringToDate(str).getOrElse((Function0 & Serializable)() -> {
                        throw e;
                    });
                    object = object2;
                }
                return object;
            });
        } else if (dataType2 instanceof TimestampType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> {
                Object object;
                try {
                    object = BoxesRunTime.boxToLong((long)this.timestampFormatter().parse(datum));
                }
                catch (Throwable throwable) {
                    Throwable e;
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        e = (Throwable)option.get();
                        if (!this.enableParsingFallbackForTimestampType()) {
                            throw e;
                        }
                    } else {
                        throw throwable;
                    }
                    UTF8String str = DateTimeUtils$.MODULE$.cleanLegacyTimestampStr(UTF8String.fromString((String)datum));
                    Object object2 = DateTimeUtils$.MODULE$.stringToTimestamp(str, this.options().zoneId()).getOrElse((Function0 & Serializable)() -> {
                        throw e;
                    });
                    object = object2;
                }
                return object;
            });
        } else if (dataType2 instanceof TimestampNTZType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> BoxesRunTime.boxToLong((long)UnivocityParser.$anonfun$makeConverter$24(this, datum)));
        } else if (dataType2 instanceof StringType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$1 -> UTF8String.fromString((String)x$1));
        } else if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> IntervalUtils$.MODULE$.safeStringToInterval(UTF8String.fromString((String)datum)));
        } else if (dataType2 instanceof YearMonthIntervalType) {
            YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType2;
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> new Cast(Literal$.MODULE$.apply(datum), (DataType)yearMonthIntervalType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()).eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow()));
        } else if (dataType2 instanceof DayTimeIntervalType) {
            DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType2;
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> new Cast(Literal$.MODULE$.apply(datum), (DataType)dayTimeIntervalType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()).eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow()));
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            function1 = this.makeConverter(name, userDefinedType.sqlType(), nullable);
        } else {
            throw QueryExecutionErrors$.MODULE$.unsupportedTypeError(dataType);
        }
        return function1;
    }

    public boolean makeConverter$default$3() {
        return true;
    }

    private Object nullSafeDatum(String datum, String name, boolean nullable, CSVOptions options, Function1<String, Object> converter) {
        Object object;
        String string = datum;
        String string2 = options.nullValue();
        if (!(string == null ? string2 != null : !string.equals(string2)) || datum == null) {
            if (!nullable) {
                throw QueryExecutionErrors$.MODULE$.foundNullValueForNotNullableFieldError(name);
            }
            object = null;
        } else {
            object = converter.apply((Object)datum);
        }
        return object;
    }

    public Function1<String, Option<InternalRow>> parse() {
        return this.parse;
    }

    private Function2<String[], Object, String> getToken() {
        return this.getToken;
    }

    public Option<InternalRow> org$apache$spark$sql$catalyst$csv$UnivocityParser$$convert(String[] tokens) {
        Some<GenericInternalRow> some;
        if (tokens == null) {
            throw new BadRecordException((Function0<UTF8String>)(Function0 & Serializable)() -> this.getCurrentInput(), (Function0<InternalRow[]>)(Function0 & Serializable)() -> (InternalRow[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InternalRow.class)), (Throwable)QueryExecutionErrors$.MODULE$.malformedCSVRecordError(""));
        }
        UTF8String currentInput = this.getCurrentInput();
        None$ badRecordException = tokens.length != this.parsedSchema().length() ? new Some((Object)QueryExecutionErrors$.MODULE$.malformedCSVRecordError(currentInput.toString())) : None$.MODULE$;
        GenericInternalRow row = (GenericInternalRow)this.requiredRow().get();
        boolean skipRow = false;
        for (int i = 0; i < this.requiredSchema.length(); ++i) {
            try {
                if (skipRow) {
                    row.setNullAt(i);
                    continue;
                }
                row.update(i, this.valueConverters()[i].apply(this.getToken().apply((Object)tokens, (Object)BoxesRunTime.boxToInteger((int)i))));
                if (!this.csvFilters().skipRow(row, i)) continue;
                skipRow = true;
                continue;
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof SparkUpgradeException) {
                    SparkUpgradeException sparkUpgradeException = (SparkUpgradeException)throwable2;
                    throw sparkUpgradeException;
                }
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    badRecordException = badRecordException.orElse((Function0 & Serializable)() -> new Some((Object)e));
                    row.update(i, ResolveDefaultColumns$.MODULE$.existenceDefaultValues(this.requiredSchema)[i]);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw throwable;
            }
        }
        if (skipRow) {
            some = this.noRows();
        } else {
            if (badRecordException.isDefined()) {
                throw new BadRecordException((Function0<UTF8String>)(Function0 & Serializable)() -> currentInput, (Function0<InternalRow[]>)(Function0 & Serializable)() -> (InternalRow[])((Object[])new InternalRow[]{(InternalRow)this.requiredRow().get()}), (Throwable)badRecordException.get());
            }
            some = this.requiredRow();
        }
        return some;
    }

    public static final /* synthetic */ boolean $anonfun$columnPruning$1(StructField x$1) {
        return x$1.metadata().contains(ResolveDefaultColumns$.MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY());
    }

    public static final /* synthetic */ long $anonfun$makeConverter$24(UnivocityParser $this, String datum) {
        return $this.timestampNTZFormatter().parseWithoutTimeZone(datum, false);
    }

    public static final /* synthetic */ String $anonfun$getToken$1(String[] tokens, int index) {
        return tokens[index];
    }

    public static final /* synthetic */ String $anonfun$getToken$2(UnivocityParser $this, String[] tokens, int index) {
        return tokens[Predef$.MODULE$.Integer2int($this.tokenIndexArr()[index])];
    }

    public UnivocityParser(StructType dataSchema, StructType requiredSchema, CSVOptions options, Seq<Filter> filters) {
        this.dataSchema = dataSchema;
        this.requiredSchema = requiredSchema;
        this.options = options;
        Logging.$init$((Logging)this);
        Predef$.MODULE$.require(requiredSchema.toSet().subsetOf((Set)dataSchema.toSet()), (Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(42).append("requiredSchema (").append($this.requiredSchema.catalogString()).append(") should be the subset of ").toString()).append(new StringBuilder(14).append("dataSchema (").append($this.dataSchema.catalogString()).append(").").toString()).toString());
        this.tokenIndexArr = (Integer[])((IterableOnceOps)requiredSchema.map((Function1 & Serializable)f -> $this.dataSchema.indexOf(f))).toArray(ClassTag$.MODULE$.apply(Integer.class));
        this.parsedSchema = this.columnPruning() ? requiredSchema : dataSchema;
        CsvParserSettings parserSetting = options.asParserSettings();
        Object object = this.parsedSchema().length() < dataSchema.length() ? parserSetting.selectIndexes(this.tokenIndexArr()) : BoxedUnit.UNIT;
        this.tokenizer = new CsvParser(parserSetting);
        this.requiredRow = new Some((Object)new GenericInternalRow(requiredSchema.length()));
        this.noRows = None$.MODULE$;
        this.csvFilters = SQLConf$.MODULE$.get().csvFilterPushDown() ? new OrderedFilters(filters, requiredSchema) : new NoopFilters();
        this.enableParsingFallbackForTimestampType = BoxesRunTime.unboxToBoolean((Object)options.enableDateTimeParsingFallback().orElse((Function0 & Serializable)() -> SQLConf$.MODULE$.get().csvEnableDateTimeParsingFallback()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            Enumeration.Value value = SQLConf$.MODULE$.get().legacyTimeParserPolicy();
            Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
            return !(value == null ? value2 != null : !value.equals(value2)) || this.options().timestampFormatInRead().isEmpty();
        }));
        this.enableParsingFallbackForDateType = BoxesRunTime.unboxToBoolean((Object)options.enableDateTimeParsingFallback().orElse((Function0 & Serializable)() -> SQLConf$.MODULE$.get().csvEnableDateTimeParsingFallback()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            Enumeration.Value value = SQLConf$.MODULE$.get().legacyTimeParserPolicy();
            Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
            return !(value == null ? value2 != null : !value.equals(value2)) || this.options().dateFormatOption().isEmpty();
        }));
        this.valueConverters = (Function1[])((IterableOnceOps)requiredSchema.map((Function1 & Serializable)f -> this.makeConverter(f.name(), f.dataType(), f.nullable()))).toArray(ClassTag$.MODULE$.apply(Function1.class));
        this.decimalParser = ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.parse = this.columnPruning() && requiredSchema.isEmpty() ? (Function1 & Serializable)x$7 -> new Some((Object)InternalRow$.MODULE$.empty()) : (Function1 & Serializable)input -> this.org$apache$spark$sql$catalyst$csv$UnivocityParser$$convert(this.tokenizer().parseLine(input));
        this.getToken = this.columnPruning() ? (Function2 & Serializable)(tokens, index) -> UnivocityParser.$anonfun$getToken$1(tokens, BoxesRunTime.unboxToInt((Object)index)) : (Function2 & Serializable)(tokens, index) -> UnivocityParser.$anonfun$getToken$2(this, tokens, BoxesRunTime.unboxToInt((Object)index));
    }

    public UnivocityParser(StructType dataSchema, StructType requiredSchema, CSVOptions options) {
        this(dataSchema, requiredSchema, options, (Seq<Filter>)((Seq)package$.MODULE$.Seq().empty()));
    }

    public UnivocityParser(StructType schema, CSVOptions options) {
        this(schema, schema, options);
    }
}

