/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.FunctionIdentifier$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.AlterDatabaseEvent;
import org.apache.spark.sql.catalyst.catalog.AlterDatabasePreEvent;
import org.apache.spark.sql.catalyst.catalog.AlterFunctionEvent;
import org.apache.spark.sql.catalyst.catalog.AlterFunctionPreEvent;
import org.apache.spark.sql.catalyst.catalog.AlterTableEvent;
import org.apache.spark.sql.catalyst.catalog.AlterTableKind$;
import org.apache.spark.sql.catalyst.catalog.AlterTablePreEvent;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CreateDatabaseEvent;
import org.apache.spark.sql.catalyst.catalog.CreateDatabasePreEvent;
import org.apache.spark.sql.catalyst.catalog.CreateFunctionEvent;
import org.apache.spark.sql.catalyst.catalog.CreateFunctionPreEvent;
import org.apache.spark.sql.catalyst.catalog.CreateTableEvent;
import org.apache.spark.sql.catalyst.catalog.CreateTablePreEvent;
import org.apache.spark.sql.catalyst.catalog.DropDatabaseEvent;
import org.apache.spark.sql.catalyst.catalog.DropDatabasePreEvent;
import org.apache.spark.sql.catalyst.catalog.DropFunctionEvent;
import org.apache.spark.sql.catalyst.catalog.DropFunctionPreEvent;
import org.apache.spark.sql.catalyst.catalog.DropTableEvent;
import org.apache.spark.sql.catalyst.catalog.DropTablePreEvent;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogEvent;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogWithListener;
import org.apache.spark.sql.catalyst.catalog.InMemoryCatalog;
import org.apache.spark.sql.catalyst.catalog.InMemoryCatalog$;
import org.apache.spark.sql.catalyst.catalog.RenameFunctionEvent;
import org.apache.spark.sql.catalyst.catalog.RenameFunctionPreEvent;
import org.apache.spark.sql.catalyst.catalog.RenameTableEvent;
import org.apache.spark.sql.catalyst.catalog.RenameTablePreEvent;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005%4Aa\u0002\u0005\u0001+!)!\u0004\u0001C\u00017!)a\u0004\u0001C\t?!)1\u0005\u0001C\u0005I!)Q\n\u0001C\u0005\u001d\")Q\n\u0001C\u00059\")Q\f\u0001C\u0005=\nIR\t\u001f;fe:\fGnQ1uC2|w-\u0012<f]R\u001cV/\u001b;f\u0015\tI!\"A\u0004dCR\fGn\\4\u000b\u0005-a\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u00055q\u0011aA:rY*\u0011q\u0002E\u0001\u0006gB\f'o\u001b\u0006\u0003#I\ta!\u00199bG\",'\"A\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u0019\u001b\u0005q\u0011BA\r\u000f\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012\u0001\b\t\u0003;\u0001i\u0011\u0001C\u0001\u000b]\u0016<8)\u0019;bY><W#\u0001\u0011\u0011\u0005u\t\u0013B\u0001\u0012\t\u0005=)\u0005\u0010^3s]\u0006d7)\u0019;bY><\u0017a\u0004;fgR<\u0016\u000e\u001e5DCR\fGn\\4\u0015\u0005\u0015\u001aEC\u0001\u0014-!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u0011)f.\u001b;\t\u000b5\u001a\u0001\u0019\u0001\u0018\u0002\u0003\u0019\u0004RaJ\u0018!c\u0019J!\u0001\r\u0015\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004\u0003B\u00143i\u0019J!a\r\u0015\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA\u001b>\u0001:\u0011ag\u000f\b\u0003oij\u0011\u0001\u000f\u0006\u0003sQ\ta\u0001\u0010:p_Rt\u0014\"A\u0015\n\u0005qB\u0013a\u00029bG.\fw-Z\u0005\u0003}}\u00121aU3r\u0015\ta\u0004\u0006\u0005\u0002\u001e\u0003&\u0011!\t\u0003\u0002\u0015\u000bb$XM\u001d8bY\u000e\u000bG/\u00197pO\u00163XM\u001c;\t\u000b\u0011\u001b\u0001\u0019A#\u0002\t9\fW.\u001a\t\u0003\r*s!a\u0012%\u0011\u0005]B\u0013BA%)\u0003\u0019\u0001&/\u001a3fM&\u00111\n\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%C\u0013AE2sK\u0006$X\r\u00122EK\u001aLg.\u001b;j_:$\"a\u0014*\u0011\u0005u\u0001\u0016BA)\t\u0005=\u0019\u0015\r^1m_\u001e$\u0015\r^1cCN,\u0007\"B*\u0005\u0001\u0004!\u0016aA;sSB\u0011QKW\u0007\u0002-*\u0011q\u000bW\u0001\u0004]\u0016$(\"A-\u0002\t)\fg/Y\u0005\u00037Z\u00131!\u0016*J)\u0005y\u0015a\u00039sKB\f'/\u001a)bi\"$\"\u0001V0\t\u000b\u00014\u0001\u0019A1\u0002\tA\fG\u000f\u001b\t\u0003E\u001el\u0011a\u0019\u0006\u0003I\u0016\fAAZ5mK*\u0011a\rW\u0001\u0004]&|\u0017B\u00015d\u0005\u0011\u0001\u0016\r\u001e5")
public class ExternalCatalogEventSuite
extends SparkFunSuite {
    public ExternalCatalog newCatalog() {
        return new InMemoryCatalog(InMemoryCatalog$.MODULE$.$lessinit$greater$default$1(), InMemoryCatalog$.MODULE$.$lessinit$greater$default$2());
    }

    private void testWithCatalog(String name, Function2<ExternalCatalog, Function1<Seq<ExternalCatalogEvent>, BoxedUnit>, BoxedUnit> f) {
        this.test(name, (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ExternalCatalogWithListener catalog = new ExternalCatalogWithListener(this.newCatalog());
            Buffer recorder = (Buffer)Buffer$.MODULE$.empty();
            catalog.addListener(event -> recorder.$plus$eq((Object)event));
            f.apply((Object)catalog, (Function1 & Serializable)expected -> {
                ExternalCatalogEventSuite.$anonfun$testWithCatalog$3(this, recorder, expected);
                return BoxedUnit.UNIT;
            });
        }, new Position("ExternalCatalogEventSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
    }

    private CatalogDatabase createDbDefinition(URI uri) {
        return new CatalogDatabase("db5", "", uri, Predef$.MODULE$.Map().empty());
    }

    private CatalogDatabase createDbDefinition() {
        return this.createDbDefinition(this.preparePath(Files.createTempDirectory("db_", new FileAttribute[0])));
    }

    private URI preparePath(Path path) {
        return path.normalize().toUri();
    }

    public static final /* synthetic */ void $anonfun$testWithCatalog$3(ExternalCatalogEventSuite $this, Buffer recorder$1, Seq expected) {
        Buffer actual = (Buffer)recorder$1.clone();
        recorder$1.clear();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(expected);
        Buffer $org_scalatest_assert_macro_right = actual;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogEventSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
    }

    public static final /* synthetic */ void $anonfun$new$1(ExternalCatalogEventSuite $this, ExternalCatalog catalog, Function1 checkEvents) {
        CatalogDatabase dbDefinition = $this.createDbDefinition();
        catalog.createDatabase(dbDefinition, false);
        CreateDatabasePreEvent createDatabasePreEvent = new CreateDatabasePreEvent("db5");
        CreateDatabaseEvent createDatabaseEvent = new CreateDatabaseEvent("db5");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)createDatabaseEvent).$colon$colon((Object)createDatabasePreEvent));
        catalog.createDatabase(dbDefinition, true);
        CreateDatabasePreEvent createDatabasePreEvent2 = new CreateDatabasePreEvent("db5");
        CreateDatabaseEvent createDatabaseEvent2 = new CreateDatabaseEvent("db5");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)createDatabaseEvent2).$colon$colon((Object)createDatabasePreEvent2));
        $this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.createDatabase(dbDefinition, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogEventSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        CreateDatabasePreEvent createDatabasePreEvent3 = new CreateDatabasePreEvent("db5");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)createDatabasePreEvent3));
        String x$1 = "test";
        String x$2 = dbDefinition.copy$default$1();
        URI x$3 = dbDefinition.copy$default$3();
        Map x$4 = dbDefinition.copy$default$4();
        CatalogDatabase newDbDefinition = dbDefinition.copy(x$2, "test", x$3, x$4);
        catalog.alterDatabase(newDbDefinition);
        AlterDatabasePreEvent alterDatabasePreEvent = new AlterDatabasePreEvent("db5");
        AlterDatabaseEvent alterDatabaseEvent = new AlterDatabaseEvent("db5");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)alterDatabaseEvent).$colon$colon((Object)alterDatabasePreEvent));
        $this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.dropDatabase("db4", false, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogEventSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        DropDatabasePreEvent dropDatabasePreEvent = new DropDatabasePreEvent("db4");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)dropDatabasePreEvent));
        catalog.dropDatabase("db5", false, false);
        DropDatabasePreEvent dropDatabasePreEvent2 = new DropDatabasePreEvent("db5");
        DropDatabaseEvent dropDatabaseEvent = new DropDatabaseEvent("db5");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)dropDatabaseEvent).$colon$colon((Object)dropDatabasePreEvent2));
        catalog.dropDatabase("db4", true, false);
        DropDatabasePreEvent dropDatabasePreEvent3 = new DropDatabasePreEvent("db4");
        DropDatabaseEvent dropDatabaseEvent2 = new DropDatabaseEvent("db4");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)dropDatabaseEvent2).$colon$colon((Object)dropDatabasePreEvent3));
    }

    public static final /* synthetic */ void $anonfun$new$4(ExternalCatalogEventSuite $this, ExternalCatalog catalog, Function1 checkEvents) {
        Path path1 = Files.createTempDirectory("db_", new FileAttribute[0]);
        Path path2 = Files.createTempDirectory(path1, "tbl_", new FileAttribute[0]);
        URI uri1 = $this.preparePath(path1);
        URI uri2 = $this.preparePath(path2);
        CatalogDatabase dbDefinition = $this.createDbDefinition(uri1);
        CatalogStorageFormat storage = CatalogStorageFormat$.MODULE$.empty().copy(Option$.MODULE$.apply((Object)uri2), CatalogStorageFormat$.MODULE$.empty().copy$default$2(), CatalogStorageFormat$.MODULE$.empty().copy$default$3(), CatalogStorageFormat$.MODULE$.empty().copy$default$4(), CatalogStorageFormat$.MODULE$.empty().copy$default$5(), CatalogStorageFormat$.MODULE$.empty().copy$default$6());
        CatalogTable tableDefinition = new CatalogTable(TableIdentifier$.MODULE$.apply("tbl1", (Option)new Some((Object)"db5")), CatalogTableType$.MODULE$.MANAGED(), storage, new StructType().add("id", "long"), CatalogTable$.MODULE$.apply$default$5(), CatalogTable$.MODULE$.apply$default$6(), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20());
        catalog.createDatabase(dbDefinition, false);
        CreateDatabasePreEvent createDatabasePreEvent = new CreateDatabasePreEvent("db5");
        CreateDatabaseEvent createDatabaseEvent = new CreateDatabaseEvent("db5");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)createDatabaseEvent).$colon$colon((Object)createDatabasePreEvent));
        catalog.createTable(tableDefinition, false);
        CreateTablePreEvent createTablePreEvent = new CreateTablePreEvent("db5", "tbl1");
        CreateTableEvent createTableEvent = new CreateTableEvent("db5", "tbl1");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)createTableEvent).$colon$colon((Object)createTablePreEvent));
        catalog.createTable(tableDefinition, true);
        CreateTablePreEvent createTablePreEvent2 = new CreateTablePreEvent("db5", "tbl1");
        CreateTableEvent createTableEvent2 = new CreateTableEvent("db5", "tbl1");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)createTableEvent2).$colon$colon((Object)createTablePreEvent2));
        $this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.createTable(tableDefinition, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogEventSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        CreateTablePreEvent createTablePreEvent3 = new CreateTablePreEvent("db5", "tbl1");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)createTablePreEvent3));
        CatalogTableType x$5 = CatalogTableType$.MODULE$.EXTERNAL();
        TableIdentifier x$6 = tableDefinition.copy$default$1();
        CatalogStorageFormat x$7 = tableDefinition.copy$default$3();
        StructType x$8 = tableDefinition.copy$default$4();
        Option x$9 = tableDefinition.copy$default$5();
        Seq x$10 = tableDefinition.copy$default$6();
        Option x$11 = tableDefinition.copy$default$7();
        String x$12 = tableDefinition.copy$default$8();
        long x$13 = tableDefinition.copy$default$9();
        long x$14 = tableDefinition.copy$default$10();
        String x$15 = tableDefinition.copy$default$11();
        Map x$16 = tableDefinition.copy$default$12();
        Option x$17 = tableDefinition.copy$default$13();
        Option x$18 = tableDefinition.copy$default$14();
        Option x$19 = tableDefinition.copy$default$15();
        Seq x$20 = tableDefinition.copy$default$16();
        boolean x$21 = tableDefinition.copy$default$17();
        boolean x$22 = tableDefinition.copy$default$18();
        Map x$23 = tableDefinition.copy$default$19();
        Option x$24 = tableDefinition.copy$default$20();
        CatalogTable newTableDefinition = tableDefinition.copy(x$6, x$5, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24);
        catalog.alterTable(newTableDefinition);
        AlterTablePreEvent alterTablePreEvent = new AlterTablePreEvent("db5", "tbl1", AlterTableKind$.MODULE$.TABLE());
        AlterTableEvent alterTableEvent = new AlterTableEvent("db5", "tbl1", AlterTableKind$.MODULE$.TABLE());
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)alterTableEvent).$colon$colon((Object)alterTablePreEvent));
        StructType newSchema = new StructType().add("id", "long", false);
        catalog.alterTableDataSchema("db5", "tbl1", newSchema);
        AlterTablePreEvent alterTablePreEvent2 = new AlterTablePreEvent("db5", "tbl1", AlterTableKind$.MODULE$.DATASCHEMA());
        AlterTableEvent alterTableEvent2 = new AlterTableEvent("db5", "tbl1", AlterTableKind$.MODULE$.DATASCHEMA());
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)alterTableEvent2).$colon$colon((Object)alterTablePreEvent2));
        catalog.alterTableStats("db5", "tbl1", (Option)None$.MODULE$);
        AlterTablePreEvent alterTablePreEvent3 = new AlterTablePreEvent("db5", "tbl1", AlterTableKind$.MODULE$.STATS());
        AlterTableEvent alterTableEvent3 = new AlterTableEvent("db5", "tbl1", AlterTableKind$.MODULE$.STATS());
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)alterTableEvent3).$colon$colon((Object)alterTablePreEvent3));
        catalog.renameTable("db5", "tbl1", "tbl2");
        RenameTablePreEvent renameTablePreEvent = new RenameTablePreEvent("db5", "tbl1", "tbl2");
        RenameTableEvent renameTableEvent = new RenameTableEvent("db5", "tbl1", "tbl2");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)renameTableEvent).$colon$colon((Object)renameTablePreEvent));
        $this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.renameTable("db5", "tbl1", "tbl2"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogEventSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        RenameTablePreEvent renameTablePreEvent2 = new RenameTablePreEvent("db5", "tbl1", "tbl2");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)renameTablePreEvent2));
        $this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.dropTable("db5", "tbl1", false, true), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogEventSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        DropTablePreEvent dropTablePreEvent = new DropTablePreEvent("db5", "tbl1");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)dropTablePreEvent));
        catalog.dropTable("db5", "tbl2", false, true);
        DropTablePreEvent dropTablePreEvent2 = new DropTablePreEvent("db5", "tbl2");
        DropTableEvent dropTableEvent = new DropTableEvent("db5", "tbl2");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)dropTableEvent).$colon$colon((Object)dropTablePreEvent2));
        catalog.dropTable("db5", "tbl2", true, true);
        DropTablePreEvent dropTablePreEvent3 = new DropTablePreEvent("db5", "tbl2");
        DropTableEvent dropTableEvent2 = new DropTableEvent("db5", "tbl2");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)dropTableEvent2).$colon$colon((Object)dropTablePreEvent3));
    }

    public static final /* synthetic */ void $anonfun$new$8(ExternalCatalogEventSuite $this, ExternalCatalog catalog, Function1 checkEvents) {
        CatalogDatabase dbDefinition = $this.createDbDefinition();
        CatalogFunction functionDefinition = new CatalogFunction(FunctionIdentifier$.MODULE$.apply("fn7", (Option)new Some((Object)"db5")), "", (Seq)package$.MODULE$.Seq().empty());
        catalog.createDatabase(dbDefinition, false);
        CreateDatabasePreEvent createDatabasePreEvent = new CreateDatabasePreEvent("db5");
        CreateDatabaseEvent createDatabaseEvent = new CreateDatabaseEvent("db5");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)createDatabaseEvent).$colon$colon((Object)createDatabasePreEvent));
        catalog.createFunction("db5", functionDefinition);
        CreateFunctionPreEvent createFunctionPreEvent = new CreateFunctionPreEvent("db5", "fn7");
        CreateFunctionEvent createFunctionEvent = new CreateFunctionEvent("db5", "fn7");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)createFunctionEvent).$colon$colon((Object)createFunctionPreEvent));
        $this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.createFunction("db5", functionDefinition), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogEventSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        CreateFunctionPreEvent createFunctionPreEvent2 = new CreateFunctionPreEvent("db5", "fn7");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)createFunctionPreEvent2));
        catalog.renameFunction("db5", "fn7", "fn4");
        RenameFunctionPreEvent renameFunctionPreEvent = new RenameFunctionPreEvent("db5", "fn7", "fn4");
        RenameFunctionEvent renameFunctionEvent = new RenameFunctionEvent("db5", "fn7", "fn4");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)renameFunctionEvent).$colon$colon((Object)renameFunctionPreEvent));
        $this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.renameFunction("db5", "fn7", "fn4"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogEventSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        RenameFunctionPreEvent renameFunctionPreEvent2 = new RenameFunctionPreEvent("db5", "fn7", "fn4");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)renameFunctionPreEvent2));
        CatalogFunction alteredFunctionDefinition = new CatalogFunction(FunctionIdentifier$.MODULE$.apply("fn4", (Option)new Some((Object)"db5")), "org.apache.spark.AlterFunction", (Seq)package$.MODULE$.Seq().empty());
        catalog.alterFunction("db5", alteredFunctionDefinition);
        AlterFunctionPreEvent alterFunctionPreEvent = new AlterFunctionPreEvent("db5", "fn4");
        AlterFunctionEvent alterFunctionEvent = new AlterFunctionEvent("db5", "fn4");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)alterFunctionEvent).$colon$colon((Object)alterFunctionPreEvent));
        $this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.dropFunction("db5", "fn7"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogEventSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        DropFunctionPreEvent dropFunctionPreEvent = new DropFunctionPreEvent("db5", "fn7");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)dropFunctionPreEvent));
        catalog.dropFunction("db5", "fn4");
        DropFunctionPreEvent dropFunctionPreEvent2 = new DropFunctionPreEvent("db5", "fn4");
        DropFunctionEvent dropFunctionEvent = new DropFunctionEvent("db5", "fn4");
        checkEvents.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)dropFunctionEvent).$colon$colon((Object)dropFunctionPreEvent2));
    }

    public ExternalCatalogEventSuite() {
        this.testWithCatalog("database", (Function2<ExternalCatalog, Function1<Seq<ExternalCatalogEvent>, BoxedUnit>, BoxedUnit>)(Function2 & Serializable)(catalog, checkEvents) -> {
            ExternalCatalogEventSuite.$anonfun$new$1(this, catalog, checkEvents);
            return BoxedUnit.UNIT;
        });
        this.testWithCatalog("table", (Function2<ExternalCatalog, Function1<Seq<ExternalCatalogEvent>, BoxedUnit>, BoxedUnit>)(Function2 & Serializable)(catalog, checkEvents) -> {
            ExternalCatalogEventSuite.$anonfun$new$4(this, catalog, checkEvents);
            return BoxedUnit.UNIT;
        });
        this.testWithCatalog("function", (Function2<ExternalCatalog, Function1<Seq<ExternalCatalogEvent>, BoxedUnit>, BoxedUnit>)(Function2 & Serializable)(catalog, checkEvents) -> {
            ExternalCatalogEventSuite.$anonfun$new$8(this, catalog, checkEvents);
            return BoxedUnit.UNIT;
        });
    }
}

