/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.RandomDataGenerator$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder$;
import org.apache.spark.sql.catalyst.expressions.HiveHash;
import org.apache.spark.sql.catalyst.expressions.Murmur3Hash;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.XxHash64;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateSafeProjection$;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class HashBenchmark$
extends BenchmarkBase {
    public static final HashBenchmark$ MODULE$ = new HashBenchmark$();

    public void test(String name, StructType schema, int numRows, int iters) {
        this.runBenchmark(name, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Function0 generator = (Function0)RandomDataGenerator$.MODULE$.forType((DataType)schema, false, RandomDataGenerator$.MODULE$.forType$default$3(), RandomDataGenerator$.MODULE$.forType$default$4()).get();
            ExpressionEncoder.Serializer toRow = ExpressionEncoder$.MODULE$.apply(schema).createSerializer();
            Seq attrs = DataTypeUtils$.MODULE$.toAttributes(schema);
            package.Projection safeProjection = (package.Projection)GenerateSafeProjection$.MODULE$.generate((Object)attrs, attrs);
            InternalRow[] rows = (InternalRow[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numRows).map((Function1 & Serializable)x$1 -> HashBenchmark$.$anonfun$test$2(safeProjection, toRow, generator, BoxesRunTime.unboxToInt((Object)x$1))).toArray(ClassTag$.MODULE$.apply(InternalRow.class));
            String x$12 = new StringBuilder(9).append("Hash For ").append(name).toString();
            long x$22 = (long)iters * (long)numRows;
            Option x$3 = MODULE$.output();
            int x$42 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$62 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$12, x$22, x$42, x$5, x$62, x$7, x$3);
            benchmark.addCase("interpreted version", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                IntRef sum = IntRef.create((int)0);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)x$3 -> {
                    long l = x$3;
                    for (int i = 0; i < numRows; ++i) {
                        sum$1.elem += rows[i].hashCode();
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
            Murmur3Hash murmur3Hash = new Murmur3Hash(attrs);
            UnsafeProjection getHashCode = UnsafeProjection$.MODULE$.create((Seq)package$.MODULE$.Nil().$colon$colon((Object)murmur3Hash), attrs);
            benchmark.addCase("codegen version", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
                IntRef sum = IntRef.create((int)0);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)x$5 -> {
                    long l = x$5;
                    for (int i = 0; i < numRows; ++i) {
                        sum$2.elem += getHashCode.apply(rows[i]).getInt(0);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
            XxHash64 xxHash64 = new XxHash64(attrs);
            UnsafeProjection getHashCode64b = UnsafeProjection$.MODULE$.create((Seq)package$.MODULE$.Nil().$colon$colon((Object)xxHash64), attrs);
            benchmark.addCase("codegen version 64-bit", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> {
                IntRef sum = IntRef.create((int)0);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)x$7 -> {
                    long l = x$7;
                    for (int i = 0; i < numRows; ++i) {
                        sum$3.elem += getHashCode64b.apply(rows[i]).getInt(0);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
            HiveHash hiveHash = new HiveHash(attrs);
            UnsafeProjection getHiveHashCode = UnsafeProjection$.MODULE$.create((Seq)package$.MODULE$.Nil().$colon$colon((Object)hiveHash), attrs);
            benchmark.addCase("codegen HiveHash version", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$8 -> {
                IntRef sum = IntRef.create((int)0);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)x$9 -> {
                    long l = x$9;
                    for (int i = 0; i < numRows; ++i) {
                        sum$4.elem += getHiveHashCode.apply(rows[i]).getInt(0);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
            benchmark.run();
        });
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        StructType singleInt = new StructType().add("i", (DataType)IntegerType$.MODULE$);
        this.test("single ints", singleInt, 32768, 16384);
        StructType singleLong = new StructType().add("i", (DataType)LongType$.MODULE$);
        this.test("single longs", singleLong, 32768, 16384);
        StructType normal = new StructType().add("null", (DataType)NullType$.MODULE$).add("boolean", (DataType)BooleanType$.MODULE$).add("byte", (DataType)ByteType$.MODULE$).add("short", (DataType)ShortType$.MODULE$).add("int", (DataType)IntegerType$.MODULE$).add("long", (DataType)LongType$.MODULE$).add("float", (DataType)FloatType$.MODULE$).add("double", (DataType)DoubleType$.MODULE$).add("bigDecimal", (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT()).add("smallDecimal", (DataType)DecimalType$.MODULE$.USER_DEFAULT()).add("string", (DataType)StringType$.MODULE$).add("binary", (DataType)BinaryType$.MODULE$).add("date", (DataType)DateType$.MODULE$).add("timestamp", (DataType)TimestampType$.MODULE$);
        this.test("normal", normal, 1024, 2048);
        ArrayType arrayOfInt = ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$);
        StructType array = new StructType().add("array", (DataType)arrayOfInt).add("arrayOfArray", (DataType)ArrayType$.MODULE$.apply((DataType)arrayOfInt));
        this.test("array", array, 256, 512);
        MapType mapOfInt = MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$);
        StructType map = new StructType().add("map", (DataType)mapOfInt).add("mapOfMap", (DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)mapOfInt));
        this.test("map", map, 64, 64);
    }

    public static final /* synthetic */ InternalRow $anonfun$test$2(package.Projection safeProjection$1, ExpressionEncoder.Serializer toRow$1, Function0 generator$1, int x$1) {
        return ((InternalRow)safeProjection$1.apply((Object)toRow$1.apply((Object)((Row)generator$1.apply())))).copy();
    }

    private HashBenchmark$() {
    }
}

