/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.HllSketchEstimate;
import org.apache.spark.sql.catalyst.expressions.aggregate.HllSketchAgg;
import org.apache.spark.sql.catalyst.expressions.aggregate.HllUnionAgg;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005!4A\u0001B\u0003\u0001)!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0001=!9!\fAI\u0001\n\u0003Y&A\u0007#bi\u0006\u001c8.\u001a;dQ\u0016\u001c\b\n\u001c7TW\u0016$8\r[*vSR,'B\u0001\u0004\b\u0003%\twm\u001a:fO\u0006$XM\u0003\u0002\t\u0013\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tQ1\"\u0001\u0005dCR\fG._:u\u0015\taQ\"A\u0002tc2T!AD\b\u0002\u000bM\u0004\u0018M]6\u000b\u0005A\t\u0012AB1qC\u000eDWMC\u0001\u0013\u0003\ry'oZ\u0002\u0001'\t\u0001Q\u0003\u0005\u0002\u0017/5\tQ\"\u0003\u0002\u0019\u001b\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"A\u0003\u0002'MLW.\u001e7bi\u0016,\u0006\u000fZ1uK6+'oZ3\u0016\u0005}!F\u0003\u0002\u00112s)\u0003B!\t\u0013'S5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004UkBdWM\r\t\u0003C\u001dJ!\u0001\u000b\u0012\u0003\t1{gn\u001a\t\u0004U=2S\"A\u0016\u000b\u00051j\u0013!C5n[V$\u0018M\u00197f\u0015\tq#%\u0001\u0006d_2dWm\u0019;j_:L!\u0001M\u0016\u0003\u00199+X.\u001a:jGJ\u000bgnZ3\t\u000bI\u0012\u0001\u0019A\u001a\u0002\u0011\u0011\fG/\u0019+za\u0016\u0004\"\u0001N\u001c\u000e\u0003UR!AN\u0006\u0002\u000bQL\b/Z:\n\u0005a*$\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000bi\u0012\u0001\u0019A\u001e\u0002\u000b%t\u0007/\u001e;\u0011\u0007q\"uI\u0004\u0002>\u0005:\u0011a(Q\u0007\u0002\u007f)\u0011\u0001iE\u0001\u0007yI|w\u000e\u001e \n\u0003\rJ!a\u0011\u0012\u0002\u000fA\f7m[1hK&\u0011QI\u0012\u0002\u0004'\u0016\f(BA\"#!\t\t\u0003*\u0003\u0002JE\t\u0019\u0011I\\=\t\u000f-\u0013\u0001\u0013!a\u0001\u0019\u0006Ya.^7TW\u0016$8\r[3t!\ti%+D\u0001O\u0015\ty\u0005+\u0001\u0003mC:<'\"A)\u0002\t)\fg/Y\u0005\u0003':\u0013q!\u00138uK\u001e,'\u000fB\u0003V\u0005\t\u0007aKA\u0001U#\t9v\t\u0005\u0002\"1&\u0011\u0011L\t\u0002\b\u001d>$\b.\u001b8h\u0003u\u0019\u0018.\\;mCR,W\u000b\u001d3bi\u0016lUM]4fI\u0011,g-Y;mi\u0012\u001aTC\u0001/h+\u0005i&F\u0001'_W\u0005y\u0006C\u00011f\u001b\u0005\t'B\u00012d\u0003%)hn\u00195fG.,GM\u0003\u0002eE\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005\u0019\f'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0012)Qk\u0001b\u0001-\u0002")
public class DatasketchesHllSketchSuite
extends SparkFunSuite {
    public <T> Tuple2<Object, NumericRange<Object>> simulateUpdateMerge(DataType dataType, Seq<Object> input, Integer numSketches) {
        Map aggFunctionMap = ((IterableOnceOps)package$.MODULE$.Seq().tabulate(Predef$.MODULE$.Integer2int(numSketches), (Function1 & Serializable)index -> DatasketchesHllSketchSuite.$anonfun$simulateUpdateMerge$1(dataType, BoxesRunTime.unboxToInt((Object)index)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        input.map((Function1 & Serializable)value -> {
            Tuple2 tuple2 = (Tuple2)aggFunctionMap.apply((Object)BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt(Predef$.MODULE$.Integer2int(numSketches))));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            HllSketchAgg aggFunction = (HllSketchAgg)tuple2._1();
            HllSketch aggBuffer = (HllSketch)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)aggFunction, (Object)aggBuffer);
            Tuple2 tuple23 = tuple22;
            HllSketchAgg aggFunction2 = (HllSketchAgg)tuple23._1();
            HllSketch aggBuffer2 = (HllSketch)tuple23._2();
            return aggFunction2.update(aggBuffer2, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{value})));
        });
        Iterable mapValues = aggFunctionMap.values();
        Tuple2 tuple2 = (Tuple2)((IterableOnceOps)mapValues.tail()).foldLeft(mapValues.head(), (Function2 & Serializable)(prev, cur) -> {
            HllSketch curBuf;
            Tuple2 tuple2 = DatasketchesHllSketchSuite.serializeDeserialize$1(prev);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            HllSketchAgg prevAgg = (HllSketchAgg)tuple2._1();
            HllSketch prevBuf = (HllSketch)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)prevAgg, (Object)prevBuf);
            Tuple2 tuple23 = tuple22;
            HllSketchAgg prevAgg2 = (HllSketchAgg)tuple23._1();
            HllSketch prevBuf2 = (HllSketch)tuple23._2();
            Tuple2 tuple24 = DatasketchesHllSketchSuite.serializeDeserialize$1(cur);
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            HllSketch hllSketch = curBuf = (HllSketch)tuple24._2();
            HllSketch curBuf2 = hllSketch;
            return new Tuple2((Object)prevAgg2, (Object)prevAgg2.merge(prevBuf2, curBuf2));
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        HllSketchAgg mergedAgg = (HllSketchAgg)tuple2._1();
        HllSketch mergedBuf = (HllSketch)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)mergedAgg, (Object)mergedBuf);
        Tuple2 tuple23 = tuple22;
        HllSketchAgg mergedAgg2 = (HllSketchAgg)tuple23._1();
        HllSketch mergedBuf2 = (HllSketch)tuple23._2();
        HllSketchEstimate estimator = new HllSketchEstimate((Expression)new BoundReference(0, (DataType)BinaryType$.MODULE$, true));
        long estimate = BoxesRunTime.unboxToLong((Object)estimator.eval(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{mergedBuf2.toUpdatableByteArray()}))));
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)estimate), (Object)new RichLong(Predef$.MODULE$.longWrapper((long)mergedBuf2.getLowerBound(3))).to((Object)BoxesRunTime.boxToLong((long)((long)mergedBuf2.getUpperBound(3)))));
    }

    public <T> Integer simulateUpdateMerge$default$3() {
        return Predef$.MODULE$.int2Integer(5);
    }

    public static final /* synthetic */ Tuple2 $anonfun$simulateUpdateMerge$1(DataType dataType$1, int index) {
        HllSketchAgg sketch = new HllSketchAgg((Expression)new BoundReference(0, dataType$1, true));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)index)), (Object)new Tuple2((Object)sketch, (Object)sketch.createAggregationBuffer()));
    }

    private static final Tuple2 serializeDeserialize$1(Tuple2 tuple) {
        Tuple2 tuple2 = tuple;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        HllSketchAgg agg = (HllSketchAgg)tuple2._1();
        HllSketch buf = (HllSketch)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)agg, (Object)buf);
        Tuple2 tuple23 = tuple22;
        HllSketchAgg agg2 = (HllSketchAgg)tuple23._1();
        HllSketch buf2 = (HllSketch)tuple23._2();
        byte[] serialized = agg2.serialize(buf2);
        return new Tuple2((Object)agg2, (Object)agg2.deserialize(serialized));
    }

    public static final /* synthetic */ UTF8String $anonfun$new$4(int i) {
        return UTF8String.fromString((String)Random$.MODULE$.nextString(i));
    }

    public static final /* synthetic */ byte[] $anonfun$new$6(int i) {
        return UTF8String.fromString((String)Random$.MODULE$.nextString(i)).getBytes();
    }

    public DatasketchesHllSketchSuite() {
        this.test("Test min/max values of supported datatypes", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Bool bool;
            Bool bool2;
            Bool bool3;
            Bool bool4;
            Range intRange = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(Integer.MIN_VALUE), Integer.MAX_VALUE).by(10000000);
            Tuple2<Object, NumericRange<Object>> tuple2 = this.simulateUpdateMerge((DataType)IntegerType$.MODULE$, (Seq<Object>)intRange, this.simulateUpdateMerge$default$3());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long intEstimate = tuple2._1$mcJ$sp();
            NumericRange intEstimateRange = (NumericRange)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)intEstimate), (Object)intEstimateRange);
            Tuple2 tuple23 = tuple22;
            long intEstimate2 = tuple23._1$mcJ$sp();
            NumericRange intEstimateRange2 = (NumericRange)tuple23._2();
            long $org_scalatest_assert_macro_left = intEstimate2;
            int $org_scalatest_assert_macro_right = intRange.size();
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                bool4 = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
            } else {
                NumericRange $org_scalatest_assert_macro_left3 = intEstimateRange2;
                long $org_scalatest_assert_macro_right2 = intRange.size();
                bool4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "||", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DatasketchesHllSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            NumericRange longRange = new RichLong(Predef$.MODULE$.longWrapper(Long.MIN_VALUE)).to((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).by((Object)BoxesRunTime.boxToLong((long)1000000000000000L));
            Tuple2<Object, NumericRange<Object>> tuple24 = this.simulateUpdateMerge((DataType)LongType$.MODULE$, (Seq<Object>)longRange, this.simulateUpdateMerge$default$3());
            if (tuple24 == null) {
                throw new MatchError(tuple24);
            }
            long longEstimate = tuple24._1$mcJ$sp();
            NumericRange longEstimateRange = (NumericRange)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)BoxesRunTime.boxToLong((long)longEstimate), (Object)longEstimateRange);
            Tuple2 tuple26 = tuple25;
            long longEstimate2 = tuple26._1$mcJ$sp();
            NumericRange longEstimateRange2 = (NumericRange)tuple26._2();
            long $org_scalatest_assert_macro_left4 = longEstimate2;
            int $org_scalatest_assert_macro_right4 = longRange.size();
            Bool $org_scalatest_assert_macro_left5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == (long)$org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left5.value()) {
                bool3 = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
            } else {
                NumericRange $org_scalatest_assert_macro_left6 = longEstimateRange2;
                long $org_scalatest_assert_macro_right5 = longRange.size();
                bool3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5)), Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right6 = bool3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "||", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left5.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DatasketchesHllSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
            Seq stringRange = (Seq)package$.MODULE$.Seq().tabulate(1000, (Function1 & Serializable)i -> DatasketchesHllSketchSuite.$anonfun$new$4(BoxesRunTime.unboxToInt((Object)i)));
            Tuple2<Object, NumericRange<Object>> tuple27 = this.simulateUpdateMerge((DataType)StringType$.MODULE$, (Seq<Object>)stringRange, this.simulateUpdateMerge$default$3());
            if (tuple27 == null) {
                throw new MatchError(tuple27);
            }
            long stringEstimate = tuple27._1$mcJ$sp();
            NumericRange stringEstimateRange = (NumericRange)tuple27._2();
            Tuple2 tuple28 = new Tuple2((Object)BoxesRunTime.boxToLong((long)stringEstimate), (Object)stringEstimateRange);
            Tuple2 tuple29 = tuple28;
            long stringEstimate2 = tuple29._1$mcJ$sp();
            NumericRange stringEstimateRange2 = (NumericRange)tuple29._2();
            long $org_scalatest_assert_macro_left7 = stringEstimate2;
            int $org_scalatest_assert_macro_right7 = stringRange.size();
            Bool $org_scalatest_assert_macro_left8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == (long)$org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left8.value()) {
                bool2 = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
            } else {
                NumericRange $org_scalatest_assert_macro_left9 = stringEstimateRange2;
                long $org_scalatest_assert_macro_right8 = stringRange.size();
                bool2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right8)), Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right9 = bool2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "||", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left8.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DatasketchesHllSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            Seq binaryRange = (Seq)package$.MODULE$.Seq().tabulate(1000, (Function1 & Serializable)i -> DatasketchesHllSketchSuite.$anonfun$new$6(BoxesRunTime.unboxToInt((Object)i)));
            Tuple2<Object, NumericRange<Object>> tuple210 = this.simulateUpdateMerge((DataType)BinaryType$.MODULE$, (Seq<Object>)binaryRange, this.simulateUpdateMerge$default$3());
            if (tuple210 == null) {
                throw new MatchError(tuple210);
            }
            long binaryEstimate = tuple210._1$mcJ$sp();
            NumericRange binaryEstimateRange = (NumericRange)tuple210._2();
            Tuple2 tuple211 = new Tuple2((Object)BoxesRunTime.boxToLong((long)binaryEstimate), (Object)binaryEstimateRange);
            Tuple2 tuple212 = tuple211;
            long binaryEstimate2 = tuple212._1$mcJ$sp();
            NumericRange binaryEstimateRange2 = (NumericRange)tuple212._2();
            long $org_scalatest_assert_macro_left10 = binaryEstimate2;
            int $org_scalatest_assert_macro_right10 = binaryRange.size();
            Bool $org_scalatest_assert_macro_left11 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left10), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10 == (long)$org_scalatest_assert_macro_right10, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left11.value()) {
                bool = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
            } else {
                NumericRange $org_scalatest_assert_macro_left12 = binaryEstimateRange2;
                long $org_scalatest_assert_macro_right11 = binaryRange.size();
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left12.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right11)), Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right12 = bool;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "||", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left11.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right12), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DatasketchesHllSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        }, new Position("DatasketchesHllSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("Test lgMaxK results in downsampling sketches with larger lgConfigK", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            HllSketchAgg aggFunc1 = new HllSketchAgg((Expression)new BoundReference(0, (DataType)IntegerType$.MODULE$, true), 12);
            HllSketch sketch1 = aggFunc1.createAggregationBuffer();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable)i -> aggFunc1.update(sketch1, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))}))));
            Object binary1 = aggFunc1.eval(sketch1);
            HllSketchAgg aggFunc2 = new HllSketchAgg((Expression)new BoundReference(0, (DataType)IntegerType$.MODULE$, true), 10);
            HllSketch sketch2 = aggFunc2.createAggregationBuffer();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable)i -> aggFunc2.update(sketch2, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))}))));
            sketch2.isCompact();
            Object binary2 = aggFunc2.eval(sketch2);
            HllUnionAgg aggFunc3 = new HllUnionAgg((Expression)new BoundReference(0, (DataType)BinaryType$.MODULE$, true), true);
            Option union1 = aggFunc3.createAggregationBuffer();
            aggFunc3.update(union1, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{binary1})));
            aggFunc3.update(union1, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{binary2})));
            Object binary3 = aggFunc3.eval(union1);
            int $org_scalatest_assert_macro_left = HllSketch.heapify((Memory)Memory.wrap((byte[])((byte[])binary3))).getLgConfigK();
            int $org_scalatest_assert_macro_right = 12;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DatasketchesHllSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        }, new Position("DatasketchesHllSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
    }
}

