/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.connector.catalog.TableCapability;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.JavaConverters$;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class EnumTypeSetBenchmark$
extends BenchmarkBase {
    public static final EnumTypeSetBenchmark$ MODULE$ = new EnumTypeSetBenchmark$();

    public java.util.Set<TableCapability> emptyHashSet() {
        return Collections.emptySet();
    }

    public java.util.Set<TableCapability> emptyEnumSet() {
        return EnumSet.noneOf(TableCapability.class);
    }

    public java.util.Set<TableCapability> oneItemHashSet() {
        return (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableCapability[]{TableCapability.TRUNCATE}))).asJava();
    }

    public java.util.Set<TableCapability> oneItemEnumSet() {
        return EnumSet.of(TableCapability.TRUNCATE);
    }

    public java.util.Set<TableCapability> threeItemsHashSet() {
        return (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableCapability[]{TableCapability.BATCH_READ, TableCapability.TRUNCATE, TableCapability.V1_BATCH_WRITE}))).asJava();
    }

    public java.util.Set<TableCapability> threeItemsEnumSet() {
        return EnumSet.of(TableCapability.BATCH_READ, TableCapability.TRUNCATE, TableCapability.V1_BATCH_WRITE);
    }

    public java.util.Set<TableCapability> fiveItemsHashSet() {
        return (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableCapability[]{TableCapability.BATCH_READ, TableCapability.CONTINUOUS_READ, TableCapability.TRUNCATE, TableCapability.V1_BATCH_WRITE, TableCapability.OVERWRITE_BY_FILTER}))).asJava();
    }

    public java.util.Set<TableCapability> fiveItemsEnumSet() {
        return EnumSet.of(TableCapability.BATCH_READ, TableCapability.CONTINUOUS_READ, TableCapability.TRUNCATE, TableCapability.V1_BATCH_WRITE, TableCapability.OVERWRITE_BY_FILTER);
    }

    public java.util.Set<TableCapability> allItemsHashSet() {
        return (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableCapability[]{TableCapability.BATCH_READ, TableCapability.MICRO_BATCH_READ, TableCapability.CONTINUOUS_READ, TableCapability.BATCH_WRITE, TableCapability.STREAMING_WRITE, TableCapability.TRUNCATE, TableCapability.OVERWRITE_BY_FILTER, TableCapability.OVERWRITE_DYNAMIC, TableCapability.ACCEPT_ANY_SCHEMA, TableCapability.V1_BATCH_WRITE}))).asJava();
    }

    public java.util.Set<TableCapability> allItemsEnumSet() {
        return EnumSet.allOf(TableCapability.class);
    }

    public void testCreateSetWithEnumType(int valuesPerIteration, String sizeLiteral, Function0<java.util.Set<TableCapability>> creatHashSetFunctions, Function0<java.util.Set<TableCapability>> creatEnumSetFunctions) {
        String x$12 = new StringBuilder(16).append("Test create ").append(sizeLiteral).append(" Set").toString();
        long x$2 = valuesPerIteration;
        Option x$32 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$12, x$2, x$4, x$5, x$6, x$7, x$32);
        benchmark.addCase("Use HashSet", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)valuesPerIteration)).foreach((Function1 & Serializable)x$2 -> EnumTypeSetBenchmark$.$anonfun$testCreateSetWithEnumType$2(creatHashSetFunctions, BoxesRunTime.unboxToLong((Object)x$2))));
        benchmark.addCase("Use EnumSet", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)valuesPerIteration)).foreach((Function1 & Serializable)x$4 -> EnumTypeSetBenchmark$.$anonfun$testCreateSetWithEnumType$4(creatEnumSetFunctions, BoxesRunTime.unboxToLong((Object)x$4))));
        benchmark.run();
    }

    public void testContainsOperation(int valuesPerIteration, String sizeLiteral, java.util.Set<TableCapability> hashSet, java.util.Set<TableCapability> enumSet) {
        TableCapability[] capabilities = TableCapability.values();
        String x$1 = new StringBuilder(22).append("Test contains use ").append(sizeLiteral).append(" Set").toString();
        long x$2 = valuesPerIteration * capabilities.length;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$52 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$72 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$52, x$6, x$72, x$3);
        benchmark.addCase("Use HashSet", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)valuesPerIteration)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)x$6 -> {
            long l = x$6;
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])capabilities), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)hashSet.contains(x$1)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }));
        benchmark.addCase("Use EnumSet", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)valuesPerIteration)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)x$8 -> {
            long l = x$8;
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])capabilities), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)enumSet.contains(x$1)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }));
        benchmark.run();
    }

    public void testCreateAndContainsOperation(int valuesPerIteration, String sizeLiteral, Function0<java.util.Set<TableCapability>> creatHashSetFunctions, Function0<java.util.Set<TableCapability>> creatEnumSetFunctions) {
        TableCapability[] capabilities = TableCapability.values();
        String x$1 = new StringBuilder(33).append("Test create and contains use ").append(sizeLiteral).append(" Set").toString();
        long x$2 = valuesPerIteration * capabilities.length;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        benchmark.addCase("Use HashSet", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$9 -> new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)valuesPerIteration)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)x$10 -> {
            long l = x$10;
            java.util.Set set = (java.util.Set)creatHashSetFunctions.apply();
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])capabilities), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)set.contains(x$1)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }));
        benchmark.addCase("Use EnumSet", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$11 -> new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)valuesPerIteration)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)x$12 -> {
            long l = x$12;
            java.util.Set set = (java.util.Set)creatEnumSetFunctions.apply();
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])capabilities), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)set.contains(x$1)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }));
        benchmark.run();
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        int valuesPerIteration = 100000;
        this.testContainsOperation(valuesPerIteration, "empty", this.emptyHashSet(), this.emptyEnumSet());
        this.testContainsOperation(valuesPerIteration, "1 item", this.oneItemHashSet(), this.oneItemEnumSet());
        this.testContainsOperation(valuesPerIteration, "3 items", this.threeItemsHashSet(), this.threeItemsEnumSet());
        this.testContainsOperation(valuesPerIteration, "5 items", this.fiveItemsHashSet(), this.fiveItemsEnumSet());
        this.testContainsOperation(valuesPerIteration, new StringBuilder(6).append(TableCapability.values().length).append(" items").toString(), this.allItemsHashSet(), this.allItemsEnumSet());
        this.testCreateSetWithEnumType(valuesPerIteration, "empty", (Function0<java.util.Set<TableCapability>>)(Function0 & Serializable)() -> MODULE$.emptyHashSet(), (Function0<java.util.Set<TableCapability>>)(Function0 & Serializable)() -> MODULE$.emptyEnumSet());
        this.testCreateSetWithEnumType(valuesPerIteration, "1 item", (Function0<java.util.Set<TableCapability>>)(Function0 & Serializable)() -> MODULE$.oneItemHashSet(), (Function0<java.util.Set<TableCapability>>)(Function0 & Serializable)() -> MODULE$.oneItemEnumSet());
        this.testCreateSetWithEnumType(valuesPerIteration, "3 items", (Function0<java.util.Set<TableCapability>>)(Function0 & Serializable)() -> MODULE$.threeItemsHashSet(), (Function0<java.util.Set<TableCapability>>)(Function0 & Serializable)() -> MODULE$.threeItemsEnumSet());
        this.testCreateSetWithEnumType(valuesPerIteration, "5 items", (Function0<java.util.Set<TableCapability>>)(Function0 & Serializable)() -> MODULE$.fiveItemsHashSet(), (Function0<java.util.Set<TableCapability>>)(Function0 & Serializable)() -> MODULE$.fiveItemsEnumSet());
        this.testCreateSetWithEnumType(valuesPerIteration, new StringBuilder(6).append(TableCapability.values().length).append(" items").toString(), (Function0<java.util.Set<TableCapability>>)(Function0 & Serializable)() -> MODULE$.allItemsHashSet(), (Function0<java.util.Set<TableCapability>>)(Function0 & Serializable)() -> MODULE$.allItemsEnumSet());
        this.testCreateAndContainsOperation(valuesPerIteration, "empty", (Function0<java.util.Set<TableCapability>>)(Function0 & Serializable)() -> MODULE$.emptyHashSet(), (Function0<java.util.Set<TableCapability>>)(Function0 & Serializable)() -> MODULE$.emptyEnumSet());
        this.testCreateAndContainsOperation(valuesPerIteration, "1 item", (Function0<java.util.Set<TableCapability>>)(Function0 & Serializable)() -> MODULE$.oneItemHashSet(), (Function0<java.util.Set<TableCapability>>)(Function0 & Serializable)() -> MODULE$.oneItemEnumSet());
        this.testCreateAndContainsOperation(valuesPerIteration, "3 items", (Function0<java.util.Set<TableCapability>>)(Function0 & Serializable)() -> MODULE$.threeItemsHashSet(), (Function0<java.util.Set<TableCapability>>)(Function0 & Serializable)() -> MODULE$.threeItemsEnumSet());
        this.testCreateAndContainsOperation(valuesPerIteration, "5 items", (Function0<java.util.Set<TableCapability>>)(Function0 & Serializable)() -> MODULE$.fiveItemsHashSet(), (Function0<java.util.Set<TableCapability>>)(Function0 & Serializable)() -> MODULE$.fiveItemsEnumSet());
        this.testCreateAndContainsOperation(valuesPerIteration, new StringBuilder(6).append(TableCapability.values().length).append(" items").toString(), (Function0<java.util.Set<TableCapability>>)(Function0 & Serializable)() -> MODULE$.allItemsHashSet(), (Function0<java.util.Set<TableCapability>>)(Function0 & Serializable)() -> MODULE$.allItemsEnumSet());
    }

    public static final /* synthetic */ java.util.Set $anonfun$testCreateSetWithEnumType$2(Function0 creatHashSetFunctions$1, long x$2) {
        long l = x$2;
        java.util.Set set = (java.util.Set)creatHashSetFunctions$1.apply();
        return set;
    }

    public static final /* synthetic */ java.util.Set $anonfun$testCreateSetWithEnumType$4(Function0 creatEnumSetFunctions$1, long x$4) {
        long l = x$4;
        java.util.Set set = (java.util.Set)creatEnumSetFunctions$1.apply();
        return set;
    }

    private EnumTypeSetBenchmark$() {
    }
}

