/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.serializer.JavaSerializer;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.UnsafeMapData;
import org.apache.spark.unsafe.Platform;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00112A\u0001B\u0003\u0001%!)q\u0003\u0001C\u00011!91\u0004\u0001b\u0001\n\u0003a\u0002BB\u0012\u0001A\u0003%QD\u0001\bV]N\fg-Z'baN+\u0018\u000e^3\u000b\u0005\u00199\u0011\u0001B;uS2T!\u0001C\u0005\u0002\u0011\r\fG/\u00197zgRT!AC\u0006\u0002\u0007M\fHN\u0003\u0002\r\u001b\u0005)1\u000f]1sW*\u0011abD\u0001\u0007CB\f7\r[3\u000b\u0003A\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\n\u0011\u0005Q)R\"A\u0006\n\u0005YY!!D*qCJ\\g)\u001e8Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011!\u0004A\u0007\u0002\u000b\u0005iQO\\:bM\u0016l\u0015\r\u001d#bi\u0006,\u0012!\b\t\u0003=\u0005j\u0011a\b\u0006\u0003A\u001d\t1\"\u001a=qe\u0016\u001c8/[8og&\u0011!e\b\u0002\u000e+:\u001c\u0018MZ3NCB$\u0015\r^1\u0002\u001dUt7/\u00194f\u001b\u0006\u0004H)\u0019;bA\u0001")
public class UnsafeMapSuite
extends SparkFunSuite {
    private final UnsafeMapData unsafeMapData;

    public UnsafeMapData unsafeMapData() {
        return this.unsafeMapData;
    }

    public UnsafeMapSuite() {
        int offset = 32;
        int keyArraySize = 256;
        byte[] baseObject = new byte[1024];
        Platform.putLong((Object)baseObject, (long)offset, (long)keyArraySize);
        UnsafeMapData unsafeMap = new UnsafeMapData();
        Platform.putLong((Object)baseObject, (long)(offset + 8), (long)1L);
        UnsafeArrayData keyArray = new UnsafeArrayData();
        keyArray.pointTo((Object)baseObject, (long)(offset + 8), keyArraySize);
        keyArray.setLong(0, 19285L);
        UnsafeArrayData valueArray = new UnsafeArrayData();
        Platform.putLong((Object)baseObject, (long)(offset + 8 + keyArray.getSizeInBytes()), (long)1L);
        valueArray.pointTo((Object)baseObject, (long)(offset + 8 + keyArray.getSizeInBytes()), keyArraySize);
        valueArray.setLong(0, 19286L);
        unsafeMap.pointTo((Object)baseObject, (long)offset, baseObject.length);
        this.unsafeMapData = unsafeMap;
        this.test("unsafe java serialization", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SerializerInstance ser = new JavaSerializer(new SparkConf()).newInstance();
            UnsafeMapData mapDataSer = (UnsafeMapData)ser.deserialize(ser.serialize((Object)this.unsafeMapData(), ClassTag$.MODULE$.apply(UnsafeMapData.class)), ClassTag$.MODULE$.apply(UnsafeMapData.class));
            int $org_scalatest_assert_macro_left = mapDataSer.numElements();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
            long $org_scalatest_assert_macro_left2 = mapDataSer.keyArray().getLong(0);
            int $org_scalatest_assert_macro_right2 = 19285;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
            long $org_scalatest_assert_macro_left3 = mapDataSer.valueArray().getLong(0);
            int $org_scalatest_assert_macro_right3 = 19286;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
            byte[] $org_scalatest_assert_macro_left4 = (byte[])mapDataSer.getBaseObject();
            int $org_scalatest_assert_macro_right4 = 1024;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        }, new Position("UnsafeMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("unsafe Kryo serialization", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SerializerInstance ser = new KryoSerializer(new SparkConf()).newInstance();
            UnsafeMapData mapDataSer = (UnsafeMapData)ser.deserialize(ser.serialize((Object)this.unsafeMapData(), ClassTag$.MODULE$.apply(UnsafeMapData.class)), ClassTag$.MODULE$.apply(UnsafeMapData.class));
            int $org_scalatest_assert_macro_left = mapDataSer.numElements();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            long $org_scalatest_assert_macro_left2 = mapDataSer.keyArray().getLong(0);
            int $org_scalatest_assert_macro_right2 = 19285;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            long $org_scalatest_assert_macro_left3 = mapDataSer.valueArray().getLong(0);
            int $org_scalatest_assert_macro_right3 = 19286;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            byte[] $org_scalatest_assert_macro_left4 = (byte[])mapDataSer.getBaseObject();
            int $org_scalatest_assert_macro_right4 = 1024;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        }, new Position("UnsafeMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
    }
}

