/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.Random;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.catalyst.expressions.HiveHasher;
import org.apache.spark.sql.catalyst.expressions.XXH64;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class HashByteArrayBenchmark$
extends BenchmarkBase {
    public static final HashByteArrayBenchmark$ MODULE$ = new HashByteArrayBenchmark$();

    public void test(int length, long seed, int numArrays, int iters) {
        Random random = new Random(seed);
        byte[][] arrays = (byte[][])Array$.MODULE$.fill(numArrays, (Function0 & Serializable)() -> {
            void var2_2;
            byte[] bytes = new byte[length];
            random.nextBytes(bytes);
            return var2_2;
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        String x$12 = new StringBuilder(29).append("Hash byte arrays with length ").append(length).toString();
        long x$2 = (long)iters * (long)numArrays;
        Option x$32 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$52 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$12, x$2, x$4, x$52, x$6, x$7, x$32);
        benchmark.addCase("Murmur3_x86_32", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)x$2 -> {
                long l = x$2;
                for (int i = 0; i < numArrays; ++i) {
                    sum$1.elem += (long)Murmur3_x86_32.hashUnsafeBytes((Object)arrays[i], (long)Platform.BYTE_ARRAY_OFFSET, (int)length, (int)42);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        });
        benchmark.addCase("xxHash 64-bit", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)x$4 -> {
                long l = x$4;
                for (int i = 0; i < numArrays; ++i) {
                    sum$2.elem += XXH64.hashUnsafeBytes((Object)arrays[i], (long)Platform.BYTE_ARRAY_OFFSET, (int)length, (long)42L);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        });
        benchmark.addCase("HiveHasher", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> {
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)x$6 -> {
                long l = x$6;
                for (int i = 0; i < numArrays; ++i) {
                    sum$3.elem += (long)HiveHasher.hashUnsafeBytes((Object)arrays[i], (long)Platform.BYTE_ARRAY_OFFSET, (int)length);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        });
        benchmark.run();
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runBenchmark("Benchmark for MurMurHash 3 and xxHash64", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.test(8, 42L, 1024, 2048);
            MODULE$.test(16, 42L, 1024, 2048);
            MODULE$.test(24, 42L, 1024, 2048);
            MODULE$.test(31, 42L, 1024, 2048);
            MODULE$.test(95, 42L, 1024, 2048);
            MODULE$.test(287, 42L, 1024, 2048);
            MODULE$.test(1055, 42L, 1024, 2048);
            MODULE$.test(2079, 42L, 1024, 2048);
            MODULE$.test(8223, 42L, 1024, 2048);
        });
    }

    private HashByteArrayBenchmark$() {
    }
}

