/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.StructFilters;
import org.apache.spark.sql.catalyst.StructFilters$;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Contains;
import org.apache.spark.sql.catalyst.expressions.EndsWith;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.StartsWith;
import org.apache.spark.sql.sources.AlwaysFalse$;
import org.apache.spark.sql.sources.AlwaysTrue$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005!3Q\u0001B\u0003\u0002\u0002AAQ!\u0006\u0001\u0005\u0002YAQ!\u0007\u0001\u0007\u0012iAQ\u0001\u0010\u0001\u0005\nu\u0012!c\u0015;sk\u000e$h)\u001b7uKJ\u001c8+^5uK*\u0011aaB\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0001\"C\u0001\u0004gFd'B\u0001\u0006\f\u0003\u0015\u0019\b/\u0019:l\u0015\taQ\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0005\t\u0003%Mi\u0011!C\u0005\u0003)%\u0011Qb\u00159be.4UO\\*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0006\u00035\u0019'/Z1uK\u001aKG\u000e^3sgR\u00191D\b\u001b\u0011\u0005aa\u0012BA\u000f\u0006\u00055\u0019FO];di\u001aKG\u000e^3sg\")qD\u0001a\u0001A\u00059a-\u001b7uKJ\u001c\bcA\u0011,]9\u0011!\u0005\u000b\b\u0003G\u0019j\u0011\u0001\n\u0006\u0003K=\ta\u0001\u0010:p_Rt\u0014\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%R\u0013a\u00029bG.\fw-\u001a\u0006\u0002O%\u0011A&\f\u0002\u0004'\u0016\f(BA\u0015+!\ty#'D\u00011\u0015\t\tt!A\u0004t_V\u00148-Z:\n\u0005M\u0002$A\u0002$jYR,'\u000fC\u00036\u0005\u0001\u0007a'\u0001\u0004tG\",W.\u0019\t\u0003oij\u0011\u0001\u000f\u0006\u0003s\u001d\tQ\u0001^=qKNL!a\u000f\u001d\u0003\u0015M#(/^2u)f\u0004X-A\u0005hKR\u001c6\r[3nCR\u0011aG\u0010\u0005\u0006\u007f\r\u0001\r\u0001Q\u0001\u0004gR\u0014\bCA!F\u001d\t\u00115\t\u0005\u0002$U%\u0011AIK\u0001\u0007!J,G-\u001a4\n\u0005\u0019;%AB*ue&twM\u0003\u0002EU\u0001")
public abstract class StructFiltersSuite
extends SparkFunSuite {
    public abstract StructFilters createFilters(Seq<Filter> var1, StructType var2);

    private StructType getSchema(String str) {
        StructType structType;
        block3: {
            String string = str;
            switch (string == null ? 0 : string.hashCode()) {
                case 0: {
                    if (!"".equals(string)) break;
                    structType = new StructType();
                    break block3;
                }
            }
            structType = StructType$.MODULE$.fromDDL(str);
        }
        return structType;
    }

    private final void check$1(Filter f, Expression expr, BoundReference ref$1) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(StructFilters$.MODULE$.filterToExpression(f, (Function1 & Serializable)x$1 -> new Some((Object)ref$1)).get());
        Expression $org_scalatest_assert_macro_right = expr;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructFiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
    }

    private final void check$2(String requiredSchema, Seq filters, InternalRow row, int pos, boolean skip) {
        StructFilters structFilters = this.createFilters((Seq<Filter>)filters, this.getSchema(requiredSchema));
        structFilters.reset();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)structFilters.skipRow(row, pos)));
        boolean $org_scalatest_assert_macro_right = skip;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructFiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
    }

    private static final String check$default$1$1() {
        return "i INTEGER, d DOUBLE";
    }

    public static final /* synthetic */ Assertion $anonfun$new$6(StructFiltersSuite $this, StructFilters structFilters$1, InternalRow row$1, boolean skip$1, Seq filters$1, int p) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)structFilters$1.skipRow(row$1, p)));
        boolean $org_scalatest_assert_macro_right = skip$1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(23).append("p = ").append(p).append(" filters = ").append(filters$1).append(" skip = ").append(skip$1).toString(), Prettifier$.MODULE$.default(), new Position("StructFiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
    }

    public static final /* synthetic */ void $anonfun$new$4(StructFiltersSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq filters = (Seq)tuple2._1();
        boolean skip = tuple2._2$mcZ$sp();
        String schema = "i INTEGER, d DOUBLE, s STRING";
        InternalRow row = InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToDouble((double)3.14), UTF8String.fromString((String)"abc")}));
        StructFilters structFilters = $this.createFilters((Seq<Filter>)filters, $this.getSchema(schema));
        structFilters.reset();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 3).withFilter((Function1)(JFunction1.mcZI.sp & Serializable)p -> !skip).foreach((Function1 & Serializable)p -> StructFiltersSuite.$anonfun$new$6($this, structFilters, row, skip, filters, BoxesRunTime.unboxToInt((Object)p)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public StructFiltersSuite() {
        this.test("filter to expression conversion", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            BoundReference ref = new BoundReference(0, (DataType)IntegerType$.MODULE$, true);
            this.check$1((Filter)AlwaysTrue$.MODULE$, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), ref);
            this.check$1((Filter)AlwaysFalse$.MODULE$, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false)), ref);
            this.check$1((Filter)new org.apache.spark.sql.sources.IsNull("a"), (Expression)new IsNull((Expression)ref), ref);
            this.check$1((Filter)new org.apache.spark.sql.sources.Not((Filter)new org.apache.spark.sql.sources.IsNull("a")), (Expression)new Not((Expression)new IsNull((Expression)ref)), ref);
            this.check$1((Filter)new org.apache.spark.sql.sources.IsNotNull("a"), (Expression)new IsNotNull((Expression)ref), ref);
            this.check$1((Filter)new org.apache.spark.sql.sources.EqualTo("a", (Object)"b"), (Expression)new EqualTo((Expression)ref, (Expression)Literal$.MODULE$.apply((Object)"b")), ref);
            this.check$1((Filter)new org.apache.spark.sql.sources.EqualNullSafe("a", (Object)"b"), (Expression)new EqualNullSafe((Expression)ref, (Expression)Literal$.MODULE$.apply((Object)"b")), ref);
            this.check$1((Filter)new StringStartsWith("a", "b"), (Expression)new StartsWith((Expression)ref, (Expression)Literal$.MODULE$.apply((Object)"b")), ref);
            this.check$1((Filter)new StringEndsWith("a", "b"), (Expression)new EndsWith((Expression)ref, (Expression)Literal$.MODULE$.apply((Object)"b")), ref);
            this.check$1((Filter)new StringContains("a", "b"), (Expression)new Contains((Expression)ref, (Expression)Literal$.MODULE$.apply((Object)"b")), ref);
            this.check$1((Filter)new org.apache.spark.sql.sources.LessThanOrEqual("a", (Object)BoxesRunTime.boxToInteger((int)1)), (Expression)new LessThanOrEqual((Expression)ref, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), ref);
            this.check$1((Filter)new org.apache.spark.sql.sources.LessThan("a", (Object)BoxesRunTime.boxToInteger((int)1)), (Expression)new LessThan((Expression)ref, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), ref);
            this.check$1((Filter)new org.apache.spark.sql.sources.GreaterThanOrEqual("a", (Object)BoxesRunTime.boxToInteger((int)1)), (Expression)new GreaterThanOrEqual((Expression)ref, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), ref);
            this.check$1((Filter)new org.apache.spark.sql.sources.GreaterThan("a", (Object)BoxesRunTime.boxToInteger((int)1)), (Expression)new GreaterThan((Expression)ref, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), ref);
            this.check$1((Filter)new org.apache.spark.sql.sources.And((Filter)AlwaysTrue$.MODULE$, (Filter)AlwaysTrue$.MODULE$), (Expression)new And((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true))), ref);
            this.check$1((Filter)new org.apache.spark.sql.sources.Or((Filter)AlwaysTrue$.MODULE$, (Filter)AlwaysTrue$.MODULE$), (Expression)new Or((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true))), ref);
            this.check$1((Filter)new org.apache.spark.sql.sources.In("a", new Object[]{BoxesRunTime.boxToInteger((int)1)}), (Expression)new In((Expression)ref, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))}))), ref);
        }, new Position("StructFiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("skipping rows", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq x$1 = (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$);
            InternalRow x$2 = InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)3.14)}));
            boolean x$3 = false;
            boolean x$4 = false;
            String x$5 = StructFiltersSuite.check$default$1$1();
            this.check$2(x$5, x$1, x$2, 0, false);
            Seq x$6 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlwaysTrue$[]{AlwaysTrue$.MODULE$}));
            InternalRow x$7 = InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
            boolean x$8 = false;
            boolean x$9 = false;
            String x$10 = StructFiltersSuite.check$default$1$1();
            this.check$2(x$10, x$6, x$7, 0, false);
            Seq x$11 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlwaysFalse$[]{AlwaysFalse$.MODULE$}));
            InternalRow x$12 = InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
            boolean x$13 = false;
            boolean x$14 = true;
            String x$15 = StructFiltersSuite.check$default$1$1();
            this.check$2(x$15, x$11, x$12, 0, true);
            Seq x$16 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Filter[]{new org.apache.spark.sql.sources.EqualTo("i", (Object)BoxesRunTime.boxToInteger((int)1)), new org.apache.spark.sql.sources.LessThan("d", (Object)BoxesRunTime.boxToInteger((int)10)), AlwaysFalse$.MODULE$}));
            InternalRow x$17 = InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)3.14)}));
            boolean x$18 = false;
            boolean x$19 = true;
            String x$20 = StructFiltersSuite.check$default$1$1();
            this.check$2(x$20, x$16, x$17, 0, true);
            Seq x$21 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new org.apache.spark.sql.sources.EqualTo[]{new org.apache.spark.sql.sources.EqualTo("i", (Object)BoxesRunTime.boxToInteger((int)10))}));
            InternalRow x$22 = InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToDouble((double)3.14)}));
            boolean x$23 = false;
            boolean x$24 = false;
            String x$25 = StructFiltersSuite.check$default$1$1();
            this.check$2(x$25, x$21, x$22, 0, false);
            Seq x$26 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Filter[]{new org.apache.spark.sql.sources.IsNotNull("d"), new org.apache.spark.sql.sources.GreaterThanOrEqual("d", (Object)BoxesRunTime.boxToDouble((double)2.96))}));
            InternalRow x$27 = InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)3.14)}));
            boolean x$28 = false;
            boolean x$29 = false;
            String x$30 = StructFiltersSuite.check$default$1$1();
            this.check$2(x$30, x$26, x$27, 0, false);
            Seq x$31 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Filter[]{new org.apache.spark.sql.sources.In("i", new Object[]{BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)20)}), new org.apache.spark.sql.sources.LessThanOrEqual("d", (Object)BoxesRunTime.boxToDouble((double)2.96))}));
            InternalRow x$32 = InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToDouble((double)3.14)}));
            boolean x$33 = true;
            boolean x$34 = true;
            String x$35 = StructFiltersSuite.check$default$1$1();
            this.check$2(x$35, x$31, x$32, 1, true);
            Seq filters1 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Filter[]{new org.apache.spark.sql.sources.Or((Filter)AlwaysTrue$.MODULE$, (Filter)new org.apache.spark.sql.sources.And((Filter)new org.apache.spark.sql.sources.Not((Filter)new org.apache.spark.sql.sources.IsNull("i")), (Filter)new org.apache.spark.sql.sources.Not((Filter)new org.apache.spark.sql.sources.And((Filter)new StringEndsWith("s", "ab"), (Filter)new StringEndsWith("s", "cd"))))), new org.apache.spark.sql.sources.GreaterThan("d", (Object)BoxesRunTime.boxToInteger((int)0)), new org.apache.spark.sql.sources.LessThan("i", (Object)BoxesRunTime.boxToInteger((int)500))}));
            Seq filters2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Filter[]{new org.apache.spark.sql.sources.And((Filter)new StringContains("s", "abc"), (Filter)new org.apache.spark.sql.sources.And((Filter)new org.apache.spark.sql.sources.Not((Filter)new org.apache.spark.sql.sources.IsNull("i")), (Filter)new org.apache.spark.sql.sources.And((Filter)new StringEndsWith("s", "ab"), (Filter)new StringEndsWith("s", "bc")))), new org.apache.spark.sql.sources.GreaterThan("d", (Object)BoxesRunTime.boxToInteger((int)100)), new org.apache.spark.sql.sources.LessThan("i", (Object)BoxesRunTime.boxToInteger((int)0))}));
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)filters1), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)filters2), (Object)BoxesRunTime.boxToBoolean((boolean)true))})).foreach((Function1 & Serializable)x0$1 -> {
                StructFiltersSuite.$anonfun$new$4(this, x0$1);
                return BoxedUnit.UNIT;
            });
        }, new Position("StructFiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
    }
}

