/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import scala.Byte$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public final class DateTimeTestUtils$ {
    public static final DateTimeTestUtils$ MODULE$ = new DateTimeTestUtils$();
    private static final ZoneId CEST = DateTimeUtils$.MODULE$.getZoneId("+02:00");
    private static final ZoneId CET = DateTimeUtils$.MODULE$.getZoneId("+01:00");
    private static final ZoneId JST = DateTimeUtils$.MODULE$.getZoneId("+09:00");
    private static final ZoneId LA = DateTimeUtils$.MODULE$.getZoneId("America/Los_Angeles");
    private static final ZoneId MIT = DateTimeUtils$.MODULE$.getZoneId("-09:30");
    private static final ZoneId PST = DateTimeUtils$.MODULE$.getZoneId("-08:00");
    private static final ZoneId UTC = DateTimeUtils$.MODULE$.getZoneId("+00:00");
    private static final Option<String> UTC_OPT = Option$.MODULE$.apply((Object)"UTC");
    private static final Seq<ZoneId> ALL_TIMEZONES = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaSetConverter(ZoneId.getAvailableZoneIds()).asScala()).map((Function1 & Serializable)timeZoneId -> DateTimeUtils$.MODULE$.getZoneId(timeZoneId))).toSeq();
    private static final Seq<String> outstandingTimezonesIds = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"UTC", MODULE$.PST().getId(), MODULE$.CET().getId(), "Africa/Dakar", MODULE$.LA().getId(), "Asia/Urumqi", "Asia/Hong_Kong", "Europe/Brussels"}));
    private static final Seq<ZoneId> outstandingZoneIds = (Seq)MODULE$.outstandingTimezonesIds().map((Function1 & Serializable)timeZoneId -> DateTimeUtils$.MODULE$.getZoneId(timeZoneId));

    public ZoneId CEST() {
        return CEST;
    }

    public ZoneId CET() {
        return CET;
    }

    public ZoneId JST() {
        return JST;
    }

    public ZoneId LA() {
        return LA;
    }

    public ZoneId MIT() {
        return MIT;
    }

    public ZoneId PST() {
        return PST;
    }

    public ZoneId UTC() {
        return UTC;
    }

    public Option<String> UTC_OPT() {
        return UTC_OPT;
    }

    public Seq<ZoneId> ALL_TIMEZONES() {
        return ALL_TIMEZONES;
    }

    public Seq<String> outstandingTimezonesIds() {
        return outstandingTimezonesIds;
    }

    public Seq<ZoneId> outstandingZoneIds() {
        return outstandingZoneIds;
    }

    public <T> T withDefaultTimeZone(ZoneId newDefaultTimeZone, Function0<T> block) {
        Object object;
        ZoneId originalDefaultTimeZone = ZoneId.systemDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone(newDefaultTimeZone));
            object = block.apply();
        }
        finally {
            TimeZone.setDefault(TimeZone.getTimeZone(originalDefaultTimeZone));
        }
        return (T)object;
    }

    public long localDateTimeToMicros(LocalDateTime localDateTime, ZoneId zoneId) {
        Instant instant = localDateTime.atZone(zoneId).toInstant();
        return DateTimeUtils$.MODULE$.instantToMicros(instant);
    }

    public long date(int year, byte month, byte day, byte hour, byte minute, byte sec, int micros, ZoneId zid) {
        int nanos = (int)TimeUnit.MICROSECONDS.toNanos(micros);
        LocalDateTime localDateTime = LocalDateTime.of(year, month, Byte$.MODULE$.byte2int(day), Byte$.MODULE$.byte2int(hour), Byte$.MODULE$.byte2int(minute), Byte$.MODULE$.byte2int(sec), nanos);
        return this.localDateTimeToMicros(localDateTime, zid);
    }

    public byte date$default$2() {
        return 1;
    }

    public byte date$default$3() {
        return 1;
    }

    public byte date$default$4() {
        return 0;
    }

    public byte date$default$5() {
        return 0;
    }

    public byte date$default$6() {
        return 0;
    }

    public int date$default$7() {
        return 0;
    }

    public ZoneId date$default$8() {
        return ZoneOffset.UTC;
    }

    public int days(int year, byte month, byte day) {
        return (int)LocalDate.of(year, month, Byte$.MODULE$.byte2int(day)).toEpochDay();
    }

    public byte days$default$2() {
        return 1;
    }

    public byte days$default$3() {
        return 1;
    }

    public long time(byte hour, byte minute, byte sec, int micros, ZoneId zid) {
        int nanos = (int)TimeUnit.MICROSECONDS.toNanos(micros);
        LocalDate localDate = LocalDate.now(zid);
        LocalTime localTime = LocalTime.of(hour, minute, sec, nanos);
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        return this.localDateTimeToMicros(localDateTime, zid);
    }

    public byte time$default$1() {
        return 0;
    }

    public byte time$default$2() {
        return 0;
    }

    public byte time$default$3() {
        return 0;
    }

    public int time$default$4() {
        return 0;
    }

    public ZoneId time$default$5() {
        return ZoneOffset.UTC;
    }

    public long secFrac(int seconds, int milliseconds, int microseconds) {
        long result = microseconds;
        result = Math.addExact(result, Math.multiplyExact((long)milliseconds, 1000L));
        result = Math.addExact(result, Math.multiplyExact((long)seconds, 1000000L));
        return result;
    }

    private DateTimeTestUtils$() {
    }
}

