/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import com.fasterxml.jackson.core.JsonParseException;
import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.StringConcat;
import org.apache.spark.sql.catalyst.util.StringConcat$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.DataTypeTestUtils$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005]4A\u0001E\t\u00019!)\u0011\u0005\u0001C\u0001E!)Q\u0005\u0001C\u0001M!)!\u0007\u0001C\u0001g!9Q\u0007\u0001b\u0001\n\u00031\u0004B\u0002\u001e\u0001A\u0003%q\u0007C\u0004<\u0001\t\u0007I\u0011\u0001\u001f\t\r\u0001\u0003\u0001\u0015!\u0003>\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u0015a\u0006\u0001\"\u0001^\u0011\u001d\u0019\u0007!%A\u0005\u0002\u0011DQa\u001c\u0001\u0005\u0002ADqA\u001e\u0001\u0012\u0002\u0013\u0005AMA\u0007ECR\fG+\u001f9f'VLG/\u001a\u0006\u0003%M\tQ\u0001^=qKNT!\u0001F\u000b\u0002\u0007M\fHN\u0003\u0002\u0017/\u0005)1\u000f]1sW*\u0011\u0001$G\u0001\u0007CB\f7\r[3\u000b\u0003i\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u000f\u0011\u0005yyR\"A\u000b\n\u0005\u0001*\"!D*qCJ\\g)\u001e8Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u0002GA\u0011A\u0005A\u0007\u0002#\u0005)2\r[3dW\u0012\u000bG/\u0019+za\u00164%o\\7Kg>tGCA\u0014.!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0011)f.\u001b;\t\u000b9\u0012\u0001\u0019A\u0018\u0002\u0011\u0011\fG/\u0019+za\u0016\u0004\"\u0001\n\u0019\n\u0005E\n\"\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002)\rDWmY6ECR\fG+\u001f9f\rJ|W\u000e\u0012#M)\t9C\u0007C\u0003/\u0007\u0001\u0007q&\u0001\u0005nKR\fG-\u0019;b+\u00059\u0004C\u0001\u00139\u0013\tI\u0014C\u0001\u0005NKR\fG-\u0019;b\u0003%iW\r^1eCR\f\u0007%\u0001\u0006tiJ,8\r\u001e+za\u0016,\u0012!\u0010\t\u0003IyJ!aP\t\u0003\u0015M#(/^2u)f\u0004X-A\u0006tiJ,8\r\u001e+za\u0016\u0004\u0013\u0001E2iK\u000e\\G)\u001a4bk2$8+\u001b>f)\r93\t\u0012\u0005\u0006]!\u0001\ra\f\u0005\u0006\u000b\"\u0001\rAR\u0001\u0014Kb\u0004Xm\u0019;fI\u0012+g-Y;miNK'0\u001a\t\u0003Q\u001dK!\u0001S\u0015\u0003\u0007%sG/\u0001\u0014dQ\u0016\u001c7.R9vC2\u001c\u0018j\u001a8pe\u0016\u001cu.\u001c9bi&\u0014G.\u001a(vY2\f'-\u001b7jif$BaJ&N\u001f\")A*\u0003a\u0001_\u0005!aM]8n\u0011\u0015q\u0015\u00021\u00010\u0003\t!x\u000eC\u0003Q\u0013\u0001\u0007\u0011+\u0001\u0005fqB,7\r^3e!\tA#+\u0003\u0002TS\t9!i\\8mK\u0006t\u0017AE2iK\u000e\\7)\u0019;bY><7\u000b\u001e:j]\u001e$\"a\n,\t\u000b]S\u0001\u0019A\u0018\u0002\u0005\u0011$\u0018\u0001D2sK\u0006$Xm\u0015;sk\u000e$HCA\u001f[\u0011\u0015Y6\u00021\u0001G\u0003\u0005q\u0017aF2iK\u000e\\W)];bYN\u001cFO];diV\u0014\u0018\r\u001c7z)\u00159cl\u00181b\u0011\u0015aE\u00021\u00010\u0011\u0015qE\u00021\u00010\u0011\u0015\u0001F\u00021\u0001R\u0011\u001d\u0011G\u0002%AA\u0002E\u000b\u0011#[4o_J,g*\u001e7mC\nLG.\u001b;z\u0003\u0005\u001a\u0007.Z2l\u000bF,\u0018\r\\:TiJ,8\r^;sC2d\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135+\u0005)'FA)gW\u00059\u0007C\u00015n\u001b\u0005I'B\u00016l\u0003%)hn\u00195fG.,GM\u0003\u0002mS\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u00059L'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i2\r[3dW\u0016\u000bX/\u00197t'R\u0014Xo\u0019;ve\u0006dG.\u001f\"z\u001d\u0006lW\rF\u0003(cJ\u001cH\u000fC\u0003M\u001d\u0001\u0007q\u0006C\u0003O\u001d\u0001\u0007q\u0006C\u0003Q\u001d\u0001\u0007\u0011\u000bC\u0004v\u001dA\u0005\t\u0019A)\u0002\u001b\r\f7/Z*f]NLG/\u001b<f\u0003\u001d\u001a\u0007.Z2l\u000bF,\u0018\r\\:TiJ,8\r^;sC2d\u0017PQ=OC6,G\u0005Z3gCVdG\u000f\n\u001b")
public class DataTypeSuite
extends SparkFunSuite {
    private final Metadata metadata;
    private final StructType structType;

    public void checkDataTypeFromJson(DataType dataType) {
        this.test(new StringBuilder(12).append("from Json - ").append(dataType).toString(), (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DataType$.MODULE$.fromJson(dataType.json()));
            DataType $org_scalatest_assert_macro_right = dataType;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
    }

    public void checkDataTypeFromDDL(DataType dataType) {
        this.test(new StringBuilder(11).append("from DDL - ").append(dataType).toString(), (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType parsed = StructType$.MODULE$.fromDDL(new StringBuilder(2).append("a ").append(dataType.sql()).toString());
            StructType expected = new StructType().add("a", dataType);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(DataTypeUtils$.MODULE$.sameType((DataType)parsed, (DataType)expected), "org.apache.spark.sql.catalyst.types.DataTypeUtils.sameType(parsed, expected)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public StructType structType() {
        return this.structType;
    }

    public void checkDefaultSize(DataType dataType, int expectedDefaultSize) {
        this.test(new StringBuilder(26).append("Check the default size of ").append(dataType).toString(), (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)dataType.defaultSize()));
            int $org_scalatest_assert_macro_right = expectedDefaultSize;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
    }

    public void checkEqualsIgnoreCompatibleNullability(DataType from, DataType to, boolean expected) {
        String testName = new StringBuilder(49).append("equalsIgnoreCompatibleNullability: (from: ").append(from).append(", to: ").append(to).append(")").toString();
        this.test(testName, (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)DataType$.MODULE$.equalsIgnoreCompatibleNullability(from, to)));
            boolean $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
    }

    public void checkCatalogString(DataType dt) {
        this.test(new StringBuilder(15).append("catalogString: ").append(dt).toString(), (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            DataType dt2 = CatalystSqlParser$.MODULE$.parseDataType(dt.catalogString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(dt);
            DataType $org_scalatest_assert_macro_right = dt2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437));
    }

    public StructType createStruct(int n) {
        return new StructType((StructField[])Array$.MODULE$.tabulate(n, (Function1 & Serializable)i -> DataTypeSuite.$anonfun$createStruct$1(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(StructField.class)));
    }

    public void checkEqualsStructurally(DataType from, DataType to, boolean expected, boolean ignoreNullability) {
        String testName = new StringBuilder(0).append(new StringBuilder(35).append("equalsStructurally: (from: ").append(from).append(", to: ").append(to).append(", ").toString()).append(new StringBuilder(20).append("ignoreNullability: ").append(ignoreNullability).append(")").toString()).toString();
        this.test(testName, (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)DataType$.MODULE$.equalsStructurally(from, to, ignoreNullability)));
            boolean $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 473));
    }

    public boolean checkEqualsStructurally$default$4() {
        return false;
    }

    public void checkEqualsStructurallyByName(DataType from, DataType to, boolean expected, boolean caseSensitive) {
        String testName = new StringBuilder(0).append(new StringBuilder(54).append("SPARK-36918: equalsStructurallyByName: (from: ").append(from).append(", to: ").append(to).append(", ").toString()).append(new StringBuilder(16).append("caseSensitive: ").append(caseSensitive).append(")").toString()).toString();
        Function2 resolver = caseSensitive ? package$.MODULE$.caseSensitiveResolution() : package$.MODULE$.caseInsensitiveResolution();
        this.test(testName, (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)DataType$.MODULE$.equalsStructurallyByName(from, to, resolver)));
            boolean $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 616));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 615));
    }

    public boolean checkEqualsStructurallyByName$default$4() {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$new$17(DataType x$1) {
        return x$1 instanceof LongType;
    }

    public static final /* synthetic */ boolean $anonfun$new$18(DataType x$2) {
        return x$2 instanceof StructType;
    }

    public static final /* synthetic */ boolean $anonfun$new$19(DataType x$3) {
        return x$3 instanceof IntegerType;
    }

    public static final /* synthetic */ boolean $anonfun$new$20(DataType x$4) {
        return x$4 instanceof LongType;
    }

    public static final /* synthetic */ boolean $anonfun$new$21(DataType x$5) {
        return x$5 instanceof StructType;
    }

    public static final /* synthetic */ boolean $anonfun$new$22(DataType x$6) {
        return x$6 instanceof StringType;
    }

    public static final /* synthetic */ boolean $anonfun$new$23(DataType x$7) {
        return x$7 instanceof MapType;
    }

    public static final /* synthetic */ boolean $anonfun$new$24(DataType x$8) {
        return x$8 instanceof IntegerType;
    }

    public static final /* synthetic */ boolean $anonfun$new$25(DataType x$9) {
        return x$9 instanceof LongType;
    }

    public static final /* synthetic */ boolean $anonfun$new$26(DataType x$10) {
        return x$10 instanceof StructType;
    }

    public static final /* synthetic */ boolean $anonfun$new$27(DataType x$11) {
        return x$11 instanceof StringType;
    }

    public static final /* synthetic */ boolean $anonfun$new$28(DataType x$12) {
        return x$12 instanceof MapType;
    }

    public static final /* synthetic */ boolean $anonfun$new$29(DataType x$13) {
        return x$13 instanceof ArrayType;
    }

    public static final /* synthetic */ boolean $anonfun$new$30(DataType x$14) {
        return x$14 instanceof IntegerType;
    }

    public static final /* synthetic */ StructField $anonfun$createStruct$1(int i) {
        return new StructField(new StringBuilder(3).append("col").append(i).toString(), (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
    }

    public DataTypeSuite() {
        this.test("construct an ArrayType", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ArrayType array = ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayType((DataType)StringType$.MODULE$, true));
            ArrayType $org_scalatest_assert_macro_right = array;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("construct an MapType", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            MapType map = MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new MapType((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$, true));
            MapType $org_scalatest_assert_macro_right = map;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.test("construct with add", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType struct = new StructType().add("a", (DataType)IntegerType$.MODULE$, true).add("b", (DataType)LongType$.MODULE$, false).add("c", (DataType)StringType$.MODULE$, true);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()));
            StructField $org_scalatest_assert_macro_right = struct.apply("b");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("construct with add from StructField", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType struct = new StructType().add(new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4())).add(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4())).add(new StructField("c", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()));
            StructField $org_scalatest_assert_macro_right = struct.apply("b");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        this.test("construct with add from StructField with comments", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType struct = new StructType().add("a", "int", true, "test1").add("b", (DataType)StringType$.MODULE$, true, "test3").add(new StructField("c", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()).withComment("test4")).add(new StructField("d", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
            StructField $org_scalatest_assert_macro_left = new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()).withComment("test1");
            StructField $org_scalatest_assert_macro_right = struct.apply("a");
            StructField structField = $org_scalatest_assert_macro_left;
            StructField structField2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structField != null ? !structField.equals(structField2) : structField2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            StructField $org_scalatest_assert_macro_left2 = new StructField("b", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()).withComment("test3");
            StructField $org_scalatest_assert_macro_right2 = struct.apply("b");
            StructField structField3 = $org_scalatest_assert_macro_left2;
            StructField structField4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structField3 != null ? !structField3.equals(structField4) : structField4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            StructField $org_scalatest_assert_macro_left3 = new StructField("c", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()).withComment("test4");
            StructField $org_scalatest_assert_macro_right3 = struct.apply("c");
            StructField structField5 = $org_scalatest_assert_macro_left3;
            StructField structField6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(structField5 != null ? !structField5.equals(structField6) : structField6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            StructField $org_scalatest_assert_macro_left4 = new StructField("d", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField $org_scalatest_assert_macro_right4 = struct.apply("d");
            StructField structField7 = $org_scalatest_assert_macro_left4;
            StructField structField8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(structField7 != null ? !structField7.equals(structField8) : structField8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            Option $org_scalatest_assert_macro_left5 = struct.apply("c").getComment();
            Option $org_scalatest_assert_macro_right5 = Option$.MODULE$.apply((Object)"test4");
            Option option = $org_scalatest_assert_macro_left5;
            Option option2 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            Option $org_scalatest_assert_macro_left6 = struct.apply("d").getComment();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("construct with String DataType", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType struct = new StructType().add("a", "int", true).add("b", "long", false).add("c", "string", true);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()));
            StructField $org_scalatest_assert_macro_right = struct.apply("a");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()));
            StructField $org_scalatest_assert_macro_right2 = struct.apply("b");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new StructField("c", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()));
            StructField $org_scalatest_assert_macro_right3 = struct.apply("c");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("extract fields from a StructType", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructField structField = new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
            StructField structField3 = new StructField("c", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            StructField structField4 = new StructField("d", (DataType)FloatType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            StructType struct = StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)structField4).$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()));
            StructField $org_scalatest_assert_macro_right = struct.apply("b");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            this.intercept((Function0 & Serializable)() -> struct.apply("e"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            StructField structField5 = new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
            StructField structField6 = new StructField("d", (DataType)FloatType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            StructType expectedStruct = StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)structField6).$colon$colon((Object)structField5));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(expectedStruct);
            StructType $org_scalatest_assert_macro_right2 = struct.apply((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", "d"})));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> struct.apply((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", "d", "e", "f"}))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("extract field index from a StructType", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType struct = StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)structField2).$colon$colon((Object)structField));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)struct.fieldIndex("a")));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)struct.fieldIndex("b")));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            return (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcI.sp & Serializable)() -> struct.fieldIndex("non_existent"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        this.test("fieldsMap returns map of name to StructField", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType struct = StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)structField2).$colon$colon((Object)structField));
            Map mapped = StructType$.MODULE$.fieldsMap(struct.fields(), StructType$.MODULE$.fieldsMap$default$2());
            scala.collection.immutable.Map expected = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(mapped);
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("fieldNames and names returns field names", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType struct = StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)structField2).$colon$colon((Object)structField));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(struct.fieldNames());
            Seq $org_scalatest_assert_macro_right = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(struct.names());
            Seq $org_scalatest_assert_macro_right2 = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("merge where right contains type conflict", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType left = StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)structField2).$colon$colon((Object)structField));
            StructField structField3 = new StructField("b", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType right = StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)structField3));
            SparkException x$1 = (SparkException)this.intercept((Function0 & Serializable)() -> left.merge(right, left.merge$default$2()), ClassTag$.MODULE$.apply(SparkException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            String x$2 = "CANNOT_MERGE_INCOMPATIBLE_DATA_TYPE";
            scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)"\"FLOAT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)"\"BIGINT\"")}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            QueryContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, "CANNOT_MERGE_INCOMPATIBLE_DATA_TYPE", x$4, x$3, x$5, x$6);
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        this.test("existsRecursively", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType struct = StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)structField2).$colon$colon((Object)structField));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(struct.existsRecursively((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$17(x$1))), "struct.existsRecursively(((x$1: org.apache.spark.sql.types.DataType) => x$1.isInstanceOf[org.apache.spark.sql.types.LongType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(struct.existsRecursively((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$18(x$2))), "struct.existsRecursively(((x$2: org.apache.spark.sql.types.DataType) => x$2.isInstanceOf[org.apache.spark.sql.types.StructType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(struct.existsRecursively((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$19(x$3))), "struct.existsRecursively(((x$3: org.apache.spark.sql.types.DataType) => x$3.isInstanceOf[org.apache.spark.sql.types.IntegerType]))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            MapType mapType = MapType$.MODULE$.apply((DataType)struct, (DataType)StringType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$20(x$4))), "mapType.existsRecursively(((x$4: org.apache.spark.sql.types.DataType) => x$4.isInstanceOf[org.apache.spark.sql.types.LongType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$21(x$5))), "mapType.existsRecursively(((x$5: org.apache.spark.sql.types.DataType) => x$5.isInstanceOf[org.apache.spark.sql.types.StructType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$22(x$6))), "mapType.existsRecursively(((x$6: org.apache.spark.sql.types.DataType) => x$6.isInstanceOf[org.apache.spark.sql.types.StringType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$23(x$7))), "mapType.existsRecursively(((x$7: org.apache.spark.sql.types.DataType) => x$7.isInstanceOf[org.apache.spark.sql.types.MapType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$24(x$8))), "mapType.existsRecursively(((x$8: org.apache.spark.sql.types.DataType) => x$8.isInstanceOf[org.apache.spark.sql.types.IntegerType]))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            ArrayType arrayType = ArrayType$.MODULE$.apply((DataType)mapType);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$25(x$9))), "arrayType.existsRecursively(((x$9: org.apache.spark.sql.types.DataType) => x$9.isInstanceOf[org.apache.spark.sql.types.LongType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$26(x$10))), "arrayType.existsRecursively(((x$10: org.apache.spark.sql.types.DataType) => x$10.isInstanceOf[org.apache.spark.sql.types.StructType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$27(x$11))), "arrayType.existsRecursively(((x$11: org.apache.spark.sql.types.DataType) => x$11.isInstanceOf[org.apache.spark.sql.types.StringType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$28(x$12))), "arrayType.existsRecursively(((x$12: org.apache.spark.sql.types.DataType) => x$12.isInstanceOf[org.apache.spark.sql.types.MapType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$29(x$13))), "arrayType.existsRecursively(((x$13: org.apache.spark.sql.types.DataType) => x$13.isInstanceOf[org.apache.spark.sql.types.ArrayType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$30(x$14))), "arrayType.existsRecursively(((x$14: org.apache.spark.sql.types.DataType) => x$14.isInstanceOf[org.apache.spark.sql.types.IntegerType]))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.test("SPARK-36224: Backwards compatibility test for NullType.json", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            DataType $org_scalatest_assert_macro_left = DataType$.MODULE$.fromJson("\"null\"");
            NullType$ $org_scalatest_assert_macro_right = NullType$.MODULE$;
            DataType dataType = $org_scalatest_assert_macro_left;
            NullType$ nullType$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(nullType$) : nullType$ != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        this.test("SPARK-42723: Parse timestamp_ltz as TimestampType", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            DataType $org_scalatest_assert_macro_left = DataType$.MODULE$.fromJson("\"timestamp_ltz\"");
            TimestampType$ $org_scalatest_assert_macro_right = TimestampType$.MODULE$;
            DataType dataType = $org_scalatest_assert_macro_left;
            TimestampType$ timestampType$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(timestampType$) : timestampType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            StructType expectedStructType = StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("ts", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            DataType $org_scalatest_assert_macro_left2 = DataType$.MODULE$.fromDDL("ts timestamp_ltz");
            StructType $org_scalatest_assert_macro_right2 = expectedStructType;
            DataType dataType2 = $org_scalatest_assert_macro_left2;
            StructType structType = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(structType) : structType != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        this.checkDataTypeFromJson((DataType)NullType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)NullType$.MODULE$);
        this.checkDataTypeFromJson((DataType)BooleanType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)BooleanType$.MODULE$);
        this.checkDataTypeFromJson((DataType)ByteType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)ByteType$.MODULE$);
        this.checkDataTypeFromJson((DataType)ShortType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)ShortType$.MODULE$);
        this.checkDataTypeFromJson((DataType)IntegerType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)IntegerType$.MODULE$);
        this.checkDataTypeFromJson((DataType)LongType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)LongType$.MODULE$);
        this.checkDataTypeFromJson((DataType)FloatType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)FloatType$.MODULE$);
        this.checkDataTypeFromJson((DataType)DoubleType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)DoubleType$.MODULE$);
        this.checkDataTypeFromJson((DataType)new DecimalType(10, 5));
        this.checkDataTypeFromDDL((DataType)new DecimalType(10, 5));
        this.checkDataTypeFromJson((DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT());
        this.checkDataTypeFromDDL((DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT());
        this.checkDataTypeFromJson((DataType)DateType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)DateType$.MODULE$);
        this.checkDataTypeFromJson((DataType)TimestampType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)TimestampType$.MODULE$);
        this.checkDataTypeFromJson((DataType)TimestampNTZType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)TimestampNTZType$.MODULE$);
        this.checkDataTypeFromJson((DataType)StringType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)StringType$.MODULE$);
        this.checkDataTypeFromJson((DataType)BinaryType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)BinaryType$.MODULE$);
        this.checkDataTypeFromJson((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true));
        this.checkDataTypeFromDDL((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true));
        this.checkDataTypeFromJson((DataType)new ArrayType((DataType)StringType$.MODULE$, false));
        this.checkDataTypeFromDDL((DataType)new ArrayType((DataType)StringType$.MODULE$, false));
        this.checkDataTypeFromJson((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true));
        this.checkDataTypeFromDDL((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true));
        this.checkDataTypeFromJson((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), false));
        this.checkDataTypeFromDDL((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), false));
        this.checkDataTypeFromJson((DataType)new CharType(1));
        this.checkDataTypeFromDDL((DataType)new CharType(1));
        this.checkDataTypeFromJson((DataType)new VarcharType(10));
        this.checkDataTypeFromDDL((DataType)new VarcharType(11));
        DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().foreach((Function1 & Serializable)dataType -> {
            this.checkDataTypeFromJson(dataType);
            return BoxedUnit.UNIT;
        });
        DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes().foreach((Function1 & Serializable)dataType -> {
            this.checkDataTypeFromJson(dataType);
            return BoxedUnit.UNIT;
        });
        DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes().foreach((Function1 & Serializable)dataType -> {
            this.checkDataTypeFromDDL(dataType);
            return BoxedUnit.UNIT;
        });
        DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().foreach((Function1 & Serializable)dataType -> {
            this.checkDataTypeFromDDL(dataType);
            return BoxedUnit.UNIT;
        });
        this.metadata = new MetadataBuilder().putString("name", "age").build();
        this.structType = StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), false, StructField$.MODULE$.apply$default$4()), new StructField("c", (DataType)DoubleType$.MODULE$, false, this.metadata())})));
        this.checkDataTypeFromJson((DataType)this.structType());
        this.checkDataTypeFromDDL((DataType)this.structType());
        this.test("fromJson throws an exception when given type string is invalid", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String message;
            String $org_scalatest_assert_macro_left = message = ((Throwable)this.intercept((Function0 & Serializable)() -> DataType$.MODULE$.fromJson("\"abcd\""), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295))).getMessage();
            String $org_scalatest_assert_macro_right = "Failed to convert the JSON string 'abcd' to a data type.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
            String $org_scalatest_assert_macro_left2 = message = ((Throwable)this.intercept((Function0 & Serializable)() -> DataType$.MODULE$.fromJson("{\"abcd\":\"a\"}"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301))).getMessage();
            String $org_scalatest_assert_macro_right2 = "Failed to convert the JSON string '{\"abcd\":\"a\"}' to a data type";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
            String $org_scalatest_assert_macro_left3 = message = ((Throwable)this.intercept((Function0 & Serializable)() -> DataType$.MODULE$.fromJson("{\"fields\": [{\"a\":123}], \"type\": \"struct\"}"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307))).getMessage();
            String $org_scalatest_assert_macro_right3 = "Failed to convert the JSON string '{\"a\":123}' to a field.";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
            String $org_scalatest_assert_macro_left4 = message = ((JsonParseException)this.intercept((Function0 & Serializable)() -> DataType$.MODULE$.fromJson("abcd"), ClassTag$.MODULE$.apply(JsonParseException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314))).getMessage();
            String $org_scalatest_assert_macro_right4 = "Unrecognized token 'abcd'";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 317));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        this.checkDefaultSize((DataType)NullType$.MODULE$, 1);
        this.checkDefaultSize((DataType)BooleanType$.MODULE$, 1);
        this.checkDefaultSize((DataType)ByteType$.MODULE$, 1);
        this.checkDefaultSize((DataType)ShortType$.MODULE$, 2);
        this.checkDefaultSize((DataType)IntegerType$.MODULE$, 4);
        this.checkDefaultSize((DataType)LongType$.MODULE$, 8);
        this.checkDefaultSize((DataType)FloatType$.MODULE$, 4);
        this.checkDefaultSize((DataType)DoubleType$.MODULE$, 8);
        this.checkDefaultSize((DataType)new DecimalType(10, 5), 8);
        this.checkDefaultSize((DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), 16);
        this.checkDefaultSize((DataType)DateType$.MODULE$, 4);
        this.checkDefaultSize((DataType)TimestampType$.MODULE$, 8);
        this.checkDefaultSize((DataType)TimestampNTZType$.MODULE$, 8);
        this.checkDefaultSize((DataType)StringType$.MODULE$, 20);
        this.checkDefaultSize((DataType)BinaryType$.MODULE$, 100);
        this.checkDefaultSize((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), 8);
        this.checkDefaultSize((DataType)new ArrayType((DataType)StringType$.MODULE$, false), 20);
        this.checkDefaultSize((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), 24);
        this.checkDefaultSize((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), false), 12);
        this.checkDefaultSize((DataType)this.structType(), 20);
        this.checkDefaultSize((DataType)new CharType(5), 5);
        this.checkDefaultSize((DataType)new CharType(100), 100);
        this.checkDefaultSize((DataType)new VarcharType(5), 5);
        this.checkDefaultSize((DataType)new VarcharType(10), 10);
        DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes().foreach((Function1 & Serializable)x$15 -> {
            this.checkDefaultSize((DataType)x$15, 4);
            return BoxedUnit.UNIT;
        });
        DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().foreach((Function1 & Serializable)x$16 -> {
            this.checkDefaultSize((DataType)x$16, 8);
            return BoxedUnit.UNIT;
        });
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), (DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), (DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), (DataType)new ArrayType((DataType)StringType$.MODULE$, false), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, true), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, true), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, false), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, false), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, false), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, true), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, true), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, false), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), true);
        StructField structField = new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)structField)), (DataType)StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)structField2)), true);
        StructField structField3 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)structField3)), (DataType)StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)structField4)), true);
        StructField structField5 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField6 = new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)structField5)), (DataType)StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)structField6)), true);
        StructField structField7 = new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField8 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)structField7)), (DataType)StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)structField8)), false);
        StructField structField9 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField10 = new StructField("b", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField11 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField12 = new StructField("b", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)structField10).$colon$colon((Object)structField9)), (DataType)StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)structField12).$colon$colon((Object)structField11)), false);
        this.checkCatalogString((DataType)NullType$.MODULE$);
        this.checkCatalogString((DataType)BooleanType$.MODULE$);
        this.checkCatalogString((DataType)ByteType$.MODULE$);
        this.checkCatalogString((DataType)ShortType$.MODULE$);
        this.checkCatalogString((DataType)IntegerType$.MODULE$);
        this.checkCatalogString((DataType)LongType$.MODULE$);
        this.checkCatalogString((DataType)FloatType$.MODULE$);
        this.checkCatalogString((DataType)DoubleType$.MODULE$);
        this.checkCatalogString((DataType)new DecimalType(10, 5));
        this.checkCatalogString((DataType)BinaryType$.MODULE$);
        this.checkCatalogString((DataType)StringType$.MODULE$);
        this.checkCatalogString((DataType)DateType$.MODULE$);
        this.checkCatalogString((DataType)TimestampType$.MODULE$);
        this.checkCatalogString((DataType)this.createStruct(4));
        this.checkCatalogString((DataType)this.createStruct(40));
        this.checkCatalogString((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$));
        this.checkCatalogString((DataType)ArrayType$.MODULE$.apply((DataType)this.createStruct(40)));
        this.checkCatalogString((DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$));
        this.checkCatalogString((DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)this.createStruct(40)));
        this.checkEqualsStructurally((DataType)BooleanType$.MODULE$, (DataType)BooleanType$.MODULE$, true, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$, true, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)IntegerType$.MODULE$, (DataType)LongType$.MODULE$, false, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), false, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$), true, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$, false), false, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)StringType$.MODULE$)), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$).add("g", (DataType)new StructType().add("f1", (DataType)StringType$.MODULE$)), true, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)StringType$.MODULE$, false)), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$).add("g", (DataType)new StructType().add("f1", (DataType)StringType$.MODULE$)), false, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)StringType$.MODULE$, false)), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$).add("g", (DataType)new StructType().add("f1", (DataType)StringType$.MODULE$)), true, true);
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)StringType$.MODULE$)), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$, false).add("g", (DataType)new StructType().add("f1", (DataType)StringType$.MODULE$)), true, true);
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), true, false);
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), false), (DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), false, false);
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true), false, false);
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), false), (DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), true, true);
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), false), (DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true), true, true);
        this.checkEqualsStructurally((DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), true, false);
        this.checkEqualsStructurally((DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), false), false, false);
        this.checkEqualsStructurally((DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true), false, false);
        this.checkEqualsStructurally((DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), false), true, true);
        this.checkEqualsStructurally((DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true), true, true);
        this.checkEqualsStructurally((DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), true, true);
        this.checkEqualsStructurallyByName((DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)), (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)), true, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)BooleanType$.MODULE$, (DataType)BooleanType$.MODULE$, true, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)BooleanType$.MODULE$, (DataType)IntegerType$.MODULE$, true, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)IntegerType$.MODULE$, (DataType)LongType$.MODULE$, true, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f2", (DataType)IntegerType$.MODULE$), (DataType)new StructType().add("f1", (DataType)LongType$.MODULE$).add("f2", (DataType)StringType$.MODULE$), true, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f2", (DataType)IntegerType$.MODULE$), (DataType)new StructType().add("f2", (DataType)LongType$.MODULE$).add("f1", (DataType)StringType$.MODULE$), false, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)StringType$.MODULE$)), (DataType)new StructType().add("f1", (DataType)LongType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)BooleanType$.MODULE$)), true, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)StringType$.MODULE$)), (DataType)new StructType().add("f", (DataType)new StructType().add("f2", (DataType)BooleanType$.MODULE$)).add("f1", (DataType)LongType$.MODULE$), false, this.checkEqualsStructurallyByName$default$4());
        this.checkEqualsStructurallyByName((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f2", (DataType)IntegerType$.MODULE$), (DataType)new StructType().add("F1", (DataType)LongType$.MODULE$).add("F2", (DataType)StringType$.MODULE$), true, false);
        this.checkEqualsStructurallyByName((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f2", (DataType)IntegerType$.MODULE$), (DataType)new StructType().add("F1", (DataType)LongType$.MODULE$).add("F2", (DataType)StringType$.MODULE$), false, true);
        this.test("SPARK-25031: MapType should produce current formatted string for complex types", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType keyType = StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", DataTypes.IntegerType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", DataTypes.IntegerType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            StructType valueType = StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("c", DataTypes.IntegerType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("d", DataTypes.IntegerType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            StringConcat stringConcat = new StringConcat(StringConcat$.MODULE$.$lessinit$greater$default$1());
            MapType qual$1 = MapType$.MODULE$.apply((DataType)keyType, (DataType)valueType);
            String x$7 = "";
            StringConcat x$8 = stringConcat;
            int x$9 = qual$1.buildFormattedString$default$3();
            qual$1.buildFormattedString("", x$8, x$9);
            String result = stringConcat.toString();
            String expected = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("-- key: struct\n        |    |-- a: integer (nullable = true)\n        |    |-- b: integer (nullable = true)\n        |-- value: struct (valueContainsNull = true)\n        |    |-- c: integer (nullable = true)\n        |    |-- d: integer (nullable = true)\n        |"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
            String $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 687));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 664));
    }
}

