/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.univocity.parsers.csv.CsvParser;
import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.csv.CSVInferSchema;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.SchemaOfCsv$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(csv[, options]) - Returns schema in the DDL format of CSV string.", examples="\n    Examples:\n      > SELECT _FUNC_('1,abc');\n       STRUCT<_c0: INT, _c1: STRING>\n  ", since="3.0.0", group="csv_funcs")
@ScalaSignature(bytes="\u0006\u0005\tea\u0001\u0002\u0011\"\u0001:B\u0001\"\u0015\u0001\u0003\u0016\u0004%\tA\u0015\u0005\t-\u0002\u0011\t\u0012)A\u0005'\"Aq\u000b\u0001BK\u0002\u0013\u0005\u0001\f\u0003\u0005e\u0001\tE\t\u0015!\u0003Z\u0011\u0015)\u0007\u0001\"\u0001g\u0011\u0015)\u0007\u0001\"\u0001k\u0011\u0015)\u0007\u0001\"\u0001m\u0011\u0015y\u0007\u0001\"\u0011q\u0011\u00159\b\u0001\"\u0011y\u0011!a\b\u0001#b\u0001\n\u0013i\bbBA\n\u0001\u0011\u0005\u0013Q\u0003\u0005\b\u0003G\u0001A\u0011IA\u0013\u0011\u001d\tI\u0004\u0001C!\u0003wAq!!\u0010\u0001\t#\ny\u0004C\u0005\u0002F\u0001\t\t\u0011\"\u0001\u0002H!I\u0011Q\n\u0001\u0012\u0002\u0013\u0005\u0011q\n\u0005\n\u0003K\u0002\u0011\u0013!C\u0001\u0003OB\u0011\"a\u001b\u0001\u0003\u0003%\t%!\u001c\t\u0013\u0005u\u0004!!A\u0005\u0002\u0005}\u0004\"CAD\u0001\u0005\u0005I\u0011AAE\u0011%\ty\tAA\u0001\n\u0003\n\t\nC\u0005\u0002 \u0002\t\t\u0011\"\u0001\u0002\"\"I\u0011Q\u0015\u0001\u0002\u0002\u0013\u0005\u0013q\u0015\u0005\n\u0003W\u0003\u0011\u0011!C!\u0003[;\u0011\"!5\"\u0003\u0003E\t!a5\u0007\u0011\u0001\n\u0013\u0011!E\u0001\u0003+Da!\u001a\u000e\u0005\u0002\u00055\b\"CAx5\u0005\u0005IQIAy\u0011%\t\u0019PGA\u0001\n\u0003\u000b)\u0010C\u0005\u0002|j\t\t\u0011\"!\u0002~\"I!q\u0002\u000e\u0002\u0002\u0013%!\u0011\u0003\u0002\f'\u000eDW-\\1PM\u000e\u001bhO\u0003\u0002#G\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t!S%\u0001\u0005dCR\fG._:u\u0015\t1s%A\u0002tc2T!\u0001K\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005)Z\u0013AB1qC\u000eDWMC\u0001-\u0003\ry'oZ\u0002\u0001'\u0019\u0001qfM\u001d@\u000bB\u0011\u0001'M\u0007\u0002C%\u0011!'\t\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011AgN\u0007\u0002k)\u0011a'I\u0001\bG>$WmZ3o\u0013\tATGA\bD_\u0012,w-\u001a8GC2d'-Y2l!\tQT(D\u0001<\u0015\taT%\u0001\u0004feJ|'o]\u0005\u0003}m\u0012q\"U;fef,%O]8sg\n\u000b7/\u001a\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0002\u0005\u0006)1oY1mC&\u0011A)\u0011\u0002\b!J|G-^2u!\t1eJ\u0004\u0002H\u0019:\u0011\u0001jS\u0007\u0002\u0013*\u0011!*L\u0001\u0007yI|w\u000e\u001e \n\u0003\tK!!T!\u0002\u000fA\f7m[1hK&\u0011q\n\u0015\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u001b\u0006\u000bQa\u00195jY\u0012,\u0012a\u0015\t\u0003aQK!!V\u0011\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\b_B$\u0018n\u001c8t+\u0005I\u0006\u0003\u0002._C\u0006t!a\u0017/\u0011\u0005!\u000b\u0015BA/B\u0003\u0019\u0001&/\u001a3fM&\u0011q\f\u0019\u0002\u0004\u001b\u0006\u0004(BA/B!\tQ&-\u0003\u0002dA\n11\u000b\u001e:j]\u001e\f\u0001b\u001c9uS>t7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u001dD\u0017\u000e\u0005\u00021\u0001!)\u0011+\u0002a\u0001'\")q+\u0002a\u00013R\u0011qm\u001b\u0005\u0006#\u001a\u0001\ra\u0015\u000b\u0004O6t\u0007\"B)\b\u0001\u0004\u0019\u0006\"B,\b\u0001\u0004\u0019\u0016\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003E\u0004\"A];\u000e\u0003MT!\u0001^\u0013\u0002\u000bQL\b/Z:\n\u0005Y\u001c(\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00119,H\u000e\\1cY\u0016,\u0012!\u001f\t\u0003\u0001jL!a_!\u0003\u000f\t{w\u000e\\3b]\u0006\u00191m\u001d<\u0016\u0003y\u00042a`A\u0004\u001b\t\t\tAC\u0002u\u0003\u0007Q1!!\u0002(\u0003\u0019)hn]1gK&!\u0011\u0011BA\u0001\u0005))FK\u0012\u001dTiJLgn\u001a\u0015\u0004\u0015\u00055\u0001c\u0001!\u0002\u0010%\u0019\u0011\u0011C!\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHCAA\f!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000fG\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002\"\u0005m!a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0003O\ti\u0003E\u0002A\u0003SI1!a\u000bB\u0005\r\te.\u001f\u0005\n\u0003_a\u0001\u0013!a\u0001\u0003c\t\u0011A\u001e\t\u0005\u0003g\t)$D\u0001$\u0013\r\t9d\t\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012!Y\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0007\u001d\f\t\u0005\u0003\u0004\u0002D9\u0001\raU\u0001\t]\u0016<8\t[5mI\u0006!1m\u001c9z)\u00159\u0017\u0011JA&\u0011\u001d\tv\u0002%AA\u0002MCqaV\b\u0011\u0002\u0003\u0007\u0011,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005E#fA*\u0002T-\u0012\u0011Q\u000b\t\u0005\u0003/\n\t'\u0004\u0002\u0002Z)!\u00111LA/\u0003%)hn\u00195fG.,GMC\u0002\u0002`\u0005\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019'!\u0017\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005%$fA-\u0002T\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u001c\u0011\t\u0005E\u00141P\u0007\u0003\u0003gRA!!\u001e\u0002x\u0005!A.\u00198h\u0015\t\tI(\u0001\u0003kCZ\f\u0017bA2\u0002t\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0011\t\u0004\u0001\u0006\r\u0015bAAC\u0003\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qEAF\u0011%\ti\tFA\u0001\u0002\u0004\t\t)A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003'\u0003b!!&\u0002\u001c\u0006\u001dRBAAL\u0015\r\tI*Q\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAO\u0003/\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019\u00110a)\t\u0013\u00055e#!AA\u0002\u0005\u001d\u0012A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u001c\u0002*\"I\u0011QR\f\u0002\u0002\u0003\u0007\u0011\u0011Q\u0001\u0007KF,\u0018\r\\:\u0015\u0007e\fy\u000bC\u0005\u0002\u000eb\t\t\u00111\u0001\u0002(!\u001a\u0002!a-\u0002:\u0006m\u0016qXAa\u0003\u000b\f9-a3\u0002NB\u0019\u0001'!.\n\u0007\u0005]\u0016EA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005u\u0016\u0001S0G+:\u001bu\fK2tmnc\u0003e\u001c9uS>t7/X\u0015![\u0001\u0012V\r^;s]N\u00043o\u00195f[\u0006\u0004\u0013N\u001c\u0011uQ\u0016\u0004C\t\u0012'!M>\u0014X.\u0019;!_\u001a\u00043i\u0015,!gR\u0014\u0018N\\4/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAb\u0003YS\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ\u0019-C\n\u001cw%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!'R\u0013Vk\u0011+=?\u000e\u0004$\bI%O)2\u0002slY\u0019;AM#&+\u0013(H})\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002J\u0006)1G\f\u0019/a\u0005)qM]8va\u0006\u0012\u0011qZ\u0001\nGN4xLZ;oGN\f1bU2iK6\fwJZ\"tmB\u0011\u0001GG\n\u00065\u0005]\u00171\u001d\t\b\u00033\fynU-h\u001b\t\tYNC\u0002\u0002^\u0006\u000bqA];oi&lW-\u0003\u0003\u0002b\u0006m'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011Q]Av\u001b\t\t9O\u0003\u0003\u0002j\u0006]\u0014AA5p\u0013\ry\u0015q\u001d\u000b\u0003\u0003'\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003_\nQ!\u00199qYf$RaZA|\u0003sDQ!U\u000fA\u0002MCQaV\u000fA\u0002e\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u0000\n-\u0001#\u0002!\u0003\u0002\t\u0015\u0011b\u0001B\u0002\u0003\n1q\n\u001d;j_:\u0004R\u0001\u0011B\u0004'fK1A!\u0003B\u0005\u0019!V\u000f\u001d7fe!A!Q\u0002\u0010\u0002\u0002\u0003\u0007q-A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa\u0005\u0011\t\u0005E$QC\u0005\u0005\u0005/\t\u0019H\u0001\u0004PE*,7\r\u001e")
public class SchemaOfCsv
extends UnaryExpression
implements CodegenFallback,
QueryErrorsBase,
Serializable {
    private transient UTF8String csv;
    private final Expression child;
    private final Map<String, String> options;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Map<String, String>>> unapply(SchemaOfCsv x$0) {
        return SchemaOfCsv$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Map<String, String>>, SchemaOfCsv> tupled() {
        return SchemaOfCsv$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Map<String, String>, SchemaOfCsv>> curried() {
        return SchemaOfCsv$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    private UTF8String csv$lzycompute() {
        SchemaOfCsv schemaOfCsv = this;
        synchronized (schemaOfCsv) {
            if (!this.bitmap$trans$0) {
                this.csv = (UTF8String)this.child().eval(this.child().eval$default$1());
                this.bitmap$trans$0 = true;
            }
        }
        return this.csv;
    }

    private UTF8String csv() {
        return !this.bitmap$trans$0 ? this.csv$lzycompute() : this.csv;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.child().foldable() && this.csv() != null ? super.checkInputDataTypes() : (!this.child().foldable() ? new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)"csv"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.child().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)this.toSQLExpr(this.child()))})))) : new TypeCheckResult.DataTypeMismatch("UNEXPECTED_NULL", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"csv")})))));
    }

    @Override
    public Object eval(InternalRow v) {
        Map exprOptions = (Map)this.options().$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lineSep"), (Object)Character.toString('\uffff'))})));
        CSVOptions parsedOptions = new CSVOptions((Map<String, String>)exprOptions, true, "UTC");
        CsvParser parser = new CsvParser(parsedOptions.asParserSettings());
        String[] row = parser.parseLine(this.csv().toString());
        Predef$.MODULE$.assert(row != null, (Function0 & Serializable)() -> "Parsed CSV record should not be null.");
        String[] header = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])row))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int index = tuple2._2$mcI$sp();
            String string = new StringBuilder(2).append("_c").append(index).toString();
            return string;
        }, ClassTag$.MODULE$.apply(String.class));
        DataType[] startType = (DataType[])Array$.MODULE$.fill(header.length, (Function0 & Serializable)() -> NullType$.MODULE$, ClassTag$.MODULE$.apply(DataType.class));
        CSVInferSchema inferSchema = new CSVInferSchema(parsedOptions);
        DataType[] fieldTypes = inferSchema.inferRowType(startType, row);
        StructType st = new StructType(inferSchema.toStructFields(fieldTypes, header));
        return UTF8String.fromString((String)st.sql());
    }

    @Override
    public String prettyName() {
        return "schema_of_csv";
    }

    @Override
    public SchemaOfCsv withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public SchemaOfCsv copy(Expression child, Map<String, String> options) {
        return new SchemaOfCsv(child, options);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    @Override
    public String productPrefix() {
        return "SchemaOfCsv";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.options();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SchemaOfCsv;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "options";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SchemaOfCsv)) return false;
        boolean bl = true;
        if (!bl) return false;
        SchemaOfCsv schemaOfCsv = (SchemaOfCsv)x$1;
        Expression expression = this.child();
        Expression expression2 = schemaOfCsv.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = schemaOfCsv.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (!schemaOfCsv.canEqual(this)) return false;
        return true;
    }

    public SchemaOfCsv(Expression child, Map<String, String> options) {
        this.child = child;
        this.options = options;
        CodegenFallback.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
    }

    public SchemaOfCsv(Expression child) {
        this(child, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public SchemaOfCsv(Expression child, Expression options) {
        this(child, ExprUtils$.MODULE$.convertToMapData(options));
    }
}

