/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.WrappedString;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class CSVExprUtils$ {
    public static final CSVExprUtils$ MODULE$ = new CSVExprUtils$();

    public Iterator<String> filterCommentAndEmpty(Iterator<String> iter, CSVOptions options) {
        if (options.isCommentSet()) {
            String commentPrefix = Character.toString(options.comment());
            return iter.filter((Function1 & Serializable)line -> BoxesRunTime.boxToBoolean((boolean)CSVExprUtils$.$anonfun$filterCommentAndEmpty$1(commentPrefix, line)));
        }
        return iter.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$1.trim()))));
    }

    public Iterator<String> skipComments(Iterator<String> iter, CSVOptions options) {
        if (options.isCommentSet()) {
            String commentPrefix = Character.toString(options.comment());
            return iter.dropWhile((Function1 & Serializable)line -> BoxesRunTime.boxToBoolean((boolean)CSVExprUtils$.$anonfun$skipComments$1(commentPrefix, line)));
        }
        return iter.dropWhile((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CSVExprUtils$.$anonfun$skipComments$2(x$2)));
    }

    public Option<String> extractHeader(Iterator<String> iter, CSVOptions options) {
        Iterator<String> nonEmptyLines = this.skipComments(iter, options);
        if (nonEmptyLines.hasNext()) {
            return new Some(nonEmptyLines.next());
        }
        return None$.MODULE$;
    }

    public char toChar(String str) throws SparkIllegalArgumentException {
        char c;
        SeqOps seqOps;
        SeqOps seqOps2;
        SeqOps seqOps3;
        SeqOps seqOps4;
        SeqOps seqOps5;
        SeqOps seqOps6;
        SeqOps seqOps7;
        SeqOps seqOps8;
        SeqOps seqOps9;
        char c2;
        SeqOps seqOps10;
        SeqOps seqOps11;
        WrappedString wrappedString = Predef$.MODULE$.wrapString(str);
        if (wrappedString != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps11 = package$.MODULE$.Seq().unapplySeq((SeqOps)wrappedString)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps11)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps11), 0) == 0) {
            throw new SparkIllegalArgumentException("INVALID_DELIMITER_VALUE.EMPTY_STRING");
        }
        if (wrappedString != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps10 = package$.MODULE$.Seq().unapplySeq((SeqOps)wrappedString)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps10)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps10), 1) == 0 && '\\' == (c2 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps10), 0)))) {
            throw new SparkIllegalArgumentException("INVALID_DELIMITER_VALUE.SINGLE_BACKSLASH");
        }
        if (wrappedString != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps9 = package$.MODULE$.Seq().unapplySeq((SeqOps)wrappedString)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps9)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps9), 1) == 0) {
            char c3 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps9), 0));
            return c3;
        }
        if (wrappedString != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps8 = package$.MODULE$.Seq().unapplySeq((SeqOps)wrappedString)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps8)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps8), 2) == 0) {
            char c4 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps8), 0));
            char c5 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps8), 1));
            if ('\\' == c4 && 't' == c5) {
                return '\t';
            }
        }
        if (wrappedString != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps7 = package$.MODULE$.Seq().unapplySeq((SeqOps)wrappedString)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps7)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps7), 2) == 0) {
            char c6 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps7), 0));
            char c7 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps7), 1));
            if ('\\' == c6 && 'r' == c7) {
                return '\r';
            }
        }
        if (wrappedString != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps6 = package$.MODULE$.Seq().unapplySeq((SeqOps)wrappedString)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 2) == 0) {
            char c8 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 0));
            char c9 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 1));
            if ('\\' == c8 && 'b' == c9) {
                return '\b';
            }
        }
        if (wrappedString != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps5 = package$.MODULE$.Seq().unapplySeq((SeqOps)wrappedString)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 2) == 0) {
            char c10 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 0));
            char c11 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 1));
            if ('\\' == c10 && 'f' == c11) {
                return '\f';
            }
        }
        if (wrappedString != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps4 = package$.MODULE$.Seq().unapplySeq((SeqOps)wrappedString)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 2) == 0) {
            char c12 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 0));
            char c13 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 1));
            if ('\\' == c12 && '\"' == c13) {
                return '\"';
            }
        }
        if (wrappedString != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = package$.MODULE$.Seq().unapplySeq((SeqOps)wrappedString)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 2) == 0) {
            char c14 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0));
            char c15 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1));
            if ('\\' == c14 && '\'' == c15) {
                return '\'';
            }
        }
        if (wrappedString != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq((SeqOps)wrappedString)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2) == 0) {
            char c16 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0));
            char c17 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1));
            if ('\\' == c16 && '\\' == c17) {
                return '\\';
            }
        }
        String string = str;
        String string2 = "\u0000";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return '\u0000';
        }
        if (wrappedString != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)wrappedString)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0 && '\\' == (c = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)))) {
            throw new SparkIllegalArgumentException("INVALID_DELIMITER_VALUE.UNSUPPORTED_SPECIAL_CHARACTER", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"str"), (Object)str)})));
        }
        throw new SparkIllegalArgumentException("INVALID_DELIMITER_VALUE.DELIMITER_LONGER_THAN_EXPECTED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"str"), (Object)str)})));
    }

    public String toDelimiterStr(String str) {
        String chunk;
        Object delimiter = "";
        for (int idx = 0; idx < str.length(); idx += chunk.length()) {
            int readAhead = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), idx) == '\\' ? 2 : 1;
            chunk = StringUtils.substring((String)str, (int)idx, (int)(idx + readAhead));
            delimiter = (String)delimiter + this.toChar(chunk);
        }
        return StringOps$.MODULE$.mkString$extension(Predef$.MODULE$.augmentString((String)delimiter), "");
    }

    public static final /* synthetic */ boolean $anonfun$filterCommentAndEmpty$1(String commentPrefix$1, String line) {
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(line.trim())) && !line.startsWith(commentPrefix$1);
    }

    public static final /* synthetic */ boolean $anonfun$skipComments$1(String commentPrefix$2, String line) {
        return line.trim().isEmpty() || line.startsWith(commentPrefix$2);
    }

    public static final /* synthetic */ boolean $anonfun$skipComments$2(String x$2) {
        return x$2.trim().isEmpty();
    }

    private CSVExprUtils$() {
    }
}

