/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.Serializable;
import java.io.Writer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.CSVOptions$;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalStringStyles$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.catalyst.util.SparkStringUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.util.ArrayImplicits$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001de\u0001\u0002\u000f\u001e\u0001)B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!A\u0011\t\u0001B\u0001B\u0003%!\tC\u0003G\u0001\u0011\u0005q\tC\u0004M\u0001\t\u0007I\u0011B'\t\re\u0003\u0001\u0015!\u0003O\u0011\u001dQ\u0006A1A\u0005\nmCaa\u0018\u0001!\u0002\u0013aV\u0001\u00021\u0001\t\u0005Dq\u0001\u001f\u0001C\u0002\u0013%\u0011\u0010\u0003\u0004\u0000\u0001\u0001\u0006IA\u001f\u0005\n\u0003\u0003\u0001!\u0019!C\u0005\u0003\u0007A\u0001\"!\u0005\u0001A\u0003%\u0011Q\u0001\u0005\n\u0003'\u0001!\u0019!C\u0005\u0003\u0007A\u0001\"!\u0006\u0001A\u0003%\u0011Q\u0001\u0005\n\u0003/\u0001!\u0019!C\u0005\u00033A\u0001\"!\t\u0001A\u0003%\u00111\u0004\u0005\n\u0003G\u0001!\u0019!C\u0005\u0003KA\u0001\"!\f\u0001A\u0003%\u0011q\u0005\u0005\b\u0003_\u0001A\u0011BA\u0019\u0011\u001d\ti\u0004\u0001C\u0005\u0003\u007fAq!!\u0018\u0001\t\u0013\ty\u0006C\u0004\u0002t\u0001!\t!!\u001e\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0004bBAB\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0003\u000b\u0003A\u0011AA;\u0005I)f.\u001b<pG&$\u0018pR3oKJ\fGo\u001c:\u000b\u0005yy\u0012aA2tm*\u0011\u0001%I\u0001\tG\u0006$\u0018\r\\=ti*\u0011!eI\u0001\u0004gFd'B\u0001\u0013&\u0003\u0015\u0019\b/\u0019:l\u0015\t1s%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Q\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u000b\t\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\u0007\u0003:L(+\u001a4\u0002\rM\u001c\u0007.Z7b!\t\u0019d'D\u00015\u0015\t)\u0014%A\u0003usB,7/\u0003\u00028i\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\r]\u0014\u0018\u000e^3s!\tQt(D\u0001<\u0015\taT(\u0001\u0002j_*\ta(\u0001\u0003kCZ\f\u0017B\u0001!<\u0005\u00199&/\u001b;fe\u00069q\u000e\u001d;j_:\u001c\bCA\"E\u001b\u0005i\u0012BA#\u001e\u0005)\u00195KV(qi&|gn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\t!K%j\u0013\t\u0003\u0007\u0002AQ!\r\u0003A\u0002IBQ\u0001\u000f\u0003A\u0002eBQ!\u0011\u0003A\u0002\t\u000bab\u001e:ji\u0016\u00148+\u001a;uS:<7/F\u0001O!\tyu+D\u0001Q\u0015\tq\u0012K\u0003\u0002S'\u00069\u0001/\u0019:tKJ\u001c(B\u0001+V\u0003%)h.\u001b<pG&$\u0018PC\u0001W\u0003\r\u0019w.\\\u0005\u00031B\u0013\u0011cQ:w/JLG/\u001a:TKR$\u0018N\\4t\u0003=9(/\u001b;feN+G\u000f^5oON\u0004\u0013aA4f]V\tA\f\u0005\u0002P;&\u0011a\f\u0015\u0002\n\u0007N4xK]5uKJ\fAaZ3oA\tqa+\u00197vK\u000e{gN^3si\u0016\u0014\b#\u0002\u0017cI*l\u0017BA2.\u0005%1UO\\2uS>t'\u0007\u0005\u0002fQ6\taM\u0003\u0002h?\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\tIgM\u0001\nTa\u0016\u001c\u0017.\u00197ju\u0016$w)\u001a;uKJ\u001c\bC\u0001\u0017l\u0013\taWFA\u0002J]R\u0004\"A\\;\u000f\u0005=\u001c\bC\u00019.\u001b\u0005\t(B\u0001:*\u0003\u0019a$o\\8u}%\u0011A/L\u0001\u0007!J,G-\u001a4\n\u0005Y<(AB*ue&twM\u0003\u0002u[\u0005ya/\u00197vK\u000e{gN^3si\u0016\u00148/F\u0001{!\ra30`\u0005\u0003y6\u0012Q!\u0011:sCf\u0004\"A`\u0005\u000e\u0003\u0001\t\u0001C^1mk\u0016\u001cuN\u001c<feR,'o\u001d\u0011\u0002%QLW.Z:uC6\u0004hi\u001c:nCR$XM]\u000b\u0003\u0003\u000b\u0001B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017y\u0012\u0001B;uS2LA!a\u0004\u0002\n\t\u0011B+[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s\u0003M!\u0018.\\3ti\u0006l\u0007OR8s[\u0006$H/\u001a:!\u0003U!\u0018.\\3ti\u0006l\u0007O\u0014+[\r>\u0014X.\u0019;uKJ\fa\u0003^5nKN$\u0018-\u001c9O)j3uN]7biR,'\u000fI\u0001\u000eI\u0006$XMR8s[\u0006$H/\u001a:\u0016\u0005\u0005m\u0001\u0003BA\u0004\u0003;IA!a\b\u0002\n\tiA)\u0019;f\r>\u0014X.\u0019;uKJ\fa\u0002Z1uK\u001a{'/\\1ui\u0016\u0014\b%A\fok2d\u0017i])v_R,G-R7qif\u001cFO]5oOV\u0011\u0011q\u0005\t\u0004Y\u0005%\u0012bAA\u0016[\t9!i\\8mK\u0006t\u0017\u0001\u00078vY2\f5/U;pi\u0016$W)\u001c9usN#(/\u001b8hA\u0005iQ.Y6f\u0007>tg/\u001a:uKJ$2!`A\u001a\u0011\u001d\t)\u0004\u0006a\u0001\u0003o\t\u0001\u0002Z1uCRK\b/\u001a\t\u0004g\u0005e\u0012bAA\u001ei\tAA)\u0019;b)f\u0004X-\u0001\u0006baB,g\u000e\u001a(vY2$B!!\u0011\u0002HA\u0019A&a\u0011\n\u0007\u0005\u0015SF\u0001\u0003V]&$\bbBA%+\u0001\u0007\u00111J\u0001\bEVLG\u000eZ3s!\u0011\ti%a\u0016\u000f\t\u0005=\u00131\u000b\b\u0004a\u0006E\u0013\"\u0001\u0018\n\u0007\u0005US&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00131\f\u0002\u000e'R\u0014\u0018N\\4Ck&dG-\u001a:\u000b\u0007\u0005US&\u0001\u0006d_:4XM\u001d;S_^$B!!\u0019\u0002hA)\u0011QJA2[&!\u0011QMA.\u0005\r\u0019V-\u001d\u0005\b\u0003S2\u0002\u0019AA6\u0003\r\u0011xn\u001e\t\u0005\u0003[\ny'D\u0001 \u0013\r\t\th\b\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\u0007xe&$X\rS3bI\u0016\u00148\u000f\u0006\u0002\u0002B\u0005)qO]5uKR!\u0011\u0011IA>\u0011\u001d\tI\u0007\u0007a\u0001\u0003W\nQb\u001e:ji\u0016$vn\u0015;sS:<GcA7\u0002\u0002\"9\u0011\u0011N\rA\u0002\u0005-\u0014!B2m_N,\u0017!\u00024mkND\u0007")
public class UnivocityGenerator {
    private final CSVOptions options;
    private final CsvWriterSettings writerSettings;
    private final CsvWriter gen;
    private final Function2<SpecializedGetters, Object, String>[] valueConverters;
    private final TimestampFormatter timestampFormatter;
    private final TimestampFormatter timestampNTZFormatter;
    private final DateFormatter dateFormatter;
    private final boolean nullAsQuotedEmptyString;

    private CsvWriterSettings writerSettings() {
        return this.writerSettings;
    }

    private CsvWriter gen() {
        return this.gen;
    }

    private Function2<SpecializedGetters, Object, String>[] valueConverters() {
        return this.valueConverters;
    }

    private TimestampFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    private DateFormatter dateFormatter() {
        return this.dateFormatter;
    }

    private boolean nullAsQuotedEmptyString() {
        return this.nullAsQuotedEmptyString;
    }

    private Function2<SpecializedGetters, Object, String> makeConverter(DataType dataType2) {
        DataType dataType3;
        while (true) {
            if (BinaryType$.MODULE$.equals(dataType3 = dataType2)) {
                return (Function2 & Serializable)(getter, ordinal) -> SparkStringUtils$.MODULE$.getHexString(getter.getBinary(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
            if (DateType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$2(this, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
            if (TimestampType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$3(this, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
            if (TimestampNTZType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$4(this, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
            if (dataType3 instanceof YearMonthIntervalType) {
                YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType3;
                byte start = yearMonthIntervalType.startField();
                byte end = yearMonthIntervalType.endField();
                return (Function2 & Serializable)(getter, ordinal) -> IntervalUtils$.MODULE$.toYearMonthIntervalString(getter.getInt(BoxesRunTime.unboxToInt((Object)ordinal)), IntervalStringStyles$.MODULE$.ANSI_STYLE(), start, end);
            }
            if (dataType3 instanceof DayTimeIntervalType) {
                DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType3;
                byte start = dayTimeIntervalType.startField();
                byte end = dayTimeIntervalType.endField();
                return (Function2 & Serializable)(getter, ordinal) -> IntervalUtils$.MODULE$.toDayTimeIntervalString(getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)), IntervalStringStyles$.MODULE$.ANSI_STYLE(), start, end);
            }
            if (!(dataType3 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType3;
            dataType2 = userDefinedType.sqlType();
        }
        if (dataType3 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType3;
            DataType et = arrayType.elementType();
            Function2<SpecializedGetters, Object, String> elementConverter = this.makeConverter(et);
            return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$7(this, elementConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
        }
        if (dataType3 instanceof MapType) {
            MapType mapType = (MapType)dataType3;
            DataType kt = mapType.keyType();
            DataType vt = mapType.valueType();
            Function2<SpecializedGetters, Object, String> keyConverter = this.makeConverter(kt);
            Function2<SpecializedGetters, Object, String> valueConverter = this.makeConverter(vt);
            return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$8(this, keyConverter, valueConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
        }
        if (dataType3 instanceof StructType) {
            StructType structType = (StructType)dataType3;
            StructField[] fields = structType.fields();
            Function2[] converters = (Function2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)x$2 -> x$2.dataType(), ClassTag$.MODULE$.apply(DataType.class))), (Function1 & Serializable)dataType -> this.makeConverter((DataType)dataType), ClassTag$.MODULE$.apply(Function2.class));
            return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$11(this, fields, converters, getter, BoxesRunTime.unboxToInt((Object)ordinal));
        }
        if (dataType3 != null) {
            DataType dataType4 = dataType3;
            return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$12(dataType4, getter, BoxesRunTime.unboxToInt((Object)ordinal));
        }
        throw new MatchError((Object)dataType3);
    }

    private void appendNull(StringBuilder builder) {
        Option option = this.options.parameters().get(CSVOptions$.MODULE$.NULL_VALUE());
        if (option instanceof Some) {
            builder.append(" " + this.options.nullValue());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError((Object)option);
    }

    private Seq<String> convertRow(InternalRow row) {
        String[] values = new String[row.numFields()];
        for (int i = 0; i < row.numFields(); ++i) {
            if (!row.isNullAt(i)) {
                values[i] = (String)this.valueConverters()[i].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i));
                continue;
            }
            if (!this.nullAsQuotedEmptyString()) continue;
            values[i] = this.options.nullValue();
        }
        return ArrayImplicits$.MODULE$.SparkArrayOps((Object)values).toImmutableArraySeq();
    }

    public void writeHeaders() {
        this.gen().writeHeaders();
    }

    public void write(InternalRow row) {
        this.gen().writeRow((Object[])this.convertRow(row).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public String writeToString(InternalRow row) {
        return this.gen().writeRowToString((Object[])this.convertRow(row).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public void close() {
        this.gen().close();
    }

    public void flush() {
        this.gen().flush();
    }

    public static final /* synthetic */ String $anonfun$makeConverter$2(UnivocityGenerator $this, SpecializedGetters getter, int ordinal) {
        return $this.dateFormatter().format(getter.getInt(ordinal));
    }

    public static final /* synthetic */ String $anonfun$makeConverter$3(UnivocityGenerator $this, SpecializedGetters getter, int ordinal) {
        return $this.timestampFormatter().format(getter.getLong(ordinal));
    }

    public static final /* synthetic */ String $anonfun$makeConverter$4(UnivocityGenerator $this, SpecializedGetters getter, int ordinal) {
        return $this.timestampNTZFormatter().format(DateTimeUtils$.MODULE$.microsToLocalDateTime(getter.getLong(ordinal)));
    }

    public static final /* synthetic */ String $anonfun$makeConverter$7(UnivocityGenerator $this, Function2 elementConverter$1, SpecializedGetters getter, int ordinal) {
        ArrayData array = getter.getArray(ordinal);
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        if (array.numElements() > 0) {
            if (array.isNullAt(0)) {
                $this.appendNull(builder);
                v0 = BoxedUnit.UNIT;
            } else {
                v0 = builder.append((String)elementConverter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)0)));
            }
            for (int i = 1; i < array.numElements(); ++i) {
                BoxedUnit boxedUnit;
                builder.append(",");
                if (array.isNullAt(i)) {
                    $this.appendNull(builder);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = builder.append(" " + elementConverter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i)));
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public static final /* synthetic */ String $anonfun$makeConverter$8(UnivocityGenerator $this, Function2 keyConverter$1, Function2 valueConverter$1, SpecializedGetters getter, int ordinal) {
        MapData map = getter.getMap(ordinal);
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if (map.numElements() > 0) {
            ArrayData keyArray = map.keyArray();
            ArrayData valueArray = map.valueArray();
            builder.append((String)keyConverter$1.apply((Object)keyArray, (Object)BoxesRunTime.boxToInteger((int)0)));
            builder.append(" ->");
            if (valueArray.isNullAt(0)) {
                $this.appendNull(builder);
                v0 = BoxedUnit.UNIT;
            } else {
                v0 = builder.append(" " + valueConverter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)0)));
            }
            for (int i = 1; i < map.numElements(); ++i) {
                BoxedUnit boxedUnit;
                builder.append(", ");
                builder.append((String)keyConverter$1.apply((Object)keyArray, (Object)BoxesRunTime.boxToInteger((int)i)));
                builder.append(" ->");
                if (valueArray.isNullAt(i)) {
                    $this.appendNull(builder);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = builder.append(" " + valueConverter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i)));
            }
        }
        builder.append("}");
        return builder.toString();
    }

    public static final /* synthetic */ String $anonfun$makeConverter$11(UnivocityGenerator $this, StructField[] fields$1, Function2[] converters$1, SpecializedGetters getter, int ordinal) {
        InternalRow row = getter.getStruct(ordinal, fields$1.length);
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if (row.numFields() > 0) {
            if (row.isNullAt(0)) {
                $this.appendNull(builder);
                v0 = BoxedUnit.UNIT;
            } else {
                v0 = builder.append((String)converters$1[0].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)0)));
            }
            for (int i = 1; i < row.numFields(); ++i) {
                BoxedUnit boxedUnit;
                builder.append(",");
                if (row.isNullAt(i)) {
                    $this.appendNull(builder);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = builder.append(" " + converters$1[i].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i)));
            }
        }
        builder.append("}");
        return builder.toString();
    }

    public static final /* synthetic */ String $anonfun$makeConverter$12(DataType x14$1, SpecializedGetters getter, int ordinal) {
        return getter.get(ordinal, x14$1).toString();
    }

    public UnivocityGenerator(StructType schema, Writer writer, CSVOptions options) {
        this.options = options;
        this.writerSettings = options.asWriterSettings();
        this.writerSettings().setHeaders(schema.fieldNames());
        this.gen = new CsvWriter(writer, this.writerSettings());
        this.valueConverters = (Function2[])((IterableOnceOps)((IterableOps)schema.map((Function1 & Serializable)x$1 -> x$1.dataType())).map((Function1 & Serializable)dataType -> this.makeConverter((DataType)dataType))).toArray(ClassTag$.MODULE$.apply(Function2.class));
        this.timestampFormatter = TimestampFormatter$.MODULE$.apply(options.timestampFormatInWrite(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false);
        this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(options.timestampNTZFormatInWrite(), options.zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false, true);
        this.dateFormatter = DateFormatter$.MODULE$.apply(options.dateFormatInWrite(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false);
        this.nullAsQuotedEmptyString = BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_NULL_VALUE_WRITTEN_AS_QUOTED_EMPTY_STRING_CSV()));
    }
}

