/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import org.apache.spark.SparkUpgradeException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.NoopFilters;
import org.apache.spark.sql.catalyst.OrderedFilters;
import org.apache.spark.sql.catalyst.StructFilters;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.BadRecordException;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.LazyBadRecordCauseWrapper;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.ExecutionErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t}g\u0001\u0002\u001a4\u0001\u0001C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t)\u0002\u0011\t\u0011)A\u0005\u001d\"AQ\u000b\u0001BC\u0002\u0013\u0005a\u000b\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003X\u0011!a\u0006A!A!\u0002\u0013i\u0006\"B8\u0001\t\u0003\u0001\b\"B8\u0001\t\u00031\b\"B8\u0001\t\u0003QX\u0001\u0002@\u0001\t}D\u0011\"a\u0007\u0001\u0005\u0004%I!!\b\t\u0011\u0005-\u0002\u0001)A\u0005\u0003?Aq!!\f\u0001\t\u0013\ty\u0003C\u0005\u00028\u0001\u0011\r\u0011\"\u0003\u0002:!9\u00111\b\u0001!\u0002\u0013q\u0005\"CA\u001f\u0001\t\u0007I\u0011AA \u0011!\t9\u0006\u0001Q\u0001\n\u0005\u0005\u0003\"CA-\u0001\t\u0007I\u0011BA.\u0011!\ty\u0007\u0001Q\u0001\n\u0005u\u0003\"CA9\u0001\t\u0007I\u0011BA:\u0011!\tY\b\u0001Q\u0001\n\u0005U\u0004BCA?\u0001!\u0015\r\u0011\"\u0003\u0002\u0000!Q\u0011Q\u0012\u0001\t\u0006\u0004%I!a \t\u0015\u0005=\u0005\u0001#b\u0001\n\u0013\t\t\nC\u0005\u0002\u001a\u0002\u0011\r\u0011\"\u0003\u0002\u001c\"A\u0011Q\u0015\u0001!\u0002\u0013\ti\nC\u0005\u0002(\u0002\u0011\r\u0011\"\u0003\u00020!A\u0011\u0011\u0016\u0001!\u0002\u0013\t\t\u0004C\u0005\u0002,\u0002\u0011\r\u0011\"\u0003\u00020!A\u0011Q\u0016\u0001!\u0002\u0013\t\t\u0004C\u0004\u00020\u0002!I!!-\t\u0013\u0005\u0005\u0007A1A\u0005\n\u0005\r\u0007\u0002CAf\u0001\u0001\u0006I!!2\t\u0013\u00055\u0007A1A\u0005\n\u0005=\u0007\u0002CAr\u0001\u0001\u0006I!!5\t\u000f\u0005\u0015\b\u0001\"\u0001\u0002h\"I\u00111 \u0001\u0012\u0002\u0013\u0005\u0011Q \u0005\b\u0005'\u0001A\u0011\u0002B\u000b\u0011%\u00119\u0003\u0001b\u0001\n\u0003\u0011I\u0003\u0003\u0005\u0003:\u0001\u0001\u000b\u0011\u0002B\u0016\u0011%\u0011Y\u0004\u0001b\u0001\n\u0013\u0011i\u0004\u0003\u0005\u0003H\u0001\u0001\u000b\u0011\u0002B \u0011\u001d\u0011I\u0005\u0001C\u0005\u0005\u0017:\u0001B!\u00154\u0011\u00039$1\u000b\u0004\beMB\ta\u000eB+\u0011\u0019yG\u0006\"\u0001\u0003X!9!\u0011\f\u0017\u0005\u0002\tm\u0003b\u0002B?Y\u0011\u0005!q\u0010\u0005\b\u0005+cC\u0011\u0002BL\u0011\u001d\u0011y\r\fC\u0001\u0005#\u0014q\"\u00168jm>\u001c\u0017\u000e^=QCJ\u001cXM\u001d\u0006\u0003iU\n1aY:w\u0015\t1t'\u0001\u0005dCR\fG._:u\u0015\tA\u0014(A\u0002tc2T!AO\u001e\u0002\u000bM\u0004\u0018M]6\u000b\u0005qj\u0014AB1qC\u000eDWMC\u0001?\u0003\ry'oZ\u0002\u0001'\r\u0001\u0011i\u0012\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\u0005![U\"A%\u000b\u0005)K\u0014\u0001C5oi\u0016\u0014h.\u00197\n\u00051K%a\u0002'pO\u001eLgnZ\u0001\u000bI\u0006$\u0018mU2iK6\f\u0007CA(S\u001b\u0005\u0001&BA)8\u0003\u0015!\u0018\u0010]3t\u0013\t\u0019\u0006K\u0001\u0006TiJ,8\r\u001e+za\u0016\faB]3rk&\u0014X\rZ*dQ\u0016l\u0017-A\u0004paRLwN\\:\u0016\u0003]\u0003\"\u0001W-\u000e\u0003MJ!AW\u001a\u0003\u0015\r\u001bfk\u00149uS>t7/\u0001\u0005paRLwN\\:!\u0003\u001d1\u0017\u000e\u001c;feN\u00042A\u00184j\u001d\tyFM\u0004\u0002aG6\t\u0011M\u0003\u0002c\u007f\u00051AH]8pizJ\u0011\u0001R\u0005\u0003K\u000e\u000bq\u0001]1dW\u0006<W-\u0003\u0002hQ\n\u00191+Z9\u000b\u0005\u0015\u001c\u0005C\u00016n\u001b\u0005Y'B\u000178\u0003\u001d\u0019x.\u001e:dKNL!A\\6\u0003\r\u0019KG\u000e^3s\u0003\u0019a\u0014N\\5u}Q)\u0011O]:ukB\u0011\u0001\f\u0001\u0005\u0006\u001b\u001a\u0001\rA\u0014\u0005\u0006)\u001a\u0001\rA\u0014\u0005\u0006+\u001a\u0001\ra\u0016\u0005\u00069\u001a\u0001\r!\u0018\u000b\u0005c^D\u0018\u0010C\u0003N\u000f\u0001\u0007a\nC\u0003U\u000f\u0001\u0007a\nC\u0003V\u000f\u0001\u0007q\u000bF\u0002rwvDQ\u0001 \u0005A\u00029\u000baa]2iK6\f\u0007\"B+\t\u0001\u00049&A\u0004,bYV,7i\u001c8wKJ$XM\u001d\t\b\u0005\u0006\u0005\u0011QAA\u000b\u0013\r\t\u0019a\u0011\u0002\n\rVt7\r^5p]F\u0002B!a\u0002\u0002\u00109!\u0011\u0011BA\u0006!\t\u00017)C\u0002\u0002\u000e\r\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\t\u0003'\u0011aa\u0015;sS:<'bAA\u0007\u0007B\u0019!)a\u0006\n\u0007\u0005e1IA\u0002B]f\fQ\u0002^8lK:Le\u000eZ3y\u0003J\u0014XCAA\u0010!\u0015\u0011\u0015\u0011EA\u0013\u0013\r\t\u0019c\u0011\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u0005\u0006\u001d\u0012bAA\u0015\u0007\n\u0019\u0011J\u001c;\u0002\u001dQ|7.\u001a8J]\u0012,\u00070\u0011:sA\u0005i1m\u001c7v[:\u0004&/\u001e8j]\u001e,\"!!\r\u0011\u0007\t\u000b\u0019$C\u0002\u00026\r\u0013qAQ8pY\u0016\fg.\u0001\u0007qCJ\u001cX\rZ*dQ\u0016l\u0017-F\u0001O\u00035\u0001\u0018M]:fIN\u001b\u0007.Z7bA\u0005IAo\\6f]&TXM]\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002T5\u0011\u0011Q\t\u0006\u0004i\u0005\u001d#\u0002BA%\u0003\u0017\nq\u0001]1sg\u0016\u00148O\u0003\u0003\u0002N\u0005=\u0013!C;oSZ|7-\u001b;z\u0015\t\t\t&A\u0002d_6LA!!\u0016\u0002F\tI1i\u001d<QCJ\u001cXM]\u0001\u000bi>\\WM\\5{KJ\u0004\u0013a\u0003:fcVL'/\u001a3S_^,\"!!\u0018\u0011\u000b\t\u000by&a\u0019\n\u0007\u0005\u00054I\u0001\u0003T_6,\u0007\u0003BA3\u0003Wj!!a\u001a\u000b\u0007\u0005%T'A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002BA7\u0003O\u0012!cR3oKJL7-\u00138uKJt\u0017\r\u001c*po\u0006a!/Z9vSJ,GMU8xA\u00051an\u001c*poN,\"!!\u001e\u000f\u0007\t\u000b9(C\u0002\u0002z\r\u000bAAT8oK\u00069an\u001c*poN\u0004\u0013A\u0005;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJ,\"!!!\u0011\t\u0005\r\u0015\u0011R\u0007\u0003\u0003\u000bS1!a\"6\u0003\u0011)H/\u001b7\n\t\u0005-\u0015Q\u0011\u0002\u0013)&lWm\u001d;b[B4uN]7biR,'/A\u000buS6,7\u000f^1na:#&LR8s[\u0006$H/\u001a:\u0002\u001b\u0011\fG/\u001a$pe6\fG\u000f^3s+\t\t\u0019\n\u0005\u0003\u0002\u0004\u0006U\u0015\u0002BAL\u0003\u000b\u0013Q\u0002R1uK\u001a{'/\\1ui\u0016\u0014\u0018AC2tm\u001aKG\u000e^3sgV\u0011\u0011Q\u0014\t\u0005\u0003?\u000b\t+D\u00016\u0013\r\t\u0019+\u000e\u0002\u000e'R\u0014Xo\u0019;GS2$XM]:\u0002\u0017\r\u001chOR5mi\u0016\u00148\u000fI\u0001&K:\f'\r\\3QCJ\u001c\u0018N\\4GC2d'-Y2l\r>\u0014H+[7fgR\fW\u000e\u001d+za\u0016\fa%\u001a8bE2,\u0007+\u0019:tS:<g)\u00197mE\u0006\u001c7NR8s)&lWm\u001d;b[B$\u0016\u0010]3!\u0003\u0001*g.\u00192mKB\u000b'o]5oO\u001a\u000bG\u000e\u001c2bG.4uN\u001d#bi\u0016$\u0016\u0010]3\u0002C\u0015t\u0017M\u00197f!\u0006\u00148/\u001b8h\r\u0006dGNY1dW\u001a{'\u000fR1uKRK\b/\u001a\u0011\u0002\u001f\u001d,GoQ;se\u0016tG/\u00138qkR,\"!a-\u0011\t\u0005U\u0016QX\u0007\u0003\u0003oS1!UA]\u0015\r\tY,O\u0001\u0007k:\u001c\u0018MZ3\n\t\u0005}\u0016q\u0017\u0002\u000b+R3\u0005h\u0015;sS:<\u0017a\u0004<bYV,7i\u001c8wKJ$XM]:\u0016\u0005\u0005\u0015\u0007#\u0002\"\u0002\"\u0005\u001d\u0007cAAe\u00135\t\u0001!\u0001\twC2,XmQ8om\u0016\u0014H/\u001a:tA\u0005iA-Z2j[\u0006d\u0007+\u0019:tKJ,\"!!5\u0011\u000f\t\u000b\t!!\u0002\u0002TB!\u0011Q[Ap\u001b\t\t9N\u0003\u0003\u0002Z\u0006m\u0017\u0001B7bi\"T!!!8\u0002\t)\fg/Y\u0005\u0005\u0003C\f9N\u0001\u0006CS\u001e$UmY5nC2\fa\u0002Z3dS6\fG\u000eU1sg\u0016\u0014\b%A\u0007nC.,7i\u001c8wKJ$XM\u001d\u000b\t\u0003\u000f\fI/!<\u0002x\"9\u00111^\u0012A\u0002\u0005\u0015\u0011\u0001\u00028b[\u0016Dq!a<$\u0001\u0004\t\t0\u0001\u0005eCR\fG+\u001f9f!\ry\u00151_\u0005\u0004\u0003k\u0004&\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u0013\u0005e8\u0005%AA\u0002\u0005E\u0012\u0001\u00038vY2\f'\r\\3\u0002/5\f7.Z\"p]Z,'\u000f^3sI\u0011,g-Y;mi\u0012\u001aTCAA\u0000U\u0011\t\tD!\u0001,\u0005\t\r\u0001\u0003\u0002B\u0003\u0005\u001fi!Aa\u0002\u000b\t\t%!1B\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0004D\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005#\u00119AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQB\\;mYN\u000bg-\u001a#biVlGC\u0003B\f\u0005;\u0011\tCa\t\u0003&Q!\u0011Q\u0003B\r\u0011\u001d\u0011Y\"\na\u0001\u0003\u000f\f\u0011bY8om\u0016\u0014H/\u001a:\t\u000f\t}Q\u00051\u0001\u0002\u0006\u0005)A-\u0019;v[\"9\u00111^\u0013A\u0002\u0005\u0015\u0001bBA}K\u0001\u0007\u0011\u0011\u0007\u0005\u0006+\u0016\u0002\raV\u0001\u0006a\u0006\u00148/Z\u000b\u0003\u0005W\u0001rAQA\u0001\u0003\u000b\u0011i\u0003E\u0003C\u0005_\u0011\u0019$C\u0002\u00032\r\u0013aa\u00149uS>t\u0007\u0003BAP\u0005kI1Aa\u000e6\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\rA\f'o]3!\u0003!9W\r\u001e+pW\u0016tWC\u0001B !%\u0011%\u0011\tB#\u0003K\t)!C\u0002\u0003D\r\u0013\u0011BR;oGRLwN\u001c\u001a\u0011\u000b\t\u000b\t#!\u0002\u0002\u0013\u001d,G\u000fV8lK:\u0004\u0013aB2p]Z,'\u000f\u001e\u000b\u0005\u0005[\u0011i\u0005C\u0004\u0003P)\u0002\rA!\u0012\u0002\rQ|7.\u001a8t\u0003=)f.\u001b<pG&$\u0018\u0010U1sg\u0016\u0014\bC\u0001--'\ta\u0013\t\u0006\u0002\u0003T\u0005qAo\\6f]&TXm\u0015;sK\u0006lGC\u0003B/\u0005G\u0012\u0019Ha\u001e\u0003zA)aLa\u0018\u0003F%\u0019!\u0011\r5\u0003\u0011%#XM]1u_JDqA!\u001a/\u0001\u0004\u00119'A\u0006j]B,Ho\u0015;sK\u0006l\u0007\u0003\u0002B5\u0005_j!Aa\u001b\u000b\t\t5\u00141\\\u0001\u0003S>LAA!\u001d\u0003l\tY\u0011J\u001c9viN#(/Z1n\u0011\u001d\u0011)H\fa\u0001\u0003c\t\u0001c\u001d5pk2$GI]8q\u0011\u0016\fG-\u001a:\t\u000f\u0005ub\u00061\u0001\u0002B!9!1\u0010\u0018A\u0002\u0005\u0015\u0011\u0001C3oG>$\u0017N\\4\u0002\u0017A\f'o]3TiJ,\u0017-\u001c\u000b\u000b\u0005\u0003\u0013\u0019I!\"\u0003\n\nM\u0005#\u00020\u0003`\tM\u0002b\u0002B3_\u0001\u0007!q\r\u0005\u0007\u0005\u000f{\u0003\u0019A9\u0002\rA\f'o]3s\u0011\u001d\u0011Yi\fa\u0001\u0005\u001b\u000bQ\u0002[3bI\u0016\u00148\t[3dW\u0016\u0014\bc\u0001-\u0003\u0010&\u0019!\u0011S\u001a\u0003!\r\u001bf\u000bS3bI\u0016\u00148\t[3dW\u0016\u0014\b\"\u0002?0\u0001\u0004q\u0015!D2p]Z,'\u000f^*ue\u0016\fW.\u0006\u0003\u0003\u001a\n%FC\u0003BN\u0005s\u0013YL!0\u0003NR!!Q\u0014B[%\u0015\u0011y*\u0011BR\r\u0019\u0011\t\u000b\r\u0001\u0003\u001e\naAH]3gS:,W.\u001a8u}A)aLa\u0018\u0003&B!!q\u0015BU\u0019\u0001!qAa+1\u0005\u0004\u0011iKA\u0001U#\u0011\u0011y+!\u0006\u0011\u0007\t\u0013\t,C\u0002\u00034\u000e\u0013qAT8uQ&tw\rC\u0004\u0003JA\u0002\rAa.\u0011\u000f\t\u000b\tA!\u0012\u0003&\"9!Q\r\u0019A\u0002\t\u001d\u0004bBA\u001fa\u0001\u0007\u0011\u0011\t\u0005\b\u0005\u007f\u0003\u0004\u0019\u0001Ba\u00031A\u0017M\u001c3mK\"+\u0017\rZ3s!\u0015\u0011%1\u0019Bd\u0013\r\u0011)m\u0011\u0002\n\rVt7\r^5p]B\u00022A\u0011Be\u0013\r\u0011Ym\u0011\u0002\u0005+:LG\u000fC\u0004\u0003|A\u0002\r!!\u0002\u0002\u001bA\f'o]3Ji\u0016\u0014\u0018\r^8s))\u0011\tIa5\u0003Z\nm'Q\u001c\u0005\b\u0005+\f\u0004\u0019\u0001Bl\u0003\u0015a\u0017N\\3t!\u0015q&qLA\u0003\u0011\u0019\u00119)\ra\u0001c\"9!1R\u0019A\u0002\t5\u0005\"\u0002?2\u0001\u0004q\u0005")
public class UnivocityParser
implements Logging {
    private TimestampFormatter timestampFormatter;
    private TimestampFormatter timestampNTZFormatter;
    private DateFormatter dateFormatter;
    private final StructType dataSchema;
    private final StructType requiredSchema;
    private final CSVOptions options;
    private final int[] tokenIndexArr;
    private final StructType parsedSchema;
    private final CsvParser tokenizer;
    private final Some<GenericInternalRow> requiredRow;
    private final None$ noRows;
    private final StructFilters csvFilters;
    private final boolean enableParsingFallbackForTimestampType;
    private final boolean enableParsingFallbackForDateType;
    private final Function1<String, Object>[] valueConverters;
    private final Function1<String, BigDecimal> decimalParser;
    private final Function1<String, Option<InternalRow>> parse;
    private final Function2<String[], Object, String> getToken;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Iterator<InternalRow> parseIterator(Iterator<String> lines, UnivocityParser parser, CSVHeaderChecker headerChecker, StructType schema) {
        return UnivocityParser$.MODULE$.parseIterator(lines, parser, headerChecker, schema);
    }

    public static Iterator<InternalRow> parseStream(InputStream inputStream, UnivocityParser parser, CSVHeaderChecker headerChecker, StructType schema) {
        return UnivocityParser$.MODULE$.parseStream(inputStream, parser, headerChecker, schema);
    }

    public static Iterator<String[]> tokenizeStream(InputStream inputStream, boolean shouldDropHeader, CsvParser tokenizer, String encoding) {
        return UnivocityParser$.MODULE$.tokenizeStream(inputStream, shouldDropHeader, tokenizer, encoding);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public CSVOptions options() {
        return this.options;
    }

    private int[] tokenIndexArr() {
        return this.tokenIndexArr;
    }

    private boolean columnPruning() {
        return this.options().isColumnPruningEnabled(this.requiredSchema);
    }

    private StructType parsedSchema() {
        return this.parsedSchema;
    }

    public CsvParser tokenizer() {
        return this.tokenizer;
    }

    private Some<GenericInternalRow> requiredRow() {
        return this.requiredRow;
    }

    private None$ noRows() {
        return this.noRows;
    }

    private TimestampFormatter timestampFormatter$lzycompute() {
        UnivocityParser univocityParser = this;
        synchronized (univocityParser) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.timestampFormatter = TimestampFormatter$.MODULE$.apply(this.options().timestampFormatInRead(), this.options().zoneId(), this.options().locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampFormatter() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.timestampFormatter$lzycompute();
        }
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampNTZFormatter$lzycompute() {
        UnivocityParser univocityParser = this;
        synchronized (univocityParser) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(this.options().timestampNTZFormatInRead(), this.options().zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true, true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.timestampNTZFormatter;
    }

    private TimestampFormatter timestampNTZFormatter() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.timestampNTZFormatter$lzycompute();
        }
        return this.timestampNTZFormatter;
    }

    private DateFormatter dateFormatter$lzycompute() {
        UnivocityParser univocityParser = this;
        synchronized (univocityParser) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.dateFormatter = DateFormatter$.MODULE$.apply(this.options().dateFormatInRead(), this.options().locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.dateFormatter;
    }

    private DateFormatter dateFormatter() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.dateFormatter$lzycompute();
        }
        return this.dateFormatter;
    }

    private StructFilters csvFilters() {
        return this.csvFilters;
    }

    private boolean enableParsingFallbackForTimestampType() {
        return this.enableParsingFallbackForTimestampType;
    }

    private boolean enableParsingFallbackForDateType() {
        return this.enableParsingFallbackForDateType;
    }

    private UTF8String getCurrentInput() {
        if (this.tokenizer().getContext() == null) {
            return null;
        }
        String currentContent = this.tokenizer().getContext().currentParsedContent();
        if (currentContent == null) {
            return null;
        }
        return UTF8String.fromString((String)StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(currentContent)));
    }

    private Function1<String, Object>[] valueConverters() {
        return this.valueConverters;
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    public Function1<String, Object> makeConverter(String name, DataType dataType, boolean nullable) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof ByteType) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$2 -> BoxesRunTime.boxToByte((byte)StringOps$.MODULE$.toByte$extension(Predef$.MODULE$.augmentString(x$2))));
        }
        if (dataType2 instanceof ShortType) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$3 -> BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(x$3))));
        }
        if (dataType2 instanceof IntegerType) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$4))));
        }
        if (dataType2 instanceof LongType) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$5))));
        }
        if (dataType2 instanceof FloatType) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x0$1 -> {
                String string = x0$1;
                String string2 = this.options().nanValue();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    return BoxesRunTime.boxToFloat((float)Float.NaN);
                }
                String string4 = this.options().negativeInf();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    return BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY);
                }
                String string6 = this.options().positiveInf();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    return BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY);
                }
                return BoxesRunTime.boxToFloat((float)StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(string)));
            });
        }
        if (dataType2 instanceof DoubleType) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x0$2 -> {
                String string = x0$2;
                String string2 = this.options().nanValue();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    return BoxesRunTime.boxToDouble((double)Double.NaN);
                }
                String string4 = this.options().negativeInf();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    return BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY);
                }
                String string6 = this.options().positiveInf();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    return BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY);
                }
                return BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(string)));
            });
        }
        if (dataType2 instanceof BooleanType) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$6))));
        }
        if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> Decimal$.MODULE$.apply((BigDecimal)this.decimalParser().apply(datum), decimalType.precision(), decimalType.scale()));
        }
        if (dataType2 instanceof DateType) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> {
                Object object;
                try {
                    object = BoxesRunTime.boxToInteger((int)this.dateFormatter().parse(datum));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(throwable2)) {
                        if (!this.enableParsingFallbackForDateType()) {
                            throw throwable2;
                        }
                        UTF8String str = DateTimeUtils$.MODULE$.cleanLegacyTimestampStr(UTF8String.fromString((String)datum));
                        object = DateTimeUtils$.MODULE$.stringToDate(str).getOrElse((Function0 & Serializable)() -> {
                            throw throwable2;
                        });
                    }
                    throw throwable;
                }
                return object;
            });
        }
        if (dataType2 instanceof TimestampType) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> {
                Object object;
                try {
                    object = BoxesRunTime.boxToLong((long)this.timestampFormatter().parse(datum));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(throwable2)) {
                        if (!this.enableParsingFallbackForTimestampType()) {
                            throw throwable2;
                        }
                        UTF8String str = DateTimeUtils$.MODULE$.cleanLegacyTimestampStr(UTF8String.fromString((String)datum));
                        object = DateTimeUtils$.MODULE$.stringToTimestamp(str, this.options().zoneId()).getOrElse((Function0 & Serializable)() -> {
                            throw throwable2;
                        });
                    }
                    throw throwable;
                }
                return object;
            });
        }
        if (dataType2 instanceof TimestampNTZType) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> BoxesRunTime.boxToLong((long)UnivocityParser.$anonfun$makeConverter$24(this, datum)));
        }
        if (dataType2 instanceof StringType) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$1 -> UTF8String.fromString((String)x$1));
        }
        if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> IntervalUtils$.MODULE$.safeStringToInterval(UTF8String.fromString((String)datum)));
        }
        if (dataType2 instanceof YearMonthIntervalType) {
            YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType2;
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> new Cast(Literal$.MODULE$.apply(datum), (DataType)yearMonthIntervalType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()).eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow()));
        }
        if (dataType2 instanceof DayTimeIntervalType) {
            DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType2;
            return (Function1 & Serializable)d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> new Cast(Literal$.MODULE$.apply(datum), (DataType)dayTimeIntervalType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()).eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow()));
        }
        if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            return this.makeConverter(name, userDefinedType.sqlType(), nullable);
        }
        throw ExecutionErrors$.MODULE$.unsupportedDataTypeError(dataType);
    }

    public boolean makeConverter$default$3() {
        return true;
    }

    private Object nullSafeDatum(String datum, String name, boolean nullable, CSVOptions options, Function1<String, Object> converter) {
        String string = datum;
        String string2 = options.nullValue();
        if (!(string == null ? string2 != null : !string.equals(string2)) || datum == null) {
            if (!nullable) {
                throw QueryExecutionErrors$.MODULE$.foundNullValueForNotNullableFieldError(name);
            }
            return null;
        }
        return converter.apply((Object)datum);
    }

    public Function1<String, Option<InternalRow>> parse() {
        return this.parse;
    }

    private Function2<String[], Object, String> getToken() {
        return this.getToken;
    }

    public Option<InternalRow> org$apache$spark$sql$catalyst$csv$UnivocityParser$$convert(String[] tokens) {
        if (tokens == null) {
            throw new BadRecordException((Function0<UTF8String>)(Function0 & Serializable)() -> this.getCurrentInput(), (Function0<InternalRow[]>)(Function0 & Serializable)() -> (InternalRow[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InternalRow.class)), new LazyBadRecordCauseWrapper((Function0<Throwable>)(Function0 & Serializable)() -> QueryExecutionErrors$.MODULE$.malformedCSVRecordError("")));
        }
        UTF8String currentInput = this.getCurrentInput();
        None$ badRecordException = tokens.length != this.parsedSchema().length() ? new Some((Object)new LazyBadRecordCauseWrapper((Function0<Throwable>)(Function0 & Serializable)() -> QueryExecutionErrors$.MODULE$.malformedCSVRecordError(currentInput.toString()))) : None$.MODULE$;
        GenericInternalRow row = (GenericInternalRow)this.requiredRow().get();
        boolean skipRow = false;
        for (int i = 0; i < this.requiredSchema.length(); ++i) {
            try {
                if (skipRow) {
                    row.setNullAt(i);
                    continue;
                }
                row.update(i, this.valueConverters()[i].apply(this.getToken().apply((Object)tokens, (Object)BoxesRunTime.boxToInteger((int)i))));
                if (!this.csvFilters().skipRow(row, i)) continue;
                skipRow = true;
                continue;
            }
            catch (SparkUpgradeException sparkUpgradeException) {
                throw sparkUpgradeException;
            }
            catch (Throwable throwable) {
                if (NonFatal$.MODULE$.apply(throwable)) {
                    badRecordException = badRecordException.orElse((Function0 & Serializable)() -> new Some((Object)throwable));
                    row.update(i, ResolveDefaultColumns$.MODULE$.existenceDefaultValues(this.requiredSchema)[i]);
                    continue;
                }
                throw throwable;
            }
        }
        if (skipRow) {
            return this.noRows();
        }
        if (badRecordException.isDefined()) {
            throw new BadRecordException((Function0<UTF8String>)(Function0 & Serializable)() -> currentInput, (Function0<InternalRow[]>)(Function0 & Serializable)() -> (InternalRow[])((Object[])new InternalRow[]{(InternalRow)this.requiredRow().get()}), (Throwable)badRecordException.get());
        }
        return this.requiredRow();
    }

    public static final /* synthetic */ long $anonfun$makeConverter$24(UnivocityParser $this, String datum) {
        return $this.timestampNTZFormatter().parseWithoutTimeZone(datum, false);
    }

    public static final /* synthetic */ String $anonfun$getToken$1(String[] tokens, int index) {
        return tokens[index];
    }

    public static final /* synthetic */ String $anonfun$getToken$2(UnivocityParser $this, String[] tokens, int index) {
        return tokens[$this.tokenIndexArr()[index]];
    }

    public UnivocityParser(StructType dataSchema, StructType requiredSchema, CSVOptions options, Seq<Filter> filters) {
        this.dataSchema = dataSchema;
        this.requiredSchema = requiredSchema;
        this.options = options;
        Logging.$init$((Logging)this);
        Predef$.MODULE$.require(requiredSchema.toSet().subsetOf((Set)dataSchema.toSet()), (Function0 & Serializable)() -> "requiredSchema (" + $this.requiredSchema.catalogString() + ") should be the subset of dataSchema (" + $this.dataSchema.catalogString() + ").");
        this.tokenIndexArr = (int[])((IterableOnceOps)requiredSchema.map((Function1 & Serializable)f -> BoxesRunTime.boxToInteger((int)this.dataSchema.indexOf((Object)f)))).toArray((ClassTag)ClassTag$.MODULE$.Int());
        this.parsedSchema = this.columnPruning() ? requiredSchema : dataSchema;
        CsvParserSettings parserSetting = options.asParserSettings();
        Object object = this.parsedSchema().length() < dataSchema.length() ? parserSetting.selectIndexes((Integer[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(this.tokenIndexArr()), (Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), ClassTag$.MODULE$.apply(Integer.class))) : BoxedUnit.UNIT;
        this.tokenizer = new CsvParser(parserSetting);
        this.requiredRow = new Some((Object)new GenericInternalRow(requiredSchema.length()));
        this.noRows = None$.MODULE$;
        this.csvFilters = SQLConf$.MODULE$.get().csvFilterPushDown() ? new OrderedFilters(filters, requiredSchema) : new NoopFilters();
        this.enableParsingFallbackForTimestampType = BoxesRunTime.unboxToBoolean((Object)options.enableDateTimeParsingFallback().orElse((Function0 & Serializable)() -> SQLConf$.MODULE$.get().csvEnableDateTimeParsingFallback()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            Enumeration.Value value = SQLConf$.MODULE$.get().legacyTimeParserPolicy();
            Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
            return !(value == null ? value2 != null : !value.equals(value2)) || this.options().timestampFormatInRead().isEmpty();
        }));
        this.enableParsingFallbackForDateType = BoxesRunTime.unboxToBoolean((Object)options.enableDateTimeParsingFallback().orElse((Function0 & Serializable)() -> SQLConf$.MODULE$.get().csvEnableDateTimeParsingFallback()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            Enumeration.Value value = SQLConf$.MODULE$.get().legacyTimeParserPolicy();
            Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
            return !(value == null ? value2 != null : !value.equals(value2)) || this.options().dateFormatOption().isEmpty();
        }));
        this.valueConverters = (Function1[])((IterableOnceOps)requiredSchema.map((Function1 & Serializable)f -> this.makeConverter(f.name(), f.dataType(), f.nullable()))).toArray(ClassTag$.MODULE$.apply(Function1.class));
        this.decimalParser = ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.parse = this.columnPruning() && requiredSchema.isEmpty() ? (Function1 & Serializable)x$7 -> new Some((Object)InternalRow$.MODULE$.empty()) : (Function1 & Serializable)input -> this.org$apache$spark$sql$catalyst$csv$UnivocityParser$$convert(this.tokenizer().parseLine(input));
        this.getToken = this.columnPruning() ? (Function2 & Serializable)(tokens, index) -> UnivocityParser.$anonfun$getToken$1(tokens, BoxesRunTime.unboxToInt((Object)index)) : (Function2 & Serializable)(tokens, index) -> UnivocityParser.$anonfun$getToken$2(this, tokens, BoxesRunTime.unboxToInt((Object)index));
    }

    public UnivocityParser(StructType dataSchema, StructType requiredSchema, CSVOptions options) {
        this(dataSchema, requiredSchema, options, (Seq<Filter>)((Seq)package$.MODULE$.Seq().empty()));
    }

    public UnivocityParser(StructType schema, CSVOptions options) {
        this(schema, schema, options);
    }
}

