/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayAppend$;
import org.apache.spark.sql.catalyst.expressions.ArrayInsert;
import org.apache.spark.sql.catalyst.expressions.ArrayPendBase;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n      _FUNC_(array, element) - Add the element at the end of the array passed as first\n      argument. Type of element should be similar to type of the elements of the array.\n      Null element is also appended into the array. But if the array passed, is NULL\n      output is NULL\n      ", examples="\n    Examples:\n      > SELECT _FUNC_(array('b', 'd', 'c', 'a'), 'd');\n       [\"b\",\"d\",\"c\",\"a\",\"d\"]\n      > SELECT _FUNC_(array(1, 2, 3, null), null);\n       [1,2,3,null,null]\n      > SELECT _FUNC_(CAST(null as Array<Int>), 2);\n       NULL\n  ", since="3.4.0", group="array_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005]e\u0001\u0002\u000e\u001c\u0001\"B\u0001B\u0011\u0001\u0003\u0016\u0004%\ta\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005S!AQ\t\u0001BK\u0002\u0013\u00051\t\u0003\u0005G\u0001\tE\t\u0015!\u0003*\u0011\u00159\u0005\u0001\"\u0001I\u0011!a\u0005\u0001#b\u0001\n\u0003\u001a\u0005\"B'\u0001\t\u0003r\u0005\"B,\u0001\t#B\u0006bB/\u0001\u0003\u0003%\tA\u0018\u0005\bC\u0002\t\n\u0011\"\u0001c\u0011\u001di\u0007!%A\u0005\u0002\tDqA\u001c\u0001\u0002\u0002\u0013\u0005s\u000eC\u0004x\u0001\u0005\u0005I\u0011\u0001=\t\u000fq\u0004\u0011\u0011!C\u0001{\"I\u0011q\u0001\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0002\u0005\n\u0003/\u0001\u0011\u0011!C\u0001\u00033A\u0011\"a\t\u0001\u0003\u0003%\t%!\n\t\u0013\u0005%\u0002!!A\u0005B\u0005-r!CA(7\u0005\u0005\t\u0012AA)\r!Q2$!A\t\u0002\u0005M\u0003BB$\u0015\t\u0003\tY\u0007C\u0005\u0002nQ\t\t\u0011\"\u0012\u0002p!I\u0011\u0011\u000f\u000b\u0002\u0002\u0013\u0005\u00151\u000f\u0005\n\u0003s\"\u0012\u0011!CA\u0003wB\u0011\"!$\u0015\u0003\u0003%I!a$\u0003\u0017\u0005\u0013(/Y=BaB,g\u000e\u001a\u0006\u00039u\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011adH\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0001%I\u0001\u0004gFd'B\u0001\u0012$\u0003\u0015\u0019\b/\u0019:l\u0015\t!S%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0005\u0019qN]4\u0004\u0001M)\u0001!K\u00171mA\u0011!fK\u0007\u00027%\u0011Af\u0007\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007C\u0001\u0016/\u0013\ty3DA\u0007BeJ\f\u0017\u0010U3oI\n\u000b7/\u001a\t\u0003cQj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QG\r\u0002\b!J|G-^2u!\t9tH\u0004\u00029{9\u0011\u0011\bP\u0007\u0002u)\u00111hJ\u0001\u0007yI|w\u000e\u001e \n\u0003MJ!A\u0010\u001a\u0002\u000fA\f7m[1hK&\u0011\u0001)\u0011\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003}I\nA\u0001\\3giV\t\u0011&A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007%S5\n\u0005\u0002+\u0001!)!)\u0002a\u0001S!)Q)\u0002a\u0001S\u0005Y!/\u001a9mC\u000e,W.\u001a8u\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002\u001fB\u0011\u0001\u000b\u0016\b\u0003#J\u0003\"!\u000f\u001a\n\u0005M\u0013\u0014A\u0002)sK\u0012,g-\u0003\u0002V-\n11\u000b\u001e:j]\u001eT!a\u0015\u001a\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGcA%Z7\")!\f\u0003a\u0001S\u00059a.Z<MK\u001a$\b\"\u0002/\t\u0001\u0004I\u0013\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\u0004\u0013~\u0003\u0007b\u0002\"\n!\u0003\u0005\r!\u000b\u0005\b\u000b&\u0001\n\u00111\u0001*\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012a\u0019\u0016\u0003S\u0011\\\u0013!\u001a\t\u0003M.l\u0011a\u001a\u0006\u0003Q&\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005)\u0014\u0014AC1o]>$\u0018\r^5p]&\u0011An\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0003A\u0004\"!\u001d<\u000e\u0003IT!a\u001d;\u0002\t1\fgn\u001a\u0006\u0002k\u0006!!.\u0019<b\u0013\t)&/\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001z!\t\t$0\u0003\u0002|e\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019a0a\u0001\u0011\u0005Ez\u0018bAA\u0001e\t\u0019\u0011I\\=\t\u0011\u0005\u0015a\"!AA\u0002e\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u0006!\u0015\ti!a\u0005\u007f\u001b\t\tyAC\u0002\u0002\u0012I\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)\"a\u0004\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u00037\t\t\u0003E\u00022\u0003;I1!a\b3\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u0002\u0011\u0003\u0003\u0005\rA`\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\rF\u0002q\u0003OA\u0001\"!\u0002\u0012\u0003\u0003\u0005\r!_\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005m\u0011Q\u0006\u0005\t\u0003\u000b\u0011\u0012\u0011!a\u0001}\"\u001a\u0002!!\r\u00028\u0005e\u0012QHA \u0003\u0007\n)%!\u0013\u0002LA\u0019!&a\r\n\u0007\u0005U2DA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005m\u0012A!\u0011\u000bA\u0001\u0002\u0003\u0005\t\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010\f\u0011fY\u0016lWM\u001c;*A5\u0002\u0013\t\u001a3!i\",\u0007%\u001a7f[\u0016tG\u000fI1uAQDW\rI3oI\u0002zg\r\t;iK\u0002\n'O]1zAA\f7o]3eA\u0005\u001c\bEZ5sgRT\u0001\u0005\t\u0011!A\u0001\n'oZ;nK:$h\u0006\t+za\u0016\u0004sN\u001a\u0011fY\u0016lWM\u001c;!g\"|W\u000f\u001c3!E\u0016\u00043/[7jY\u0006\u0014\b\u0005^8!if\u0004X\rI8gAQDW\rI3mK6,g\u000e^:!_\u001a\u0004C\u000f[3!CJ\u0014\u0018-\u001f\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011Ok2d\u0007%\u001a7f[\u0016tG\u000fI5tA\u0005d7o\u001c\u0011baB,g\u000eZ3eA%tGo\u001c\u0011uQ\u0016\u0004\u0013M\u001d:bs:\u0002#)\u001e;!S\u001a\u0004C\u000f[3!CJ\u0014\u0018-\u001f\u0011qCN\u001cX\r\u001a\u0017!SN\u0004c*\u0016'M\u0015\u0001\u0002\u0003\u0005\t\u0011!_V$\b/\u001e;!SN\u0004c*\u0016'M\u0015\u0001\u0002\u0003\u0005\t\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA!\u0003\u0005\r(\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\bf\n2(Y\u0001:Cm\n\u0017!O\r<C\u0006I\u0014bO%b\u0003e\n3(SmR\u0001\u0005\t\u0011!A\u0001\u00023L\t2#Y\t\"'\u0005\f\u0012dE1\u0012\u0013M\t\u0017#I\nj&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\b&\r\u0017!e1\u00023\u0007\f\u0011ok2d\u0017\u0006\f\u0011ok2d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\c1\u0012Df\r\u0017ok2dGF\\;mYvS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fQ!T)\"rW\u000f\u001c7!CN\u0004\u0013I\u001d:bsrJe\u000e\u001e *Y\u0001\u0012\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005\u001d\u0013!B\u001a/i9\u0002\u0014!B4s_V\u0004\u0018EAA'\u0003-\t'O]1z?\u001a,hnY:\u0002\u0017\u0005\u0013(/Y=BaB,g\u000e\u001a\t\u0003UQ\u0019R\u0001FA+\u0003C\u0002r!a\u0016\u0002^%J\u0013*\u0004\u0002\u0002Z)\u0019\u00111\f\u001a\u0002\u000fI,h\u000e^5nK&!\u0011qLA-\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0003G\nI'\u0004\u0002\u0002f)\u0019\u0011q\r;\u0002\u0005%|\u0017b\u0001!\u0002fQ\u0011\u0011\u0011K\u0001\ti>\u001cFO]5oOR\t\u0001/A\u0003baBd\u0017\u0010F\u0003J\u0003k\n9\bC\u0003C/\u0001\u0007\u0011\u0006C\u0003F/\u0001\u0007\u0011&A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005u\u0014\u0011\u0012\t\u0006c\u0005}\u00141Q\u0005\u0004\u0003\u0003\u0013$AB(qi&|g\u000eE\u00032\u0003\u000bK\u0013&C\u0002\u0002\bJ\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAF1\u0005\u0005\t\u0019A%\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002\u0012B\u0019\u0011/a%\n\u0007\u0005U%O\u0001\u0004PE*,7\r\u001e")
public class ArrayAppend
extends Expression
implements ArrayPendBase,
Serializable {
    private Expression replacement;
    private final Expression left;
    private final Expression right;
    private transient Seq<Expression> children;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayAppend x$0) {
        return ArrayAppend$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayAppend> tupled() {
        return ArrayAppend$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayAppend>> curried() {
        return ArrayAppend$.MODULE$.curried();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return ArrayPendBase.inputTypes$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ArrayPendBase.checkInputDataTypes$(this);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private Seq<Expression> children$lzycompute() {
        ArrayAppend arrayAppend = this;
        synchronized (arrayAppend) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        ArrayAppend arrayAppend = this;
        synchronized (arrayAppend) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private Expression replacement$lzycompute() {
        ArrayAppend arrayAppend = this;
        synchronized (arrayAppend) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = new ArrayInsert(this.left(), Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)-1)), this.right());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public String prettyName() {
        return "array_append";
    }

    @Override
    public ArrayAppend withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArrayAppend copy(Expression left, Expression right) {
        return new ArrayAppend(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayAppend";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayAppend;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayAppend)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayAppend arrayAppend = (ArrayAppend)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayAppend.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayAppend.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayAppend.canEqual(this)) return false;
        return true;
    }

    public ArrayAppend(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        BinaryLike.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        ArrayPendBase.$init$(this);
        Statics.releaseFence();
    }
}

