/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ArrayInsert$;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(x, pos, val) - Places val into index pos of array x.\n      Array indices start at 1. The maximum negative index is -1 for which the function inserts\n      new element after the current last element.\n      Index above array size appends the array, or prepends the array if index is negative,\n      with 'null' elements.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3, 4), 5, 5);\n       [1,2,3,4,5]\n      > SELECT _FUNC_(array(5, 4, 3, 2), -1, 1);\n       [5,4,3,2,1]\n      > SELECT _FUNC_(array(5, 3, 2, 1), -4, 4);\n       [5,4,3,2,1]\n  ", group="array_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0005\t]e\u0001B\u0017/\u0001nB\u0001\"\u0019\u0001\u0003\u0016\u0004%\tA\u0019\u0005\tM\u0002\u0011\t\u0012)A\u0005G\"Aq\r\u0001BK\u0002\u0013\u0005!\r\u0003\u0005i\u0001\tE\t\u0015!\u0003d\u0011!I\u0007A!f\u0001\n\u0003\u0011\u0007\u0002\u00036\u0001\u0005#\u0005\u000b\u0011B2\t\u0011-\u0004!Q3A\u0005\u00021D\u0001\u0002\u001d\u0001\u0003\u0012\u0003\u0006I!\u001c\u0005\u0006c\u0002!\tA\u001d\u0005\u0006c\u0002!\t\u0001\u001f\u0005\u0006y\u0002!\t% \u0005\b\u0003\u001f\u0001A\u0011IA\t\u0011)\ty\u0002\u0001EC\u0002\u0013%\u0011\u0011\u0005\u0005\b\u0003_\u0001A\u0011IA\u0019\u0011\u001d\t)\u0005\u0001C!\u0003\u000fBq!!\u0016\u0001\t\u0003\n9\u0006\u0003\u0004\u0002t\u0001!\tE\u0019\u0005\u0007\u0003k\u0002A\u0011\t2\t\r\u0005]\u0004\u0001\"\u0011c\u0011\u001d\tI\b\u0001C!\u0003wBq!!$\u0001\t\u0003\ny\t\u0003\u0004\u0002\u0018\u0002!\t\u0005\u001c\u0005\u000b\u00033\u0003\u0001R1A\u0005\n\u0005=\u0005bBAR\u0001\u0011E\u0013Q\u0015\u0005\b\u0003g\u0003A\u0011IA[\u0011%\t\t\rAA\u0001\n\u0003\t\u0019\rC\u0005\u0002N\u0002\t\n\u0011\"\u0001\u0002P\"I\u0011Q\u001d\u0001\u0012\u0002\u0013\u0005\u0011q\u001a\u0005\n\u0003O\u0004\u0011\u0013!C\u0001\u0003\u001fD\u0011\"!;\u0001#\u0003%\t!a;\t\u0013\u0005=\b!!A\u0005B\u0005E\b\"\u0003B\u0001\u0001\u0005\u0005I\u0011\u0001B\u0002\u0011%\u0011)\u0001AA\u0001\n\u0003\u00119\u0001C\u0005\u0003\u000e\u0001\t\t\u0011\"\u0011\u0003\u0010!I!Q\u0004\u0001\u0002\u0002\u0013\u0005!q\u0004\u0005\n\u0005G\u0001\u0011\u0011!C!\u0005KA\u0011B!\u000b\u0001\u0003\u0003%\tEa\u000b\b\u0013\t=c&!A\t\u0002\tEc\u0001C\u0017/\u0003\u0003E\tAa\u0015\t\rE<C\u0011\u0001B6\u0011%\u0011igJA\u0001\n\u000b\u0012y\u0007C\u0005\u0003r\u001d\n\t\u0011\"!\u0003t!I!QP\u0014\u0002\u0002\u0013\u0005%q\u0010\u0005\n\u0005\u001b;\u0013\u0011!C\u0005\u0005\u001f\u00131\"\u0011:sCfLen]3si*\u0011q\u0006M\u0001\fKb\u0004(/Z:tS>t7O\u0003\u00022e\u0005A1-\u0019;bYf\u001cHO\u0003\u00024i\u0005\u00191/\u001d7\u000b\u0005U2\u0014!B:qCJ\\'BA\u001c9\u0003\u0019\t\u0007/Y2iK*\t\u0011(A\u0002pe\u001e\u001c\u0001a\u0005\u0005\u0001y\u0001\u001be\tT(V!\tid(D\u0001/\u0013\tydFA\tUKJt\u0017M]=FqB\u0014Xm]:j_:\u0004\"!P!\n\u0005\ts#AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005u\"\u0015BA#/\u0005q\u0019u.\u001c9mKb$\u0016\u0010]3NKJ<\u0017N\\4FqB\u0014Xm]:j_:\u0004\"a\u0012&\u000e\u0003!S!!\u0013\u001a\u0002\r\u0015\u0014(o\u001c:t\u0013\tY\u0005JA\bRk\u0016\u0014\u00180\u0012:s_J\u001c()Y:f!\tiT*\u0003\u0002O]\t\u00192+\u001e9q_J$\u0018+^3ss\u000e{g\u000e^3yiB\u0011\u0001kU\u0007\u0002#*\t!+A\u0003tG\u0006d\u0017-\u0003\u0002U#\n9\u0001K]8ek\u000e$\bC\u0001,_\u001d\t9FL\u0004\u0002Y76\t\u0011L\u0003\u0002[u\u00051AH]8pizJ\u0011AU\u0005\u0003;F\u000bq\u0001]1dW\u0006<W-\u0003\u0002`A\na1+\u001a:jC2L'0\u00192mK*\u0011Q,U\u0001\rgJ\u001c\u0017I\u001d:bs\u0016C\bO]\u000b\u0002GB\u0011Q\bZ\u0005\u0003K:\u0012!\"\u0012=qe\u0016\u001c8/[8o\u00035\u0019(oY!se\u0006LX\t\u001f9sA\u00059\u0001o\\:FqB\u0014\u0018\u0001\u00039pg\u0016C\bO\u001d\u0011\u0002\u0011%$X-\\#yaJ\f\u0011\"\u001b;f[\u0016C\bO\u001d\u0011\u0002'1,w-Y2z\u001d\u0016<\u0017\r^5wK&sG-\u001a=\u0016\u00035\u0004\"\u0001\u00158\n\u0005=\f&a\u0002\"p_2,\u0017M\\\u0001\u0015Y\u0016<\u0017mY=OK\u001e\fG/\u001b<f\u0013:$W\r\u001f\u0011\u0002\rqJg.\u001b;?)\u0015\u0019H/\u001e<x!\ti\u0004\u0001C\u0003b\u0013\u0001\u00071\rC\u0003h\u0013\u0001\u00071\rC\u0003j\u0013\u0001\u00071\rC\u0003l\u0013\u0001\u0007Q\u000e\u0006\u0003tsj\\\b\"B1\u000b\u0001\u0004\u0019\u0007\"B4\u000b\u0001\u0004\u0019\u0007\"B5\u000b\u0001\u0004\u0019\u0017AC5oaV$H+\u001f9fgV\ta\u0010\u0005\u0003W\u007f\u0006\r\u0011bAA\u0001A\n\u00191+Z9\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u00033\u0003\u0015!\u0018\u0010]3t\u0013\u0011\ti!a\u0002\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHCAA\n!\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\ra\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002\u001e\u0005]!a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u0017A|7/\u001b;jm\u0016\u0004vn]\u000b\u0003\u0003G\u0001R\u0001UA\u0013\u0003SI1!a\nR\u0005\u0019y\u0005\u000f^5p]B\u0019\u0001+a\u000b\n\u0007\u00055\u0012KA\u0002J]R\fA!\u001a<bYR!\u00111GA\u001d!\r\u0001\u0016QG\u0005\u0004\u0003o\t&aA!os\"I\u00111\b\b\u0011\u0002\u0003\u0007\u0011QH\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0003\u007f\t\t%D\u00011\u0013\r\t\u0019\u0005\r\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0005\u00024\u0005%\u0013QJA)\u0011\u001d\tYe\u0004a\u0001\u0003g\t1!\u0019:s\u0011\u001d\tye\u0004a\u0001\u0003g\t1\u0001]8t\u0011\u001d\t\u0019f\u0004a\u0001\u0003g\tA!\u001b;f[\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u00033\n)'a\u001c\u0011\t\u0005m\u0013\u0011M\u0007\u0003\u0003;R1!a\u0018/\u0003\u001d\u0019w\u000eZ3hK:LA!a\u0019\u0002^\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002hA\u0001\r!!\u001b\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\\\u0005-\u0014\u0002BA7\u0003;\u0012abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002rA\u0001\r!!\u0017\u0002\u0005\u00154\u0018!\u00024jeN$\u0018AB:fG>tG-A\u0003uQ&\u0014H-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!! \u0011\t\u0005}\u0014q\u0011\b\u0005\u0003\u0003\u000b\u0019\t\u0005\u0002Y#&\u0019\u0011QQ)\u0002\rA\u0013X\rZ3g\u0013\u0011\tI)a#\u0003\rM#(/\u001b8h\u0015\r\t))U\u0001\tI\u0006$\u0018\rV=qKV\u0011\u0011\u0011\u0013\t\u0005\u0003\u000b\t\u0019*\u0003\u0003\u0002\u0016\u0006\u001d!\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00119,H\u000e\\1cY\u0016\f1\"\u001a7f[\u0016tG\u000fV=qK\"\u001aq#!(\u0011\u0007A\u000by*C\u0002\u0002\"F\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGcB:\u0002(\u0006-\u0016q\u0016\u0005\u0007\u0003SC\u0002\u0019A2\u0002\u001f9,wo\u0015:d\u0003J\u0014\u0018-_#yaJDa!!,\u0019\u0001\u0004\u0019\u0017A\u00038foB{7/\u0012=qe\"1\u0011\u0011\u0017\rA\u0002\r\f1B\\3x\u0013R,W.\u0012=qe\u0006\u0001\u0012N\\5u#V,'/_\"p]R,\u0007\u0010\u001e\u000b\u0003\u0003o\u0003R\u0001UA\u0013\u0003s\u0003B!a/\u0002>6\tA'C\u0002\u0002@R\u0012A\"U;fef\u001cuN\u001c;fqR\fAaY8qsRI1/!2\u0002H\u0006%\u00171\u001a\u0005\bCj\u0001\n\u00111\u0001d\u0011\u001d9'\u0004%AA\u0002\rDq!\u001b\u000e\u0011\u0002\u0003\u00071\rC\u0004l5A\u0005\t\u0019A7\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u001b\u0016\u0004G\u0006M7FAAk!\u0011\t9.!9\u000e\u0005\u0005e'\u0002BAn\u0003;\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}\u0017+\u0001\u0006b]:|G/\u0019;j_:LA!a9\u0002Z\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003[T3!\\Aj\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u001f\t\u0005\u0003k\fy0\u0004\u0002\u0002x*!\u0011\u0011`A~\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0018\u0001\u00026bm\u0006LA!!#\u0002x\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011F\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019D!\u0003\t\u0013\t-\u0011%!AA\u0002\u0005%\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\u0012A1!1\u0003B\r\u0003gi!A!\u0006\u000b\u0007\t]\u0011+\u0001\u0006d_2dWm\u0019;j_:LAAa\u0007\u0003\u0016\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\ri'\u0011\u0005\u0005\n\u0005\u0017\u0019\u0013\u0011!a\u0001\u0003g\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u00111\u001fB\u0014\u0011%\u0011Y\u0001JA\u0001\u0002\u0004\tI#\u0001\u0004fcV\fGn\u001d\u000b\u0004[\n5\u0002\"\u0003B\u0006K\u0005\u0005\t\u0019AA\u001aQM\u0001!\u0011\u0007B\u001c\u0005s\u0011iDa\u0010\u0003D\t\u0015#\u0011\nB&!\ri$1G\u0005\u0004\u0005kq#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0005w\t!1\u0014\u0006!A\u0001\u0002sLR+O\u0007~C\u0003\u0010\f\u0011q_Nd\u0003E^1mS\u0001j\u0003\u0005\u00157bG\u0016\u001c\bE^1mA%tGo\u001c\u0011j]\u0012,\u0007\u0010\t9pg\u0002zg\rI1se\u0006L\b\u0005\u001f\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011BeJ\f\u0017\u0010I5oI&\u001cWm\u001d\u0011ti\u0006\u0014H\u000fI1uAEr\u0003\u0005\u00165fA5\f\u00070[7v[\u0002rWmZ1uSZ,\u0007%\u001b8eKb\u0004\u0013n\u001d\u0011.c\u00012wN\u001d\u0011xQ&\u001c\u0007\u000e\t;iK\u00022WO\\2uS>t\u0007%\u001b8tKJ$8O\u0003\u0011!A\u0001\u0002\u0003E\\3xA\u0015dW-\\3oi\u0002\ng\r^3sAQDW\rI2veJ,g\u000e\u001e\u0011mCN$\b%\u001a7f[\u0016tGO\f\u0006!A\u0001\u0002\u0003\u0005I%oI\u0016D\b%\u00192pm\u0016\u0004\u0013M\u001d:bs\u0002\u001a\u0018N_3!CB\u0004XM\u001c3tAQDW\rI1se\u0006LH\u0006I8sAA\u0014X\r]3oIN\u0004C\u000f[3!CJ\u0014\u0018-\u001f\u0011jM\u0002Jg\u000eZ3yA%\u001c\bE\\3hCRLg/\u001a\u0017\u000bA\u0001\u0002\u0003\u0005\t\u0011xSRD\u0007e\n8vY2<\u0003%\u001a7f[\u0016tGo\u001d\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005\u0003\n\u0011\u0011\u0018\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00152Y\u0001\u0012D\u0006I\u001a-AQJC\u0006I\u001b-AUJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.2YIb3\u0007\f\u001b-kuS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfDS\u0007\f\u00115Y\u0001\u001aD\u0006\t\u001a*Y\u0001j\u0013\u0007\f\u00112SmR\u0001\u0005\t\u0011!A\u0001\u00023,\u000e\u00175YMb#\u0007L\u0019^\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQUb\u0003e\r\u0017!e1\u0002\u0013'\u000b\u0017![Qb\u0003\u0005N\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am+D\u0006\u000e\u00174YIb\u0013'\u0018\u0006!A\u0005)qM]8va\u0006\u0012!qI\u0001\fCJ\u0014\u0018-_0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0003N\u0005)1G\f\u001b/a\u0005Y\u0011I\u001d:bs&s7/\u001a:u!\titeE\u0003(\u0005+\u0012\t\u0007E\u0005\u0003X\tu3mY2ng6\u0011!\u0011\f\u0006\u0004\u00057\n\u0016a\u0002:v]RLW.Z\u0005\u0005\u0005?\u0012IFA\tBEN$(/Y2u\rVt7\r^5p]R\u0002BAa\u0019\u0003j5\u0011!Q\r\u0006\u0005\u0005O\nY0\u0001\u0002j_&\u0019qL!\u001a\u0015\u0005\tE\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005M\u0018!B1qa2LH#C:\u0003v\t]$\u0011\u0010B>\u0011\u0015\t'\u00061\u0001d\u0011\u00159'\u00061\u0001d\u0011\u0015I'\u00061\u0001d\u0011\u0015Y'\u00061\u0001n\u0003\u001d)h.\u00199qYf$BA!!\u0003\nB)\u0001+!\n\u0003\u0004B9\u0001K!\"dG\u000el\u0017b\u0001BD#\n1A+\u001e9mKRB\u0001Ba#,\u0003\u0003\u0005\ra]\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001BI!\u0011\t)Pa%\n\t\tU\u0015q\u001f\u0002\u0007\u001f\nTWm\u0019;")
public class ArrayInsert
extends TernaryExpression
implements ImplicitCastInputTypes,
ComplexTypeMergingExpression,
QueryErrorsBase,
SupportQueryContext {
    private Option<Object> positivePos;
    private transient DataType elementType;
    private final Expression srcArrayExpr;
    private final Expression posExpr;
    private final Expression itemExpr;
    private final boolean legacyNegativeIndex;
    private Option<QueryContext> queryContext;
    private transient Seq<DataType> inputTypesForMerging;
    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    private volatile byte bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple4<Expression, Expression, Expression, Object>> unapply(ArrayInsert x$0) {
        return ArrayInsert$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Object>, ArrayInsert> tupled() {
        return ArrayInsert$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, ArrayInsert>>>> curried() {
        return ArrayInsert$.MODULE$.curried();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public QueryContext getContextOrNull() {
        return SupportQueryContext.getContextOrNull$(this);
    }

    @Override
    public String getContextOrNullCode(CodegenContext ctx, boolean withErrorContext) {
        return SupportQueryContext.getContextOrNullCode$(this, ctx, withErrorContext);
    }

    @Override
    public boolean getContextOrNullCode$default$2() {
        return SupportQueryContext.getContextOrNullCode$default$2$(this);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    @Override
    public Option<QueryContext> queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(Option<QueryContext> x$1) {
        this.queryContext = x$1;
    }

    private Seq<DataType> inputTypesForMerging$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.inputTypesForMerging = ComplexTypeMergingExpression.inputTypesForMerging$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.inputTypesForMerging$lzycompute();
        }
        return this.inputTypesForMerging;
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType = ComplexTypeMergingExpression.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    public Expression srcArrayExpr() {
        return this.srcArrayExpr;
    }

    public Expression posExpr() {
        return this.posExpr;
    }

    public Expression itemExpr() {
        return this.itemExpr;
    }

    public boolean legacyNegativeIndex() {
        return this.legacyNegativeIndex;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple3 tuple3 = new Tuple3((Object)this.srcArrayExpr().dataType(), (Object)this.posExpr().dataType(), (Object)this.itemExpr().dataType());
        if (tuple3 != null) {
            DataType dataType = (DataType)tuple3._1();
            DataType e2 = (DataType)tuple3._2();
            DataType e3 = (DataType)tuple3._3();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType e1 = arrayType.elementType();
                boolean hasNull = arrayType.containsNull();
                if (e2 instanceof IntegralType) {
                    IntegralType integralType;
                    IntegralType integralType2 = integralType = (IntegralType)e2;
                    LongType$ longType$ = LongType$.MODULE$;
                    if (integralType2 == null ? longType$ != null : !integralType2.equals(longType$)) {
                        Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)e1, (Object)e3);
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            DataType dt = (DataType)some.value();
                            return new .colon.colon((Object)new ArrayType(dt, hasNull), (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)dt, (List)Nil$.MODULE$)));
                        }
                        return (Seq)package$.MODULE$.Seq().empty();
                    }
                }
            }
        }
        if (tuple3 != null) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        throw new MatchError((Object)tuple3);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        Tuple3 tuple3 = new Tuple3((Object)this.first().dataType(), (Object)this.second().dataType(), (Object)this.third().dataType());
        if (tuple3 != null) {
            DataType e2 = (DataType)tuple3._2();
            if (tuple3._1() instanceof ArrayType) {
                DataType dataType = e2;
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
                    return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)this.ordinalNumber(1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.second())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.second().dataType()))}))));
                }
            }
        }
        if (tuple3 != null) {
            ArrayType arrayType;
            DataType e1;
            DataType dataType = (DataType)tuple3._1();
            DataType e3 = (DataType)tuple3._3();
            if (dataType instanceof ArrayType && DataTypeUtils$.MODULE$.sameType(e1 = (arrayType = (ArrayType)dataType).elementType(), e3)) {
                return TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
        }
        return new TypeCheckResult.DataTypeMismatch("ARRAY_FUNCTION_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType((AbstractDataType)ArrayType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftType"), (Object)this.toSQLType((AbstractDataType)this.first().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightType"), (Object)this.toSQLType((AbstractDataType)this.third().dataType()))}))));
    }

    private Option<Object> positivePos$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                InternalRow x$1;
                Expression qual$1;
                int pos;
                this.positivePos = this.second().foldable() ? ((pos = BoxesRunTime.unboxToInt((Object)(qual$1 = this.second()).eval(x$1 = qual$1.eval$default$1()))) > 0 ? new Some((Object)BoxesRunTime.boxToInteger((int)pos)) : None$.MODULE$) : None$.MODULE$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.positivePos;
    }

    private Option<Object> positivePos() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.positivePos$lzycompute();
        }
        return this.positivePos;
    }

    @Override
    public Object eval(InternalRow input) {
        Object value2;
        Object value1 = this.first().eval(input);
        if (value1 != null && (value2 = this.second().eval(input)) != null) {
            Object value3 = this.third().eval(input);
            return this.nullSafeEval(value1, value2, value3);
        }
        return null;
    }

    @Override
    public Object nullSafeEval(Object arr, Object pos, Object item) {
        boolean newPosExtendsArrayLeft;
        ArrayData baseArr = (ArrayData)arr;
        if (this.positivePos().isDefined()) {
            int newArrayLength = scala.math.package$.MODULE$.max(baseArr.numElements() + 1, BoxesRunTime.unboxToInt((Object)this.positivePos().get()));
            if (newArrayLength > 0x7FFFFFF0) {
                throw QueryExecutionErrors$.MODULE$.arrayFunctionWithElementsExceedLimitError(this.prettyName(), newArrayLength);
            }
            Object[] newArray = new Object[newArrayLength];
            int posInt = BoxesRunTime.unboxToInt((Object)this.positivePos().get()) - 1;
            baseArr.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(i, v) -> {
                ArrayInsert.$anonfun$nullSafeEval$13(posInt, newArray, BoxesRunTime.unboxToInt((Object)i), v);
                return BoxedUnit.UNIT;
            });
            newArray[posInt] = item;
            return new GenericArrayData(newArray);
        }
        IntRef posInt = IntRef.create((int)BoxesRunTime.unboxToInt((Object)pos));
        if (posInt.elem == 0) {
            throw QueryExecutionErrors$.MODULE$.invalidIndexOfZeroError(this.getContextOrNull());
        }
        boolean bl = newPosExtendsArrayLeft = posInt.elem < 0 && -posInt.elem > baseArr.numElements();
        if (newPosExtendsArrayLeft) {
            int baseOffset = this.legacyNegativeIndex() ? 1 : 0;
            int newArrayLength = -posInt.elem + baseOffset;
            if (newArrayLength > 0x7FFFFFF0) {
                throw QueryExecutionErrors$.MODULE$.arrayFunctionWithElementsExceedLimitError(this.prettyName(), newArrayLength);
            }
            Object[] newArray = new Object[newArrayLength];
            baseArr.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(i, v) -> {
                ArrayInsert.$anonfun$nullSafeEval$14(baseOffset, posInt, baseArr, newArray, BoxesRunTime.unboxToInt((Object)i), v);
                return BoxedUnit.UNIT;
            });
            newArray[0] = item;
            return new GenericArrayData(newArray);
        }
        if (posInt.elem < 0) {
            posInt.elem = posInt.elem + baseArr.numElements() + (this.legacyNegativeIndex() ? 0 : 1);
        } else if (posInt.elem > 0) {
            --posInt.elem;
        }
        int newArrayLength = scala.math.package$.MODULE$.max(baseArr.numElements() + 1, posInt.elem + 1);
        if (newArrayLength > 0x7FFFFFF0) {
            throw QueryExecutionErrors$.MODULE$.arrayFunctionWithElementsExceedLimitError(this.prettyName(), newArrayLength);
        }
        Object[] newArray = new Object[newArrayLength];
        baseArr.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(i, v) -> {
            ArrayInsert.$anonfun$nullSafeEval$15(posInt, newArray, BoxesRunTime.unboxToInt((Object)i), v);
            return BoxedUnit.UNIT;
        });
        newArray[posInt.elem] = item;
        return new GenericArrayData(newArray);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        Function3 & Serializable f = (Function3 & Serializable)(arrExpr, posExpr, itemExpr) -> {
            ExprValue arr = arrExpr.value();
            ExprValue item = itemExpr.value();
            String itemInsertionIndex = ctx.freshName("itemInsertionIndex");
            String adjustedAllocIdx = ctx.freshName("adjustedAllocIdx");
            String resLength = ctx.freshName("resLength");
            String insertedItemIsNull = ctx.freshName("insertedItemIsNull");
            String i = ctx.freshName("i");
            String j = ctx.freshName("j");
            String values = ctx.freshName("values");
            String allocation = CodeGenerator$.MODULE$.createArrayData(values, this.elementType(), resLength, this.prettyName() + " failed.");
            String assignment = CodeGenerator$.MODULE$.createArrayAssignment(values, this.elementType(), ExprValue$.MODULE$.exprValueToString(arr), adjustedAllocIdx, i, ((ArrayType)this.first().dataType()).containsNull());
            String errorContext = this.getContextOrNullCode(ctx, this.getContextOrNullCode$default$2());
            if (this.positivePos().isDefined()) {
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |int " + itemInsertionIndex + " = " + (BoxesRunTime.unboxToInt((Object)this.positivePos().get()) - 1) + ";\n           |int " + adjustedAllocIdx + " = 0;\n           |boolean " + insertedItemIsNull + " = " + itemExpr.isNull() + ";\n           |\n           |final int " + resLength + " = java.lang.Math.max(" + arr + ".numElements() + 1, " + this.positivePos().get() + ");\n           |if (" + resLength + " > " + 0x7FFFFFF0 + ") {\n           |  throw QueryExecutionErrors.arrayFunctionWithElementsExceedLimitError(\n           |    \"" + this.prettyName() + "\", " + resLength + ");\n           |}\n           |\n           |" + allocation + "\n           |for (int " + i + " = 0; " + i + " < " + arr + ".numElements(); " + i + " ++) {\n           |  " + adjustedAllocIdx + " = " + i + ";\n           |  if (" + i + " >= " + itemInsertionIndex + ") {\n           |    " + adjustedAllocIdx + " = " + adjustedAllocIdx + " + 1;\n           |  }\n           |  " + assignment + "\n           |}\n           |" + CodeGenerator$.MODULE$.setArrayElement(values, this.elementType(), itemInsertionIndex, ExprValue$.MODULE$.exprValueToString(item), (Option<String>)new Some((Object)insertedItemIsNull)) + "\n           |\n           |for (int " + j + " = " + arr + ".numElements(); " + j + " < " + resLength + " - 1; " + j + " ++) {\n           |  " + values + ".setNullAt(" + j + ");\n           |}\n           |\n           |" + ev.value() + " = " + values + ";\n           |"));
            }
            ExprValue pos = posExpr.value();
            int baseOffset = this.legacyNegativeIndex() ? 1 : 0;
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |int " + itemInsertionIndex + " = 0;\n           |int " + resLength + " = 0;\n           |int " + adjustedAllocIdx + " = 0;\n           |boolean " + insertedItemIsNull + " = " + itemExpr.isNull() + ";\n           |\n           |if (" + pos + " == 0) {\n           |  throw QueryExecutionErrors.invalidIndexOfZeroError(" + errorContext + ");\n           |}\n           |\n           |if (" + pos + " < 0 && (java.lang.Math.abs(" + pos + ") > " + arr + ".numElements())) {\n           |\n           |  " + resLength + " = java.lang.Math.abs(" + pos + ") + " + baseOffset + ";\n           |  if (" + resLength + " > " + 0x7FFFFFF0 + ") {\n           |    throw QueryExecutionErrors.arrayFunctionWithElementsExceedLimitError(\n           |      \"" + this.prettyName() + "\", " + resLength + ");\n           |  }\n           |\n           |  " + allocation + "\n           |  for (int " + i + " = 0; " + i + " < " + arr + ".numElements(); " + i + " ++) {\n           |    " + adjustedAllocIdx + " = " + i + " + " + baseOffset + " + java.lang.Math.abs(" + pos + " + " + arr + ".numElements());\n           |    " + assignment + "\n           |  }\n           |  " + CodeGenerator$.MODULE$.setArrayElement(values, this.elementType(), itemInsertionIndex, ExprValue$.MODULE$.exprValueToString(item), (Option<String>)new Some((Object)insertedItemIsNull)) + "\n           |\n           |  for (int " + j + " = " + (this.legacyNegativeIndex() ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)1)) + " + " + pos + " + " + arr + ".numElements(); " + j + " < 0; " + j + " ++) {\n           |    " + values + ".setNullAt(" + j + " + " + baseOffset + " + java.lang.Math.abs(" + pos + " + " + arr + ".numElements()));\n           |  }\n           |\n           |  " + ev.value() + " = " + values + ";\n           |} else {\n           |\n           |  " + itemInsertionIndex + " = 0;\n           |  if (" + pos + " < 0) {\n           |    " + itemInsertionIndex + " = " + pos + " + " + arr + ".numElements() + " + (this.legacyNegativeIndex() ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)1)) + ";\n           |  } else if (" + pos + " > 0) {\n           |    " + itemInsertionIndex + " = " + pos + " - 1;\n           |  }\n           |\n           |  " + resLength + " = java.lang.Math.max(" + arr + ".numElements() + 1, " + itemInsertionIndex + " + 1);\n           |  if (" + resLength + " > " + 0x7FFFFFF0 + ") {\n           |    throw QueryExecutionErrors.createArrayWithElementsExceedLimitError(\n           |      \"" + this.prettyName() + "\", " + resLength + ");\n           |  }\n           |\n           |  " + allocation + "\n           |  for (int " + i + " = 0; " + i + " < " + arr + ".numElements(); " + i + " ++) {\n           |    " + adjustedAllocIdx + " = " + i + ";\n           |    if (" + i + " >= " + itemInsertionIndex + ") {\n           |      " + adjustedAllocIdx + " = " + adjustedAllocIdx + " + 1;\n           |    }\n           |    " + assignment + "\n           |  }\n           |  " + CodeGenerator$.MODULE$.setArrayElement(values, this.elementType(), itemInsertionIndex, ExprValue$.MODULE$.exprValueToString(item), (Option<String>)new Some((Object)insertedItemIsNull)) + "\n           |\n           |  for (int " + j + " = " + arr + ".numElements(); " + j + " < " + resLength + " - 1; " + j + " ++) {\n           |    " + values + ".setNullAt(" + j + ");\n           |  }\n           |\n           |  " + ev.value() + " = " + values + ";\n           |}\n           |"));
        };
        ExprCode leftGen = this.first().genCode(ctx);
        ExprCode midGen = this.second().genCode(ctx);
        ExprCode rightGen = this.third().genCode(ctx);
        String resultCode = (String)f.apply((Object)leftGen, (Object)midGen, (Object)rightGen);
        if (this.nullable()) {
            String nullSafeEval = leftGen.code().toString() + ctx.nullSafeExec(this.first().nullable(), ExprValue$.MODULE$.exprValueToString(leftGen.isNull()), midGen.code().toString() + ctx.nullSafeExec(this.second().nullable(), ExprValue$.MODULE$.exprValueToString(midGen.isNull()), "\n              " + rightGen.code() + "\n              " + ev.isNull() + " = false;\n              " + resultCode + "\n            "));
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = true;\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), nullSafeEval})), ev.copy$default$2(), ev.copy$default$3());
        }
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        ", "\n        ", "\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{leftGen.code(), midGen.code(), rightGen.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), resultCode})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Expression first() {
        return this.srcArrayExpr();
    }

    @Override
    public Expression second() {
        return this.posExpr();
    }

    @Override
    public Expression third() {
        return this.itemExpr();
    }

    @Override
    public String prettyName() {
        return "array_insert";
    }

    @Override
    public DataType dataType() {
        return this.first().dataType().asNullable();
    }

    @Override
    public boolean nullable() {
        return this.first().nullable() | this.second().nullable();
    }

    private DataType elementType$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.elementType = ((ArrayType)this.srcArrayExpr().dataType()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.elementType;
    }

    private DataType elementType() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.elementType$lzycompute();
        }
        return this.elementType;
    }

    @Override
    public ArrayInsert withNewChildrenInternal(Expression newSrcArrayExpr, Expression newPosExpr, Expression newItemExpr) {
        return this.copy(newSrcArrayExpr, newPosExpr, newItemExpr, this.copy$default$4());
    }

    @Override
    public Option<QueryContext> initQueryContext() {
        return new Some((Object)this.origin().context());
    }

    public ArrayInsert copy(Expression srcArrayExpr, Expression posExpr, Expression itemExpr, boolean legacyNegativeIndex) {
        return new ArrayInsert(srcArrayExpr, posExpr, itemExpr, legacyNegativeIndex);
    }

    public Expression copy$default$1() {
        return this.srcArrayExpr();
    }

    public Expression copy$default$2() {
        return this.posExpr();
    }

    public Expression copy$default$3() {
        return this.itemExpr();
    }

    public boolean copy$default$4() {
        return this.legacyNegativeIndex();
    }

    @Override
    public String productPrefix() {
        return "ArrayInsert";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.srcArrayExpr();
            }
            case 1: {
                return this.posExpr();
            }
            case 2: {
                return this.itemExpr();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.legacyNegativeIndex());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayInsert;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "srcArrayExpr";
            }
            case 1: {
                return "posExpr";
            }
            case 2: {
                return "itemExpr";
            }
            case 3: {
                return "legacyNegativeIndex";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayInsert)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayInsert arrayInsert = (ArrayInsert)x$1;
        if (this.legacyNegativeIndex() != arrayInsert.legacyNegativeIndex()) return false;
        Expression expression = this.srcArrayExpr();
        Expression expression2 = arrayInsert.srcArrayExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.posExpr();
        Expression expression4 = arrayInsert.posExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.itemExpr();
        Expression expression6 = arrayInsert.itemExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!arrayInsert.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$13(int posInt$1, Object[] newArray$2, int i, Object v) {
        if (i >= posInt$1) {
            newArray$2[i + 1] = v;
            return;
        }
        newArray$2[i] = v;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$14(int baseOffset$1, IntRef posInt$2, ArrayData baseArr$1, Object[] newArray$3, int i, Object v) {
        int elementPosition = i + baseOffset$1 + scala.math.package$.MODULE$.abs(posInt$2.elem + baseArr$1.numElements());
        newArray$3[elementPosition] = v;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$15(IntRef posInt$2, Object[] newArray$4, int i, Object v) {
        if (i >= posInt$2.elem) {
            newArray$4[i + 1] = v;
            return;
        }
        newArray$4[i] = v;
    }

    public ArrayInsert(Expression srcArrayExpr, Expression posExpr, Expression itemExpr, boolean legacyNegativeIndex) {
        this.srcArrayExpr = srcArrayExpr;
        this.posExpr = posExpr;
        this.itemExpr = itemExpr;
        this.legacyNegativeIndex = legacyNegativeIndex;
        ExpectsInputTypes.$init$(this);
        ComplexTypeMergingExpression.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        SupportQueryContext.$init$(this);
    }

    public ArrayInsert(Expression srcArrayExpr, Expression posExpr, Expression itemExpr) {
        this(srcArrayExpr, posExpr, itemExpr, SQLConf$.MODULE$.get().legacyNegativeIndexInArrayInsert());
    }
}

