/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Between$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.InheritAnalysisRules;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.With$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="Usage: input [NOT] BETWEEN lower AND upper - evaluate if `input` is [not] in between `lower` and `upper`", examples="\n    Examples:\n      > SELECT 0.5 _FUNC_ 0.1 AND 1.0;\n        true\n  ", arguments="\n    Arguments:\n      * input - An expression that is being compared with lower and upper bound.\n      * lower - Lower bound of the between check.\n      * upper - Upper bound of the between check.\n  ", since="4.0.0", group="conditional_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005}f\u0001\u0002\u0011\"\u0001:B\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005_!Aa\n\u0001BK\u0002\u0013\u0005A\n\u0003\u0005P\u0001\tE\t\u0015!\u00030\u0011!\u0001\u0006A!f\u0001\n\u0003a\u0005\u0002C)\u0001\u0005#\u0005\u000b\u0011B\u0018\t\u0011I\u0003!Q3A\u0005\u00021C\u0001b\u0015\u0001\u0003\u0012\u0003\u0006Ia\f\u0005\u0006)\u0002!I!\u0016\u0005\u0006)\u0002!\ta\u0017\u0005\u0006?\u0002!\t\u0005\u0019\u0005\u0006I\u0002!\t&\u001a\u0005\bQ\u0002\t\t\u0011\"\u0001j\u0011\u001dq\u0007!%A\u0005\u0002=DqA\u001f\u0001\u0012\u0002\u0013\u0005q\u000eC\u0004|\u0001E\u0005I\u0011A8\t\u000fq\u0004\u0011\u0013!C\u0001_\"9Q\u0010AA\u0001\n\u0003r\b\"CA\b\u0001\u0005\u0005I\u0011AA\t\u0011%\tI\u0002AA\u0001\n\u0003\tY\u0002C\u0005\u0002(\u0001\t\t\u0011\"\u0011\u0002*!I\u0011q\u0007\u0001\u0002\u0002\u0013\u0005\u0011\u0011\b\u0005\n\u0003\u0007\u0002\u0011\u0011!C!\u0003\u000bB\u0011\"!\u0013\u0001\u0003\u0003%\t%a\u0013\b\u000f\u0005U\u0014\u0005#\u0001\u0002x\u00191\u0001%\tE\u0001\u0003sBa\u0001\u0016\u000e\u0005\u0002\u0005-\u0005bBAG5\u0011\u0005\u0011q\u0012\u0005\n\u0003\u001bS\u0012\u0011!CA\u0003/C\u0011\"!)\u001b\u0003\u0003%\t)a)\t\u0013\u0005U&$!A\u0005\n\u0005]&a\u0002\"fi^,WM\u001c\u0006\u0003E\r\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011A%J\u0001\tG\u0006$\u0018\r\\=ti*\u0011aeJ\u0001\u0004gFd'B\u0001\u0015*\u0003\u0015\u0019\b/\u0019:l\u0015\tQ3&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0005\u0019qN]4\u0004\u0001M1\u0001aL\u001a7s}\u0002\"\u0001M\u0019\u000e\u0003\u0005J!AM\u0011\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u00021i%\u0011Q'\t\u0002\u0013%VtG/[7f%\u0016\u0004H.Y2fC\ndW\r\u0005\u00021o%\u0011\u0001(\t\u0002\u0015\u0013:DWM]5u\u0003:\fG._:jgJ+H.Z:\u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001\t\u0013\b\u0003\u0003\u001as!AQ#\u000e\u0003\rS!\u0001R\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0014BA$<\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0013&\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\u001d[\u0014!B5oaV$X#A\u0018\u0002\r%t\u0007/\u001e;!\u0003\u0015awn^3s\u0003\u0019awn^3sA\u0005)Q\u000f\u001d9fe\u00061Q\u000f\u001d9fe\u0002\n1B]3qY\u0006\u001cW-\\3oi\u0006a!/\u001a9mC\u000e,W.\u001a8uA\u00051A(\u001b8jiz\"RAV,Y3j\u0003\"\u0001\r\u0001\t\u000b-K\u0001\u0019A\u0018\t\u000b9K\u0001\u0019A\u0018\t\u000bAK\u0001\u0019A\u0018\t\u000bIK\u0001\u0019A\u0018\u0015\tYcVL\u0018\u0005\u0006\u0017*\u0001\ra\f\u0005\u0006\u001d*\u0001\ra\f\u0005\u0006!*\u0001\raL\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cX#A1\u0011\u0007\u0001\u0013w&\u0003\u0002d\u0015\n\u00191+Z9\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\t1f\rC\u0003h\u0019\u0001\u0007q&\u0001\u0005oK^\u001c\u0005.\u001b7e\u0003\u0011\u0019w\u000e]=\u0015\u000bYS7\u000e\\7\t\u000f-k\u0001\u0013!a\u0001_!9a*\u0004I\u0001\u0002\u0004y\u0003b\u0002)\u000e!\u0003\u0005\ra\f\u0005\b%6\u0001\n\u00111\u00010\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012\u0001\u001d\u0016\u0003_E\\\u0013A\u001d\t\u0003gbl\u0011\u0001\u001e\u0006\u0003kZ\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005]\\\u0014AC1o]>$\u0018\r^5p]&\u0011\u0011\u0010\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#A@\u0011\t\u0005\u0005\u00111B\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005!A.\u00198h\u0015\t\tI!\u0001\u0003kCZ\f\u0017\u0002BA\u0007\u0003\u0007\u0011aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA\n!\rQ\u0014QC\u0005\u0004\u0003/Y$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u000f\u0003G\u00012AOA\u0010\u0013\r\t\tc\u000f\u0002\u0004\u0003:L\b\"CA\u0013)\u0005\u0005\t\u0019AA\n\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u0006\t\u0007\u0003[\t\u0019$!\b\u000e\u0005\u0005=\"bAA\u0019w\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u0012q\u0006\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002<\u0005\u0005\u0003c\u0001\u001e\u0002>%\u0019\u0011qH\u001e\u0003\u000f\t{w\u000e\\3b]\"I\u0011Q\u0005\f\u0002\u0002\u0003\u0007\u0011QD\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\rF\u0002\u0000\u0003\u000fB\u0011\"!\n\u0018\u0003\u0003\u0005\r!a\u0005\u0002\r\u0015\fX/\u00197t)\u0011\tY$!\u0014\t\u0013\u0005\u0015\u0002$!AA\u0002\u0005u\u0001f\u0006\u0001\u0002R\u0005]\u0013\u0011LA/\u0003?\n\u0019'!\u001a\u0002j\u0005-\u0014qNA9!\r\u0001\u00141K\u0005\u0004\u0003+\n#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u00037\n\u0001.V:bO\u0016T\u0004%\u001b8qkR\u00043LT(U;\u0002\u0012U\tV,F\u000b:\u0003Cn\\<fe\u0002\ne\n\u0012\u0011vaB,'\u000fI\u0017!KZ\fG.^1uK\u0002Jg\r\t1j]B,H\u000f\u0019\u0011jg\u0002Zfn\u001c;^A%t\u0007EY3uo\u0016,g\u000e\t1m_^,'\u000f\u0019\u0011b]\u0012\u0004\u0003-\u001e9qKJ\u0004\u0017\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u0005\u0014!\u0012\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!a9*\u0004e\u0018$V\u001d\u000e{\u0006\u0005\r\u00182A\u0005sE\tI\u0019/amR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\u001e:vK*\u0001\u0003%A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011qM\u0001\u0002\u0010*\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003%\u001b8qkR\u0004S\u0006I!oA\u0015D\bO]3tg&|g\u000e\t;iCR\u0004\u0013n\u001d\u0011cK&tw\rI2p[B\f'/\u001a3!o&$\b\u000e\t7po\u0016\u0014\b%\u00198eAU\u0004\b/\u001a:!E>,h\u000e\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+A1|w/\u001a:![\u0001bun^3sA\t|WO\u001c3!_\u001a\u0004C\u000f[3!E\u0016$x/Z3oA\rDWmY6/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001*\b\u000f]3sA5\u0002S\u000b\u001d9fe\u0002\u0012w.\u001e8eA=4\u0007\u0005\u001e5fA\t,Go^3f]\u0002\u001a\u0007.Z2l])\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002n\u0005)AG\f\u0019/a\u0005)qM]8va\u0006\u0012\u00111O\u0001\u0012G>tG-\u001b;j_:\fGn\u00184v]\u000e\u001c\u0018a\u0002\"fi^,WM\u001c\t\u0003ai\u0019RAGA>\u0003\u0003\u00032AOA?\u0013\r\tyh\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005\r\u0015\u0011R\u0007\u0003\u0003\u000bSA!a\"\u0002\b\u0005\u0011\u0011n\\\u0005\u0004\u0013\u0006\u0015ECAA<\u0003\u0015\t\u0007\u000f\u001d7z)\u001d1\u0016\u0011SAJ\u0003+CQa\u0013\u000fA\u0002=BQA\u0014\u000fA\u0002=BQ\u0001\u0015\u000fA\u0002=\"\u0012BVAM\u00037\u000bi*a(\t\u000b-k\u0002\u0019A\u0018\t\u000b9k\u0002\u0019A\u0018\t\u000bAk\u0002\u0019A\u0018\t\u000bIk\u0002\u0019A\u0018\u0002\u000fUt\u0017\r\u001d9msR!\u0011QUAY!\u0015Q\u0014qUAV\u0013\r\tIk\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000fi\nikL\u00180_%\u0019\u0011qV\u001e\u0003\rQ+\b\u000f\\35\u0011!\t\u0019LHA\u0001\u0002\u00041\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011\u0011\u0018\t\u0005\u0003\u0003\tY,\u0003\u0003\u0002>\u0006\r!AB(cU\u0016\u001cG\u000f")
public class Between
extends Expression
implements RuntimeReplaceable,
InheritAnalysisRules,
Serializable {
    private final Expression input;
    private final Expression lower;
    private final Expression upper;
    private final Expression replacement;
    private transient Seq<Expression> children;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple4<Expression, Expression, Expression, Expression>> unapply(Between x$0) {
        return Between$.MODULE$.unapply(x$0);
    }

    @Override
    public Expression child() {
        return InheritAnalysisRules.child$(this);
    }

    @Override
    public Iterator<Object> flatArguments() {
        return InheritAnalysisRules.flatArguments$(this);
    }

    @Override
    public String makeSQLString(Seq<String> childrenSQL) {
        return InheritAnalysisRules.makeSQLString$(this, childrenSQL);
    }

    @Override
    public final String sql() {
        return InheritAnalysisRules.sql$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private Seq<Expression> children$lzycompute() {
        Between between = this;
        synchronized (between) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        Between between = this;
        synchronized (between) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if (!this.bitmap$0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression input() {
        return this.input;
    }

    public Expression lower() {
        return this.lower;
    }

    public Expression upper() {
        return this.upper;
    }

    @Override
    public Expression replacement() {
        return this.replacement;
    }

    @Override
    public Seq<Expression> parameters() {
        return new .colon.colon((Object)this.input(), (List)new .colon.colon((Object)this.lower(), (List)new .colon.colon((Object)this.upper(), (List)Nil$.MODULE$)));
    }

    @Override
    public Between withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, x$1);
    }

    public Between copy(Expression input, Expression lower, Expression upper, Expression replacement) {
        return new Between(input, lower, upper, replacement);
    }

    public Expression copy$default$1() {
        return this.input();
    }

    public Expression copy$default$2() {
        return this.lower();
    }

    public Expression copy$default$3() {
        return this.upper();
    }

    public Expression copy$default$4() {
        return this.replacement();
    }

    @Override
    public String productPrefix() {
        return "Between";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.input();
            }
            case 1: {
                return this.lower();
            }
            case 2: {
                return this.upper();
            }
            case 3: {
                return this.replacement();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Between;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "input";
            }
            case 1: {
                return "lower";
            }
            case 2: {
                return "upper";
            }
            case 3: {
                return "replacement";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Between)) return false;
        boolean bl = true;
        if (!bl) return false;
        Between between = (Between)x$1;
        Expression expression = this.input();
        Expression expression2 = between.input();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.lower();
        Expression expression4 = between.lower();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.upper();
        Expression expression6 = between.upper();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.replacement();
        Expression expression8 = between.replacement();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (!between.canEqual(this)) return false;
        return true;
    }

    public Between(Expression input, Expression lower, Expression upper, Expression replacement) {
        this.input = input;
        this.lower = lower;
        this.upper = upper;
        this.replacement = replacement;
        RuntimeReplaceable.$init$(this);
        UnaryLike.$init$(this);
        InheritAnalysisRules.$init$(this);
        Statics.releaseFence();
    }

    public Between(Expression input, Expression lower, Expression upper) {
        this(input, lower, upper, !BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.ALWAYS_INLINE_COMMON_EXPR())) ? With$.MODULE$.apply((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{input}), (Function1<Seq<Expression>, Expression>)new Serializable(lower, upper){
            private static final long serialVersionUID = 0L;
            private final Expression lower$1;
            private final Expression upper$1;

            public final Expression apply(Seq<Expression> x0$1) {
                SeqOps seqOps;
                Seq<Expression> seq = x0$1;
                if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
                    Expression ref = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                    return new And(new GreaterThanOrEqual(ref, this.lower$1), new LessThanOrEqual(ref, this.upper$1));
                }
                throw new MatchError(seq);
            }
            {
                this.lower$1 = lower$1;
                this.upper$1 = upper$1;
            }
        }) : new And(new GreaterThanOrEqual(input, lower), new LessThanOrEqual(input, upper)));
    }
}

