/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.ExpressionBuilder;
import org.apache.spark.sql.catalyst.expressions.Collate;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.plans.logical.FunctionBuilderBase;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr, collationName) - Marks a given expression with the specified collation.", arguments="\n    Arguments:\n      * expr - String expression to perform collation on.\n      * collationName - Foldable string expression that specifies the collation name.\n  ", examples="\n    Examples:\n      > SET spark.sql.collation.enabled=true;\n      spark.sql.collation.enabled\ttrue\n      > SELECT COLLATION('Spark SQL' _FUNC_ UTF8_BINARY_LCASE);\n      UTF8_BINARY_LCASE\n      > SET spark.sql.collation.enabled=false;\n      spark.sql.collation.enabled\tfalse\n  ", since="4.0.0", group="string_funcs")
public final class CollateExpressionBuilder$
implements ExpressionBuilder {
    public static final CollateExpressionBuilder$ MODULE$ = new CollateExpressionBuilder$();

    static {
        FunctionBuilderBase.$init$(MODULE$);
    }

    @Override
    public Option<FunctionSignature> functionSignature() {
        return FunctionBuilderBase.functionSignature$(this);
    }

    @Override
    public Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName) {
        return FunctionBuilderBase.rearrange$(this, expectedSignature, providedArguments, functionName);
    }

    @Override
    public boolean supportsLambda() {
        return FunctionBuilderBase.supportsLambda$(this);
    }

    @Override
    public Expression build(String funcName, Seq<Expression> expressions) {
        SeqOps seqOps;
        if (!SQLConf$.MODULE$.get().collationEnabled()) {
            throw QueryCompilationErrors$.MODULE$.collationNotEnabledError();
        }
        Seq<Expression> seq = expressions;
        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
            Expression e = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Expression collationExpr = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (e != null) {
                Expression expression = e;
                if (collationExpr != null) {
                    Expression expression2 = collationExpr;
                    Tuple2 tuple2 = new Tuple2((Object)expression2.dataType(), (Object)BoxesRunTime.boxToBoolean((boolean)expression2.foldable()));
                    if (tuple2 != null) {
                        boolean bl = tuple2._2$mcZ$sp();
                        if (tuple2._1() instanceof StringType && bl) {
                            Object evalCollation = expression2.eval(expression2.eval$default$1());
                            if (evalCollation == null) {
                                throw QueryCompilationErrors$.MODULE$.unexpectedNullError("collation", expression2);
                            }
                            return new Collate(expression, evalCollation.toString());
                        }
                    }
                    if (tuple2 != null) {
                        boolean bl = tuple2._2$mcZ$sp();
                        if (tuple2._1() instanceof StringType && !bl) {
                            throw QueryCompilationErrors$.MODULE$.nonFoldableArgumentError(funcName, "collationName", (DataType)StringType$.MODULE$);
                        }
                    }
                    if (tuple2 != null) {
                        throw QueryCompilationErrors$.MODULE$.unexpectedInputDataTypeError(funcName, 1, (DataType)StringType$.MODULE$, expression2);
                    }
                    throw new MatchError((Object)tuple2);
                }
            }
        }
        throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(funcName, (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}))), seq.length(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
    }

    private CollateExpressionBuilder$() {
    }
}

