/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Collation$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.CollationFactory;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the collation name of a given expression.", arguments="\n    Arguments:\n      * expr - String expression to perform collation on.\n  ", examples="\n    Examples:\n      > SET spark.sql.collation.enabled=true;\n      spark.sql.collation.enabled\ttrue\n      > SELECT _FUNC_('Spark SQL');\n      UTF8_BINARY\n      > SET spark.sql.collation.enabled=false;\n      spark.sql.collation.enabled\tfalse\n  ", since="4.0.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Ee\u0001B\f\u0019\u0001\u0016B\u0001B\u0011\u0001\u0003\u0016\u0004%\ta\u0011\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005\t\")\u0001\n\u0001C\u0001\u0013\")A\n\u0001C)\u001b\")\u0001\u000b\u0001C!\u0007\")\u0011\u000b\u0001C!%\"9A\fAA\u0001\n\u0003i\u0006bB0\u0001#\u0003%\t\u0001\u0019\u0005\bW\u0002\t\t\u0011\"\u0011m\u0011\u001d)\b!!A\u0005\u0002YDqA\u001f\u0001\u0002\u0002\u0013\u00051\u0010C\u0005\u0002\u0004\u0001\t\t\u0011\"\u0011\u0002\u0006!I\u00111\u0003\u0001\u0002\u0002\u0013\u0005\u0011Q\u0003\u0005\n\u0003?\u0001\u0011\u0011!C!\u0003CA\u0011\"!\n\u0001\u0003\u0003%\t%a\n\b\u0013\u0005E\u0003$!A\t\u0002\u0005Mc\u0001C\f\u0019\u0003\u0003E\t!!\u0016\t\r!\u000bB\u0011AA7\u0011%\ty'EA\u0001\n\u000b\n\t\bC\u0005\u0002tE\t\t\u0011\"!\u0002v!I\u0011\u0011P\t\u0002\u0002\u0013\u0005\u00151\u0010\u0005\n\u0003\u000f\u000b\u0012\u0011!C\u0005\u0003\u0013\u0013\u0011bQ8mY\u0006$\u0018n\u001c8\u000b\u0005eQ\u0012aC3yaJ,7o]5p]NT!a\u0007\u000f\u0002\u0011\r\fG/\u00197zgRT!!\b\u0010\u0002\u0007M\fHN\u0003\u0002 A\u0005)1\u000f]1sW*\u0011\u0011EI\u0001\u0007CB\f7\r[3\u000b\u0003\r\n1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\u0014+[A2\u0004CA\u0014)\u001b\u0005A\u0012BA\u0015\u0019\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u0014,\u0013\ta\u0003D\u0001\nSk:$\u0018.\\3SKBd\u0017mY3bE2,\u0007CA\u0014/\u0013\ty\u0003DA\tFqB,7\r^:J]B,H\u000fV=qKN\u0004\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00028\u007f9\u0011\u0001(\u0010\b\u0003sqj\u0011A\u000f\u0006\u0003w\u0011\na\u0001\u0010:p_Rt\u0014\"A\u001a\n\u0005y\u0012\u0014a\u00029bG.\fw-Z\u0005\u0003\u0001\u0006\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!A\u0010\u001a\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003\u0011\u0003\"aJ#\n\u0005\u0019C\"AC#yaJ,7o]5p]\u000611\r[5mI\u0002\na\u0001P5oSRtDC\u0001&L!\t9\u0003\u0001C\u0003C\u0007\u0001\u0007A)\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0003\u0015:CQa\u0014\u0003A\u0002\u0011\u000b\u0001B\\3x\u0007\"LG\u000eZ\u0001\fe\u0016\u0004H.Y2f[\u0016tG/\u0001\u0006j]B,H\u000fV=qKN,\u0012a\u0015\t\u0004oQ3\u0016BA+B\u0005\r\u0019V-\u001d\t\u0003/jk\u0011\u0001\u0017\u0006\u00033r\tQ\u0001^=qKNL!a\u0017-\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001B2paf$\"A\u00130\t\u000f\t;\u0001\u0013!a\u0001\t\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A1+\u0005\u0011\u00137&A2\u0011\u0005\u0011LW\"A3\u000b\u0005\u0019<\u0017!C;oG\",7m[3e\u0015\tA''\u0001\u0006b]:|G/\u0019;j_:L!A[3\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002[B\u0011an]\u0007\u0002_*\u0011\u0001/]\u0001\u0005Y\u0006twMC\u0001s\u0003\u0011Q\u0017M^1\n\u0005Q|'AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001x!\t\t\u00040\u0003\u0002ze\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0011Ap \t\u0003cuL!A \u001a\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002\u0002-\t\t\u00111\u0001x\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0001\t\u0006\u0003\u0013\ty\u0001`\u0007\u0003\u0003\u0017Q1!!\u00043\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003#\tYA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\f\u0003;\u00012!MA\r\u0013\r\tYB\r\u0002\b\u0005>|G.Z1o\u0011!\t\t!DA\u0001\u0002\u0004a\u0018A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$2!\\A\u0012\u0011!\t\tADA\u0001\u0002\u00049\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0018\u0005%\u0002\u0002CA\u0001\u001f\u0005\u0005\t\u0019\u0001?)/\u0001\ti#a\r\u00026\u0005e\u00121HA \u0003\u0003\n)%a\u0012\u0002L\u00055\u0003cA\u0014\u00020%\u0019\u0011\u0011\u0007\r\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qG\u0001A?\u001a+fjQ0)Kb\u0004(/\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011d_2d\u0017\r^5p]\u0002r\u0017-\\3!_\u001a\u0004\u0013\rI4jm\u0016t\u0007%\u001a=qe\u0016\u001c8/[8o]\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003{\tAJ\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!Kb\u0004(\u000fI\u0017!'R\u0014\u0018N\\4!Kb\u0004(/Z:tS>t\u0007\u0005^8!a\u0016\u0014hm\u001c:nA\r|G\u000e\\1uS>t\u0007e\u001c8/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\r\u0013!a:\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E\u000bI:qCJ\\gf]9m]\r|G\u000e\\1uS>tg&\u001a8bE2,G-\u0010;sk\u0016\\$\u0002\t\u0011!A\u0001\u00023\u000f]1sW:\u001a\u0018\u000f\u001c\u0018d_2d\u0017\r^5p]:*g.\u00192mK\u0012LAO];f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3\u000b]1sW\u0002\u001a\u0016\u000bT\u0014*w)\u0001\u0003\u0005\t\u0011!AU#f\tO0C\u0013:\u000b%+\u0017\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016#\u0006e\u001d9be.t3/\u001d7/G>dG.\u0019;j_:tSM\\1cY\u0016$WHZ1mg\u0016\\$\u0002\t\u0011!A\u0001\u00023\u000f]1sW:\u001a\u0018\u000f\u001c\u0018d_2d\u0017\r^5p]:*g.\u00192mK\u0012La-\u00197tK*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002J\u0005)AG\f\u0019/a\u0005)qM]8va\u0006\u0012\u0011qJ\u0001\rgR\u0014\u0018N\\4`MVt7m]\u0001\n\u0007>dG.\u0019;j_:\u0004\"aJ\t\u0014\u000bE\t9&a\u0019\u0011\r\u0005e\u0013q\f#K\u001b\t\tYFC\u0002\u0002^I\nqA];oi&lW-\u0003\u0003\u0002b\u0005m#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocA!\u0011QMA6\u001b\t\t9GC\u0002\u0002jE\f!![8\n\u0007\u0001\u000b9\u0007\u0006\u0002\u0002T\u0005AAo\\*ue&tw\rF\u0001n\u0003\u0015\t\u0007\u000f\u001d7z)\rQ\u0015q\u000f\u0005\u0006\u0005R\u0001\r\u0001R\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti(a!\u0011\tE\ny\bR\u0005\u0004\u0003\u0003\u0013$AB(qi&|g\u000e\u0003\u0005\u0002\u0006V\t\t\u00111\u0001K\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003\u0017\u00032A\\AG\u0013\r\tyi\u001c\u0002\u0007\u001f\nTWm\u0019;")
public class Collation
extends UnaryExpression
implements RuntimeReplaceable,
ExpectsInputTypes,
Serializable {
    private final Expression child;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Option<Expression> unapply(Collation x$0) {
        return Collation$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Collation, A> g) {
        return Collation$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, Collation> compose(Function1<A$, Expression> g) {
        return Collation$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        Collation collation = this;
        synchronized (collation) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if (!this.bitmap$0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Collation withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    @Override
    public Expression replacement() {
        int collationId = ((StringType)this.child().dataType()).collationId();
        String collationName = CollationFactory.fetchCollation((int)collationId).collationName;
        return Literal$.MODULE$.create(collationName, (DataType)SQLConf$.MODULE$.get().defaultStringType());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)Nil$.MODULE$);
    }

    public Collation copy(Expression child) {
        return new Collation(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Collation";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Collation;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Collation)) return false;
        boolean bl = true;
        if (!bl) return false;
        Collation collation = (Collation)x$1;
        Expression expression = this.child();
        Expression expression2 = collation.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!collation.canEqual(this)) return false;
        return true;
    }

    public Collation(Expression child) {
        this.child = child;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }
}

