/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.Encode$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.GlobalValue;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str, charset) - Encodes the first argument using the second argument character set. If either argument is null, the result will also be null.", arguments="\n    Arguments:\n      * str - a string expression\n      * charset - one of the charsets 'US-ASCII', 'ISO-8859-1', 'UTF-8', 'UTF-16BE', 'UTF-16LE', 'UTF-16', 'UTF-32' to encode `str` into a BINARY. It is case insensitive.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('abc', 'utf-8');\n       abc\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0015b\u0001\u0002\u0013&\u0001JB\u0001B\u0015\u0001\u0003\u0016\u0004%\ta\u0015\u0005\t/\u0002\u0011\t\u0012)A\u0005)\"A\u0001\f\u0001BK\u0002\u0013\u00051\u000b\u0003\u0005Z\u0001\tE\t\u0015!\u0003U\u0011!Q\u0006A!f\u0001\n\u0003Y\u0006\u0002C0\u0001\u0005#\u0005\u000b\u0011\u0002/\t\u000b\u0001\u0004A\u0011A1\t\u000b\u0001\u0004A\u0011\u00014\t\u000b)\u0004A\u0011I*\t\u000b-\u0004A\u0011I*\t\u000b1\u0004A\u0011I7\t\u000bQ\u0004A\u0011I;\t\u000fq\u0004!\u0019!C\u0005{\"9\u0011Q\u0004\u0001!\u0002\u0013q\bbBA\u0010\u0001\u0011E\u0013\u0011\u0005\u0005\b\u0003c\u0001A\u0011IA\u001a\u0011\u001d\ty\u0005\u0001C)\u0003#B\u0011\"a\u0017\u0001\u0003\u0003%\t!!\u0018\t\u0013\u0005\u0015\u0004!%A\u0005\u0002\u0005\u001d\u0004\"CA?\u0001E\u0005I\u0011AA4\u0011%\ty\bAI\u0001\n\u0003\t\t\tC\u0005\u0002\u0006\u0002\t\t\u0011\"\u0011\u0002\b\"I\u0011\u0011\u0012\u0001\u0002\u0002\u0013\u0005\u00111\u0012\u0005\n\u0003'\u0003\u0011\u0011!C\u0001\u0003+C\u0011\"a'\u0001\u0003\u0003%\t%!(\t\u0013\u0005\u001d\u0006!!A\u0005\u0002\u0005%\u0006\"CAW\u0001\u0005\u0005I\u0011IAX\u0011%\t\u0019\fAA\u0001\n\u0003\n)lB\u0004\u0002`\u0016B\t!!9\u0007\r\u0011*\u0003\u0012AAr\u0011\u0019\u0001g\u0004\"\u0001\u0002v\"9\u0011q\u001f\u0010\u0005\u0002\u0005e\b\"CA|=\u0005\u0005I\u0011QA\u0000\u0011%\u00119AHA\u0001\n\u0003\u0013I\u0001C\u0005\u0003\u001cy\t\t\u0011\"\u0003\u0003\u001e\t1QI\\2pI\u0016T!AJ\u0014\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003Q%\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003U-\n1a]9m\u0015\taS&A\u0003ta\u0006\u00148N\u0003\u0002/_\u00051\u0011\r]1dQ\u0016T\u0011\u0001M\u0001\u0004_J<7\u0001A\n\u0007\u0001M:$(Q$\u0011\u0005Q*T\"A\u0013\n\u0005Y*#\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t!\u0004(\u0003\u0002:K\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002<}9\u0011A\u0007P\u0005\u0003{\u0015\nq\u0001]1dW\u0006<W-\u0003\u0002@\u0001\nqa*\u001e7m\u0013:$x\u000e\\3sC:$(BA\u001f&!\t\u0011U)D\u0001D\u0015\u0005!\u0015!B:dC2\f\u0017B\u0001$D\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001S(\u000f\u0005%seB\u0001&N\u001b\u0005Y%B\u0001'2\u0003\u0019a$o\\8u}%\tA)\u0003\u0002>\u0007&\u0011\u0001+\u0015\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003{\r\u000b1a\u001d;s+\u0005!\u0006C\u0001\u001bV\u0013\t1VE\u0001\u0006FqB\u0014Xm]:j_:\fAa\u001d;sA\u000591\r[1sg\u0016$\u0018\u0001C2iCJ\u001cX\r\u001e\u0011\u0002\u001d1,w-Y2z\u0007\"\f'o]3ugV\tA\f\u0005\u0002C;&\u0011al\u0011\u0002\b\u0005>|G.Z1o\u0003=aWmZ1ds\u000eC\u0017M]:fiN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003cG\u0012,\u0007C\u0001\u001b\u0001\u0011\u0015\u0011v\u00011\u0001U\u0011\u0015Av\u00011\u0001U\u0011\u0015Qv\u00011\u0001])\r\u0011w-\u001b\u0005\u0006Q\"\u0001\r\u0001V\u0001\u0006m\u0006dW/\u001a\u0005\u00061\"\u0001\r\u0001V\u0001\u0005Y\u00164G/A\u0003sS\u001eDG/\u0001\u0005eCR\fG+\u001f9f+\u0005q\u0007CA8s\u001b\u0005\u0001(BA9*\u0003\u0015!\u0018\u0010]3t\u0013\t\u0019\bO\u0001\u0005ECR\fG+\u001f9f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002mB\u0019\u0001j^=\n\u0005a\f&aA*fcB\u0011qN_\u0005\u0003wB\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002#M,\b\u000f]8si\u0016$7\t[1sg\u0016$8/F\u0001\u007f!\u0015y\u0018\u0011BA\u0007\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011!C5n[V$\u0018M\u00197f\u0015\r\t9aQ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0006\u0003\u0003\u00111aU3u!\u0011\ty!!\u0007\u000e\u0005\u0005E!\u0002BA\n\u0003+\tA\u0001\\1oO*\u0011\u0011qC\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001c\u0005E!AB*ue&tw-\u0001\ntkB\u0004xN\u001d;fI\u000eC\u0017M]:fiN\u0004\u0013\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGCBA\u0012\u0003S\ti\u0003E\u0002C\u0003KI1!a\nD\u0005\r\te.\u001f\u0005\b\u0003Wy\u0001\u0019AA\u0012\u0003\u0019Ig\u000e];uc!9\u0011qF\bA\u0002\u0005\r\u0012AB5oaV$('A\u0005e_\u001e+gnQ8eKR1\u0011QGA!\u0003\u0017\u0002B!a\u000e\u0002>5\u0011\u0011\u0011\b\u0006\u0004\u0003w)\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003\u007f\tID\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t\u0019\u0005\u0005a\u0001\u0003\u000b\n1a\u0019;y!\u0011\t9$a\u0012\n\t\u0005%\u0013\u0011\b\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\ti\u0005\u0005a\u0001\u0003k\t!!\u001a<\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#\u00022\u0002T\u0005]\u0003BBA+#\u0001\u0007A+A\u0004oK^dUM\u001a;\t\r\u0005e\u0013\u00031\u0001U\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$rAYA0\u0003C\n\u0019\u0007C\u0004S%A\u0005\t\u0019\u0001+\t\u000fa\u0013\u0002\u0013!a\u0001)\"9!L\u0005I\u0001\u0002\u0004a\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003SR3\u0001VA6W\t\ti\u0007\u0005\u0003\u0002p\u0005eTBAA9\u0015\u0011\t\u0019(!\u001e\u0002\u0013Ut7\r[3dW\u0016$'bAA<\u0007\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0014\u0011\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019IK\u0002]\u0003W\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0007\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\tE\u0002C\u0003\u001fK1!!%D\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019#a&\t\u0013\u0005e\u0005$!AA\u0002\u00055\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002 B1\u0011\u0011UAR\u0003Gi!!!\u0002\n\t\u0005\u0015\u0016Q\u0001\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002]\u0003WC\u0011\"!'\u001b\u0003\u0003\u0005\r!a\t\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u001b\t\t\fC\u0005\u0002\u001an\t\t\u00111\u0001\u0002\u000e\u00061Q-];bYN$2\u0001XA\\\u0011%\tI\nHA\u0001\u0002\u0004\t\u0019\u0003K\f\u0001\u0003w\u000b\t-a1\u0002H\u0006%\u0017QZAh\u0003'\f).!7\u0002\\B\u0019A'!0\n\u0007\u0005}VEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\u0015\u0017!!\u000b`\rVs5i\u0018\u0015tiJd\u0003e\u00195beN,G/\u000b\u0011.A\u0015s7m\u001c3fg\u0002\"\b.\u001a\u0011gSJ\u001cH\u000fI1sOVlWM\u001c;!kNLgn\u001a\u0011uQ\u0016\u00043/Z2p]\u0012\u0004\u0013M]4v[\u0016tG\u000fI2iCJ\f7\r^3sAM,GO\f\u0011JM\u0002*\u0017\u000e\u001e5fe\u0002\n'oZ;nK:$\b%[:!]VdG\u000e\f\u0011uQ\u0016\u0004#/Z:vYR\u0004s/\u001b7mA\u0005d7o\u001c\u0011cK\u0002rW\u000f\u001c7/\u0003%\t'oZ;nK:$8/\t\u0002\u0002L\u0006\tyL\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!gR\u0014\b%\f\u0011bAM$(/\u001b8hA\u0015D\bO]3tg&|gN\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011dQ\u0006\u00148/\u001a;![\u0001zg.\u001a\u0011pM\u0002\"\b.\u001a\u0011dQ\u0006\u00148/\u001a;tA\u001d*6+L!T\u0007&Ku\u0005\f\u0011(\u0013N{U\u0006\u000f\u001d6s5\nt\u0005\f\u0011(+R3U\u0006O\u0014-A\u001d*FKR\u00172m\t+u\u0005\f\u0011(+R3U&\r\u001cM\u000b\u001eb\u0003eJ+U\r6\ndg\n\u0017!OU#f)L\u001a3O\u0001\"x\u000eI3oG>$W\r\t1tiJ\u0004\u0007%\u001b8u_\u0002\n\u0007EQ%O\u0003JKf\u0006I%uA%\u001c\beY1tK\u0002Jgn]3og&$\u0018N^3/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005E\u0017a\u0011\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O\u0005\u00147m\n\u0017!OU$h-\f\u001d(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013MY2\u000bA\u0001\nQa]5oG\u0016\f#!a6\u0002\u000bErSG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005u\u0017\u0001D:ue&twm\u00184v]\u000e\u001c\u0018AB#oG>$W\r\u0005\u00025=M)a$!:\u0002lB\u0019!)a:\n\u0007\u0005%8I\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0003[\f\u00190\u0004\u0002\u0002p*!\u0011\u0011_A\u000b\u0003\tIw.C\u0002Q\u0003_$\"!!9\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b\t\fY0!@\t\u000b!\u0004\u0003\u0019\u0001+\t\u000ba\u0003\u0003\u0019\u0001+\u0015\u000f\t\u0014\tAa\u0001\u0003\u0006!)!+\ta\u0001)\")\u0001,\ta\u0001)\")!,\ta\u00019\u00069QO\\1qa2LH\u0003\u0002B\u0006\u0005/\u0001RA\u0011B\u0007\u0005#I1Aa\u0004D\u0005\u0019y\u0005\u000f^5p]B1!Ia\u0005U)rK1A!\u0006D\u0005\u0019!V\u000f\u001d7fg!A!\u0011\u0004\u0012\u0002\u0002\u0003\u0007!-A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa\b\u0011\t\u0005=!\u0011E\u0005\u0005\u0005G\t\tB\u0001\u0004PE*,7\r\u001e")
public class Encode
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression str;
    private final Expression charset;
    private final boolean legacyCharsets;
    private final Set<String> supportedCharsets;

    public static Option<Tuple3<Expression, Expression, Object>> unapply(Encode x$0) {
        return Encode$.MODULE$.unapply(x$0);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression charset() {
        return this.charset;
    }

    public boolean legacyCharsets() {
        return this.legacyCharsets;
    }

    @Override
    public Expression left() {
        return this.str();
    }

    @Override
    public Expression right() {
        return this.charset();
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)Nil$.MODULE$));
    }

    private Set<String> supportedCharsets() {
        return this.supportedCharsets;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        byte[] byArray;
        String toCharset = ((UTF8String)input2).toString();
        try {
            if (!this.legacyCharsets() && !this.supportedCharsets().contains((Object)toCharset.toUpperCase(Locale.ROOT))) {
                throw new UnsupportedEncodingException();
            }
            byArray = ((UTF8String)input1).toString().getBytes(toCharset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw QueryExecutionErrors$.MODULE$.invalidCharsetError(this.prettyName(), toCharset);
        }
        return byArray;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(string, charset) -> {
            String toCharset = ctx.freshName("toCharset");
            GlobalValue sc = JavaCode$.MODULE$.global(ctx.addReferenceObj("supportedCharsets", this.supportedCharsets(), ctx.addReferenceObj$default$3()), this.supportedCharsets().getClass());
            return "\n        String " + toCharset + " = " + charset + ".toString();\n        try {\n          if (" + this.legacyCharsets() + " || " + sc + ".contains(" + toCharset + ".toUpperCase(java.util.Locale.ROOT))) {\n            " + ev.value() + " = " + string + ".toString().getBytes(" + toCharset + ");\n          } else {\n            throw new java.io.UnsupportedEncodingException();\n          }\n        } catch (java.io.UnsupportedEncodingException e) {\n          throw QueryExecutionErrors.invalidCharsetError(\"" + this.prettyName() + "\", " + toCharset + ");\n        }";
        });
    }

    @Override
    public Encode withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public Encode copy(Expression str, Expression charset, boolean legacyCharsets) {
        return new Encode(str, charset, legacyCharsets);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.charset();
    }

    public boolean copy$default$3() {
        return this.legacyCharsets();
    }

    @Override
    public String productPrefix() {
        return "Encode";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.str();
            }
            case 1: {
                return this.charset();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.legacyCharsets());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Encode;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "str";
            }
            case 1: {
                return "charset";
            }
            case 2: {
                return "legacyCharsets";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Encode)) return false;
        boolean bl = true;
        if (!bl) return false;
        Encode encode = (Encode)x$1;
        if (this.legacyCharsets() != encode.legacyCharsets()) return false;
        Expression expression = this.str();
        Expression expression2 = encode.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.charset();
        Expression expression4 = encode.charset();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!encode.canEqual(this)) return false;
        return true;
    }

    public Encode(Expression str, Expression charset, boolean legacyCharsets) {
        this.str = str;
        this.charset = charset;
        this.legacyCharsets = legacyCharsets;
        ExpectsInputTypes.$init$(this);
        this.supportedCharsets = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"US-ASCII", "ISO-8859-1", "UTF-8", "UTF-16BE", "UTF-16LE", "UTF-16", "UTF-32"}));
    }

    public Encode(Expression value, Expression charset) {
        this(value, charset, SQLConf$.MODULE$.get().legacyJavaCharsets());
    }
}

