/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.CreateMap;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery;
import org.apache.spark.sql.catalyst.expressions.WindowExpression;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.types.AbstractMapType;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class ExprUtils$
implements QueryErrorsBase {
    public static final ExprUtils$ MODULE$ = new ExprUtils$();

    static {
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)MODULE$);
        QueryErrorsBase.$init$(MODULE$);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public DataType evalTypeExpr(Expression exp) {
        if (exp.foldable()) {
            UTF8String uTF8String;
            Object object = exp.eval(exp.eval$default$1());
            if (object instanceof UTF8String && (uTF8String = (UTF8String)object) != null) {
                DataType dataType = DataType$.MODULE$.fromDDL(uTF8String.toString());
                return CharVarcharUtils$.MODULE$.failIfHasCharVarchar(dataType);
            }
            throw QueryCompilationErrors$.MODULE$.unexpectedSchemaTypeError(exp);
        }
        throw QueryCompilationErrors$.MODULE$.unexpectedSchemaTypeError(exp);
    }

    public StructType evalSchemaExpr(Expression exp) {
        DataType dataType = this.evalTypeExpr(exp);
        if (!(dataType instanceof StructType)) {
            throw QueryCompilationErrors$.MODULE$.schemaIsNotStructTypeError(exp, dataType);
        }
        return (StructType)dataType;
    }

    public Map<String, String> convertToMapData(Expression exp) {
        boolean bl = false;
        CreateMap createMap = null;
        Expression expression = exp;
        if (expression instanceof CreateMap) {
            bl = true;
            createMap = (CreateMap)expression;
            if (new AbstractMapType((AbstractDataType)StringTypeAnyCollation$.MODULE$, (AbstractDataType)StringTypeAnyCollation$.MODULE$).acceptsType((DataType)createMap.dataType())) {
                ArrayBasedMapData arrayMap = (ArrayBasedMapData)createMap.eval(createMap.eval$default$1());
                return (Map)ArrayBasedMapData$.MODULE$.toScalaMap(arrayMap).map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Object key = tuple2._1();
                        Object value = tuple2._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key.toString()), (Object)value.toString());
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
        }
        if (bl) {
            throw QueryCompilationErrors$.MODULE$.keyValueInMapNotStringError(createMap);
        }
        throw QueryCompilationErrors$.MODULE$.nonMapFunctionNotAllowedError();
    }

    public void verifyColumnNameOfCorruptRecord(StructType schema, String columnNameOfCorruptRecord) {
        schema.getFieldIndex(columnNameOfCorruptRecord).foreach((Function1)(JFunction1.mcVI.sp & Serializable)corruptFieldIndex -> {
            StructField f = schema.apply(corruptFieldIndex);
            if (!(f.dataType() instanceof StringType) || !f.nullable()) {
                throw QueryCompilationErrors$.MODULE$.invalidFieldTypeForCorruptRecordError();
            }
        });
    }

    public Function1<String, BigDecimal> getDecimalParser(Locale locale) {
        Locale locale2 = locale;
        Locale locale3 = Locale.US;
        if (!(locale2 != null ? !((Object)locale2).equals(locale3) : locale3 != null)) {
            return (Function1 & Serializable)s -> new BigDecimal(s.replaceAll(",", ""));
        }
        DecimalFormat decimalFormat = new DecimalFormat("", new DecimalFormatSymbols(locale));
        decimalFormat.setParseBigDecimal(true);
        return (Function1 & Serializable)s -> {
            ParsePosition pos = new ParsePosition(0);
            BigDecimal result = (BigDecimal)decimalFormat.parse((String)s, pos);
            if (pos.getIndex() != s.length() || pos.getErrorIndex() != -1) {
                throw QueryExecutionErrors$.MODULE$.cannotParseDecimalError();
            }
            return result;
        };
    }

    public TypeCheckResult checkJsonSchema(DataType schema) {
        boolean isInvalid = schema.existsRecursively((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExprUtils$.$anonfun$checkJsonSchema$1(x0$1)));
        if (isInvalid) {
            return new TypeCheckResult.DataTypeMismatch("INVALID_JSON_MAP_KEY_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)this.toSQLType((AbstractDataType)schema))}))));
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    public TypeCheckResult checkXmlSchema(DataType schema) {
        boolean isInvalid = schema.existsRecursively((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExprUtils$.$anonfun$checkXmlSchema$1(x0$1)));
        if (isInvalid) {
            return new TypeCheckResult.DataTypeMismatch("INVALID_XML_MAP_KEY_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)this.toSQLType((AbstractDataType)schema))}))));
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    public void assertValidAggregation(Aggregate a) {
        a.groupingExpressions().foreach((Function1 & Serializable)expr -> {
            this.checkValidGroupingExprs$1(expr);
            return BoxedUnit.UNIT;
        });
        a.aggregateExpressions().foreach((Function1 & Serializable)expr -> {
            this.checkValidAggregateExpression$1(expr, a);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkJsonSchema$1(DataType x0$1) {
        MapType mapType;
        DataType keyType;
        DataType dataType = x0$1;
        return dataType instanceof MapType && !((keyType = (mapType = (MapType)dataType).keyType()) instanceof StringType);
    }

    public static final /* synthetic */ boolean $anonfun$checkXmlSchema$1(DataType x0$1) {
        MapType mapType;
        DataType keyType;
        DataType dataType = x0$1;
        return dataType instanceof MapType && !((keyType = (mapType = (MapType)dataType).keyType()) instanceof StringType);
    }

    public static final /* synthetic */ void $anonfun$assertValidAggregation$2(Expression x0$1) {
        Expression expression = x0$1;
        if (expression instanceof AggregateExpression) {
            AggregateExpression aggregateExpression = (AggregateExpression)expression;
            throw package$.MODULE$.AnalysisErrorAt(aggregateExpression).failAnalysis("NESTED_AGGREGATE_FUNCTION", (Map<String, String>)Predef$.MODULE$.Map().empty());
        }
    }

    public static final /* synthetic */ void $anonfun$assertValidAggregation$1(AggregateExpression x2$1, Expression child) {
        child.foreach((Function1 & Serializable)x0$1 -> {
            ExprUtils$.$anonfun$assertValidAggregation$2(x0$1);
            return BoxedUnit.UNIT;
        });
        if (!child.deterministic()) {
            throw package$.MODULE$.AnalysisErrorAt(child).failAnalysis("AGGREGATE_FUNCTION_WITH_NONDETERMINISTIC_EXPRESSION", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)MODULE$.toSQLExpr(x2$1))}))));
        }
    }

    private final void checkValidAggregateExpression$1(Expression expr2, Aggregate a$1) {
        block7: {
            Expression expression;
            while (true) {
                ScalarSubquery scalarSubquery;
                boolean bl = false;
                Attribute attribute = null;
                expression = expr2;
                if (expression instanceof AggregateExpression) {
                    AggregateExpression aggregateExpression = (AggregateExpression)expression;
                    AggregateFunction aggFunction = aggregateExpression.aggregateFunction();
                    aggFunction.children().foreach((Function1 & Serializable)child -> {
                        ExprUtils$.$anonfun$assertValidAggregation$1(aggregateExpression, child);
                        return BoxedUnit.UNIT;
                    });
                    break block7;
                }
                if (expression instanceof Attribute) {
                    bl = true;
                    attribute = (Attribute)expression;
                    if (a$1.groupingExpressions().isEmpty()) {
                        throw package$.MODULE$.AnalysisErrorAt(a$1).failAnalysis("MISSING_GROUP_BY", (Map<String, String>)Predef$.MODULE$.Map().empty());
                    }
                }
                if (bl && !a$1.groupingExpressions().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.semanticEquals(attribute)))) {
                    throw QueryCompilationErrors$.MODULE$.columnNotInGroupByClauseError(attribute);
                }
                if (expression instanceof ScalarSubquery && (scalarSubquery = (ScalarSubquery)expression).children().nonEmpty() && !a$1.groupingExpressions().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.semanticEquals(scalarSubquery)))) {
                    throw package$.MODULE$.AnalysisErrorAt(scalarSubquery).failAnalysis("SCALAR_SUBQUERY_IS_IN_GROUP_BY_OR_AGGREGATE_FUNCTION", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)this.toSQLExpr(scalarSubquery))}))));
                }
                if (a$1.groupingExpressions().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.semanticEquals(expression)))) {
                    break block7;
                }
                if (!(expression instanceof WindowExpression)) break;
                WindowExpression windowExpression = (WindowExpression)expression;
                Expression function = windowExpression.windowFunction();
                WindowSpecDefinition spec = windowExpression.windowSpec();
                function.children().foreach((Function1 & Serializable)expr -> {
                    this.checkValidAggregateExpression$1(expr, a$1);
                    return BoxedUnit.UNIT;
                });
                expr2 = spec;
            }
            expression.children().foreach((Function1 & Serializable)expr -> {
                this.checkValidAggregateExpression$1(expr, a$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$assertValidAggregation$8(Expression x$4) {
        return x$4 instanceof AggregateExpression;
    }

    public static final /* synthetic */ boolean $anonfun$assertValidAggregation$9(DataType x$5) {
        return x$5 instanceof VariantType;
    }

    private final void checkValidGroupingExprs$1(Expression expr) {
        if (expr.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ExprUtils$.$anonfun$assertValidAggregation$8(x$4)))) {
            throw package$.MODULE$.AnalysisErrorAt(expr).failAnalysis("GROUP_BY_AGGREGATE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)expr.sql())}))));
        }
        if (expr.dataType().existsRecursively((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ExprUtils$.$anonfun$assertValidAggregation$9(x$5)))) {
            throw package$.MODULE$.AnalysisErrorAt(expr).failAnalysis("GROUP_EXPRESSION_TYPE_IS_NOT_ORDERABLE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)this.toSQLExpr(expr)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType((AbstractDataType)expr.dataType()))}))));
        }
        if (!expr.deterministic()) {
            throw SparkException$.MODULE$.internalError("Non-deterministic expression '" + this.toSQLExpr(expr) + "' should not appear in grouping expression.", expr.origin().getQueryContext(), expr.origin().context().summary());
        }
    }

    private ExprUtils$() {
    }
}

