/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FindInSet$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str, str_array) - Returns the index (1-based) of the given string (`str`) in the comma-delimited list (`str_array`).\n      Returns 0, if the string was not found or if the given string (`str`) contains a comma.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('ab','abc,b,ab,c,def');\n       3\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005mh\u0001\u0002\u0010 \u00012B\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t#\u0002\u0011\t\u0012)A\u0005\u001d\"A!\u000b\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005T\u0001\tE\t\u0015!\u0003O\u0011\u0015!\u0006\u0001\"\u0001V\u0011!I\u0006\u0001#b\u0001\n\u000bQ\u0006\"\u00020\u0001\t\u0003z\u0006\"B5\u0001\t#R\u0007\"\u0002:\u0001\t\u0003\u001a\bbBA\u0002\u0001\u0011\u0005\u0013Q\u0001\u0005\b\u0003\u001b\u0001A\u0011IA\b\u0011\u001d\t\t\u0003\u0001C)\u0003GA\u0011\"!\f\u0001\u0003\u0003%\t!a\f\t\u0013\u0005U\u0002!%A\u0005\u0002\u0005]\u0002\"CA'\u0001E\u0005I\u0011AA\u001c\u0011%\ty\u0005AA\u0001\n\u0003\n\t\u0006\u0003\u0005\u0002b\u0001\t\t\u0011\"\u0001[\u0011%\t\u0019\u0007AA\u0001\n\u0003\t)\u0007C\u0005\u0002l\u0001\t\t\u0011\"\u0011\u0002n!I\u00111\u0010\u0001\u0002\u0002\u0013\u0005\u0011Q\u0010\u0005\n\u0003\u000f\u0003\u0011\u0011!C!\u0003\u0013C\u0011\"!$\u0001\u0003\u0003%\t%a$\b\u0013\u0005Mv$!A\t\u0002\u0005Uf\u0001\u0003\u0010 \u0003\u0003E\t!a.\t\rQCB\u0011AAh\u0011%\t\t\u000eGA\u0001\n\u000b\n\u0019\u000eC\u0005\u0002Vb\t\t\u0011\"!\u0002X\"I\u0011Q\u001c\r\u0002\u0002\u0013\u0005\u0015q\u001c\u0005\n\u0003cD\u0012\u0011!C\u0005\u0003g\u0014\u0011BR5oI&s7+\u001a;\u000b\u0005\u0001\n\u0013aC3yaJ,7o]5p]NT!AI\u0012\u0002\u0011\r\fG/\u00197zgRT!\u0001J\u0013\u0002\u0007M\fHN\u0003\u0002'O\u0005)1\u000f]1sW*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0007\u0001\u0019b\u0001A\u00172im\n\u0005C\u0001\u00180\u001b\u0005y\u0012B\u0001\u0019 \u0005A\u0011\u0015N\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002/e%\u00111g\b\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011Q\u0007\u000f\b\u0003]YJ!aN\u0010\u0002\u000fA\f7m[1hK&\u0011\u0011H\u000f\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\t9t\u0004\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UHA\u0004Qe>$Wo\u0019;\u0011\u0005\tKeBA\"I\u001d\t!u)D\u0001F\u0015\t15&\u0001\u0004=e>|GOP\u0005\u0002}%\u0011q'P\u0005\u0003\u0015.\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!aN\u001f\u0002\t1,g\r^\u000b\u0002\u001dB\u0011afT\u0005\u0003!~\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015aWM\u001a;!\u0003\u0015\u0011\u0018n\u001a5u\u0003\u0019\u0011\u0018n\u001a5uA\u00051A(\u001b8jiz\"2AV,Y!\tq\u0003\u0001C\u0003M\u000b\u0001\u0007a\nC\u0003S\u000b\u0001\u0007a*A\u0006d_2d\u0017\r^5p]&#W#A.\u0011\u0005qb\u0016BA/>\u0005\rIe\u000e^\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u00011\u0011\u0007\t\u000b7-\u0003\u0002c\u0017\n\u00191+Z9\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019\u001c\u0013!\u0002;za\u0016\u001c\u0018B\u00015f\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002l]B\u0004\"\u0001\u00107\n\u00055l$aA!os\")q\u000e\u0003a\u0001W\u0006!qo\u001c:e\u0011\u0015\t\b\u00021\u0001l\u0003\r\u0019X\r^\u0001\nI><UM\\\"pI\u0016$2\u0001\u001e>\u0000!\t)\b0D\u0001w\u0015\t9x$A\u0004d_\u0012,w-\u001a8\n\u0005e4(\u0001C#yaJ\u001cu\u000eZ3\t\u000bmL\u0001\u0019\u0001?\u0002\u0007\r$\b\u0010\u0005\u0002v{&\u0011aP\u001e\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0019\t\t!\u0003a\u0001i\u0006\u0011QM^\u0001\tI\u0006$\u0018\rV=qKV\u0011\u0011q\u0001\t\u0004I\u0006%\u0011bAA\u0006K\nAA)\u0019;b)f\u0004X-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\u0005\u0011\t\u0005M\u00111\u0004\b\u0005\u0003+\t9\u0002\u0005\u0002E{%\u0019\u0011\u0011D\u001f\u0002\rA\u0013X\rZ3g\u0013\u0011\ti\"a\b\u0003\rM#(/\u001b8h\u0015\r\tI\"P\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$RAVA\u0013\u0003SAa!a\n\r\u0001\u0004q\u0015a\u00028fo2+g\r\u001e\u0005\u0007\u0003Wa\u0001\u0019\u0001(\u0002\u00119,wOU5hQR\fAaY8qsR)a+!\r\u00024!9A*\u0004I\u0001\u0002\u0004q\u0005b\u0002*\u000e!\u0003\u0005\rAT\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tIDK\u0002O\u0003wY#!!\u0010\u0011\t\u0005}\u0012\u0011J\u0007\u0003\u0003\u0003RA!a\u0011\u0002F\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000fj\u0014AC1o]>$\u0018\r^5p]&!\u00111JA!\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u000b\t\u0005\u0003+\ny&\u0004\u0002\u0002X)!\u0011\u0011LA.\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0013\u0001\u00026bm\u0006LA!!\b\u0002X\u0005a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA6\u0002h!A\u0011\u0011\u000e\n\u0002\u0002\u0003\u00071,A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003_\u0002R!!\u001d\u0002x-l!!a\u001d\u000b\u0007\u0005UT(\u0001\u0006d_2dWm\u0019;j_:LA!!\u001f\u0002t\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ty(!\"\u0011\u0007q\n\t)C\u0002\u0002\u0004v\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002jQ\t\t\u00111\u0001l\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005M\u00131\u0012\u0005\t\u0003S*\u0012\u0011!a\u00017\u00061Q-];bYN$B!a \u0002\u0012\"A\u0011\u0011\u000e\f\u0002\u0002\u0003\u00071\u000eK\n\u0001\u0003+\u000bY*!(\u0002\"\u0006\r\u0016qUAU\u0003[\u000by\u000bE\u0002/\u0003/K1!!' \u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a(\u0002\u0003\u0007T\u0001\u0005\t\u0011!?\u001a+fjQ0)gR\u0014H\u0006I:ue~\u000b'O]1zS\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002Jg\u000eZ3yA!\nTFY1tK\u0012L\u0003e\u001c4!i\",\u0007eZ5wK:\u00043\u000f\u001e:j]\u001e\u0004\u0003\u0006Y:ue\u0002L\u0003%\u001b8!i\",\u0007eY8n[\u0006lC-\u001a7j[&$X\r\u001a\u0011mSN$\b\u0005\u000b1tiJ|\u0016M\u001d:bs\u0002LcF\u0003\u0011!A\u0001\u0002\u0003EU3ukJt7\u000f\t\u0019-A%4\u0007\u0005\u001e5fAM$(/\u001b8hA]\f7\u000f\t8pi\u00022w.\u001e8eA=\u0014\b%\u001b4!i\",\u0007eZ5wK:\u00043\u000f\u001e:j]\u001e\u0004\u0003\u0006Y:ue\u0002L\u0003eY8oi\u0006Lgn\u001d\u0011bA\r|W.\\1/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u0015\u0016\u0001\u0013\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O\u0005\u0014w\u0005L\u0014bE\u000ed#\rL1cY\rdC-\u001a4(SmR\u0001\u0005\t\u0011!A\u0001\u00023G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\tY+A\u00032]Ur\u0003'A\u0003he>,\b/\t\u0002\u00022\u0006a1\u000f\u001e:j]\u001e|f-\u001e8dg\u0006Ia)\u001b8e\u0013:\u001cV\r\u001e\t\u0003]a\u0019R\u0001GA]\u0003\u000b\u0004r!a/\u0002B:se+\u0004\u0002\u0002>*\u0019\u0011qX\u001f\u0002\u000fI,h\u000e^5nK&!\u00111YA_\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0003\u000f\fi-\u0004\u0002\u0002J*!\u00111ZA.\u0003\tIw.C\u0002K\u0003\u0013$\"!!.\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0015\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bY\u000bI.a7\t\u000b1[\u0002\u0019\u0001(\t\u000bI[\u0002\u0019\u0001(\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011]Aw!\u0015a\u00141]At\u0013\r\t)/\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bq\nIO\u0014(\n\u0007\u0005-XH\u0001\u0004UkBdWM\r\u0005\t\u0003_d\u0012\u0011!a\u0001-\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005U\b\u0003BA+\u0003oLA!!?\u0002X\t1qJ\u00196fGR\u0004")
public class FindInSet
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private int collationId;
    private final Expression left;
    private final Expression right;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(FindInSet x$0) {
        return FindInSet$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, FindInSet> tupled() {
        return FindInSet$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, FindInSet>> curried() {
        return FindInSet$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private int collationId$lzycompute() {
        FindInSet findInSet = this;
        synchronized (findInSet) {
            if (!this.bitmap$0) {
                this.collationId = ((StringType)this.left().dataType()).collationId();
                this.bitmap$0 = true;
            }
        }
        return this.collationId;
    }

    public final int collationId() {
        if (!this.bitmap$0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public Object nullSafeEval(Object word, Object set) {
        return BoxesRunTime.boxToInteger((int)CollationSupport.FindInSet.exec((UTF8String)((UTF8String)word), (UTF8String)((UTF8String)set), (int)this.collationId()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(word, set) -> CollationSupport.FindInSet.genCode((String)word, (String)set, (int)this.collationId()));
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "find_in_set";
    }

    @Override
    public FindInSet withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public FindInSet copy(Expression left, Expression right) {
        return new FindInSet(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "FindInSet";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FindInSet;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FindInSet)) return false;
        boolean bl = true;
        if (!bl) return false;
        FindInSet findInSet = (FindInSet)x$1;
        Expression expression = this.left();
        Expression expression2 = findInSet.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = findInSet.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!findInSet.canEqual(this)) return false;
        return true;
    }

    public FindInSet(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

