/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Hex$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Converts `expr` to hexadecimal.", examples="\n    Examples:\n      > SELECT _FUNC_(17);\n       11\n      > SELECT _FUNC_('Spark SQL');\n       537061726B2053514C\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0005q!B\u0010!\u0011\u0003ic!B\u0018!\u0011\u0003\u0001\u0004\"B \u0002\t\u0003\u0001\u0005bB!\u0002\u0005\u0004%\tA\u0011\u0005\u0007\u0013\u0006\u0001\u000b\u0011B\"\t\u000f)\u000b!\u0019!C\u0001\u0005\"11*\u0001Q\u0001\n\rCQ\u0001T\u0001\u0005\u00025CQ\u0001T\u0001\u0005\u0002aCQAX\u0001\u0005\u0002}Cq!Y\u0001\u0002\u0002\u0013\u0005%\rC\u0005\u0002j\u0006\t\t\u0011\"!\u0002l\"I\u0011q_\u0001\u0002\u0002\u0013%\u0011\u0011 \u0004\u0005_\u0001\u0002E\rC\u0005\u0000\u001b\tU\r\u0011\"\u0001\u0002\u0002!Q\u0011\u0011B\u0007\u0003\u0012\u0003\u0006I!a\u0001\t\r}jA\u0011AA\u0006\u0011\u001d\ty!\u0004C!\u0003#Aq!a\t\u000e\t\u0003\n)\u0003C\u0004\u0002.5!\t&a\f\t\u000f\u0005eR\u0002\"\u0015\u0002<!9\u0011qK\u0007\u0005R\u0005e\u0003\"CA0\u001b\u0005\u0005I\u0011AA1\u0011%\t)'DI\u0001\n\u0003\t9\u0007C\u0005\u0002~5\t\t\u0011\"\u0011\u0002\u0000!I\u0011QR\u0007\u0002\u0002\u0013\u0005\u0011q\u0012\u0005\n\u0003/k\u0011\u0011!C\u0001\u00033C\u0011\"a(\u000e\u0003\u0003%\t%!)\t\u0013\u0005=V\"!A\u0005\u0002\u0005E\u0006\"CA^\u001b\u0005\u0005I\u0011IA_\u0011%\t\t-DA\u0001\n\u0003\n\u0019-A\u0002IKbT!!\t\u0012\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003G\u0011\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003K\u0019\n1a]9m\u0015\t9\u0003&A\u0003ta\u0006\u00148N\u0003\u0002*U\u00051\u0011\r]1dQ\u0016T\u0011aK\u0001\u0004_J<7\u0001\u0001\t\u0003]\u0005i\u0011\u0001\t\u0002\u0004\u0011\u0016D8cA\u00012oA\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t1\u0011I\\=SK\u001a\u0004\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\u0005%|'\"\u0001\u001f\u0002\t)\fg/Y\u0005\u0003}e\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001P5oSRtD#A\u0017\u0002\u0013!,\u0007\u0010R5hSR\u001cX#A\"\u0011\u0007I\"e)\u0003\u0002Fg\t)\u0011I\u001d:bsB\u0011!gR\u0005\u0003\u0011N\u0012AAQ=uK\u0006Q\u0001.\u001a=ES\u001eLGo\u001d\u0011\u0002\u0017Ut\u0007.\u001a=ES\u001eLGo]\u0001\rk:DW\r\u001f#jO&$8\u000fI\u0001\u0004Q\u0016DHC\u0001(W!\tyE+D\u0001Q\u0015\t\t&+A\u0003usB,7O\u0003\u0002TM\u00051QO\\:bM\u0016L!!\u0016)\u0003\u0015U#f\tO*ue&tw\rC\u0003X\u000f\u0001\u00071)A\u0003csR,7\u000f\u0006\u0002O3\")!\f\u0003a\u00017\u0006\u0019a.^7\u0011\u0005Ib\u0016BA/4\u0005\u0011auN\\4\u0002\u000bUt\u0007.\u001a=\u0015\u0005\r\u0003\u0007\"B,\n\u0001\u0004\u0019\u0015!B1qa2LHcA2\u0002hB\u0011a&D\n\u0007\u001b\u0015D7N];\u0011\u000592\u0017BA4!\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u0018j\u0013\tQ\u0007E\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\tawN\u0004\u0002/[&\u0011a\u000eI\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0018O\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u00059\u0004\u0003C\u0001\u001at\u0013\t!8GA\u0004Qe>$Wo\u0019;\u0011\u0005YlhBA<}\u001d\tA80D\u0001z\u0015\tQH&\u0001\u0004=e>|GOP\u0005\u0002i%\u0011anM\u0005\u0003}yT!A\\\u001a\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0005\u0005\r\u0001c\u0001\u0018\u0002\u0006%\u0019\u0011q\u0001\u0011\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\r\t\u000b\u0004G\u00065\u0001BB@\u0011\u0001\u0004\t\u0019!\u0001\u0006j]B,H\u000fV=qKN,\"!a\u0005\u0011\u000bY\f)\"!\u0007\n\u0007\u0005]aPA\u0002TKF\u0004B!a\u0007\u0002 5\u0011\u0011Q\u0004\u0006\u0003#\u0012JA!!\t\u0002\u001e\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\u0011\u0011q\u0005\t\u0005\u00037\tI#\u0003\u0003\u0002,\u0005u!\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\t\u0005E\u0012q\u0007\t\u0004e\u0005M\u0012bAA\u001bg\t\u0019\u0011I\\=\t\ri\u001b\u0002\u0019AA\u0019\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002>\u0005%\u00131\u000b\t\u0005\u0003\u007f\t)%\u0004\u0002\u0002B)\u0019\u00111\t\u0011\u0002\u000f\r|G-Z4f]&!\u0011qIA!\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA&)\u0001\u0007\u0011QJ\u0001\u0004GRD\b\u0003BA \u0003\u001fJA!!\u0015\u0002B\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA+)\u0001\u0007\u0011QH\u0001\u0003KZ\fAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dGcA2\u0002\\!9\u0011QL\u000bA\u0002\u0005\r\u0011\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\u0004G\u0006\r\u0004\u0002C@\u0017!\u0003\u0005\r!a\u0001\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u000e\u0016\u0005\u0003\u0007\tYg\u000b\u0002\u0002nA!\u0011qNA=\u001b\t\t\tH\u0003\u0003\u0002t\u0005U\u0014!C;oG\",7m[3e\u0015\r\t9hM\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA>\u0003c\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u0011\t\u0005\u0003\u0007\u000bI)\u0004\u0002\u0002\u0006*\u0019\u0011qQ\u001e\u0002\t1\fgnZ\u0005\u0005\u0003\u0017\u000b)I\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003#\u00032AMAJ\u0013\r\t)j\r\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003c\tY\nC\u0005\u0002\u001ej\t\t\u00111\u0001\u0002\u0012\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a)\u0011\r\u0005\u0015\u00161VA\u0019\u001b\t\t9KC\u0002\u0002*N\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti+a*\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003g\u000bI\fE\u00023\u0003kK1!a.4\u0005\u001d\u0011un\u001c7fC:D\u0011\"!(\u001d\u0003\u0003\u0005\r!!\r\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u0003\u000by\fC\u0005\u0002\u001ev\t\t\u00111\u0001\u0002\u0012\u00061Q-];bYN$B!a-\u0002F\"I\u0011Q\u0014\u0010\u0002\u0002\u0003\u0007\u0011\u0011\u0007\u0015\u0014\u001b\u0005%\u0017qZAi\u0003+\f9.a7\u0002^\u0006\u0005\u00181\u001d\t\u0004]\u0005-\u0017bAAgA\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAj\u00039zf)\u0016(D?\"*\u0007\u0010\u001d:*A5\u00023i\u001c8wKJ$8\u000f\t1fqB\u0014\b\r\t;pA!,\u00070\u00193fG&l\u0017\r\u001c\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!7\u0002i*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013gN\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AE\n$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u0006\u00148\u000eI*R\u0019\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001b4oA2\u0014g\u000e\u001a7\u0005J\u0002TgM\u001b2i\rS\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003?\fQ!\r\u00186]A\nQa\u001a:pkB\f#!!:\u0002\u00155\fG\u000f[0gk:\u001c7\u000f\u0003\u0004\u0000\u0015\u0001\u0007\u00111A\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti/a=\u0011\u000bI\ny/a\u0001\n\u0007\u0005E8G\u0001\u0004PaRLwN\u001c\u0005\t\u0003k\\\u0011\u0011!a\u0001G\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005m\b\u0003BAB\u0003{LA!a@\u0002\u0006\n1qJ\u00196fGR\u0004")
public class Hex
extends UnaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Hex x$0) {
        return Hex$.MODULE$.unapply(x$0);
    }

    public static byte[] unhex(byte[] bytes) {
        return Hex$.MODULE$.unhex(bytes);
    }

    public static UTF8String hex(long num) {
        return Hex$.MODULE$.hex(num);
    }

    public static UTF8String hex(byte[] bytes) {
        return Hex$.MODULE$.hex(bytes);
    }

    public static byte[] unhexDigits() {
        return Hex$.MODULE$.unhexDigits();
    }

    public static byte[] hexDigits() {
        return Hex$.MODULE$.hexDigits();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{LongType$.MODULE$, BinaryType$.MODULE$, StringTypeAnyCollation$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        DataType dataType = this.child().dataType();
        if (dataType instanceof StringType) {
            StringType stringType = (StringType)dataType;
            return stringType;
        }
        return SQLConf$.MODULE$.get().defaultStringType();
    }

    @Override
    public Object nullSafeEval(Object num) {
        DataType dataType = this.child().dataType();
        if (LongType$.MODULE$.equals(dataType)) {
            return Hex$.MODULE$.hex(BoxesRunTime.unboxToLong((Object)num));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return Hex$.MODULE$.hex((byte[])num);
        }
        if (dataType instanceof StringType) {
            return Hex$.MODULE$.hex(((UTF8String)num).getBytes());
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> {
            DataType dataType;
            String hex = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(Hex$.MODULE$.getClass().getName()), "$");
            return ev.value() + " = " + ((dataType = this.child().dataType()) instanceof StringType ? hex + ".hex(" + c + ".getBytes());" : hex + ".hex(" + c + ");");
        });
    }

    @Override
    public Hex withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Hex copy(Expression child) {
        return new Hex(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Hex";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Hex;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Hex)) return false;
        boolean bl = true;
        if (!bl) return false;
        Hex hex = (Hex)x$1;
        Expression expression = this.child();
        Expression expression2 = hex.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!hex.canEqual(this)) return false;
        return true;
    }

    public Hex(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

