/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LengthOfJsonArray$;
import org.apache.spark.sql.catalyst.expressions.SharedFactory$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(jsonArray) - Returns the number of elements in the outermost JSON array.", arguments="\n    Arguments:\n      * jsonArray - A JSON array. `NULL` is returned in case of any other valid JSON string,\n          `NULL` or an invalid JSON.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('[1,2,3,4]');\n        4\n      > SELECT _FUNC_('[1,2,3,{\"f1\":1,\"f2\":[5,6]},4]');\n        5\n      > SELECT _FUNC_('[1,2');\n        NULL\n  ", group="json_funcs", since="3.1.0")
@ScalaSignature(bytes="\u0006\u0005\u0005=h\u0001B\u000e\u001d\u0001&B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\")q\n\u0001C\u0001!\")1\u000b\u0001C!)\")a\f\u0001C!?\")1\r\u0001C!I\")\u0001\u000e\u0001C!S\")!\u000f\u0001C!g\")Q\u0010\u0001C\u0005}\"9\u0011Q\u0004\u0001\u0005R\u0005}\u0001\"CA\u0013\u0001\u0005\u0005I\u0011AA\u0014\u0011%\tY\u0003AI\u0001\n\u0003\ti\u0003C\u0005\u0002D\u0001\t\t\u0011\"\u0011\u0002F!I\u0011Q\u000b\u0001\u0002\u0002\u0013\u0005\u0011q\u000b\u0005\n\u0003?\u0002\u0011\u0011!C\u0001\u0003CB\u0011\"a\u001a\u0001\u0003\u0003%\t%!\u001b\t\u0013\u0005]\u0004!!A\u0005\u0002\u0005e\u0004\"CA?\u0001\u0005\u0005I\u0011IA@\u0011%\t\u0019\tAA\u0001\n\u0003\n)iB\u0005\u00020r\t\t\u0011#\u0001\u00022\u001aA1\u0004HA\u0001\u0012\u0003\t\u0019\f\u0003\u0004P+\u0011\u0005\u00111\u001a\u0005\n\u0003\u001b,\u0012\u0011!C#\u0003\u001fD\u0011\"!5\u0016\u0003\u0003%\t)a5\t\u0013\u0005]W#!A\u0005\u0002\u0006e\u0007\"CAs+\u0005\u0005I\u0011BAt\u0005EaUM\\4uQ>3'j]8o\u0003J\u0014\u0018-\u001f\u0006\u0003;y\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0004I\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011EI\u0001\u0004gFd'BA\u0012%\u0003\u0015\u0019\b/\u0019:l\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001M1\u0001A\u000b\u00185ou\u0002\"a\u000b\u0017\u000e\u0003qI!!\f\u000f\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"a\f\u001a\u000e\u0003AR!!\r\u000f\u0002\u000f\r|G-Z4f]&\u00111\u0007\r\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u00111&N\u0005\u0003mq\u0011\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u0010$\u000f\u0005}\"eB\u0001!D\u001b\u0005\t%B\u0001\")\u0003\u0019a$o\\8u}%\t!(\u0003\u0002Fs\u00059\u0001/Y2lC\u001e,\u0017BA$I\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t)\u0015(A\u0003dQ&dG-F\u0001L!\tYC*\u0003\u0002N9\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003\u0019a\u0014N\\5u}Q\u0011\u0011K\u0015\t\u0003W\u0001AQ!S\u0002A\u0002-\u000b!\"\u001b8qkR$\u0016\u0010]3t+\u0005)\u0006c\u0001 W1&\u0011q\u000b\u0013\u0002\u0004'\u0016\f\bCA-]\u001b\u0005Q&BA.!\u0003\u0015!\u0018\u0010]3t\u0013\ti&L\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-F\u0001a!\tI\u0016-\u0003\u0002c5\nAA)\u0019;b)f\u0004X-\u0001\u0005ok2d\u0017M\u00197f+\u0005)\u0007C\u0001\u001dg\u0013\t9\u0017HA\u0004C_>dW-\u00198\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001k!\tYwN\u0004\u0002m[B\u0011\u0001)O\u0005\u0003]f\na\u0001\u0015:fI\u00164\u0017B\u00019r\u0005\u0019\u0019FO]5oO*\u0011a.O\u0001\u0005KZ\fG\u000e\u0006\u0002uoB\u0011\u0001(^\u0005\u0003mf\u00121!\u00118z\u0011\u001dA\b\u0002%AA\u0002e\fQ!\u001b8qkR\u0004\"A_>\u000e\u0003yI!\u0001 \u0010\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\ra\u0006\u00148/Z\"pk:$XM\u001d\u000b\u0005i~\fY\u0002C\u0004\u0002\u0002%\u0001\r!a\u0001\u0002\rA\f'o]3s!\u0011\t)!a\u0006\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\tAaY8sK*!\u0011QBA\b\u0003\u001dQ\u0017mY6t_:TA!!\u0005\u0002\u0014\u0005Ia-Y:uKJDX\u000e\u001c\u0006\u0003\u0003+\t1aY8n\u0013\u0011\tI\"a\u0002\u0003\u0015)\u001bxN\u001c)beN,'\u000fC\u0003y\u0013\u0001\u0007\u00110\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0004#\u0006\u0005\u0002BBA\u0012\u0015\u0001\u00071*\u0001\u0005oK^\u001c\u0005.\u001b7e\u0003\u0011\u0019w\u000e]=\u0015\u0007E\u000bI\u0003C\u0004J\u0017A\u0005\t\u0019A&\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0006\u0016\u0004\u0017\u0006E2FAA\u001a!\u0011\t)$a\u0010\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005u\u0012(\u0001\u0006b]:|G/\u0019;j_:LA!!\u0011\u00028\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t9\u0005\u0005\u0003\u0002J\u0005MSBAA&\u0015\u0011\ti%a\u0014\u0002\t1\fgn\u001a\u0006\u0003\u0003#\nAA[1wC&\u0019\u0001/a\u0013\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005e\u0003c\u0001\u001d\u0002\\%\u0019\u0011QL\u001d\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007Q\f\u0019\u0007C\u0005\u0002f=\t\t\u00111\u0001\u0002Z\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u001b\u0011\u000b\u00055\u00141\u000f;\u000e\u0005\u0005=$bAA9s\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u0014q\u000e\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002f\u0003wB\u0001\"!\u001a\u0012\u0003\u0003\u0005\r\u0001^\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002H\u0005\u0005\u0005\"CA3%\u0005\u0005\t\u0019AA-\u0003\u0019)\u0017/^1mgR\u0019Q-a\"\t\u0011\u0005\u00154#!AA\u0002QDs\u0003AAF\u0003#\u000b\u0019*a&\u0002\u001a\u0006u\u0015qTAR\u0003K\u000bI+a+\u0011\u0007-\ni)C\u0002\u0002\u0010r\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u0016\u0006yuLR+O\u0007~C#n]8o\u0003J\u0014\u0018-_\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!]Vl'-\u001a:!_\u001a\u0004S\r\\3nK:$8\u000fI5oAQDW\rI8vi\u0016\u0014Xn\\:uA)\u001bvJ\u0014\u0011beJ\f\u0017PL\u0001\nCJ<W/\\3oiN\f#!a'\u0002\u0003SQ\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006\t6t_:\f%O]1zA5\u0002\u0013\t\t&T\u001f:\u0003\u0013M\u001d:bs:\u0002\u0003MT+M\u0019\u0002\u0004\u0013n\u001d\u0011sKR,(O\\3eA%t\u0007eY1tK\u0002zg\rI1os\u0002zG\u000f[3sAY\fG.\u001b3!\u0015N{e\nI:ue&tw\r\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002g*\u0016'MA\u0002z'\u000fI1oA%tg/\u00197jI\u0002R5k\u0014(/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u0005\u0016!a\u0017\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dZ\u0016\u0007\f\u001a-g1\"TlJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014\\c1\u0012Df\r\u0017|E\u0019\f$EO\u0019-E\u0019\u0014$EO.6YYjV\u0010\f\u001b^O%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005I\u001b\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dZ\u0016\u0007\f\u001a(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002(\u0006Q!n]8o?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u00055\u0016!B\u001a/c9\u0002\u0014!\u0005'f]\u001e$\bn\u00144Kg>t\u0017I\u001d:bsB\u00111&F\n\u0006+\u0005U\u0016\u0011\u0019\t\u0007\u0003o\u000bilS)\u000e\u0005\u0005e&bAA^s\u00059!/\u001e8uS6,\u0017\u0002BA`\u0003s\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82!\u0011\t\u0019-!3\u000e\u0005\u0005\u0015'\u0002BAd\u0003\u001f\n!![8\n\u0007\u001d\u000b)\r\u0006\u0002\u00022\u0006AAo\\*ue&tw\r\u0006\u0002\u0002H\u0005)\u0011\r\u001d9msR\u0019\u0011+!6\t\u000b%C\u0002\u0019A&\u0002\u000fUt\u0017\r\u001d9msR!\u00111\\Aq!\u0011A\u0014Q\\&\n\u0007\u0005}\u0017H\u0001\u0004PaRLwN\u001c\u0005\t\u0003GL\u0012\u0011!a\u0001#\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005%\b\u0003BA%\u0003WLA!!<\u0002L\t1qJ\u00196fGR\u0004")
public class LengthOfJsonArray
extends UnaryExpression
implements CodegenFallback,
ExpectsInputTypes,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(LengthOfJsonArray x$0) {
        return LengthOfJsonArray$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<LengthOfJsonArray, A> g) {
        return LengthOfJsonArray$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, LengthOfJsonArray> compose(Function1<A$, Expression> g) {
        return LengthOfJsonArray$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "json_array_length";
    }

    @Override
    public Object eval(InternalRow input) {
        Object object;
        block7: {
            Object object2 = new Object();
            try {
                UTF8String json = (UTF8String)this.child().eval(input);
                if (json == null) {
                    return null;
                }
                try {
                    object = Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> CreateJacksonParser$.MODULE$.utf8String(SharedFactory$.MODULE$.jsonFactory(), json), (Function1 & Serializable)parser -> {
                        if (parser.nextToken() == null) {
                            throw new NonLocalReturnControl(object2, null);
                        }
                        return this.parseCounter((JsonParser)parser, input);
                    });
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof IOException) {
                        object = null;
                        break block7;
                    }
                    throw throwable;
                }
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object2) {
                    object = ex.value();
                }
                throw ex;
            }
        }
        return object;
    }

    private Object parseCounter(JsonParser parser, InternalRow input) {
        int length = 0;
        JsonToken jsonToken = parser.currentToken();
        JsonToken jsonToken2 = JsonToken.START_ARRAY;
        if (jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2)) {
            return null;
        }
        while (true) {
            JsonToken jsonToken3 = parser.nextToken();
            JsonToken jsonToken4 = JsonToken.END_ARRAY;
            if (!(jsonToken3 == null ? jsonToken4 != null : !jsonToken3.equals(jsonToken4))) break;
            ++length;
            parser.skipChildren();
        }
        return BoxesRunTime.boxToInteger((int)length);
    }

    @Override
    public LengthOfJsonArray withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public LengthOfJsonArray copy(Expression child) {
        return new LengthOfJsonArray(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "LengthOfJsonArray";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LengthOfJsonArray;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LengthOfJsonArray)) return false;
        boolean bl = true;
        if (!bl) return false;
        LengthOfJsonArray lengthOfJsonArray = (LengthOfJsonArray)x$1;
        Expression expression = this.child();
        Expression expression2 = lengthOfJsonArray.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!lengthOfJsonArray.canEqual(this)) return false;
        return true;
    }

    public LengthOfJsonArray(Expression child) {
        this.child = child;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

