/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Like$;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="str _FUNC_ pattern[ ESCAPE escape] - Returns true if str matches `pattern` with `escape`, null if any arguments are null, false otherwise.", arguments="\n    Arguments:\n      * str - a string expression\n      * pattern - a string expression. The pattern is a string which is matched literally, with\n          exception to the following special symbols:<br><br>\n          _ matches any one character in the input (similar to . in posix regular expressions)\\\n          % matches zero or more characters in the input (similar to .* in posix regular\n          expressions)<br><br>\n          Since Spark 2.0, string literals are unescaped in our SQL parser, see the unescaping\n          rules at <a href=\"https://spark.apache.org/docs/latest/sql-ref-literals.html#string-literal\">String Literal</a>.\n          For example, in order to match \"\\abc\", the pattern should be \"\\\\abc\".<br><br>\n          When SQL config 'spark.sql.parser.escapedStringLiterals' is enabled, it falls back\n          to Spark 1.6 behavior regarding string literal parsing. For example, if the config is\n          enabled, the pattern to match \"\\abc\" should be \"\\abc\".<br><br>\n          It's recommended to use a raw string literal (with the `r` prefix) to avoid escaping\n          special characters in the pattern string if exists.\n      * escape - an character added since Spark 3.0. The default escape character is the '\\'.\n          If an escape character precedes a special symbol or another escape character, the\n          following character is matched literally. It is invalid to escape any other character.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', '_park');\n      true\n      > SELECT '\\\\abc' AS S, S _FUNC_ r'\\\\abc', S _FUNC_ '\\\\\\\\abc';\n      \\abc\ttrue\ttrue\n      > SET spark.sql.parser.escapedStringLiterals=true;\n      spark.sql.parser.escapedStringLiterals\ttrue\n      > SELECT '%SystemDrive%\\Users\\John' _FUNC_ '\\%SystemDrive\\%\\\\Users%';\n      true\n      > SET spark.sql.parser.escapedStringLiterals=false;\n      spark.sql.parser.escapedStringLiterals\tfalse\n      > SELECT '%SystemDrive%\\\\Users\\\\John' _FUNC_ r'%SystemDrive%\\\\Users%';\n      true\n      > SELECT '%SystemDrive%/Users/John' _FUNC_ '/%SystemDrive/%//Users%' ESCAPE '/';\n      true\n  ", note="\n    Use RLIKE to match with standard regular expressions.\n  ", since="1.0.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u001dc\u0001B\u0012%\u0001FB\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\"Aa\n\u0001BK\u0002\u0013\u0005\u0011\n\u0003\u0005P\u0001\tE\t\u0015!\u0003K\u0011!\u0001\u0006A!f\u0001\n\u0003\t\u0006\u0002C+\u0001\u0005#\u0005\u000b\u0011\u0002*\t\u000bY\u0003A\u0011A,\t\u000bY\u0003A\u0011\u0001/\t\u000b}\u0003A\u0011\t1\t\u000b-\u0004A\u0011\t7\t\u000fu\u0004!\u0019!C#}\"9\u0011q\u0006\u0001!\u0002\u001by\bbBA\u0019\u0001\u0011\u0005\u00131\u0007\u0005\u0007S\u0001!\t%!\u000e\t\u000f\u0005]\u0002\u0001\"\u0015\u0002:!9\u0011Q\u000b\u0001\u0005R\u0005]\u0003\"CA1\u0001\u0005\u0005I\u0011AA2\u0011%\tY\u0007AI\u0001\n\u0003\ti\u0007C\u0005\u0002\u0004\u0002\t\n\u0011\"\u0001\u0002n!I\u0011Q\u0011\u0001\u0012\u0002\u0013\u0005\u0011q\u0011\u0005\n\u0003\u0017\u0003\u0011\u0011!C!\u0003\u001bC\u0011\"!'\u0001\u0003\u0003%\t!a'\t\u0013\u0005\r\u0006!!A\u0005\u0002\u0005\u0015\u0006\"CAY\u0001\u0005\u0005I\u0011IAZ\u0011%\t\t\rAA\u0001\n\u0003\t\u0019\rC\u0005\u0002H\u0002\t\t\u0011\"\u0011\u0002J\"I\u0011Q\u001a\u0001\u0002\u0002\u0013\u0005\u0013qZ\u0004\n\u0003\u007f$\u0013\u0011!E\u0001\u0005\u00031\u0001b\t\u0013\u0002\u0002#\u0005!1\u0001\u0005\u0007-v!\tAa\u0007\t\u0013\u0005ER$!A\u0005F\tu\u0001\"\u0003B\u0010;\u0005\u0005I\u0011\u0011B\u0011\u0011%\u0011I#HA\u0001\n\u0003\u0013Y\u0003C\u0005\u0003>u\t\t\u0011\"\u0003\u0003@\t!A*[6f\u0015\t)c%A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0014)\u0003!\u0019\u0017\r^1msN$(BA\u0015+\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003W1\nQa\u001d9be.T!!\f\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0013aA8sO\u000e\u00011\u0003\u0002\u00013mq\u0002\"a\r\u001b\u000e\u0003\u0011J!!\u000e\u0013\u0003+M#(/\u001b8h%\u0016<W\r_#yaJ,7o]5p]B\u0011qGO\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t9\u0001K]8ek\u000e$\bCA\u001fF\u001d\tq4I\u0004\u0002@\u00056\t\u0001I\u0003\u0002Ba\u00051AH]8pizJ\u0011!O\u0005\u0003\tb\nq\u0001]1dW\u0006<W-\u0003\u0002G\u000f\na1+\u001a:jC2L'0\u00192mK*\u0011A\tO\u0001\u0005Y\u00164G/F\u0001K!\t\u00194*\u0003\u0002MI\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003))7oY1qK\u000eC\u0017M]\u000b\u0002%B\u0011qgU\u0005\u0003)b\u0012Aa\u00115be\u0006YQm]2ba\u0016\u001c\u0005.\u0019:!\u0003\u0019a\u0014N\\5u}Q!\u0001,\u0017.\\!\t\u0019\u0004\u0001C\u0003I\u000f\u0001\u0007!\nC\u0003O\u000f\u0001\u0007!\nC\u0003Q\u000f\u0001\u0007!\u000bF\u0002Y;zCQ\u0001\u0013\u0005A\u0002)CQA\u0014\u0005A\u0002)\u000ba!Z:dCB,GCA1j!\t\u0011gM\u0004\u0002dIB\u0011q\bO\u0005\u0003Kb\na\u0001\u0015:fI\u00164\u0017BA4i\u0005\u0019\u0019FO]5oO*\u0011Q\r\u000f\u0005\u0006U&\u0001\r!Y\u0001\u0002m\u00069Q.\u0019;dQ\u0016\u001cHcA7qwB\u0011qG\\\u0005\u0003_b\u0012qAQ8pY\u0016\fg\u000eC\u0003r\u0015\u0001\u0007!/A\u0003sK\u001e,\u0007\u0010\u0005\u0002ts6\tAO\u0003\u0002rk*\u0011ao^\u0001\u0005kRLGNC\u0001y\u0003\u0011Q\u0017M^1\n\u0005i$(a\u0002)biR,'O\u001c\u0005\u0006y*\u0001\r!Y\u0001\u0004gR\u0014\u0018\u0001\u00048pI\u0016\u0004\u0016\r\u001e;fe:\u001cX#A@\u0011\u000bu\n\t!!\u0002\n\u0007\u0005\rqIA\u0002TKF\u0004B!a\u0002\u0002*9!\u0011\u0011BA\u0012\u001d\u0011\tY!a\b\u000f\t\u00055\u0011Q\u0004\b\u0005\u0003\u001f\tYB\u0004\u0003\u0002\u0012\u0005ea\u0002BA\n\u0003/q1aPA\u000b\u0013\u0005y\u0013BA\u0017/\u0013\tYC&\u0003\u0002*U%\u0011q\u0005K\u0005\u0004\u0003C1\u0013!\u0002;sK\u0016\u001c\u0018\u0002BA\u0013\u0003O\t1\u0002\u0016:fKB\u000bG\u000f^3s]*\u0019\u0011\u0011\u0005\u0014\n\t\u0005-\u0012Q\u0006\u0002\f)J,W\rU1ui\u0016\u0014hN\u0003\u0003\u0002&\u0005\u001d\u0012!\u00048pI\u0016\u0004\u0016\r\u001e;fe:\u001c\b%\u0001\u0005u_N#(/\u001b8h)\u0005\tW#A1\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA\u001e\u0003\u000f\n\t\u0006\u0005\u0003\u0002>\u0005\rSBAA \u0015\r\t\t\u0005J\u0001\bG>$WmZ3o\u0013\u0011\t)%a\u0010\u0003\u0011\u0015C\bO]\"pI\u0016Dq!!\u0013\u0010\u0001\u0004\tY%A\u0002dib\u0004B!!\u0010\u0002N%!\u0011qJA \u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!a\u0015\u0010\u0001\u0004\tY$\u0001\u0002fm\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u00061\u0006e\u0013Q\f\u0005\u0007\u00037\u0002\u0002\u0019\u0001&\u0002\u000f9,w\u000fT3gi\"1\u0011q\f\tA\u0002)\u000b\u0001B\\3x%&<\u0007\u000e^\u0001\u0005G>\u0004\u0018\u0010F\u0004Y\u0003K\n9'!\u001b\t\u000f!\u000b\u0002\u0013!a\u0001\u0015\"9a*\u0005I\u0001\u0002\u0004Q\u0005b\u0002)\u0012!\u0003\u0005\rAU\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyGK\u0002K\u0003cZ#!a\u001d\u0011\t\u0005U\u0014qP\u0007\u0003\u0003oRA!!\u001f\u0002|\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003{B\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011QA<\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!#+\u0007I\u000b\t(A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u001f\u0003B!!%\u0002\u00186\u0011\u00111\u0013\u0006\u0004\u0003+;\u0018\u0001\u00027b]\u001eL1aZAJ\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\nE\u00028\u0003?K1!!)9\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9+!,\u0011\u0007]\nI+C\u0002\u0002,b\u00121!\u00118z\u0011%\tykFA\u0001\u0002\u0004\ti*A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003k\u0003b!a.\u0002>\u0006\u001dVBAA]\u0015\r\tY\fO\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA`\u0003s\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019Q.!2\t\u0013\u0005=\u0016$!AA\u0002\u0005\u001d\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a$\u0002L\"I\u0011q\u0016\u000e\u0002\u0002\u0003\u0007\u0011QT\u0001\u0007KF,\u0018\r\\:\u0015\u00075\f\t\u000eC\u0005\u00020n\t\t\u00111\u0001\u0002(\"Z\u0002!!6\u0002\\\u0006u\u0017\u0011]Ar\u0003O\fI/!<\u0002p\u0006M\u0018Q_A}\u0003w\u00042aMAl\u0013\r\tI\u000e\n\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ty.AA\u000bgR\u0014\be\u0018$V\u001d\u000e{\u0006\u0005]1ui\u0016\u0014hn\u0017\u0011F'\u000e\u000b\u0005+\u0012\u0011fg\u000e\f\u0007/Z/![\u0001\u0012V\r^;s]N\u0004CO];fA%4\u0007e\u001d;sA5\fGo\u00195fg\u0002\u0002\u0007/\u0019;uKJt\u0007\rI<ji\"\u0004\u0003-Z:dCB,\u0007\r\f\u0011ok2d\u0007%\u001b4!C:L\b%\u0019:hk6,g\u000e^:!CJ,\u0007E\\;mY2\u0002c-\u00197tK\u0002zG\u000f[3so&\u001cXML\u0001\nCJ<W/\\3oiN\f#!!:\u0002\u0017kQ\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I:ue\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011fqB\u0014Xm]:j_:T\u0001\u0005\t\u0011!A\u0001R\u0003\u0005]1ui\u0016\u0014h\u000eI\u0017!C\u0002\u001aHO]5oO\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018!)\",\u0007\u0005]1ui\u0016\u0014h\u000eI5tA\u0005\u00043\u000f\u001e:j]\u001e\u0004s\u000f[5dQ\u0002J7\u000fI7bi\u000eDW\r\u001a\u0011mSR,'/\u00197ms2\u0002s/\u001b;i\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u001a=dKB$\u0018n\u001c8!i>\u0004C\u000f[3!M>dGn\\<j]\u001e\u00043\u000f]3dS\u0006d\u0007e]=nE>d7O\u000f\u001fcezb$M\u001d \u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002s\fI7bi\u000eDWm\u001d\u0011b]f\u0004sN\\3!G\"\f'/Y2uKJ\u0004\u0013N\u001c\u0011uQ\u0016\u0004\u0013N\u001c9vi\u0002B3/[7jY\u0006\u0014\b\u0005^8!]\u0001Jg\u000e\t9pg&D\bE]3hk2\f'\u000fI3yaJ,7o]5p]NLCL\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0015\u0002S.\u0019;dQ\u0016\u001c\bE_3s_\u0002z'\u000fI7pe\u0016\u00043\r[1sC\u000e$XM]:!S:\u0004C\u000f[3!S:\u0004X\u000f\u001e\u0011)g&l\u0017\u000e\\1sAQ|\u0007E\f\u0016!S:\u0004\u0003o\\:jq\u0002\u0012XmZ;mCJT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011fqB\u0014Xm]:j_:\u001c\u0018\u0006\u00102s}q\u0012'O\u0010\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u001a\u0016N\\2fAM\u0003\u0018M]6!e9\u0002D\u0006I:ue&tw\r\t7ji\u0016\u0014\u0018\r\\:!CJ,\u0007%\u001e8fg\u000e\f\u0007/\u001a3!S:\u0004s.\u001e:!'Fc\u0005\u0005]1sg\u0016\u0014H\u0006I:fK\u0002\"\b.\u001a\u0011v]\u0016\u001c8-\u00199j]\u001eT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011sk2,7\u000fI1uAq\n\u0007\u0005\u001b:fMv\u0012\u0003\u000e\u001e;qgjzsf\u001d9be.t\u0013\r]1dQ\u0016tsN]40I>\u001c7o\f7bi\u0016\u001cHoL:rY6\u0012XMZ\u0017mSR,'/\u00197t]!$X\u000e\\\u0012tiJLgnZ\u0017mSR,'/\u00197#}M#(/\u001b8hA1KG/\u001a:bYrz\u0013M\u0010\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002ci\u001c:!Kb\fW\u000e\u001d7fY\u0001Jg\u000eI8sI\u0016\u0014\b\u0005^8![\u0006$8\r\u001b\u0011#9\u0006\u00147M\t\u0017!i\",\u0007\u0005]1ui\u0016\u0014h\u000eI:i_VdG\r\t2fA\tbF,\u00192dE9b$M\u001d =EJt$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!/\",g\u000eI*R\u0019\u0002\u001awN\u001c4jO\u0002:3\u000f]1sW:\u001a\u0018\u000f\u001c\u0018qCJ\u001cXM\u001d\u0018fg\u000e\f\u0007/\u001a3TiJLgn\u001a'ji\u0016\u0014\u0018\r\\:(A%\u001c\b%\u001a8bE2,G\r\f\u0011ji\u00022\u0017\r\u001c7tA\t\f7m\u001b\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"x\u000eI*qCJ\\\u0007%\r\u00187A\t,\u0007.\u0019<j_J\u0004#/Z4be\u0012Lgn\u001a\u0011tiJLgn\u001a\u0011mSR,'/\u00197!a\u0006\u00148/\u001b8h]\u00012uN\u001d\u0011fq\u0006l\u0007\u000f\\3-A%4\u0007\u0005\u001e5fA\r|gNZ5hA%\u001c(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!K:\f'\r\\3eY\u0001\"\b.\u001a\u0011qCR$XM\u001d8!i>\u0004S.\u0019;dQ\u0002\u0012C,\u00192dE\u0001\u001a\bn\\;mI\u0002\u0012W\r\t\u0012]C\n\u001c'E\f\u001fcezb$M\u001d \u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013\n^\u0014tAI,7m\\7nK:$W\r\u001a\u0011u_\u0002*8/\u001a\u0011bAI\fw\u000fI:ue&tw\r\t7ji\u0016\u0014\u0018\r\u001c\u0011)o&$\b\u000e\t;iK\u0002\u0002'\u000f\u0019\u0011qe\u00164\u0017\u000e_\u0015!i>\u0004\u0013M^8jI\u0002*7oY1qS:<'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!gB,7-[1mA\rD\u0017M]1di\u0016\u00148\u000fI5oAQDW\r\t9biR,'O\u001c\u0011tiJLgn\u001a\u0011jM\u0002*\u00070[:ug:R\u0001\u0005\t\u0011!A\u0001R\u0003%Z:dCB,\u0007%\f\u0011b]\u0002\u001a\u0007.\u0019:bGR,'\u000fI1eI\u0016$\u0007e]5oG\u0016\u00043\u000b]1sW\u0002\u001ad\u0006\r\u0018!)\",\u0007\u0005Z3gCVdG\u000fI3tG\u0006\u0004X\rI2iCJ\f7\r^3sA%\u001c\b\u0005\u001e5fA\u001dbvE\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001Je\rI1oA\u0015\u001c8-\u00199fA\rD\u0017M]1di\u0016\u0014\b\u0005\u001d:fG\u0016$Wm\u001d\u0011bAM\u0004XmY5bY\u0002\u001a\u00180\u001c2pY\u0002z'\u000fI1o_RDWM\u001d\u0011fg\u000e\f\u0007/\u001a\u0011dQ\u0006\u0014\u0018m\u0019;fe2\u0002C\u000f[3\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002cm\u001c7m_^Lgn\u001a\u0011dQ\u0006\u0014\u0018m\u0019;fe\u0002J7\u000fI7bi\u000eDW\r\u001a\u0011mSR,'/\u00197ms:\u0002\u0013\n\u001e\u0011jg\u0002JgN^1mS\u0012\u0004Co\u001c\u0011fg\u000e\f\u0007/\u001a\u0011b]f\u0004s\u000e\u001e5fe\u0002\u001a\u0007.\u0019:bGR,'O\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002l\u0006)yA\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015('B\f'o[\u0014-A\u001dz\u0006/\u0019:lO%Z$\u0002\t\u0011!A\u0001\u0002CO];f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002:C\fX1cG\u001e\u0002\u0013i\u0015\u0011TY\u0001\u001a\u0006e\u0018$V\u001d\u000e{\u0006E]\u0014]9\u0006\u00147m\n\u0017!'\u0002zf)\u0016(D?\u0002:C\f\u0018/]C\n\u001cwe\u000f\u0006!A\u0001\u0002\u0003\u0005\t/bE\u000eLAO];f\u0013Q\u0014X/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016#\u0006e\u001d9be.t3/\u001d7/a\u0006\u00148/\u001a:/KN\u001c\u0017\r]3e'R\u0014\u0018N\\4MSR,'/\u00197t{Q\u0014X/Z\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011ta\u0006\u00148NL:rY:\u0002\u0018M]:fe:*7oY1qK\u0012\u001cFO]5oO2KG/\u001a:bYNLAO];f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002:SeU=ti\u0016lGI]5wK\u0016bVk]3sgrSu\u000e\u001b8(A}3UKT\"`A\u001dbVeU=ti\u0016lGI]5wKr+C\fX+tKJ\u001cXeJ\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F)\u0002\u001a\b/\u0019:l]M\fHN\f9beN,'OL3tG\u0006\u0004X\rZ*ue&tw\rT5uKJ\fGn]\u001fgC2\u001cXm\u000f\u0006!A\u0001\u0002\u0003\u0005I:qCJ\\gf]9m]A\f'o]3s]\u0015\u001c8-\u00199fIN#(/\u001b8h\u0019&$XM]1mg&1\u0017\r\\:f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002:SeU=ti\u0016lGI]5wK\u0016bF,V:feNdFLS8i]\u001e\u0002sLR+O\u0007~\u0003#oJ\u0013TsN$X-\u001c#sSZ,W\u0005\u0018/Vg\u0016\u00148/J\u0014<\u0015\u0001\u0002\u0003\u0005\t\u0011!iJ,XM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011(KMK8\u000f^3n\tJLg/Z\u00130+N,'o]\u0018K_\"tw\u0005I0G+:\u001bu\fI\u00140KMK8\u000f^3n\tJLg/Z\u0018&_=*6/\u001a:tK\u001d\u0002SiU\"B!\u0016\u0003seL\u0014<\u0015\u0001\u0002\u0003\u0005\t\u0011!iJ,XM\u0003\u0011!\u0003\u0011qw\u000e^3\"\u0005\u0005E\u0018!\u0010\u0006!A\u0001\u0002Sk]3!%2K5*\u0012\u0011u_\u0002j\u0017\r^2iA]LG\u000f\u001b\u0011ti\u0006tG-\u0019:eAI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\\:/\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAA|\u0003\u0015\td\u0006\r\u00181\u0003\u00159'o\\;qC\t\ti0A\bqe\u0016$\u0017nY1uK~3WO\\2t\u0003\u0011a\u0015n[3\u0011\u0005Mj2#B\u000f\u0003\u0006\tE\u0001\u0003\u0003B\u0004\u0005\u001bQ%J\u0015-\u000e\u0005\t%!b\u0001B\u0006q\u00059!/\u001e8uS6,\u0017\u0002\u0002B\b\u0005\u0013\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\u0011\u0019B!\u0007\u000e\u0005\tU!b\u0001B\fo\u0006\u0011\u0011n\\\u0005\u0004\r\nUAC\u0001B\u0001)\t\ty)A\u0003baBd\u0017\u0010F\u0004Y\u0005G\u0011)Ca\n\t\u000b!\u0003\u0003\u0019\u0001&\t\u000b9\u0003\u0003\u0019\u0001&\t\u000bA\u0003\u0003\u0019\u0001*\u0002\u000fUt\u0017\r\u001d9msR!!Q\u0006B\u001d!\u00159$q\u0006B\u001a\u0013\r\u0011\t\u0004\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r]\u0012)D\u0013&S\u0013\r\u00119\u0004\u000f\u0002\u0007)V\u0004H.Z\u001a\t\u0011\tm\u0012%!AA\u0002a\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\t\u0005\u0005\u0003\u0002\u0012\n\r\u0013\u0002\u0002B#\u0003'\u0013aa\u00142kK\u000e$\b")
public class Like
extends StringRegexExpression
implements Serializable {
    private final Expression left;
    private final Expression right;
    private final char escapeChar;
    private final Seq<Enumeration.Value> nodePatterns;

    public static Option<Tuple3<Expression, Expression, Object>> unapply(Like x$0) {
        return Like$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Object>, Like> tupled() {
        return Like$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, Like>>> curried() {
        return Like$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    public char escapeChar() {
        return this.escapeChar;
    }

    @Override
    public String escape(String v) {
        return StringUtils$.MODULE$.escapeLikeRegex(v, this.escapeChar());
    }

    @Override
    public boolean matches(Pattern regex, String str) {
        return regex.matcher(str).matches();
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public String toString() {
        String escapeSuffix = this.escapeChar() == '\\' ? "" : " ESCAPE '" + this.escapeChar() + "'";
        return this.left() + " " + this.prettyName().toUpperCase(Locale.ROOT) + " " + this.right() + escapeSuffix;
    }

    @Override
    public String sql() {
        String escapeSuffix = this.escapeChar() == '\\' ? "" : " ESCAPE " + Literal$.MODULE$.apply(BoxesRunTime.boxToCharacter((char)this.escapeChar())).sql();
        return this.left().sql() + " " + this.prettyName().toUpperCase(Locale.ROOT) + " " + this.right().sql() + escapeSuffix;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String patternClass = Pattern.class.getName();
        String escapeFunc = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringUtils$.MODULE$.getClass().getName()), "$") + ".escapeLikeRegex";
        if (this.right().foldable()) {
            Object rVal = this.right().eval(this.right().eval$default$1());
            if (rVal != null) {
                String regexStr = StringEscapeUtils.escapeJava((String)this.escape(((UTF8String)rVal).toString()));
                String pattern = ctx.addMutableState(patternClass, "patternLike", (Function1<String, String>)(Function1 & Serializable)v -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(v + " = " + patternClass + ".compile(\"" + regexStr + "\", " + this.collationRegexFlags() + ");")), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                ExprCode eval = this.left().genCode(ctx);
                return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", ".matcher(", ".toString()).matches();\n          }\n        "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), ev.isNull(), eval.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), pattern, eval.value()})), ev.copy$default$2(), ev.copy$default$3());
            }
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n          boolean ", " = true;\n          ", " ", " = ", ";\n        "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2())})), ev.copy$default$2(), ev.copy$default$3());
        }
        String pattern = ctx.freshName("pattern");
        String rightStr = ctx.freshName("rightStr");
        String escapedEscapeChar = StringEscapeUtils.escapeJava((String)Character.toString(this.escapeChar()));
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(eval1, eval2) -> "\n          String " + rightStr + " = " + eval2 + ".toString();\n          " + patternClass + " " + pattern + " = " + patternClass + ".compile(\n            " + escapeFunc + "(" + rightStr + ", '" + escapedEscapeChar + "'), " + this.collationRegexFlags() + ");\n          " + ev.value() + " = " + pattern + ".matcher(" + eval1 + ".toString()).matches();\n        ");
    }

    @Override
    public Like withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public Like copy(Expression left, Expression right, char escapeChar) {
        return new Like(left, right, escapeChar);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public char copy$default$3() {
        return this.escapeChar();
    }

    @Override
    public String productPrefix() {
        return "Like";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return BoxesRunTime.boxToCharacter((char)this.escapeChar());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Like;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "escapeChar";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Like)) return false;
        boolean bl = true;
        if (!bl) return false;
        Like like = (Like)x$1;
        if (this.escapeChar() != like.escapeChar()) return false;
        Expression expression = this.left();
        Expression expression2 = like.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = like.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!like.canEqual(this)) return false;
        return true;
    }

    public Like(Expression left, Expression right, char escapeChar) {
        this.left = left;
        this.right = right;
        this.escapeChar = escapeChar;
        this.nodePatterns = new .colon.colon((Object)TreePattern$.MODULE$.LIKE_FAMLIY(), (List)Nil$.MODULE$);
    }

    public Like(Expression left, Expression right) {
        this(left, right, '\\');
    }
}

