/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionImplUtils;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Luhncheck$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str ) - Checks that a string of digits is valid according to the Luhn algorithm.\n    This checksum function is widely applied on credit card numbers and government identification\n    numbers to distinguish valid numbers from mistyped, incorrect numbers.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('8112189876');\n       true\n      > SELECT _FUNC_('79927398713');\n       true\n      > SELECT _FUNC_('79927398714');\n       false\n  ", since="3.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005\u001df\u0001B\r\u001b\u0001\u001eB\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\r\u0002\u0011\t\u0012)A\u0005Q!)q\t\u0001C\u0001\u0011\"A1\n\u0001EC\u0002\u0013\u0005S\tC\u0003M\u0001\u0011\u0005S\nC\u0003X\u0001\u0011\u0005\u0003\fC\u0003b\u0001\u0011\u0005#\rC\u0003e\u0001\u0011ES\rC\u0004l\u0001\u0005\u0005I\u0011\u00017\t\u000f9\u0004\u0011\u0013!C\u0001_\"9!\u0010AA\u0001\n\u0003Z\b\"CA\u0004\u0001\u0005\u0005I\u0011AA\u0005\u0011%\t\t\u0002AA\u0001\n\u0003\t\u0019\u0002C\u0005\u0002 \u0001\t\t\u0011\"\u0011\u0002\"!I\u0011q\u0006\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0007\u0005\n\u0003w\u0001\u0011\u0011!C!\u0003{A\u0011\"!\u0011\u0001\u0003\u0003%\t%a\u0011\b\u0013\u0005\u001d$$!A\t\u0002\u0005%d\u0001C\r\u001b\u0003\u0003E\t!a\u001b\t\r\u001d\u001bB\u0011AAB\u0011%\t)iEA\u0001\n\u000b\n9\tC\u0005\u0002\nN\t\t\u0011\"!\u0002\f\"I\u0011qR\n\u0002\u0002\u0013\u0005\u0015\u0011\u0013\u0005\n\u0003;\u001b\u0012\u0011!C\u0005\u0003?\u0013\u0011\u0002T;i]\u000eDWmY6\u000b\u0005ma\u0012aC3yaJ,7o]5p]NT!!\b\u0010\u0002\u0011\r\fG/\u00197zgRT!a\b\u0011\u0002\u0007M\fHN\u0003\u0002\"E\u0005)1\u000f]1sW*\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\u0015-_IB\u0004CA\u0015+\u001b\u0005Q\u0012BA\u0016\u001b\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003S5J!A\f\u000e\u0003%I+h\u000e^5nKJ+\u0007\u000f\\1dK\u0006\u0014G.\u001a\t\u0003SAJ!!\r\u000e\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002:\u0003:\u0011!h\u0010\b\u0003wyj\u0011\u0001\u0010\u0006\u0003{\u0019\na\u0001\u0010:p_Rt\u0014\"A\u001b\n\u0005\u0001#\u0014a\u00029bG.\fw-Z\u0005\u0003\u0005\u000e\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u0011\u001b\u0002\u000b%t\u0007/\u001e;\u0016\u0003!\na!\u001b8qkR\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002J\u0015B\u0011\u0011\u0006\u0001\u0005\u0006\t\u000e\u0001\r\u0001K\u0001\fe\u0016\u0004H.Y2f[\u0016tG/\u0001\u0006j]B,H\u000fV=qKN,\u0012A\u0014\t\u0004s=\u000b\u0016B\u0001)D\u0005\r\u0019V-\u001d\t\u0003%Vk\u0011a\u0015\u0006\u0003)z\tQ\u0001^=qKNL!AV*\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017A\u00039sKR$\u0018PT1nKV\t\u0011\f\u0005\u0002[=:\u00111\f\u0018\t\u0003wQJ!!\u0018\u001b\u0002\rA\u0013X\rZ3g\u0013\ty\u0006M\u0001\u0004TiJLgn\u001a\u0006\u0003;R\n\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0002GB\u0019\u0011h\u0014\u0015\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGC\u0001\u0015g\u0011\u00159\u0007\u00021\u0001i\u0003-qWm^\"iS2$'/\u001a8\u0011\u0007eJ\u0007&\u0003\u0002k\u0007\nQ\u0011J\u001c3fq\u0016$7+Z9\u0002\t\r|\u0007/\u001f\u000b\u0003\u00136Dq\u0001R\u0005\u0011\u0002\u0003\u0007\u0001&\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003AT#\u0001K9,\u0003I\u0004\"a\u001d=\u000e\u0003QT!!\u001e<\u0002\u0013Ut7\r[3dW\u0016$'BA<5\u0003)\tgN\\8uCRLwN\\\u0005\u0003sR\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\tA\u0010E\u0002~\u0003\u000bi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011\u0001\u00027b]\u001eT!!a\u0001\u0002\t)\fg/Y\u0005\u0003?z\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0003\u0011\u0007M\ni!C\u0002\u0002\u0010Q\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0006\u0002\u001cA\u00191'a\u0006\n\u0007\u0005eAGA\u0002B]fD\u0011\"!\b\u000e\u0003\u0003\u0005\r!a\u0003\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\u0003\u0005\u0004\u0002&\u0005-\u0012QC\u0007\u0003\u0003OQ1!!\u000b5\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003[\t9C\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u001a\u0003s\u00012aMA\u001b\u0013\r\t9\u0004\u000e\u0002\b\u0005>|G.Z1o\u0011%\tibDA\u0001\u0002\u0004\t)\"\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,Gc\u0001?\u0002@!I\u0011Q\u0004\t\u0002\u0002\u0003\u0007\u00111B\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005M\u0012Q\t\u0005\n\u0003;\t\u0012\u0011!a\u0001\u0003+A3\u0003AA%\u0003\u001f\n\t&!\u0016\u0002X\u0005m\u0013QLA1\u0003G\u00022!KA&\u0013\r\tiE\u0007\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\u0019&\u0001B\r\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK:ue\u0002J\u0003%\f\u0011DQ\u0016\u001c7n\u001d\u0011uQ\u0006$\b%\u0019\u0011tiJLgn\u001a\u0011pM\u0002\"\u0017nZ5ug\u0002J7\u000f\t<bY&$\u0007%Y2d_J$\u0017N\\4!i>\u0004C\u000f[3!\u0019VDg\u000eI1mO>\u0014\u0018\u000e\u001e5n])\u0001\u0003\u0005\t\u0011UQ&\u001c\be\u00195fG.\u001cX/\u001c\u0011gk:\u001cG/[8oA%\u001c\be^5eK2L\b%\u00199qY&,G\rI8oA\r\u0014X\rZ5uA\r\f'\u000f\u001a\u0011ok6\u0014WM]:!C:$\u0007eZ8wKJtW.\u001a8uA%$WM\u001c;jM&\u001c\u0017\r^5p]*\u0001\u0003\u0005\t\u0011ok6\u0014WM]:!i>\u0004C-[:uS:<W/[:iAY\fG.\u001b3!]Vl'-\u001a:tA\u0019\u0014x.\u001c\u0011nSN$\u0018\u0010]3eY\u0001JgnY8se\u0016\u001cG\u000f\t8v[\n,'o\u001d\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u00033\n\u0011q\n\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)Oa\n\u0014GM\u00199sa:dgJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O]J\u0014HM\u001c4sa:\u0014gM\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\"(/^3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d:\u0014(\u000f\u001a8geBt'\r\u001b(SmR\u0001\u0005\t\u0011!A\u0001\u0002c-\u00197tK*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002`\u0005)1GL\u001b/a\u0005)qM]8va\u0006\u0012\u0011QM\u0001\rgR\u0014\u0018N\\4`MVt7m]\u0001\n\u0019VDgn\u00195fG.\u0004\"!K\n\u0014\u000bM\ti'!\u001f\u0011\r\u0005=\u0014Q\u000f\u0015J\u001b\t\t\tHC\u0002\u0002tQ\nqA];oi&lW-\u0003\u0003\u0002x\u0005E$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocA!\u00111PAA\u001b\t\tiH\u0003\u0003\u0002\u0000\u0005\u0005\u0011AA5p\u0013\r\u0011\u0015Q\u0010\u000b\u0003\u0003S\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002y\u0006)\u0011\r\u001d9msR\u0019\u0011*!$\t\u000b\u00113\u0002\u0019\u0001\u0015\u0002\u000fUt\u0017\r\u001d9msR!\u00111SAM!\u0011\u0019\u0014Q\u0013\u0015\n\u0007\u0005]EG\u0001\u0004PaRLwN\u001c\u0005\t\u00037;\u0012\u0011!a\u0001\u0013\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005\u0005\u0006cA?\u0002$&\u0019\u0011Q\u0015@\u0003\r=\u0013'.Z2u\u0001")
public class Luhncheck
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
Serializable {
    private Expression replacement;
    private final Expression input;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;

    public static Option<Expression> unapply(Luhncheck x$0) {
        return Luhncheck$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Luhncheck, A> g) {
        return Luhncheck$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, Luhncheck> compose(Function1<A$, Expression> g) {
        return Luhncheck$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        Luhncheck luhncheck = this;
        synchronized (luhncheck) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression input() {
        return this.input;
    }

    private Expression replacement$lzycompute() {
        Luhncheck luhncheck = this;
        synchronized (luhncheck) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = new StaticInvoke(ExpressionImplUtils.class, (DataType)BooleanType$.MODULE$, "isLuhnNumber", (Seq<Expression>)new .colon.colon((Object)this.input(), (List)Nil$.MODULE$), this.inputTypes(), StaticInvoke$.MODULE$.apply$default$6(), StaticInvoke$.MODULE$.apply$default$7(), StaticInvoke$.MODULE$.apply$default$8(), StaticInvoke$.MODULE$.apply$default$9());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public String prettyName() {
        return "luhn_check";
    }

    @Override
    public Seq<Expression> children() {
        return new .colon.colon((Object)this.input(), (List)Nil$.MODULE$);
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0));
    }

    public Luhncheck copy(Expression input) {
        return new Luhncheck(input);
    }

    public Expression copy$default$1() {
        return this.input();
    }

    @Override
    public String productPrefix() {
        return "Luhncheck";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.input();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Luhncheck;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "input";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Luhncheck)) return false;
        boolean bl = true;
        if (!bl) return false;
        Luhncheck luhncheck = (Luhncheck)x$1;
        Expression expression = this.input();
        Expression expression2 = luhncheck.input();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!luhncheck.canEqual(this)) return false;
        return true;
    }

    public Luhncheck(Expression input) {
        this.input = input;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }
}

