/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NextDay$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(start_date, day_of_week) - Returns the first date which is later than `start_date` and named as indicated.\n      The function returns NULL if at least one of the input parameters is NULL.\n      When both of the input parameters are not NULL and day_of_week is an invalid input,\n      the function throws SparkIllegalArgumentException if `spark.sql.ansi.enabled` is set to true, otherwise NULL.\n      ", examples="\n    Examples:\n      > SELECT _FUNC_('2015-01-14', 'TU');\n       2015-01-20\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\t\rc\u0001\u0002\u0015*\u0001ZB\u0001B\u0016\u0001\u0003\u0016\u0004%\ta\u0016\u0005\t7\u0002\u0011\t\u0012)A\u00051\"AA\f\u0001BK\u0002\u0013\u0005q\u000b\u0003\u0005^\u0001\tE\t\u0015!\u0003Y\u0011!q\u0006A!f\u0001\n\u0003y\u0006\u0002C2\u0001\u0005#\u0005\u000b\u0011\u00021\t\u000b\u0011\u0004A\u0011A3\t\u000b)\u0004A\u0011I,\t\u000b-\u0004A\u0011I,\t\u000b\u0011\u0004A\u0011\u00017\t\u000b=\u0004A\u0011\t9\t\u000bi\u0004A\u0011I>\t\u000b}\u0004A\u0011I0\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!9\u00111\u0003\u0001\u0005\n\u0005U\u0001bBA\u0014\u0001\u0011%\u0011\u0011\u0006\u0005\b\u0003\u000f\u0002A\u0011KA%\u0011\u001d\t9\u0006\u0001C!\u0003+Aq!!\u0017\u0001\t#\nY\u0006C\u0005\u0002f\u0001\t\t\u0011\"\u0001\u0002h!I\u0011q\u000e\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u000f\u0005\n\u0003\u000f\u0003\u0011\u0013!C\u0001\u0003cB\u0011\"!#\u0001#\u0003%\t!a#\t\u0013\u0005=\u0005!!A\u0005B\u0005E\u0005\"CAQ\u0001\u0005\u0005I\u0011AAR\u0011%\tY\u000bAA\u0001\n\u0003\ti\u000bC\u0005\u00024\u0002\t\t\u0011\"\u0011\u00026\"I\u00111\u0019\u0001\u0002\u0002\u0013\u0005\u0011Q\u0019\u0005\n\u0003\u0013\u0004\u0011\u0011!C!\u0003\u0017D\u0011\"a4\u0001\u0003\u0003%\t%!5\b\u0013\u0005U\u0018&!A\t\u0002\u0005]h\u0001\u0003\u0015*\u0003\u0003E\t!!?\t\r\u0011\u0004C\u0011\u0001B\t\u0011%\u0011\u0019\u0002IA\u0001\n\u000b\u0012)\u0002C\u0005\u0003\u0018\u0001\n\t\u0011\"!\u0003\u001a!I!\u0011\u0005\u0011\u0012\u0002\u0013\u0005\u00111\u0012\u0005\n\u0005G\u0001\u0013\u0011!CA\u0005KA\u0011Ba\u000e!#\u0003%\t!a#\t\u0013\te\u0002%!A\u0005\n\tm\"a\u0002(fqR$\u0015-\u001f\u0006\u0003U-\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011A&L\u0001\tG\u0006$\u0018\r\\=ti*\u0011afL\u0001\u0004gFd'B\u0001\u00192\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00114'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002i\u0005\u0019qN]4\u0004\u0001M1\u0001aN\u001e?\u000b.\u0003\"\u0001O\u001d\u000e\u0003%J!AO\u0015\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001d=\u0013\ti\u0014F\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\ty$I\u0004\u00029\u0001&\u0011\u0011)K\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019EI\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005\u0005K\u0003C\u0001$J\u001b\u00059%\"\u0001%\u0002\u000bM\u001c\u0017\r\\1\n\u0005);%a\u0002)s_\u0012,8\r\u001e\t\u0003\u0019Ns!!\u0014*\u000f\u00059\u000bV\"A(\u000b\u0005A+\u0014A\u0002\u001fs_>$h(C\u0001I\u0013\t\tu)\u0003\u0002U+\na1+\u001a:jC2L'0\u00192mK*\u0011\u0011iR\u0001\ngR\f'\u000f\u001e#bi\u0016,\u0012\u0001\u0017\t\u0003qeK!AW\u0015\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0006ti\u0006\u0014H\u000fR1uK\u0002\n\u0011\u0002Z1z\u001f\u001a<V-Z6\u0002\u0015\u0011\f\u0017p\u00144XK\u0016\\\u0007%A\u0006gC&dwJ\\#se>\u0014X#\u00011\u0011\u0005\u0019\u000b\u0017B\u00012H\u0005\u001d\u0011un\u001c7fC:\fABZ1jY>sWI\u001d:pe\u0002\na\u0001P5oSRtD\u0003\u00024hQ&\u0004\"\u0001\u000f\u0001\t\u000bY;\u0001\u0019\u0001-\t\u000bq;\u0001\u0019\u0001-\t\u000fy;\u0001\u0013!a\u0001A\u0006!A.\u001a4u\u0003\u0015\u0011\u0018n\u001a5u)\r1WN\u001c\u0005\u0006U*\u0001\r\u0001\u0017\u0005\u0006W*\u0001\r\u0001W\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#A9\u0011\u00071\u0013H/\u0003\u0002t+\n\u00191+Z9\u0011\u0005UDX\"\u0001<\u000b\u0005]l\u0013!\u0002;za\u0016\u001c\u0018BA=w\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\u0005a\bCA;~\u0013\tqhO\u0001\u0005ECR\fG+\u001f9f\u0003!qW\u000f\u001c7bE2,\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGCBA\u0003\u0003\u0017\ty\u0001E\u0002G\u0003\u000fI1!!\u0003H\u0005\r\te.\u001f\u0005\b\u0003\u001bq\u0001\u0019AA\u0003\u0003\u0015\u0019H/\u0019:u\u0011\u001d\t\tB\u0004a\u0001\u0003\u000b\ta\u0001Z1z\u001f\u001a<\u0016!\u00053bi\u0016$\u0016.\\3Vi&d7\t\\1tgV\u0011\u0011q\u0003\t\u0005\u00033\t\tC\u0004\u0003\u0002\u001c\u0005u\u0001C\u0001(H\u0013\r\tybR\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0012Q\u0005\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005}q)\u0001\boKb$H)Y=HK:\u001cu\u000eZ3\u0015\u0015\u0005]\u00111FA\u001e\u0003\u007f\t\u0019\u0005C\u0004\u0002.A\u0001\r!a\f\u0002\u0005\u00154\b\u0003BA\u0019\u0003oi!!a\r\u000b\u0007\u0005U\u0012&A\u0004d_\u0012,w-\u001a8\n\t\u0005e\u00121\u0007\u0002\t\u000bb\u0004(oQ8eK\"9\u0011Q\b\tA\u0002\u0005]\u0011!\u00043bs>3w+Z3l)\u0016\u0014X\u000eC\u0004\u0002BA\u0001\r!a\u0006\u0002\u0005M$\u0007bBA#!\u0001\u0007\u0011qC\u0001\u0005I><8+A\u0005e_\u001e+gnQ8eKR1\u0011qFA&\u0003+Bq!!\u0014\u0012\u0001\u0004\ty%A\u0002dib\u0004B!!\r\u0002R%!\u00111KA\u001a\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!!\f\u0012\u0001\u0004\ty#\u0001\u0006qe\u0016$H/\u001f(b[\u0016\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000b\u0019\fi&!\u0019\t\r\u0005}3\u00031\u0001Y\u0003\u001dqWm\u001e'fMRDa!a\u0019\u0014\u0001\u0004A\u0016\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\bM\u0006%\u00141NA7\u0011\u001d1F\u0003%AA\u0002aCq\u0001\u0018\u000b\u0011\u0002\u0003\u0007\u0001\fC\u0004_)A\u0005\t\u0019\u00011\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u000f\u0016\u00041\u0006U4FAA<!\u0011\tI(a!\u000e\u0005\u0005m$\u0002BA?\u0003\u007f\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005u)\u0001\u0006b]:|G/\u0019;j_:LA!!\"\u0002|\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAAGU\r\u0001\u0017QO\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005M\u0005\u0003BAK\u0003?k!!a&\u000b\t\u0005e\u00151T\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u001e\u0006!!.\u0019<b\u0013\u0011\t\u0019#a&\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0015\u0006c\u0001$\u0002(&\u0019\u0011\u0011V$\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0015\u0011q\u0016\u0005\n\u0003cS\u0012\u0011!a\u0001\u0003K\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\\!\u0019\tI,a0\u0002\u00065\u0011\u00111\u0018\u0006\u0004\u0003{;\u0015AC2pY2,7\r^5p]&!\u0011\u0011YA^\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007\u0001\f9\rC\u0005\u00022r\t\t\u00111\u0001\u0002\u0006\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t\u0019*!4\t\u0013\u0005EV$!AA\u0002\u0005\u0015\u0016AB3rk\u0006d7\u000fF\u0002a\u0003'D\u0011\"!-\u001f\u0003\u0003\u0005\r!!\u0002)'\u0001\t9.!8\u0002`\u0006\r\u0018Q]Au\u0003W\fy/!=\u0011\u0007a\nI.C\u0002\u0002\\&\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002b\u0006\u0019yc\u0018$V\u001d\u000e{\u0006f\u001d;beR|F-\u0019;fY\u0001\"\u0017-_0pM~;X-Z6*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA\u0019L'o\u001d;!I\u0006$X\rI<iS\u000eD\u0007%[:!Y\u0006$XM\u001d\u0011uQ\u0006t\u0007\u0005Y:uCJ$x\fZ1uK\u0002\u0004\u0013M\u001c3!]\u0006lW\r\u001a\u0011bg\u0002Jg\u000eZ5dCR,GM\f\u0006!A\u0001\u0002\u0003\u0005\t+iK\u00022WO\\2uS>t\u0007E]3ukJt7\u000f\t(V\u00192\u0003\u0013N\u001a\u0011bi\u0002bW-Y:uA=tW\rI8gAQDW\rI5oaV$\b\u0005]1sC6,G/\u001a:tA%\u001c\bET+M\u0019:R\u0001\u0005\t\u0011!A\u0001:\u0006.\u001a8!E>$\b\u000eI8gAQDW\rI5oaV$\b\u0005]1sC6,G/\u001a:tA\u0005\u0014X\r\t8pi\u0002rU\u000b\u0014'!C:$\u0007\u0005Z1z?>4wl^3fW\u0002J7\u000fI1oA%tg/\u00197jI\u0002Jg\u000e];uY)\u0001\u0003\u0005\t\u0011!AQDW\r\t4v]\u000e$\u0018n\u001c8!i\"\u0014xn^:!'B\f'o[%mY\u0016<\u0017\r\\!sOVlWM\u001c;Fq\u000e,\u0007\u000f^5p]\u0002Jg\r\t1ta\u0006\u00148NL:rY:\ngn]5/K:\f'\r\\3eA\u0002J7\u000fI:fi\u0002\"x\u000e\t;sk\u0016d\u0003e\u001c;iKJ<\u0018n]3!\u001dVcEJ\f\u0006!A\u0001\u0002\u0003\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011q]\u0001O\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":#\u0007M\u00196[A\nT&\r\u001b(Y\u0001:C+V\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'M\u001b.aEj#\u0007\r\u0006!A\u0005)qM]8va\u0006\u0012\u0011Q^\u0001\u000fI\u0006$X\r^5nK~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\t\u00190A\u00032]Ur\u0003'A\u0004OKb$H)Y=\u0011\u0005a\u00023#\u0002\u0011\u0002|\n\u001d\u0001\u0003CA\u007f\u0005\u0007A\u0006\f\u00194\u000e\u0005\u0005}(b\u0001B\u0001\u000f\u00069!/\u001e8uS6,\u0017\u0002\u0002B\u0003\u0003\u007f\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\u0011IAa\u0004\u000e\u0005\t-!\u0002\u0002B\u0007\u00037\u000b!![8\n\u0007Q\u0013Y\u0001\u0006\u0002\u0002x\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0014\u0006)\u0011\r\u001d9msR9aMa\u0007\u0003\u001e\t}\u0001\"\u0002,$\u0001\u0004A\u0006\"\u0002/$\u0001\u0004A\u0006b\u00020$!\u0003\u0005\r\u0001Y\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u00059QO\\1qa2LH\u0003\u0002B\u0014\u0005g\u0001RA\u0012B\u0015\u0005[I1Aa\u000bH\u0005\u0019y\u0005\u000f^5p]B1aIa\fY1\u0002L1A!\rH\u0005\u0019!V\u000f\u001d7fg!A!QG\u0013\u0002\u0002\u0003\u0007a-A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\u001f!\u0011\t)Ja\u0010\n\t\t\u0005\u0013q\u0013\u0002\u0007\u001f\nTWm\u0019;")
public class NextDay
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression startDate;
    private final Expression dayOfWeek;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$3() {
        return NextDay$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Object>> unapply(NextDay x$0) {
        return NextDay$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$3() {
        return NextDay$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Object>, NextDay> tupled() {
        return NextDay$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, NextDay>>> curried() {
        return NextDay$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression startDate() {
        return this.startDate;
    }

    public Expression dayOfWeek() {
        return this.dayOfWeek;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Expression left() {
        return this.startDate();
    }

    @Override
    public Expression right() {
        return this.dayOfWeek();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)DateType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Object nullSafeEval(Object start, Object dayOfW) {
        Integer n;
        try {
            int dow = DateTimeUtils$.MODULE$.getDayOfWeekFromString((UTF8String)dayOfW);
            int sd = BoxesRunTime.unboxToInt((Object)start);
            n = BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getNextDateForDayOfWeek(sd, dow));
        }
        catch (SparkIllegalArgumentException e) {
            if (this.failOnError()) {
                throw e;
            }
            n = null;
        }
        return n;
    }

    private String dateTimeUtilClass() {
        return StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName()), "$");
    }

    private String nextDayGenCode(ExprCode ev, String dayOfWeekTerm, String sd, String dowS) {
        String failOnErrorBranch = this.failOnError() ? "throw e;" : ev.isNull() + " = true;";
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n     |try {\n     |  int " + dayOfWeekTerm + " = " + this.dateTimeUtilClass() + ".getDayOfWeekFromString(" + dowS + ");\n     |  " + ev.value() + " = " + this.dateTimeUtilClass() + ".getNextDateForDayOfWeek(" + sd + ", " + dayOfWeekTerm + ");\n     |} catch (org.apache.spark.SparkIllegalArgumentException e) {\n     |  " + failOnErrorBranch + "\n     |}\n     |"));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(sd, dowS) -> {
            String dayOfWeekTerm = ctx.freshName("dayOfWeek");
            if (this.dayOfWeek().foldable()) {
                Object object;
                UTF8String input = (UTF8String)this.dayOfWeek().eval(this.dayOfWeek().eval$default$1());
                if (input == null) {
                    return ev.isNull() + " = true;";
                }
                try {
                    int dayOfWeekValue = DateTimeUtils$.MODULE$.getDayOfWeekFromString(input);
                    object = ev.value() + " = " + this.dateTimeUtilClass() + ".getNextDateForDayOfWeek(" + sd + ", " + dayOfWeekValue + ");";
                }
                catch (SparkIllegalArgumentException sparkIllegalArgumentException) {
                    object = this.nextDayGenCode(ev, dayOfWeekTerm, (String)sd, (String)dowS);
                }
                return object;
            }
            return this.nextDayGenCode(ev, dayOfWeekTerm, (String)sd, (String)dowS);
        });
    }

    @Override
    public String prettyName() {
        return "next_day";
    }

    @Override
    public NextDay withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public NextDay copy(Expression startDate, Expression dayOfWeek, boolean failOnError) {
        return new NextDay(startDate, dayOfWeek, failOnError);
    }

    public Expression copy$default$1() {
        return this.startDate();
    }

    public Expression copy$default$2() {
        return this.dayOfWeek();
    }

    public boolean copy$default$3() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "NextDay";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.startDate();
            }
            case 1: {
                return this.dayOfWeek();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NextDay;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "startDate";
            }
            case 1: {
                return "dayOfWeek";
            }
            case 2: {
                return "failOnError";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NextDay)) return false;
        boolean bl = true;
        if (!bl) return false;
        NextDay nextDay = (NextDay)x$1;
        if (this.failOnError() != nextDay.failOnError()) return false;
        Expression expression = this.startDate();
        Expression expression2 = nextDay.startDate();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.dayOfWeek();
        Expression expression4 = nextDay.dayOfWeek();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!nextDay.canEqual(this)) return false;
        return true;
    }

    public NextDay(Expression startDate, Expression dayOfWeek, boolean failOnError) {
        this.startDate = startDate;
        this.dayOfWeek = dayOfWeek;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public NextDay(Expression left, Expression right) {
        this(left, right, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

