/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.ParseUrl$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(url, partToExtract[, key]) - Extracts a part from a URL.", examples="\n    Examples:\n      > SELECT _FUNC_('http://spark.apache.org/path?query=1', 'HOST');\n       spark.apache.org\n      > SELECT _FUNC_('http://spark.apache.org/path?query=1', 'QUERY');\n       query=1\n      > SELECT _FUNC_('http://spark.apache.org/path?query=1', 'QUERY', 'query');\n       1\n  ", since="2.0.0", group="url_funcs")
@ScalaSignature(bytes="\u0006\u0005\t]w!B\u001f?\u0011\u0003Ye!B'?\u0011\u0003q\u0005\"B/\u0002\t\u0003q\u0006bB0\u0002\u0005\u0004%I\u0001\u0019\u0005\u0007S\u0006\u0001\u000b\u0011B1\t\u000f)\f!\u0019!C\u0005A\"11.\u0001Q\u0001\n\u0005Dq\u0001\\\u0001C\u0002\u0013%\u0001\r\u0003\u0004n\u0003\u0001\u0006I!\u0019\u0005\b]\u0006\u0011\r\u0011\"\u0003a\u0011\u0019y\u0017\u0001)A\u0005C\"9\u0001/\u0001b\u0001\n\u0013\u0001\u0007BB9\u0002A\u0003%\u0011\rC\u0004s\u0003\t\u0007I\u0011\u00021\t\rM\f\u0001\u0015!\u0003b\u0011\u001d!\u0018A1A\u0005\n\u0001Da!^\u0001!\u0002\u0013\t\u0007b\u0002<\u0002\u0005\u0004%I\u0001\u0019\u0005\u0007o\u0006\u0001\u000b\u0011B1\t\u000fa\f!\u0019!C\u0005s\"9\u0011\u0011A\u0001!\u0002\u0013Q\b\u0002CA\u0002\u0003\t\u0007I\u0011B=\t\u000f\u0005\u0015\u0011\u0001)A\u0005u\"I\u0011qA\u0001\u0002\u0002\u0013\u0005\u0015\u0011\u0002\u0005\n\u0005k\u000b\u0011\u0013!C\u0001\u0005/B\u0011Ba.\u0002\u0003\u0003%\tI!/\t\u0013\t-\u0017!%A\u0005\u0002\t]\u0003\"\u0003Bg\u0003\u0005\u0005I\u0011\u0002Bh\r\u0015ie\bQA\u0007\u0011)\t\u0019\u0005\bBK\u0002\u0013\u0005\u0011Q\t\u0005\u000b\u0003\u001bb\"\u0011#Q\u0001\n\u0005\u001d\u0003BCA(9\tU\r\u0011\"\u0001\u0002R!Q\u0011\u0011\f\u000f\u0003\u0012\u0003\u0006I!a\u0015\t\rucB\u0011AA.\u0011\u0019iF\u0004\"\u0001\u0002b!9\u0011Q\r\u000f\u0005B\u0005E\u0003bBA49\u0011\u0005\u0013\u0011\u000e\u0005\b\u0003obB\u0011IA=\u0011\u001d\t\t\t\bC!\u0003\u0007C!\"a%\u001d\u0011\u000b\u0007I\u0011BAK\u0011)\tY\u000b\bEC\u0002\u0013%\u0011Q\u0016\u0005\u000b\u0003\u0003d\u0002R1A\u0005\n\u0005\r\u0007bBAg9\u0011\u0005\u0013q\u001a\u0005\b\u0003;dB\u0011BAp\u0011\u001d\t)\u000f\bC\u0005\u0003ODq!!<\u001d\t\u0013\ty\u000fC\u0004\u0002vr!I!a>\t\u000f\t\u0005A\u0004\"\u0003\u0003\u0004!9!\u0011\u0002\u000f\u0005\n\t-\u0001b\u0002B\t9\u0011\u0005#1\u0003\u0005\b\u0005OaB\u0011\u000bB\u0015\u0011%\u0011)\u0004HA\u0001\n\u0003\u00119\u0004C\u0005\u0003>q\t\n\u0011\"\u0001\u0003@!I!Q\u000b\u000f\u0012\u0002\u0013\u0005!q\u000b\u0005\t\u00057b\u0012\u0011!C!s\"I!Q\f\u000f\u0002\u0002\u0013\u0005!q\f\u0005\n\u0005Ob\u0012\u0011!C\u0001\u0005SB\u0011Ba\u001c\u001d\u0003\u0003%\tE!\u001d\t\u0013\t}D$!A\u0005\u0002\t\u0005\u0005\"\u0003BC9\u0005\u0005I\u0011\tBD\u0011%\u0011Y\tHA\u0001\n\u0003\u0012i)\u0001\u0005QCJ\u001cX-\u0016:m\u0015\ty\u0004)A\u0006fqB\u0014Xm]:j_:\u001c(BA!C\u0003!\u0019\u0017\r^1msN$(BA\"E\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u001a\u000bQa\u001d9be.T!a\u0012%\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0015aA8sO\u000e\u0001\u0001C\u0001'\u0002\u001b\u0005q$\u0001\u0003)beN,WK\u001d7\u0014\u0007\u0005yU\u000b\u0005\u0002Q'6\t\u0011KC\u0001S\u0003\u0015\u00198-\u00197b\u0013\t!\u0016K\u0001\u0004B]f\u0014VM\u001a\t\u0003-nk\u0011a\u0016\u0006\u00031f\u000b!![8\u000b\u0003i\u000bAA[1wC&\u0011Al\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-\u000bA\u0001S(T)V\t\u0011\r\u0005\u0002cO6\t1M\u0003\u0002eK\u0006)A/\u001f9fg*\u0011a\rR\u0001\u0007k:\u001c\u0018MZ3\n\u0005!\u001c'AC+U\rb\u001aFO]5oO\u0006)\u0001jT*UA\u0005!\u0001+\u0011+I\u0003\u0015\u0001\u0016\t\u0016%!\u0003\u0015\tV+\u0012*Z\u0003\u0019\tV+\u0012*ZA\u0005\u0019!+\u0012$\u0002\tI+e\tI\u0001\t!J{EkT\"P\u0019\u0006I\u0001KU(U\u001f\u000e{E\nI\u0001\u0005\r&cU)A\u0003G\u00132+\u0005%A\u0005B+RCuJU%U3\u0006Q\u0011)\u0016+I\u001fJKE+\u0017\u0011\u0002\u0011U\u001bVIU%O\r>\u000b\u0011\"V*F%&sei\u0014\u0011\u0002\u0017I+u)\u0012-Q%\u00163\u0015\nW\u000b\u0002uB\u00111P`\u0007\u0002y*\u0011Q0W\u0001\u0005Y\u0006tw-\u0003\u0002\u0000y\n11\u000b\u001e:j]\u001e\fABU#H\u000bb\u0003&+\u0012$J1\u0002\n1BU#H\u000bb\u001bVK\u0011$J1\u0006a!+R$F1N+&IR%YA\u0005)\u0011\r\u001d9msR1\u00111\u0002BY\u0005g\u0003\"\u0001\u0014\u000f\u0014\u0017q\ty!!\u0006\u0002\u001c\u0005\u001d\u0012Q\u0006\t\u0004\u0019\u0006E\u0011bAA\n}\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u00071\u000b9\"C\u0002\u0002\u001ay\u0012\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011}\u000591m\u001c3fO\u0016t\u0017\u0002BA\u0013\u0003?\u0011qbQ8eK\u001e,gNR1mY\n\f7m\u001b\t\u0004!\u0006%\u0012bAA\u0016#\n9\u0001K]8ek\u000e$\b\u0003BA\u0018\u0003\u007fqA!!\r\u0002<9!\u00111GA\u001d\u001b\t\t)DC\u0002\u00028)\u000ba\u0001\u0010:p_Rt\u0014\"\u0001*\n\u0007\u0005u\u0012+A\u0004qC\u000e\\\u0017mZ3\n\u0007q\u000b\tEC\u0002\u0002>E\u000b\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0003\u0003\u000f\u0002b!a\f\u0002J\u0005=\u0011\u0002BA&\u0003\u0003\u00121aU3r\u0003%\u0019\u0007.\u001b7ee\u0016t\u0007%A\u0006gC&dwJ\\#se>\u0014XCAA*!\r\u0001\u0016QK\u0005\u0004\u0003/\n&a\u0002\"p_2,\u0017M\\\u0001\rM\u0006LGn\u00148FeJ|'\u000f\t\u000b\u0007\u0003\u0017\ti&a\u0018\t\u000f\u0005\r\u0013\u00051\u0001\u0002H!I\u0011qJ\u0011\u0011\u0002\u0003\u0007\u00111\u000b\u000b\u0005\u0003\u0017\t\u0019\u0007C\u0004\u0002D\t\u0002\r!a\u0012\u0002\u00119,H\u000e\\1cY\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\t\tY\u0007\u0005\u0004\u00020\u0005%\u0013Q\u000e\t\u0005\u0003_\n\u0019(\u0004\u0002\u0002r)\u0011AMQ\u0005\u0005\u0003k\n\tH\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u0002|A!\u0011qNA?\u0013\u0011\ty(!\u001d\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\u0002\u001d:fiRLh*Y7f+\t\t)\t\u0005\u0003\u0002\b\u0006=e\u0002BAE\u0003\u0017\u00032!a\rR\u0013\r\ti)U\u0001\u0007!J,G-\u001a4\n\u0007}\f\tJC\u0002\u0002\u000eF\u000b\u0011bY1dQ\u0016$WK\u001d7\u0016\u0005\u0005]\u0005\u0003BAM\u0003?k!!a'\u000b\u0007\u0005u\u0015,A\u0002oKRLA!!)\u0002\u001c\n\u0019QKU%)\u0007\u001d\n)\u000bE\u0002Q\u0003OK1!!+R\u0005%!(/\u00198tS\u0016tG/A\u0007dC\u000eDW\r\u001a)biR,'O\\\u000b\u0003\u0003_\u0003B!!-\u0002<6\u0011\u00111\u0017\u0006\u0005\u0003k\u000b9,A\u0003sK\u001e,\u0007PC\u0002\u0002:f\u000bA!\u001e;jY&!\u0011QXAZ\u0005\u001d\u0001\u0016\r\u001e;fe:D3\u0001KAS\u0003U\u0019\u0017m\u00195fI\u0016CHO]1diB\u000b'\u000f\u001e$v]\u000e,\"!!2\u0011\u000fA\u000b9-a&\u0002\u0006&\u0019\u0011\u0011Z)\u0003\u0013\u0019+hn\u0019;j_:\f\u0004fA\u0015\u0002&\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\u0011\u0011\u0011\u001b\t\u0005\u0003'\fI.\u0004\u0002\u0002V*\u0019\u0011q\u001b!\u0002\u0011\u0005t\u0017\r\\=tSNLA!a7\u0002V\nyA+\u001f9f\u0007\",7m\u001b*fgVdG/\u0001\u0006hKR\u0004\u0016\r\u001e;fe:$B!a,\u0002b\"1\u00111]\u0016A\u0002\u0005\f1a[3z\u0003\u00199W\r^+sYR!\u0011qSAu\u0011\u0019\tY\u000f\fa\u0001C\u0006\u0019QO\u001d7\u0002%\u001d,G/\u0012=ue\u0006\u001cG\u000fU1si\u001a+hn\u0019\u000b\u0005\u0003\u000b\f\t\u0010\u0003\u0004\u0002t6\u0002\r!Y\u0001\u000ea\u0006\u0014H\u000fV8FqR\u0014\u0018m\u0019;\u0002+\u0015DHO]1diZ\u000bG.^3Ge>l\u0017+^3ssR)\u0011-!?\u0002~\"1\u00111 \u0018A\u0002\u0005\fQ!];fefDq!a@/\u0001\u0004\ty+A\u0004qCR$XM\u001d8\u0002\u001d\u0015DHO]1di\u001a\u0013x.\\+sYR)\u0011M!\u0002\u0003\b!9\u00111^\u0018A\u0002\u0005]\u0005BBAz_\u0001\u0007\u0011-\u0001\nqCJ\u001cX-\u0016:m/&$\bn\\;u\u0017\u0016LH#B1\u0003\u000e\t=\u0001BBAva\u0001\u0007\u0011\r\u0003\u0004\u0002tB\u0002\r!Y\u0001\u0005KZ\fG\u000e\u0006\u0003\u0003\u0016\tm\u0001c\u0001)\u0003\u0018%\u0019!\u0011D)\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003\u001eE\u0002\n\u00111\u0001\u0003 \u0005)\u0011N\u001c9viB!!\u0011\u0005B\u0012\u001b\u0005\u0001\u0015b\u0001B\u0013\u0001\nY\u0011J\u001c;fe:\fGNU8x\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000e\u0006\u0003\u0002\f\t-\u0002b\u0002B\u0017e\u0001\u0007!qF\u0001\f]\u0016<8\t[5mIJ,g\u000e\u0005\u0004\u00020\tE\u0012qB\u0005\u0005\u0005g\t\tE\u0001\u0006J]\u0012,\u00070\u001a3TKF\fAaY8qsR1\u00111\u0002B\u001d\u0005wA\u0011\"a\u00114!\u0003\u0005\r!a\u0012\t\u0013\u0005=3\u0007%AA\u0002\u0005M\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005\u0003RC!a\u0012\u0003D-\u0012!Q\t\t\u0005\u0005\u000f\u0012\t&\u0004\u0002\u0003J)!!1\nB'\u0003%)hn\u00195fG.,GMC\u0002\u0003PE\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019F!\u0013\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\te#\u0006BA*\u0005\u0007\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\u0018\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B1!\r\u0001&1M\u0005\u0004\u0005K\n&aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\u000b\u0005WB\u0011B!\u001c9\u0003\u0003\u0005\rA!\u0019\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011\u0019\b\u0005\u0004\u0003v\tm$QC\u0007\u0003\u0005oR1A!\u001fR\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005{\u00129H\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA*\u0005\u0007C\u0011B!\u001c;\u0003\u0003\u0005\rA!\u0006\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0004u\n%\u0005\"\u0003B7w\u0005\u0005\t\u0019\u0001B1\u0003\u0019)\u0017/^1mgR!\u00111\u000bBH\u0011%\u0011i\u0007PA\u0001\u0002\u0004\u0011)\u0002K\n\u001d\u0005'\u0013IJa'\u0003 \n\u0005&Q\u0015BT\u0005W\u0013i\u000bE\u0002M\u0005+K1Aa&?\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#A!(\u0002\u007f}3UKT\"`QU\u0014H\u000e\f\u0011qCJ$Hk\\#yiJ\f7\r^.-A-,\u00170X\u0015![\u0001*\u0005\u0010\u001e:bGR\u001c\b%\u0019\u0011qCJ$\bE\u001a:p[\u0002\n\u0007%\u0016*M]\u0005AQ\r_1na2,7/\t\u0002\u0003$\u0006\u0011\u0019E\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(QR$\bOO\u00180gB\f'o\u001b\u0018ba\u0006\u001c\u0007.\u001a\u0018pe\u001e|\u0003/\u0019;i\u007fE,XM]=>c\u001db\u0003e\n%P'R;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ta\u0006\u00148NL1qC\u000eDWML8sO*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005\u001b;uajzsf\u001d9be.t\u0013\r]1dQ\u0016tsN]40a\u0006$\bnP9vKJLX(M\u0014-A\u001d\nV+\u0012*ZO%Z$\u0002\t\u0011!A\u0001\u0002\u0003%];fefl\u0014G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(QR$\bOO\u00180gB\f'o\u001b\u0018ba\u0006\u001c\u0007.\u001a\u0018pe\u001e|\u0003/\u0019;i\u007fE,XM]=>c\u001db\u0003eJ)V\u000bJKv\u0005\f\u0011(cV,'/_\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\n$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\t%\u0016!\u0002\u001a/a9\u0002\u0014!B4s_V\u0004\u0018E\u0001BX\u0003%)(\u000f\\0gk:\u001c7\u000fC\u0004\u0002D]\u0001\r!a\u0012\t\u0013\u0005=s\u0003%AA\u0002\u0005M\u0013aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u000fUt\u0017\r\u001d9msR!!1\u0018Bd!\u0015\u0001&Q\u0018Ba\u0013\r\u0011y,\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000fA\u0013\u0019-a\u0012\u0002T%\u0019!QY)\u0003\rQ+\b\u000f\\33\u0011%\u0011I-GA\u0001\u0002\u0004\tY!A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001Bi!\rY(1[\u0005\u0004\u0005+d(AB(cU\u0016\u001cG\u000f")
public class ParseUrl
extends Expression
implements ExpectsInputTypes,
CodegenFallback,
Serializable {
    private transient URI cachedUrl;
    private transient Pattern cachedPattern;
    private transient Function1<URI, String> cachedExtractPartFunc;
    private final Seq<Expression> children;
    private final boolean failOnError;
    private volatile transient byte bitmap$trans$0;

    public static boolean $lessinit$greater$default$2() {
        return ParseUrl$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(ParseUrl x$0) {
        return ParseUrl$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$2() {
        return ParseUrl$.MODULE$.apply$default$2();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().fill(this.children().size(), (Function0 & Serializable)() -> StringTypeAnyCollation$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return SQLConf$.MODULE$.get().defaultStringType();
    }

    @Override
    public String prettyName() {
        return "parse_url";
    }

    private URI cachedUrl$lzycompute() {
        ParseUrl parseUrl = this;
        synchronized (parseUrl) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                UTF8String uTF8String;
                Literal literal;
                Object url;
                Expression expression = (Expression)this.children().apply(0);
                this.cachedUrl = expression instanceof Literal && (url = (literal = (Literal)expression).value()) instanceof UTF8String && (uTF8String = (UTF8String)url) != null ? this.getUrl(uTF8String) : null;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.cachedUrl;
    }

    private URI cachedUrl() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.cachedUrl$lzycompute();
        }
        return this.cachedUrl;
    }

    private Pattern cachedPattern$lzycompute() {
        ParseUrl parseUrl = this;
        synchronized (parseUrl) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                UTF8String uTF8String;
                Literal literal;
                Object key;
                Expression expression = (Expression)this.children().apply(2);
                this.cachedPattern = expression instanceof Literal && (key = (literal = (Literal)expression).value()) instanceof UTF8String && (uTF8String = (UTF8String)key) != null ? this.getPattern(uTF8String) : null;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.cachedPattern;
    }

    private Pattern cachedPattern() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.cachedPattern$lzycompute();
        }
        return this.cachedPattern;
    }

    private Function1<URI, String> cachedExtractPartFunc$lzycompute() {
        ParseUrl parseUrl = this;
        synchronized (parseUrl) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                Function1<URI, String> function1;
                Literal literal;
                Object part;
                Expression expression = (Expression)this.children().apply(1);
                if (expression instanceof Literal && (part = (literal = (Literal)expression).value()) instanceof UTF8String) {
                    UTF8String uTF8String = (UTF8String)part;
                    function1 = this.getExtractPartFunc(uTF8String);
                } else {
                    function1 = null;
                }
                this.cachedExtractPartFunc = function1;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.cachedExtractPartFunc;
    }

    private Function1<URI, String> cachedExtractPartFunc() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.cachedExtractPartFunc$lzycompute();
        }
        return this.cachedExtractPartFunc;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (this.children().size() > 3 || this.children().size() < 2) {
            throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(Cast$.MODULE$.toSQLId(this.prettyName()), (Seq<Object>)new .colon.colon((Object)"[2, 3]", (List)Nil$.MODULE$), this.children().length(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
        }
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private Pattern getPattern(UTF8String key) {
        return Pattern.compile(ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$REGEXPREFIX() + key.toString() + ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$REGEXSUBFIX());
    }

    private URI getUrl(UTF8String url) {
        URI uRI;
        try {
            uRI = new URI(url.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            if (this.failOnError()) {
                throw QueryExecutionErrors$.MODULE$.invalidUrlError(url, uRISyntaxException);
            }
            uRI = null;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return uRI;
    }

    private Function1<URI, String> getExtractPartFunc(UTF8String partToExtract) {
        UTF8String uTF8String = partToExtract;
        UTF8String uTF8String2 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$HOST();
        UTF8String uTF8String3 = uTF8String;
        if (!(uTF8String2 != null ? !uTF8String2.equals(uTF8String3) : uTF8String3 != null)) {
            return (Function1 & Serializable)x$1 -> x$1.getHost();
        }
        UTF8String uTF8String4 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$PATH();
        UTF8String uTF8String5 = uTF8String;
        if (!(uTF8String4 != null ? !uTF8String4.equals(uTF8String5) : uTF8String5 != null)) {
            return (Function1 & Serializable)x$2 -> x$2.getRawPath();
        }
        UTF8String uTF8String6 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$QUERY();
        UTF8String uTF8String7 = uTF8String;
        if (!(uTF8String6 != null ? !uTF8String6.equals(uTF8String7) : uTF8String7 != null)) {
            return (Function1 & Serializable)x$3 -> x$3.getRawQuery();
        }
        UTF8String uTF8String8 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$REF();
        UTF8String uTF8String9 = uTF8String;
        if (!(uTF8String8 != null ? !uTF8String8.equals(uTF8String9) : uTF8String9 != null)) {
            return (Function1 & Serializable)x$4 -> x$4.getRawFragment();
        }
        UTF8String uTF8String10 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$PROTOCOL();
        UTF8String uTF8String11 = uTF8String;
        if (!(uTF8String10 != null ? !uTF8String10.equals(uTF8String11) : uTF8String11 != null)) {
            return (Function1 & Serializable)x$5 -> x$5.getScheme();
        }
        UTF8String uTF8String12 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$FILE();
        UTF8String uTF8String13 = uTF8String;
        if (!(uTF8String12 != null ? !uTF8String12.equals(uTF8String13) : uTF8String13 != null)) {
            return (Function1 & Serializable)url -> {
                if (url.getRawQuery() != null) {
                    return url.getRawPath() + "?" + url.getRawQuery();
                }
                return url.getRawPath();
            };
        }
        UTF8String uTF8String14 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$AUTHORITY();
        UTF8String uTF8String15 = uTF8String;
        if (!(uTF8String14 != null ? !uTF8String14.equals(uTF8String15) : uTF8String15 != null)) {
            return (Function1 & Serializable)x$6 -> x$6.getRawAuthority();
        }
        UTF8String uTF8String16 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$USERINFO();
        UTF8String uTF8String17 = uTF8String;
        if (!(uTF8String16 != null ? !uTF8String16.equals(uTF8String17) : uTF8String17 != null)) {
            return (Function1 & Serializable)x$7 -> x$7.getRawUserInfo();
        }
        return (Function1 & Serializable)url -> null;
    }

    private UTF8String extractValueFromQuery(UTF8String query, Pattern pattern) {
        Matcher m = pattern.matcher(query.toString());
        if (m.find()) {
            return UTF8String.fromString((String)m.group(2));
        }
        return null;
    }

    private UTF8String extractFromUrl(URI url, UTF8String partToExtract) {
        if (this.cachedExtractPartFunc() != null) {
            return UTF8String.fromString((String)((String)this.cachedExtractPartFunc().apply((Object)url)));
        }
        return UTF8String.fromString((String)((String)this.getExtractPartFunc(partToExtract).apply((Object)url)));
    }

    private UTF8String parseUrlWithoutKey(UTF8String url, UTF8String partToExtract) {
        if (this.cachedUrl() != null) {
            return this.extractFromUrl(this.cachedUrl(), partToExtract);
        }
        URI currentUrl = this.getUrl(url);
        if (currentUrl != null) {
            return this.extractFromUrl(currentUrl, partToExtract);
        }
        return null;
    }

    @Override
    public Object eval(InternalRow input) {
        Seq evaluated = (Seq)this.children().map((Function1 & Serializable)e -> (UTF8String)e.eval(input));
        if (evaluated.contains(null)) {
            return null;
        }
        if (evaluated.size() == 2) {
            return this.parseUrlWithoutKey((UTF8String)evaluated.apply(0), (UTF8String)evaluated.apply(1));
        }
        Predef$.MODULE$.assert(evaluated.size() == 3);
        Object object = evaluated.apply(1);
        UTF8String uTF8String = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$QUERY();
        if (object == null ? uTF8String != null : !object.equals(uTF8String)) {
            return null;
        }
        UTF8String query = this.parseUrlWithoutKey((UTF8String)evaluated.apply(0), (UTF8String)evaluated.apply(1));
        if (query == null) {
            return null;
        }
        if (this.cachedPattern() != null) {
            return this.extractValueFromQuery(query, this.cachedPattern());
        }
        return this.extractValueFromQuery(query, this.getPattern((UTF8String)evaluated.apply(2)));
    }

    @Override
    public ParseUrl withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren, this.copy$default$2());
    }

    public ParseUrl copy(Seq<Expression> children2, boolean failOnError) {
        return new ParseUrl(children2, failOnError);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "ParseUrl";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.children();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseUrl;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "children";
            }
            case 1: {
                return "failOnError";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseUrl)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseUrl parseUrl = (ParseUrl)x$1;
        if (this.failOnError() != parseUrl.failOnError()) return false;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = parseUrl.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!parseUrl.canEqual(this)) return false;
        return true;
    }

    public ParseUrl(Seq<Expression> children2, boolean failOnError) {
        this.children = children2;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
        CodegenFallback.$init$(this);
    }

    public ParseUrl(Seq<Expression> children2) {
        this(children2, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

