/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.RDG;
import org.apache.spark.sql.catalyst.expressions.Rand$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_([seed]) - Returns a random value with independent and identically distributed (i.i.d.) uniformly distributed values in [0, 1).", examples="\n    Examples:\n      > SELECT _FUNC_();\n       0.9629742951434543\n      > SELECT _FUNC_(0);\n       0.7604953758285915\n      > SELECT _FUNC_(null);\n       0.7604953758285915\n  ", note="\n    The function is non-deterministic in general case.\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005]h\u0001B\u0011#\u0001>B\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\u0011\"AA\n\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005R\u0001\tE\t\u0015!\u0003O\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015\u0011\u0006\u0001\"\u0001X\u0011\u0015\u0011\u0006\u0001\"\u0001Y\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u0015\t\u0007\u0001\"\u0015c\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u0015Y\b\u0001\"\u0011}\u0011\u00199\u0003\u0001\"\u0011\u0002\b!9\u0011\u0011\u0004\u0001\u0005R\u0005m\u0001\"CA\u0011\u0001\u0005\u0005I\u0011AA\u0012\u0011%\tI\u0003AI\u0001\n\u0003\tY\u0003C\u0005\u0002B\u0001\t\n\u0011\"\u0001\u0002D!I\u0011q\t\u0001\u0002\u0002\u0013\u0005\u0013\u0011\n\u0005\n\u00033\u0002\u0011\u0011!C\u0001\u00037B\u0011\"a\u0019\u0001\u0003\u0003%\t!!\u001a\t\u0013\u0005-\u0004!!A\u0005B\u00055\u0004\"CA=\u0001\u0005\u0005I\u0011AA>\u0011%\ty\bAA\u0001\n\u0003\n\t\tC\u0005\u0002\u0006\u0002\t\t\u0011\"\u0011\u0002\b\u001e9\u0011\u0011\u0017\u0012\t\u0002\u0005MfAB\u0011#\u0011\u0003\t)\f\u0003\u0004S3\u0011\u0005\u0011q\u0019\u0005\b\u0003\u0013LB\u0011AAf\u0011%\tI-GA\u0001\n\u0003\u000by\rC\u0005\u0002Vf\t\n\u0011\"\u0001\u0002D!I\u0011q[\r\u0002\u0002\u0013\u0005\u0015\u0011\u001c\u0005\n\u0003WL\u0012\u0013!C\u0001\u0003\u0007B\u0011\"!<\u001a\u0003\u0003%I!a<\u0003\tI\u000bg\u000e\u001a\u0006\u0003G\u0011\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011QEJ\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0005K\u0001\u0004gFd'BA\u0015+\u0003\u0015\u0019\b/\u0019:l\u0015\tYC&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002[\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\r\u001b;!\t\t$'D\u0001#\u0013\t\u0019$EA\u0002S\t\u001e\u0003\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002<\u0007:\u0011A(\u0011\b\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007f9\na\u0001\u0010:p_Rt\u0014\"A\u001c\n\u0005\t3\u0014a\u00029bG.\fw-Z\u0005\u0003\t\u0016\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!A\u0011\u001c\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003!\u0003\"!M%\n\u0005)\u0013#AC#yaJ,7o]5p]\u000611\r[5mI\u0002\n\u0001\u0002[5eKN+W\rZ\u000b\u0002\u001dB\u0011QgT\u0005\u0003!Z\u0012qAQ8pY\u0016\fg.A\u0005iS\u0012,7+Z3eA\u00051A(\u001b8jiz\"2\u0001V+W!\t\t\u0004\u0001C\u0003G\u000b\u0001\u0007\u0001\nC\u0004M\u000bA\u0005\t\u0019\u0001(\u0015\u0003Q#\"\u0001V-\t\u000b\u0019;\u0001\u0019\u0001%\u0002\u0017]LG\u000f\u001b(foN+W\r\u001a\u000b\u0003)rCQ!\u0018\u0005A\u0002y\u000bAa]3fIB\u0011QgX\u0005\u0003AZ\u0012A\u0001T8oO\u0006aQM^1m\u0013:$XM\u001d8bYR\u00111M\u001a\t\u0003k\u0011L!!\u001a\u001c\u0003\r\u0011{WO\u00197f\u0011\u00159\u0017\u00021\u0001i\u0003\u0015Ig\u000e];u!\tI'.D\u0001%\u0013\tYGEA\u0006J]R,'O\\1m%><\u0018!\u00033p\u000f\u0016t7i\u001c3f)\rqG/\u001f\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003c\n\nqaY8eK\u001e,g.\u0003\u0002ta\nAQ\t\u001f9s\u0007>$W\rC\u0003v\u0015\u0001\u0007a/A\u0002dib\u0004\"a\\<\n\u0005a\u0004(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006u*\u0001\rA\\\u0001\u0003KZ\fQB\u001a7bi\u0006\u0013x-^7f]R\u001cX#A?\u0011\tmr\u0018\u0011A\u0005\u0003\u007f\u0016\u0013\u0001\"\u0013;fe\u0006$xN\u001d\t\u0004k\u0005\r\u0011bAA\u0003m\t\u0019\u0011I\\=\u0016\u0005\u0005%\u0001\u0003BA\u0006\u0003'qA!!\u0004\u0002\u0010A\u0011QHN\u0005\u0004\u0003#1\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0016\u0005]!AB*ue&twMC\u0002\u0002\u0012Y\nAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dGc\u0001+\u0002\u001e!1\u0011qD\u0007A\u0002!\u000b\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0005G>\u0004\u0018\u0010F\u0003U\u0003K\t9\u0003C\u0004G\u001dA\u0005\t\u0019\u0001%\t\u000f1s\u0001\u0013!a\u0001\u001d\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0017U\rA\u0015qF\u0016\u0003\u0003c\u0001B!a\r\u0002>5\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$A\u0005v]\u000eDWmY6fI*\u0019\u00111\b\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002@\u0005U\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA#U\rq\u0015qF\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005-\u0003\u0003BA'\u0003/j!!a\u0014\u000b\t\u0005E\u00131K\u0001\u0005Y\u0006twM\u0003\u0002\u0002V\u0005!!.\u0019<b\u0013\u0011\t)\"a\u0014\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005u\u0003cA\u001b\u0002`%\u0019\u0011\u0011\r\u001c\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0005\u0011q\r\u0005\n\u0003S\u001a\u0012\u0011!a\u0001\u0003;\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA8!\u0019\t\t(a\u001e\u0002\u00025\u0011\u00111\u000f\u0006\u0004\u0003k2\u0014AC2pY2,7\r^5p]&\u0019q0a\u001d\u0002\u0011\r\fg.R9vC2$2ATA?\u0011%\tI'FA\u0001\u0002\u0004\t\t!\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA&\u0003\u0007C\u0011\"!\u001b\u0017\u0003\u0003\u0005\r!!\u0018\u0002\r\u0015\fX/\u00197t)\rq\u0015\u0011\u0012\u0005\n\u0003S:\u0012\u0011!a\u0001\u0003\u0003As\u0003AAG\u0003'\u000b)*!'\u0002\u001c\u0006}\u0015\u0011UAS\u0003O\u000bY+!,\u0011\u0007E\ny)C\u0002\u0002\u0012\n\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u0018\u0006\tYa\u0018$V\u001d\u000e{\u0006fW:fK\u0012l\u0016\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u0004#/\u00198e_6\u0004c/\u00197vK\u0002:\u0018\u000e\u001e5!S:$W\r]3oI\u0016tG\u000fI1oI\u0002JG-\u001a8uS\u000e\fG\u000e\\=!I&\u001cHO]5ckR,G\r\t\u0015j]%tCML\u0015!k:Lgm\u001c:nYf\u0004C-[:ue&\u0014W\u000f^3eAY\fG.^3tA%t\u0007e\u0017\u0019-AEJc&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ti*AA0\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"J3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0019/sY\u0012\u0014h\u000e\u001b3sU\nDg\r\u001b6iMR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AArsG\u000e\u00195sU\u001at'\u000e\u001d3qUJ\u0014'\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)]VdG.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a9:d\u0007\r\u001b:kM:T\u0007\u000f\u001a9ke\nTG\u0003\u0011!\u0003\u0011qw\u000e^3\"\u0005\u0005\r\u0016A\u000f\u0006!A\u0001\u0002C\u000b[3!MVt7\r^5p]\u0002J7\u000f\t8p]6\"W\r^3s[&t\u0017n\u001d;jG\u0002Jg\u000eI4f]\u0016\u0014\u0018\r\u001c\u0011dCN,gF\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\tI+A\u00032]Ur\u0003'A\u0003he>,\b/\t\u0002\u00020\u0006QQ.\u0019;i?\u001a,hnY:\u0002\tI\u000bg\u000e\u001a\t\u0003ce\u0019R!GA\\\u0003{\u00032!NA]\u0013\r\tYL\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005}\u0016QY\u0007\u0003\u0003\u0003TA!a1\u0002T\u0005\u0011\u0011n\\\u0005\u0004\t\u0006\u0005GCAAZ\u0003\u0015\t\u0007\u000f\u001d7z)\r!\u0016Q\u001a\u0005\u0006;n\u0001\rA\u0018\u000b\u0006)\u0006E\u00171\u001b\u0005\u0006\rr\u0001\r\u0001\u0013\u0005\b\u0019r\u0001\n\u00111\u0001O\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u00037\f9\u000fE\u00036\u0003;\f\t/C\u0002\u0002`Z\u0012aa\u00149uS>t\u0007#B\u001b\u0002d\"s\u0015bAAsm\t1A+\u001e9mKJB\u0001\"!;\u001f\u0003\u0003\u0005\r\u0001V\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002rB!\u0011QJAz\u0013\u0011\t)0a\u0014\u0003\r=\u0013'.Z2u\u0001")
public class Rand
extends RDG
implements Serializable {
    private final Expression child;
    private final boolean hideSeed;

    public static boolean $lessinit$greater$default$2() {
        return Rand$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(Rand x$0) {
        return Rand$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$2() {
        return Rand$.MODULE$.apply$default$2();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean hideSeed() {
        return this.hideSeed;
    }

    @Override
    public Rand withNewSeed(long seed) {
        return new Rand(new Literal(BoxesRunTime.boxToLong((long)seed), (DataType)LongType$.MODULE$), this.hideSeed());
    }

    public double evalInternal(InternalRow input) {
        return this.rng().nextDouble();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String className = XORShiftRandom.class.getName();
        String rngTerm = ctx.addMutableState(className, "rng", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        ctx.addPartitionInitializationStatement(rngTerm + " = new " + className + "(" + this.seed() + "L + partitionIndex);");
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", ".nextDouble();"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), rngTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public String sql() {
        return "rand(" + (this.hideSeed() ? "" : this.child().sql()) + ")";
    }

    @Override
    public Rand withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Rand copy(Expression child, boolean hideSeed) {
        return new Rand(child, hideSeed);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.hideSeed();
    }

    @Override
    public String productPrefix() {
        return "Rand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.hideSeed());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Rand;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "hideSeed";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Rand)) return false;
        boolean bl = true;
        if (!bl) return false;
        Rand rand = (Rand)x$1;
        if (this.hideSeed() != rand.hideSeed()) return false;
        Expression expression = this.child();
        Expression expression2 = rand.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!rand.canEqual(this)) return false;
        return true;
    }

    public Rand(Expression child, boolean hideSeed) {
        this.child = child;
        this.hideSeed = hideSeed;
    }

    public Rand() {
        this(UnresolvedSeed$.MODULE$, true);
    }

    public Rand(Expression child) {
        this(child, false);
    }
}

