/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.SecondsToTimestamp$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(seconds) - Creates timestamp from the number of seconds (can be fractional) since UTC epoch.", examples="\n    Examples:\n      > SELECT _FUNC_(1230219000);\n       2008-12-25 07:30:00\n      > SELECT _FUNC_(1230219000.123);\n       2008-12-25 07:30:00.123\n  ", group="datetime_funcs", since="3.1.0")
@ScalaSignature(bytes="\u0006\u0005\u0005Eh\u0001\u0002\u000f\u001e\u0001*B\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0019\")\u0001\u000b\u0001C\u0001#\")A\u000b\u0001C!+\")q\f\u0001C!A\")A\r\u0001C!K\"A\u0011\u000e\u0001EC\u0002\u0013%!\u000eC\u0003v\u0001\u0011\u0005c\u000fC\u0003z\u0001\u0011\u0005#\u0010C\u0004\u0002\u0012\u0001!\t%a\u0005\t\u000f\u0005\u0015\u0002\u0001\"\u0015\u0002(!I\u0011Q\u0006\u0001\u0002\u0002\u0013\u0005\u0011q\u0006\u0005\n\u0003g\u0001\u0011\u0013!C\u0001\u0003kA\u0011\"a\u0013\u0001\u0003\u0003%\t%!\u0014\t\u0013\u0005u\u0003!!A\u0005\u0002\u0005}\u0003\"CA4\u0001\u0005\u0005I\u0011AA5\u0011%\ty\u0007AA\u0001\n\u0003\n\t\bC\u0005\u0002\u0000\u0001\t\t\u0011\"\u0001\u0002\u0002\"I\u0011Q\u0011\u0001\u0002\u0002\u0013\u0005\u0013q\u0011\u0005\n\u0003\u0017\u0003\u0011\u0011!C!\u0003\u001b;\u0011\"!-\u001e\u0003\u0003E\t!a-\u0007\u0011qi\u0012\u0011!E\u0001\u0003kCa\u0001\u0015\f\u0005\u0002\u00055\u0007\"CAh-\u0005\u0005IQIAi\u0011%\t\u0019NFA\u0001\n\u0003\u000b)\u000eC\u0005\u0002ZZ\t\t\u0011\"!\u0002\\\"I\u0011q\u001d\f\u0002\u0002\u0013%\u0011\u0011\u001e\u0002\u0013'\u0016\u001cwN\u001c3t)>$\u0016.\\3ti\u0006l\u0007O\u0003\u0002\u001f?\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0001\u0013%\u0001\u0005dCR\fG._:u\u0015\t\u00113%A\u0002tc2T!\u0001J\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\u0002\u0001'\u0019\u00011f\f\u001a:\u007fA\u0011A&L\u0007\u0002;%\u0011a&\b\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011A\u0006M\u0005\u0003cu\u0011\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\t\u0019dG\u0004\u0002-i%\u0011Q'H\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0004H\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005Uj\u0002C\u0001\u001e>\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ$a\u0002)s_\u0012,8\r\u001e\t\u0003\u0001\u001es!!\u0011$\u000f\u0005\t+U\"A\"\u000b\u0005\u0011K\u0013A\u0002\u001fs_>$h(C\u0001=\u0013\t)4(\u0003\u0002I\u0013\na1+\u001a:jC2L'0\u00192mK*\u0011QgO\u0001\u0006G\"LG\u000eZ\u000b\u0002\u0019B\u0011A&T\u0005\u0003\u001dv\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u00051A(\u001b8jiz\"\"AU*\u0011\u00051\u0002\u0001\"\u0002&\u0004\u0001\u0004a\u0015AC5oaV$H+\u001f9fgV\ta\u000bE\u0002A/fK!\u0001W%\u0003\u0007M+\u0017\u000f\u0005\u0002[;6\t1L\u0003\u0002]C\u0005)A/\u001f9fg&\u0011al\u0017\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002CB\u0011!LY\u0005\u0003Gn\u0013\u0001\u0002R1uCRK\b/Z\u0001\t]VdG.\u00192mKV\ta\r\u0005\u0002;O&\u0011\u0001n\u000f\u0002\b\u0005>|G.Z1o\u0003!)g/\u00197Gk:\u001cW#A6\u0011\tibgN\\\u0005\u0003[n\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0005iz\u0017B\u00019<\u0005\r\te.\u001f\u0015\u0003\u000fI\u0004\"AO:\n\u0005Q\\$!\u0003;sC:\u001c\u0018.\u001a8u\u00031qW\u000f\u001c7TC\u001a,WI^1m)\tqw\u000fC\u0003y\u0011\u0001\u0007a.A\u0003j]B,H/A\u0005e_\u001e+gnQ8eKR)10a\u0001\u0002\u000eA\u0011Ap`\u0007\u0002{*\u0011a0H\u0001\bG>$WmZ3o\u0013\r\t\t! \u0002\t\u000bb\u0004(oQ8eK\"9\u0011QA\u0005A\u0002\u0005\u001d\u0011aA2uqB\u0019A0!\u0003\n\u0007\u0005-QP\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\r\u0005=\u0011\u00021\u0001|\u0003\t)g/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\u0006\u0011\t\u0005]\u0011q\u0004\b\u0005\u00033\tY\u0002\u0005\u0002Cw%\u0019\u0011QD\u001e\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t#a\t\u0003\rM#(/\u001b8h\u0015\r\tibO\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0007I\u000bI\u0003\u0003\u0004\u0002,-\u0001\r\u0001T\u0001\t]\u0016<8\t[5mI\u0006!1m\u001c9z)\r\u0011\u0016\u0011\u0007\u0005\b\u00152\u0001\n\u00111\u0001M\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u000e+\u00071\u000bId\u000b\u0002\u0002<A!\u0011QHA$\u001b\t\tyD\u0003\u0003\u0002B\u0005\r\u0013!C;oG\",7m[3e\u0015\r\t)eO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA%\u0003\u007f\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\n\t\u0005\u0003#\nY&\u0004\u0002\u0002T)!\u0011QKA,\u0003\u0011a\u0017M\\4\u000b\u0005\u0005e\u0013\u0001\u00026bm\u0006LA!!\t\u0002T\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\r\t\u0004u\u0005\r\u0014bAA3w\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019a.a\u001b\t\u0013\u00055\u0004#!AA\u0002\u0005\u0005\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002tA)\u0011QOA>]6\u0011\u0011q\u000f\u0006\u0004\u0003sZ\u0014AC2pY2,7\r^5p]&!\u0011QPA<\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007\u0019\f\u0019\t\u0003\u0005\u0002nI\t\t\u00111\u0001o\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005=\u0013\u0011\u0012\u0005\n\u0003[\u001a\u0012\u0011!a\u0001\u0003C\na!Z9vC2\u001cHc\u00014\u0002\u0010\"A\u0011Q\u000e\u000b\u0002\u0002\u0003\u0007a\u000eK\n\u0001\u0003'\u000bI*a'\u0002 \u0006\u0005\u0016QUAT\u0003W\u000bi\u000bE\u0002-\u0003+K1!a&\u001e\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!(\u0002G~3UKT\"`QM,7m\u001c8eg&\u0002S\u0006I\"sK\u0006$Xm\u001d\u0011uS6,7\u000f^1na\u00022'o\\7!i\",\u0007E\\;nE\u0016\u0014\be\u001c4!g\u0016\u001cwN\u001c3tA!\u001a\u0017M\u001c\u0011cK\u00022'/Y2uS>t\u0017\r\\\u0015!g&t7-\u001a\u0011V)\u000e\u0003S\r]8dQ:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003G\u000b\u00111\u0006\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)cI\u001a\u0004GM\u0019:aA\u0002\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aABT&\r\u001a.eU\u0002\u0003g\u000e\u001e4ai\u0002\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00152eM\u0002$'M\u001d1aAr\u0013GM\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004\u0007\r\u001d.cIj#'\u000e\u00111oi\u001a\u0004G\u000f\u00191]E\u00124G\u0003\u0011!\u0003\u00159'o\\;qC\t\tI+\u0001\beCR,G/[7f?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005=\u0016!B\u001a/c9\u0002\u0014AE*fG>tGm\u001d+p)&lWm\u001d;b[B\u0004\"\u0001\f\f\u0014\u000bY\t9,a1\u0011\r\u0005e\u0016q\u0018'S\u001b\t\tYLC\u0002\u0002>n\nqA];oi&lW-\u0003\u0003\u0002B\u0006m&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocA!\u0011QYAf\u001b\t\t9M\u0003\u0003\u0002J\u0006]\u0013AA5p\u0013\rA\u0015q\u0019\u000b\u0003\u0003g\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u001f\nQ!\u00199qYf$2AUAl\u0011\u0015Q\u0015\u00041\u0001M\u0003\u001d)h.\u00199qYf$B!!8\u0002dB!!(a8M\u0013\r\t\to\u000f\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005\u0015($!AA\u0002I\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\tY\u000f\u0005\u0003\u0002R\u00055\u0018\u0002BAx\u0003'\u0012aa\u00142kK\u000e$\b")
public class SecondsToTimestamp
extends UnaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
Serializable {
    private transient Function1<Object, Object> evalFunc;
    private final Expression child;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> unapply(SecondsToTimestamp x$0) {
        return SecondsToTimestamp$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<SecondsToTimestamp, A> g) {
        return SecondsToTimestamp$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, SecondsToTimestamp> compose(Function1<A$, Expression> g) {
        return SecondsToTimestamp$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)NumericType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return TimestampType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        DataType dataType = this.child().dataType();
        if (dataType instanceof FloatType ? true : dataType instanceof DoubleType) {
            return true;
        }
        return this.child().nullable();
    }

    private Function1<Object, Object> evalFunc$lzycompute() {
        SecondsToTimestamp secondsToTimestamp = this;
        synchronized (secondsToTimestamp) {
            if (!this.bitmap$trans$0) {
                Function1 & Serializable intersect;
                DataType dataType = this.child().dataType();
                if (dataType instanceof IntegralType) {
                    intersect = (Function1 & Serializable)input -> BoxesRunTime.boxToLong((long)SecondsToTimestamp.$anonfun$evalFunc$1(input));
                } else if (dataType instanceof DecimalType) {
                    intersect = (Function1 & Serializable)input -> BoxesRunTime.boxToLong((long)SecondsToTimestamp.$anonfun$evalFunc$2(input));
                } else if (dataType instanceof FloatType) {
                    intersect = (Function1 & Serializable)input -> {
                        float f = BoxesRunTime.unboxToFloat((Object)input);
                        if (Float.isNaN(f) || Float.isInfinite(f)) {
                            return null;
                        }
                        return BoxesRunTime.boxToLong((long)((long)((double)f * (double)1000000L)));
                    };
                } else if (dataType instanceof DoubleType) {
                    intersect = (Function1 & Serializable)input -> {
                        double d = BoxesRunTime.unboxToDouble((Object)input);
                        if (Double.isNaN(d) || Double.isInfinite(d)) {
                            return null;
                        }
                        return BoxesRunTime.boxToLong((long)((long)(d * (double)1000000L)));
                    };
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.evalFunc = intersect;
                this.bitmap$trans$0 = true;
            }
        }
        return this.evalFunc;
    }

    private Function1<Object, Object> evalFunc() {
        if (!this.bitmap$trans$0) {
            return this.evalFunc$lzycompute();
        }
        return this.evalFunc;
    }

    @Override
    public Object nullSafeEval(Object input) {
        return this.evalFunc().apply(input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType = this.child().dataType();
        if (dataType instanceof IntegralType) {
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> "java.lang.Math.multiplyExact(" + c + ", " + 1000000L + "L)");
        }
        if (dataType instanceof DecimalType) {
            String operand = "new java.math.BigDecimal(" + 1000000L + ")";
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> c + ".toJavaBigDecimal().multiply(" + operand + ").longValueExact()");
        }
        String castToDouble = dataType instanceof FloatType ? "(double)" : "";
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> {
            String typeStr = CodeGenerator$.MODULE$.boxedType(dataType);
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |if (" + typeStr + ".isNaN(" + c + ") || " + typeStr + ".isInfinite(" + c + ")) {\n           |  " + ev.isNull() + " = true;\n           |} else {\n           |  " + ev.value() + " = (long)(" + castToDouble + c + " * " + 1000000L + ");\n           |}\n           |"));
        });
    }

    @Override
    public String prettyName() {
        return "timestamp_seconds";
    }

    @Override
    public SecondsToTimestamp withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public SecondsToTimestamp copy(Expression child) {
        return new SecondsToTimestamp(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "SecondsToTimestamp";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SecondsToTimestamp;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SecondsToTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        SecondsToTimestamp secondsToTimestamp = (SecondsToTimestamp)x$1;
        Expression expression = this.child();
        Expression expression2 = secondsToTimestamp.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!secondsToTimestamp.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$evalFunc$1(Object input) {
        return Math.multiplyExact(((Number)input).longValue(), 1000000L);
    }

    public static final /* synthetic */ long $anonfun$evalFunc$2(Object input) {
        BigDecimal operand = new BigDecimal(1000000L);
        return ((Decimal)input).toJavaBigDecimal().multiply(operand).longValueExact();
    }

    public SecondsToTimestamp(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

