/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FoldableUnevaluable;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NonSQLExpression;
import org.apache.spark.sql.catalyst.expressions.SessionWindow$;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.AnyTimestampType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Enumeration;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(time_column, gap_duration) - Generates session window given a timestamp specifying column and gap duration.\n      See <a href=\"https://spark.apache.org/docs/latest/structured-streaming-programming-guide.html#types-of-time-windows\">'Types of time windows'</a> in Structured Streaming guide doc for detailed explanation and examples.\n  ", arguments="\n    Arguments:\n      * time_column - The column or the expression to use as the timestamp for windowing by time. The time column must be of TimestampType.\n      * gap_duration - A string specifying the timeout of the session represented as \"interval value\"\n        (See <a href=\"https://spark.apache.org/docs/latest/sql-ref-literals.html#interval-literal\">Interval Literal</a> for more details.) for the fixed gap duration, or\n        an expression which is applied for each input and evaluated to the \"interval value\" for the dynamic gap duration.\n  ", examples="\n    Examples:\n      > SELECT a, session_window.start, session_window.end, count(*) as cnt FROM VALUES ('A1', '2021-01-01 00:00:00'), ('A1', '2021-01-01 00:04:30'), ('A1', '2021-01-01 00:10:00'), ('A2', '2021-01-01 00:01:00') AS tab(a, b) GROUP by a, _FUNC_(b, '5 minutes') ORDER BY a, start;\n        A1\t2021-01-01 00:00:00\t2021-01-01 00:09:30\t2\n        A1\t2021-01-01 00:10:00\t2021-01-01 00:15:00\t1\n        A2\t2021-01-01 00:01:00\t2021-01-01 00:06:00\t1\n      > SELECT a, session_window.start, session_window.end, count(*) as cnt FROM VALUES ('A1', '2021-01-01 00:00:00'), ('A1', '2021-01-01 00:04:30'), ('A1', '2021-01-01 00:10:00'), ('A2', '2021-01-01 00:01:00'), ('A2', '2021-01-01 00:04:30') AS tab(a, b) GROUP by a, _FUNC_(b, CASE WHEN a = 'A1' THEN '5 minutes' WHEN a = 'A2' THEN '1 minute' ELSE '10 minutes' END) ORDER BY a, start;\n        A1\t2021-01-01 00:00:00\t2021-01-01 00:09:30\t2\n        A1\t2021-01-01 00:10:00\t2021-01-01 00:15:00\t1\n        A2\t2021-01-01 00:01:00\t2021-01-01 00:02:00\t1\n        A2\t2021-01-01 00:04:30\t2021-01-01 00:05:30\t1\n  ", group="datetime_funcs", since="3.2.0")
@ScalaSignature(bytes="\u0006\u0005\t]a\u0001\u0002\u0012$\u0001BB\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t%\u0002\u0011\t\u0012)A\u0005c!A1\u000b\u0001BK\u0002\u0013\u0005\u0011\u000b\u0003\u0005U\u0001\tE\t\u0015!\u00032\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015Q\u0006\u0001\"\u0003\\\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011\u00159\u0007\u0001\"\u0011i\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u001dy\u0007A1A\u0005FADq!a\u0004\u0001A\u00035\u0011\u000f\u0003\u0006\u0002\u0012\u0001A)\u0019!C!\u0003'Aq!a\u0007\u0001\t\u0003\n\u0019\u0002C\u0004\u0002\u001e\u0001!\t&a\b\t\u0013\u0005-\u0002!!A\u0005\u0002\u00055\u0002\"CA\u001a\u0001E\u0005I\u0011AA\u001b\u0011%\tY\u0005AI\u0001\n\u0003\t)\u0004C\u0005\u0002N\u0001\t\t\u0011\"\u0011\u0002P!I\u0011\u0011\r\u0001\u0002\u0002\u0013\u0005\u00111\r\u0005\n\u0003W\u0002\u0011\u0011!C\u0001\u0003[B\u0011\"!\u001f\u0001\u0003\u0003%\t%a\u001f\t\u0013\u0005%\u0005!!A\u0005\u0002\u0005-\u0005\"CAH\u0001\u0005\u0005I\u0011IAI\u0011%\t)\nAA\u0001\n\u0003\n9jB\u0004\u0002B\u000eB\t!a1\u0007\r\t\u001a\u0003\u0012AAc\u0011\u0019)&\u0004\"\u0001\u0002X\"I\u0011\u0011\u001c\u000eC\u0002\u0013\u0005\u0011q\n\u0005\t\u00037T\u0002\u0015!\u0003\u0002R!9\u0011Q\u001c\u000e\u0005\u0002\u0005}\u0007\"CAo5\u0005\u0005I\u0011QAz\u0011%\tIPGA\u0001\n\u0003\u000bY\u0010C\u0005\u0003\u000ei\t\t\u0011\"\u0003\u0003\u0010\ti1+Z:tS>tw+\u001b8e_^T!\u0001J\u0013\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003M\u001d\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003Q%\n1a]9m\u0015\tQ3&A\u0003ta\u0006\u00148N\u0003\u0002-[\u00051\u0011\r]1dQ\u0016T\u0011AL\u0001\u0004_J<7\u0001A\n\b\u0001E*\u0004h\u000f E!\t\u00114'D\u0001$\u0013\t!4E\u0001\u0006FqB\u0014Xm]:j_:\u0004\"A\r\u001c\n\u0005]\u001a#AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005IJ\u0014B\u0001\u001e$\u0005-)f.\u001a<bYV\f'\r\\3\u0011\u0005Ib\u0014BA\u001f$\u0005AquN\\*R\u0019\u0016C\bO]3tg&|g\u000e\u0005\u0002@\u00056\t\u0001IC\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0005IA\u0004Qe>$Wo\u0019;\u0011\u0005\u0015keB\u0001$L\u001d\t9%*D\u0001I\u0015\tIu&\u0001\u0004=e>|GOP\u0005\u0002\u0003&\u0011A\nQ\u0001\ba\u0006\u001c7.Y4f\u0013\tquJ\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002M\u0001\u0006QA/[7f\u0007>dW/\u001c8\u0016\u0003E\n1\u0002^5nK\u000e{G.^7oA\u0005Yq-\u00199EkJ\fG/[8o\u000319\u0017\r\u001d#ve\u0006$\u0018n\u001c8!\u0003\u0019a\u0014N\\5u}Q\u0019q\u000bW-\u0011\u0005I\u0002\u0001\"\u0002)\u0006\u0001\u0004\t\u0004\"B*\u0006\u0001\u0004\t\u0014!F5oaV$H+\u001f9f\u001f:$\u0016.\\3D_2,XN\\\u000b\u00029B\u0011Q\fY\u0007\u0002=*\u0011qlJ\u0001\u0006if\u0004Xm]\u0005\u0003Cz\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012\u0001\u001a\t\u0004\u000b\u0016\f\u0014B\u00014P\u0005\r\u0019V-]\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#A5\u0011\u0007\u0015+G,\u0001\u0005eCR\fG+\u001f9f+\u0005a\u0007CA/n\u0013\tqgL\u0001\u0005ECR\fG+\u001f9f\u00031qw\u000eZ3QCR$XM\u001d8t+\u0005\t\bcA#feB\u00191/!\u0003\u000f\u0007Q\f\u0019A\u0004\u0002v\u007f:\u0011aO \b\u0003ovt!\u0001\u001f?\u000f\u0005e\\hBA${\u0013\u0005q\u0013B\u0001\u0017.\u0013\tQ3&\u0003\u0002)S%\u0011aeJ\u0005\u0004\u0003\u0003)\u0013!\u0002;sK\u0016\u001c\u0018\u0002BA\u0003\u0003\u000f\t1\u0002\u0016:fKB\u000bG\u000f^3s]*\u0019\u0011\u0011A\u0013\n\t\u0005-\u0011Q\u0002\u0002\f)J,W\rU1ui\u0016\u0014hN\u0003\u0003\u0002\u0006\u0005\u001d\u0011!\u00048pI\u0016\u0004\u0016\r\u001e;fe:\u001c\b%\u0001\u0005sKN|GN^3e+\t\t)\u0002E\u0002@\u0003/I1!!\u0007A\u0005\u001d\u0011un\u001c7fC:\f\u0001B\\;mY\u0006\u0014G.Z\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$2!MA\u0011\u0011\u001d\t\u0019C\u0004a\u0001\u0003K\t1B\\3x\u0007\"LG\u000e\u001a:f]B!Q)a\n2\u0013\r\tIc\u0014\u0002\u000b\u0013:$W\r_3e'\u0016\f\u0018\u0001B2paf$RaVA\u0018\u0003cAq\u0001U\b\u0011\u0002\u0003\u0007\u0011\u0007C\u0004T\u001fA\u0005\t\u0019A\u0019\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0007\u0016\u0004c\u0005e2FAA\u001e!\u0011\ti$a\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015\u0003)\u0001\u0006b]:|G/\u0019;j_:LA!!\u0013\u0002@\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0015\u0011\t\u0005M\u0013QL\u0007\u0003\u0003+RA!a\u0016\u0002Z\u0005!A.\u00198h\u0015\t\tY&\u0001\u0003kCZ\f\u0017\u0002BA0\u0003+\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA3!\ry\u0014qM\u0005\u0004\u0003S\u0002%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA8\u0003k\u00022aPA9\u0013\r\t\u0019\b\u0011\u0002\u0004\u0003:L\b\"CA<)\u0005\u0005\t\u0019AA3\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0010\t\u0007\u0003\u007f\n))a\u001c\u000e\u0005\u0005\u0005%bAAB\u0001\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u001d\u0015\u0011\u0011\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0016\u00055\u0005\"CA<-\u0005\u0005\t\u0019AA8\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005E\u00131\u0013\u0005\n\u0003o:\u0012\u0011!a\u0001\u0003K\na!Z9vC2\u001cH\u0003BA\u000b\u00033C\u0011\"a\u001e\u0019\u0003\u0003\u0005\r!a\u001c)/\u0001\ti*a)\u0002&\u0006%\u00161VAX\u0003c\u000b),a.\u0002<\u0006u\u0006c\u0001\u001a\u0002 &\u0019\u0011\u0011U\u0012\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qU\u0001\u00036*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015uS6,wlY8mk6tG\u0006I4ba~#WO]1uS>t\u0017\u0006I\u0017!\u000f\u0016tWM]1uKN\u00043/Z:tS>t\u0007e^5oI><\beZ5wK:\u0004\u0013\r\t;j[\u0016\u001cH/Y7qAM\u0004XmY5gs&tw\rI2pYVlg\u000eI1oI\u0002:\u0017\r\u001d\u0011ekJ\fG/[8o])\u0001\u0003\u0005\t\u0011!AM+W\r\t\u001fbA!\u0014XMZ\u001f#QR$\bo\u001d\u001e0_M\u0004\u0018M]6/CB\f7\r[3/_J<w\u0006Z8dg>b\u0017\r^3ti>\u001aHO];diV\u0014X\rZ\u0017tiJ,\u0017-\\5oO6\u0002(o\\4sC6l\u0017N\\4.OVLG-\u001a\u0018ii6d7\u0005^=qKNlsNZ\u0017uS6,Wf^5oI><8O\t ()f\u0004Xm\u001d\u0011pM\u0002\"\u0018.\\3!o&tGm\\<tOqz\u0013M\u0010\u0011j]\u0002\u001aFO];diV\u0014X\r\u001a\u0011TiJ,\u0017-\\5oO\u0002:W/\u001b3fA\u0011|7\r\t4pe\u0002\"W\r^1jY\u0016$\u0007%\u001a=qY\u0006t\u0017\r^5p]\u0002\ng\u000e\u001a\u0011fq\u0006l\u0007\u000f\\3t])\u0001\u0003%A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011QV\u0001\u0005R)\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003\u0005^5nK~\u001bw\u000e\\;n]\u0002j\u0003\u0005\u00165fA\r|G.^7oA=\u0014\b\u0005\u001e5fA\u0015D\bO]3tg&|g\u000e\t;pAU\u001cX\rI1tAQDW\r\t;j[\u0016\u001cH/Y7qA\u0019|'\u000fI<j]\u0012|w/\u001b8hA\tL\b\u0005^5nK:\u0002C\u000b[3!i&lW\rI2pYVlg\u000eI7vgR\u0004#-\u001a\u0011pM\u0002\"\u0016.\\3ti\u0006l\u0007\u000fV=qK:R\u0001\u0005\t\u0011!A\u0001R\u0003eZ1q?\u0012,(/\u0019;j_:\u0004S\u0006I!!gR\u0014\u0018N\\4!gB,7-\u001b4zS:<\u0007\u0005\u001e5fAQLW.Z8vi\u0002zg\r\t;iK\u0002\u001aXm]:j_:\u0004#/\u001a9sKN,g\u000e^3eA\u0005\u001c\bEI5oi\u0016\u0014h/\u00197!m\u0006dW/\u001a\u0012\u000bA\u0001\u0002\u0003\u0005\t\u0011!A!\u001aV-\u001a\u0011=C\u0002B'/\u001a4>E!$H\u000f]:;_=\u001a\b/\u0019:l]\u0005\u0004\u0018m\u00195f]=\u0014xm\f3pGN|C.\u0019;fgR|3/\u001d7.e\u00164W\u0006\\5uKJ\fGn\u001d\u0018ii6d7%\u001b8uKJ4\u0018\r\\\u0017mSR,'/\u00197#}%sG/\u001a:wC2\u0004C*\u001b;fe\u0006dGhL1?A\u0019|'\u000fI7pe\u0016\u0004C-\u001a;bS2\u001ch&\u000b\u0011g_J\u0004C\u000f[3!M&DX\r\u001a\u0011hCB\u0004C-\u001e:bi&|g\u000e\f\u0011pe*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0013M\u001c\u0011fqB\u0014Xm]:j_:\u0004s\u000f[5dQ\u0002J7\u000fI1qa2LW\r\u001a\u0011g_J\u0004S-Y2iA%t\u0007/\u001e;!C:$\u0007%\u001a<bYV\fG/\u001a3!i>\u0004C\u000f[3!E%tG/\u001a:wC2\u0004c/\u00197vK\n\u0002cm\u001c:!i\",\u0007\u0005Z=oC6L7\rI4ba\u0002\"WO]1uS>tgF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAZ\u0003!]\"\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI1-AM,7o]5p]~;\u0018N\u001c3po:\u001aH/\u0019:uY\u0001\u001aXm]:j_:|v/\u001b8e_^tSM\u001c3-A\r|WO\u001c;)U%\u0002\u0013m\u001d\u0011d]R\u0004cIU(NAY\u000bE*V#TA!:\u0013)M\u0014-A\u001d\u0012\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002\u0004G\u000f\u00191O%b\u0003\u0005K\u0014Bc\u001db\u0003e\n\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00195uM\u0002t%\u000b\u0017!Q\u001d\n\u0015g\n\u0017!OI\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uE\u0002$\b\r\u0019(S1\u0002\u0003fJ!3O1\u0002sE\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\bM\u0019;aA:\u0013\u0006I!TAQ\f'\rK1-A\tL\u0003e\u0012*P+B\u0003#-\u001f\u0011bY\u0001zf)\u0016(D?\"\u0012G\u0006I\u00146A5Lg.\u001e;fg\u001eJ\u0003e\u0014*E\u000bJ\u0003#)\u0017\u0011bY\u0001\u001aH/\u0019:uw)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0013)M\u00053aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1ai\u0002\u0004'\u0003\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u0019:uM\u0002\u0014B\r\u0006!A\u0001\u0002\u0003\u0005\t\u0011!\u0003FJ!\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0014\u0007\r\u001e1a%\u0011\u0004GM\u0019.aEj\u0003'\r\u00111ai\nTG\u000f\u00191\u0013ER\u0001\u0005\t\u0011!A\u0001\u0002\u0003%\u0011\u001a\neA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aER\u0004\u0007M\u00053aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1mi\u0002\u0004'C\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA\u0005d\u0003e]3tg&|gnX<j]\u0012|wOL:uCJ$H\u0006I:fgNLwN\\0xS:$wn\u001e\u0018f]\u0012d\u0003eY8v]RD#&\u000b\u0011bg\u0002\u001ag\u000e\u001e\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0014Bc\u001db\u0003e\n\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00191uA\u0002t%\u000b\u0017!Q\u001d\n\u0015g\n\u0017!OI\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA\"$h\r\u0019(S1\u0002\u0003fJ!2O1\u0002sE\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$(\r\u0019;aA:\u0013\u0006\f\u0011)O\u0005\u0013t\u0005\f\u0011(eA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aER\u0004\u0007M\u0014*Y\u0001Bs%\u0011\u001a(Y\u0001:#\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004\u0007\u000e\u001e4a\u001dJ\u0003%Q*!i\u0006\u0014\u0007&\u0019\u0017!E&\u0002sIU(V!\u0002\u0012\u0017\u0010I1-A}3UKT\"`Q\td\u0003eQ!T\u000b\u0002:\u0006*\u0012(!C\u0002j\u0004eJ!2O\u0001\"\u0006*\u0012(!OU\u0002S.\u001b8vi\u0016\u001cx\u0005I,I\u000b:\u0003\u0013\rI\u001f!O\u0005\u0013t\u0005\t+I\u000b:\u0003s%\r\u0011nS:,H/Z\u0014!\u000b2\u001bV\tI\u00142a\u0001j\u0017N\\;uKN<\u0003%\u0012(ES\u0001z%\u000bR#SA\tK\u0006%\u0019\u0017!gR\f'\u000f^\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u000b\u0014B\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\b\r\u0019;aAJ!\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004'\u000f\u001e4a%\u0011$\u0002\t\u0011!A\u0001\u0002\u0003\u0005I!2\u0013I\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uE\u0002$\b\r\u0019\neA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;cUR\u0004\u0007M\u00052\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\n%'\u0003\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00192uA\u0002\u0014B\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\b\r\u001a;aAJ\u0011G\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011Be%\u0011\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002DGO\u001a1\u0013I\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA*$h\r\u0019\nc)\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002:\u0006qA-\u0019;fi&lWm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAA`\u0003\u0015\u0019dF\r\u00181\u00035\u0019Vm]:j_:<\u0016N\u001c3poB\u0011!GG\n\u00065\u0005\u001d\u0017Q\u001a\t\u0004\u007f\u0005%\u0017bAAf\u0001\n1\u0011I\\=SK\u001a\u0004B!a4\u0002V6\u0011\u0011\u0011\u001b\u0006\u0005\u0003'\fI&\u0001\u0002j_&\u0019a*!5\u0015\u0005\u0005\r\u0017AB7be.,'/A\u0004nCJ\\WM\u001d\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b]\u000b\t/a9\t\u000bAs\u0002\u0019A\u0019\t\rMs\u0002\u0019AAs!\u0011\t9/a<\u000f\t\u0005%\u00181\u001e\t\u0003\u000f\u0002K1!!<A\u0003\u0019\u0001&/\u001a3fM&!\u0011qLAy\u0015\r\ti\u000f\u0011\u000b\u0006/\u0006U\u0018q\u001f\u0005\u0006!~\u0001\r!\r\u0005\u0006'~\u0001\r!M\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tiP!\u0003\u0011\u000b}\nyPa\u0001\n\u0007\t\u0005\u0001I\u0001\u0004PaRLwN\u001c\t\u0006\u007f\t\u0015\u0011'M\u0005\u0004\u0005\u000f\u0001%A\u0002+va2,'\u0007\u0003\u0005\u0003\f\u0001\n\t\u00111\u0001X\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005#\u0001B!a\u0015\u0003\u0014%!!QCA+\u0005\u0019y%M[3di\u0002")
public class SessionWindow
extends Expression
implements ImplicitCastInputTypes,
Unevaluable,
NonSQLExpression,
Serializable {
    private boolean resolved;
    private final Expression timeColumn;
    private final Expression gapDuration;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(SessionWindow x$0) {
        return SessionWindow$.MODULE$.unapply(x$0);
    }

    public static String marker() {
        return SessionWindow$.MODULE$.marker();
    }

    @Override
    public final String sql() {
        return NonSQLExpression.sql$(this);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return FoldableUnevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return FoldableUnevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return FoldableUnevaluable.doGenCode$(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression timeColumn() {
        return this.timeColumn;
    }

    public Expression gapDuration() {
        return this.gapDuration;
    }

    private AbstractDataType inputTypeOnTimeColumn() {
        return TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{AnyTimestampType$.MODULE$, new StructType().add(new StructField("start", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("end", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())), new StructType().add(new StructField("start", (DataType)TimestampNTZType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("end", (DataType)TimestampNTZType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))}));
    }

    @Override
    public Seq<Expression> children() {
        return new .colon.colon((Object)this.timeColumn(), (List)new .colon.colon((Object)this.gapDuration(), (List)Nil$.MODULE$));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)this.inputTypeOnTimeColumn(), (List)new .colon.colon((Object)AnyDataType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return new StructType().add(new StructField("start", ((Expression)this.children().head()).dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("end", ((Expression)this.children().head()).dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private boolean resolved$lzycompute() {
        SessionWindow sessionWindow = this;
        synchronized (sessionWindow) {
            if (!this.bitmap$0) {
                this.resolved = false;
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1));
    }

    public SessionWindow copy(Expression timeColumn, Expression gapDuration) {
        return new SessionWindow(timeColumn, gapDuration);
    }

    public Expression copy$default$1() {
        return this.timeColumn();
    }

    public Expression copy$default$2() {
        return this.gapDuration();
    }

    @Override
    public String productPrefix() {
        return "SessionWindow";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.timeColumn();
            }
            case 1: {
                return this.gapDuration();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SessionWindow;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "timeColumn";
            }
            case 1: {
                return "gapDuration";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SessionWindow)) return false;
        boolean bl = true;
        if (!bl) return false;
        SessionWindow sessionWindow = (SessionWindow)x$1;
        Expression expression = this.timeColumn();
        Expression expression2 = sessionWindow.timeColumn();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.gapDuration();
        Expression expression4 = sessionWindow.gapDuration();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!sessionWindow.canEqual(this)) return false;
        return true;
    }

    public SessionWindow(Expression timeColumn, Expression gapDuration) {
        this.timeColumn = timeColumn;
        this.gapDuration = gapDuration;
        ExpectsInputTypes.$init$(this);
        FoldableUnevaluable.$init$(this);
        Unevaluable.$init$(this);
        NonSQLExpression.$init$(this);
        this.nodePatterns = new .colon.colon((Object)TreePattern$.MODULE$.SESSION_WINDOW(), (List)Nil$.MODULE$);
    }
}

