/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Sha1$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns a sha1 hash value as a hex string of the `expr`.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark');\n       85f5955f4b27a9a4c2aab6ffe5d7189fc298b92c\n  ", since="1.5.0", group="hash_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001B\r\u001b\u0001\u001eB\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0013\")Q\n\u0001C\u0001\u001d\")\u0011\u000b\u0001C!%\")\u0011\f\u0001C!5\")a\f\u0001C)?\")Q\r\u0001C!M\")A\u000f\u0001C)k\"9\u0001\u0010AA\u0001\n\u0003I\bbB>\u0001#\u0003%\t\u0001 \u0005\n\u0003\u001f\u0001\u0011\u0011!C!\u0003#A\u0011\"a\t\u0001\u0003\u0003%\t!!\n\t\u0013\u00055\u0002!!A\u0005\u0002\u0005=\u0002\"CA\u001b\u0001\u0005\u0005I\u0011IA\u001c\u0011%\t)\u0005AA\u0001\n\u0003\t9\u0005C\u0005\u0002R\u0001\t\t\u0011\"\u0011\u0002T!I\u0011q\u000b\u0001\u0002\u0002\u0013\u0005\u0013\u0011L\u0004\n\u0003{R\u0012\u0011!E\u0001\u0003\u007f2\u0001\"\u0007\u000e\u0002\u0002#\u0005\u0011\u0011\u0011\u0005\u0007\u001bN!\t!!'\t\u0013\u0005m5#!A\u0005F\u0005u\u0005\"CAP'\u0005\u0005I\u0011QAQ\u0011%\t)kEA\u0001\n\u0003\u000b9\u000bC\u0005\u00024N\t\t\u0011\"\u0003\u00026\n!1\u000b[12\u0015\tYB$A\u0006fqB\u0014Xm]:j_:\u001c(BA\u000f\u001f\u0003!\u0019\u0017\r^1msN$(BA\u0010!\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003C\t\nQa\u001d9be.T!a\t\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0013aA8sO\u000e\u00011C\u0002\u0001)Y=2D\b\u0005\u0002*U5\t!$\u0003\u0002,5\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002*[%\u0011aF\u0007\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011\u0001g\r\b\u0003SEJ!A\r\u000e\u0002\u000fA\f7m[1hK&\u0011A'\u000e\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\t\u0011$\u0004\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004HA\u0004Qe>$Wo\u0019;\u0011\u0005u\"eB\u0001 D\u001d\ty$)D\u0001A\u0015\t\te%\u0001\u0004=e>|GOP\u0005\u0002s%\u0011!\u0007O\u0005\u0003\u000b\u001a\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!A\r\u001d\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003%\u0003\"!\u000b&\n\u0005-S\"AC#yaJ,7o]5p]\u000611\r[5mI\u0002\na\u0001P5oSRtDCA(Q!\tI\u0003\u0001C\u0003H\u0007\u0001\u0007\u0011*\u0001\u0005eCR\fG+\u001f9f+\u0005\u0019\u0006C\u0001+X\u001b\u0005)&B\u0001,\u001f\u0003\u0015!\u0018\u0010]3t\u0013\tAVK\u0001\u0005ECR\fG+\u001f9f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u00027B\u0019Q\bX*\n\u0005u3%aA*fc\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0011\u0001m\u0019\t\u0003o\u0005L!A\u0019\u001d\u0003\u0007\u0005s\u0017\u0010C\u0003e\r\u0001\u0007\u0001-A\u0003j]B,H/A\u0005e_\u001e+gnQ8eKR\u0019q-\u001c:\u0011\u0005!\\W\"A5\u000b\u0005)T\u0012aB2pI\u0016<WM\\\u0005\u0003Y&\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006]\u001e\u0001\ra\\\u0001\u0004GRD\bC\u00015q\u0013\t\t\u0018N\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000bM<\u0001\u0019A4\u0002\u0005\u00154\u0018\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000e\u0006\u0002Pm\")q\u000f\u0003a\u0001\u0013\u0006Aa.Z<DQ&dG-\u0001\u0003d_BLHCA({\u0011\u001d9\u0015\u0002%AA\u0002%\u000babY8qs\u0012\"WMZ1vYR$\u0013'F\u0001~U\tIepK\u0001\u0000!\u0011\t\t!a\u0003\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%\u0001(\u0001\u0006b]:|G/\u0019;j_:LA!!\u0004\u0002\u0004\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005}QBAA\f\u0015\u0011\tI\"a\u0007\u0002\t1\fgn\u001a\u0006\u0003\u0003;\tAA[1wC&!\u0011\u0011EA\f\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0005\t\u0004o\u0005%\u0012bAA\u0016q\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019\u0001-!\r\t\u0013\u0005MR\"!AA\u0002\u0005\u001d\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002:A)\u00111HA!A6\u0011\u0011Q\b\u0006\u0004\u0003\u007fA\u0014AC2pY2,7\r^5p]&!\u00111IA\u001f\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005%\u0013q\n\t\u0004o\u0005-\u0013bAA'q\t9!i\\8mK\u0006t\u0007\u0002CA\u001a\u001f\u0005\u0005\t\u0019\u00011\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003'\t)\u0006C\u0005\u00024A\t\t\u00111\u0001\u0002(\u00051Q-];bYN$B!!\u0013\u0002\\!A\u00111G\t\u0002\u0002\u0003\u0007\u0001\rK\n\u0001\u0003?\n)'a\u001a\u0002l\u00055\u0014\u0011OA:\u0003o\nI\bE\u0002*\u0003CJ1!a\u0019\u001b\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u001b\u0002\u000f~3UKT\"`Q\u0015D\bO]\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\rI:iCF\u0002\u0003.Y:iAY\fG.^3!CN\u0004\u0013\r\t5fq\u0002\u001aHO]5oO\u0002zg\r\t;iK\u0002\u0002W\r\u001f9sA:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003_\n\u0011M\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015('B\f'o[\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001BTGZ\u001b:kU2GG\u0019\u001a8Cf\nGg\u0019\u001abC\n4dMZ36I^\n\u0004(\u000f4deeB$-\u000f\u001ad\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAA;\u0003\u0015\td&\u000e\u00181\u0003\u00159'o\\;qC\t\tY(\u0001\u0006iCNDwLZ;oGN\fAa\u00155bcA\u0011\u0011fE\n\u0006'\u0005\r\u0015q\u0012\t\u0007\u0003\u000b\u000bY)S(\u000e\u0005\u0005\u001d%bAAEq\u00059!/\u001e8uS6,\u0017\u0002BAG\u0003\u000f\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82!\u0011\t\t*a&\u000e\u0005\u0005M%\u0002BAK\u00037\t!![8\n\u0007\u0015\u000b\u0019\n\u0006\u0002\u0002\u0000\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\u0014\u0005)\u0011\r\u001d9msR\u0019q*a)\t\u000b\u001d3\u0002\u0019A%\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011VAX!\u00119\u00141V%\n\u0007\u00055\u0006H\u0001\u0004PaRLwN\u001c\u0005\t\u0003c;\u0012\u0011!a\u0001\u001f\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005]\u0006\u0003BA\u000b\u0003sKA!a/\u0002\u0018\t1qJ\u00196fGR\u0004")
public class Sha1
extends UnaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Sha1 x$0) {
        return Sha1$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Sha1, A> g) {
        return Sha1$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, Sha1> compose(Function1<A$, Expression> g) {
        return Sha1$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public DataType dataType() {
        return SQLConf$.MODULE$.get().defaultStringType();
    }

    public Seq<DataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public Object nullSafeEval(Object input) {
        return UTF8String.fromString((String)DigestUtils.sha1Hex((byte[])((byte[])input)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> "UTF8String.fromString(" + DigestUtils.class.getName() + ".sha1Hex(" + c + "))");
    }

    @Override
    public Sha1 withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Sha1 copy(Expression child) {
        return new Sha1(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Sha1";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sha1;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sha1)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sha1 sha1 = (Sha1)x$1;
        Expression expression = this.child();
        Expression expression2 = sha1.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!sha1.canEqual(this)) return false;
        return true;
    }

    public Sha1(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

