/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.Shuffle$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.RandomIndicesGenerator;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(array) - Returns a random permutation of the given array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 20, 3, 5));\n       [3,1,5,20]\n      > SELECT _FUNC_(array(1, 20, null, 3));\n       [20,null,3,1]\n  ", note="\n    The function is non-deterministic.\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0005\t-d\u0001\u0002\u0015*\u0001ZB\u0001B\u0016\u0001\u0003\u0016\u0004%\ta\u0016\u0005\t7\u0002\u0011\t\u0012)A\u00051\"AA\f\u0001BK\u0002\u0013\u0005Q\f\u0003\u0005e\u0001\tE\t\u0015!\u0003_\u0011\u0015)\u0007\u0001\"\u0001g\u0011\u0015)\u0007\u0001\"\u0001k\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u0015\t\b\u0001\"\u0011X\u0011\u0015\u0011\b\u0001\"\u0011t\u0011!1\b\u0001#b\u0001\n\u0003j\u0007\"B<\u0001\t\u0003B\bbBA\u0003\u0001\u0011\u0005\u0013q\u0001\u0005\u0007\u0003\u001f\u0001A\u0011B7\t\u0015\u0005E\u0001\u0001#b\u0001\n\u0003\t9\u0001C\u0006\u0002\u001c\u0001\u0001\r\u0011!Q!\n\u0005u\u0001bBA\u0016\u0001\u0011E\u0013Q\u0006\u0005\b\u0003\u007f\u0001A\u0011KA!\u0011\u001d\t)\u0006\u0001C)\u0003/Bq!a\u001d\u0001\t\u0013\t)\bC\u0004\u0002\u0010\u0002!\t%!%\t\u0013\u0005]\u0005!!A\u0005\u0002\u0005e\u0005\"CAP\u0001E\u0005I\u0011AAQ\u0011%\t9\fAI\u0001\n\u0003\tI\fC\u0005\u0002>\u0002\t\t\u0011\"\u0011\u0002@\"I\u0011q\u001a\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u001b\u0005\n\u0003'\u0004\u0011\u0011!C\u0001\u0003+D\u0011\"a7\u0001\u0003\u0003%\t%!8\t\u0013\u0005-\b!!A\u0005\u0002\u00055\b\"CAy\u0001\u0005\u0005I\u0011IAz\u0011%\t9\u0010AA\u0001\n\u0003\nIpB\u0005\u0003$%\n\t\u0011#\u0001\u0003&\u0019A\u0001&KA\u0001\u0012\u0003\u00119\u0003\u0003\u0004fA\u0011\u0005!q\b\u0005\n\u0005\u0003\u0002\u0013\u0011!C#\u0005\u0007B\u0011B!\u0012!\u0003\u0003%\tIa\u0012\t\u0013\t5\u0003%%A\u0005\u0002\u0005e\u0006\"\u0003B(A\u0005\u0005I\u0011\u0011B)\u0011%\u0011y\u0006II\u0001\n\u0003\tI\fC\u0005\u0003b\u0001\n\t\u0011\"\u0003\u0003d\t91\u000b[;gM2,'B\u0001\u0016,\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u00051j\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u00059z\u0013aA:rY*\u0011\u0001'M\u0001\u0006gB\f'o\u001b\u0006\u0003eM\na!\u00199bG\",'\"\u0001\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u000194HP!E\u0015B\u0011\u0001(O\u0007\u0002S%\u0011!(\u000b\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011\u0001\bP\u0005\u0003{%\u0012\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\tAt(\u0003\u0002AS\t\u0001bj\u001c8eKR,'/\\5oSN$\u0018n\u0019\t\u0003q\tK!aQ\u0015\u00031\u0015C\bO]3tg&|gnV5uQJ\u000bg\u000eZ8n'\u0016,G\r\u0005\u0002F\u00116\taIC\u0001H\u0003\u0015\u00198-\u00197b\u0013\tIeIA\u0004Qe>$Wo\u0019;\u0011\u0005-\u001bfB\u0001'R\u001d\ti\u0005+D\u0001O\u0015\tyU'\u0001\u0004=e>|GOP\u0005\u0002\u000f&\u0011!KR\u0001\ba\u0006\u001c7.Y4f\u0013\t!VK\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002S\r\u0006)1\r[5mIV\t\u0001\f\u0005\u000293&\u0011!,\u000b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0006sC:$w.\\*fK\u0012,\u0012A\u0018\t\u0004\u000b~\u000b\u0017B\u00011G\u0005\u0019y\u0005\u000f^5p]B\u0011QIY\u0005\u0003G\u001a\u0013A\u0001T8oO\u0006Y!/\u00198e_6\u001cV-\u001a3!\u0003\u0019a\u0014N\\5u}Q\u0019q\r[5\u0011\u0005a\u0002\u0001\"\u0002,\u0006\u0001\u0004A\u0006b\u0002/\u0006!\u0003\u0005\rA\u0018\u000b\u0003O.DQA\u0016\u0004A\u0002a\u000b\u0001b\u001d;bi\u00164W\u000f\\\u000b\u0002]B\u0011Qi\\\u0005\u0003a\u001a\u0013qAQ8pY\u0016\fg.\u0001\btK\u0016$W\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u0017]LG\u000f\u001b(foN+W\r\u001a\u000b\u0003ORDQ!^\u0005A\u0002\u0005\fAa]3fI\u0006A!/Z:pYZ,G-\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u001f\t\u0004\u0017jd\u0018BA>V\u0005\r\u0019V-\u001d\t\u0004{\u0006\u0005Q\"\u0001@\u000b\u0005}l\u0013!\u0002;za\u0016\u001c\u0018bAA\u0002}\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\u0011\u0011\u0011\u0002\t\u0004{\u0006-\u0011bAA\u0007}\nAA)\u0019;b)f\u0004X-\u0001\u000esKN,H\u000e^!se\u0006LX\t\\3nK:$h*\u001e7mC\ndW-A\u0006fY\u0016lWM\u001c;UsB,\u0007f\u0001\b\u0002\u0016A\u0019Q)a\u0006\n\u0007\u0005eaIA\u0005ue\u0006t7/[3oi\u00061!/\u00198e_6\u0004B!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0004\u0003GY\u0013\u0001B;uS2LA!a\n\u0002\"\t1\"+\u00198e_6Le\u000eZ5dKN<UM\\3sCR|'\u000fK\u0002\u0010\u0003+\t!#\u001b8ji&\fG.\u001b>f\u0013:$XM\u001d8bYR!\u0011qFA\u001b!\r)\u0015\u0011G\u0005\u0004\u0003g1%\u0001B+oSRDq!a\u000e\u0011\u0001\u0004\tI$\u0001\bqCJ$\u0018\u000e^5p]&sG-\u001a=\u0011\u0007\u0015\u000bY$C\u0002\u0002>\u0019\u00131!\u00138u\u00031)g/\u00197J]R,'O\\1m)\u0011\t\u0019%!\u0013\u0011\u0007\u0015\u000b)%C\u0002\u0002H\u0019\u00131!\u00118z\u0011\u001d\tY%\u0005a\u0001\u0003\u001b\nQ!\u001b8qkR\u0004B!a\u0014\u0002R5\t1&C\u0002\u0002T-\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u00033\n)'a\u001c\u0011\t\u0005m\u0013\u0011M\u0007\u0003\u0003;R1!a\u0018*\u0003\u001d\u0019w\u000eZ3hK:LA!a\u0019\u0002^\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002hI\u0001\r!!\u001b\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\\\u0005-\u0014\u0002BA7\u0003;\u0012abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002rI\u0001\r!!\u0017\u0002\u0005\u00154\u0018aE:ik\u001a4G.Z!se\u0006L8i\u001c3f\u000f\u0016tG\u0003CA<\u0003\u000f\u000bI)a#\u0011\t\u0005e\u0014\u0011\u0011\b\u0005\u0003w\ni\b\u0005\u0002N\r&\u0019\u0011q\u0010$\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019)!\"\u0003\rM#(/\u001b8h\u0015\r\tyH\u0012\u0005\b\u0003O\u001a\u0002\u0019AA5\u0011\u001d\t\th\u0005a\u0001\u00033Bq!!$\u0014\u0001\u0004\t9(A\u0005dQ&dGMT1nK\u0006!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$2aZAJ\u0011\u0019\t)\n\u0006a\u00011\u0006Aa.Z<DQ&dG-\u0001\u0003d_BLH#B4\u0002\u001c\u0006u\u0005b\u0002,\u0016!\u0003\u0005\r\u0001\u0017\u0005\b9V\u0001\n\u00111\u0001_\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a)+\u0007a\u000b)k\u000b\u0002\u0002(B!\u0011\u0011VAZ\u001b\t\tYK\u0003\u0003\u0002.\u0006=\u0016!C;oG\",7m[3e\u0015\r\t\tLR\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA[\u0003W\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a/+\u0007y\u000b)+A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0003\u0004B!a1\u0002N6\u0011\u0011Q\u0019\u0006\u0005\u0003\u000f\fI-\u0001\u0003mC:<'BAAf\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0015QY\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003s\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002D\u0005]\u0007\"CAm5\u0005\u0005\t\u0019AA\u001d\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u001c\t\u0007\u0003C\f9/a\u0011\u000e\u0005\u0005\r(bAAs\r\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u00181\u001d\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002o\u0003_D\u0011\"!7\u001d\u0003\u0003\u0005\r!a\u0011\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u0003\f)\u0010C\u0005\u0002Zv\t\t\u00111\u0001\u0002:\u00051Q-];bYN$2A\\A~\u0011%\tINHA\u0001\u0002\u0004\t\u0019\u0005K\f\u0001\u0003\u007f\u0014)Aa\u0002\u0003\f\t5!\u0011\u0003B\n\u0005/\u0011IB!\b\u0003 A\u0019\u0001H!\u0001\n\u0007\t\r\u0011FA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t%\u0011\u0001Q0G+:\u001bu\fK1se\u0006L\u0018\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u0004#/\u00198e_6\u0004\u0003/\u001a:nkR\fG/[8oA=4\u0007\u0005\u001e5fA\u001dLg/\u001a8!CJ\u0014\u0018-\u001f\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#Aa\u0004\u0002\u0003GQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfD\u0013\u0007\f\u00113a1\u00023\u0007\f\u00116S%Z$\u0002\t\u0011!A\u0001\u0002\u0003eW\u001a-c1*DF\r\u0019^\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQEb\u0003E\r\u0019-A9,H\u000e\u001c\u0017!g%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.3a1rW\u000f\u001c7-g1\nTL\u0003\u0011!\u0003\u0011qw\u000e^3\"\u0005\tU\u0011A\u000b\u0006!A\u0001\u0002C\u000b[3!MVt7\r^5p]\u0002J7\u000f\t8p]6\"W\r^3s[&t\u0017n\u001d;jG:R\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u00057\t1\"\u0019:sCf|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012!\u0011E\u0001\u0006e9\"d\u0006M\u0001\b'\",hM\u001a7f!\tA\u0004eE\u0003!\u0005S\u0011)\u0004E\u0004\u0003,\tE\u0002LX4\u000e\u0005\t5\"b\u0001B\u0018\r\u00069!/\u001e8uS6,\u0017\u0002\u0002B\u001a\u0005[\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\u00119D!\u0010\u000e\u0005\te\"\u0002\u0002B\u001e\u0003\u0013\f!![8\n\u0007Q\u0013I\u0004\u0006\u0002\u0003&\u0005AAo\\*ue&tw\r\u0006\u0002\u0002B\u0006)\u0011\r\u001d9msR)qM!\u0013\u0003L!)ak\ta\u00011\"9Al\tI\u0001\u0002\u0004q\u0016aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u000fUt\u0017\r\u001d9msR!!1\u000bB.!\u0011)uL!\u0016\u0011\u000b\u0015\u00139\u0006\u00170\n\u0007\tecI\u0001\u0004UkBdWM\r\u0005\t\u0005;*\u0013\u0011!a\u0001O\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011)\u0007\u0005\u0003\u0002D\n\u001d\u0014\u0002\u0002B5\u0003\u000b\u0014aa\u00142kK\u000e$\b")
public class Shuffle
extends UnaryExpression
implements ExpectsInputTypes,
Nondeterministic,
ExpressionWithRandomSeed,
Serializable {
    private boolean resolved;
    private transient DataType elementType;
    private final Expression child;
    private final Option<Object> randomSeed;
    private transient RandomIndicesGenerator random;
    private Seq<Enumeration.Value> nodePatterns;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Object> $lessinit$greater$default$2() {
        return Shuffle$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Object>>> unapply(Shuffle x$0) {
        return Shuffle$.MODULE$.unapply(x$0);
    }

    public static Option<Object> apply$default$2() {
        return Shuffle$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Option<Object>>, Shuffle> tupled() {
        return Shuffle$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Object>, Shuffle>> curried() {
        return Shuffle$.MODULE$.curried();
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$ExpressionWithRandomSeed$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private boolean deterministic$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.deterministic$lzycompute();
        }
        return this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Option<Object> randomSeed() {
        return this.randomSeed;
    }

    @Override
    public boolean stateful() {
        return true;
    }

    @Override
    public Expression seedExpression() {
        return (Expression)this.randomSeed().map((Function1 & Serializable)v -> Literal$.MODULE$.apply(v)).getOrElse((Function0 & Serializable)() -> UnresolvedSeed$.MODULE$);
    }

    @Override
    public Shuffle withNewSeed(long seed) {
        Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)seed));
        Expression x$2 = this.copy$default$1();
        return this.copy(x$2, (Option<Object>)x$1);
    }

    private boolean resolved$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = this.childrenResolved() && this.checkInputDataTypes().isSuccess() && this.randomSeed().isDefined();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)ArrayType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    private boolean resultArrayElementNullable() {
        return ((ArrayType)this.dataType()).containsNull();
    }

    private DataType elementType$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if (!this.bitmap$trans$0) {
                this.elementType = ((ArrayType)this.dataType()).elementType();
                this.bitmap$trans$0 = true;
            }
        }
        return this.elementType;
    }

    public DataType elementType() {
        if (!this.bitmap$trans$0) {
            return this.elementType$lzycompute();
        }
        return this.elementType;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.random = new RandomIndicesGenerator(BoxesRunTime.unboxToLong((Object)this.randomSeed().get()) + (long)partitionIndex);
    }

    @Override
    public Object evalInternal(InternalRow input) {
        Object value = this.child().eval(input);
        if (value == null) {
            return null;
        }
        ArrayData source = (ArrayData)value;
        int numElements = source.numElements();
        int[] indices = this.random.getNextIndices(numElements);
        return new GenericArrayData((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(indices), (Function1 & Serializable)x$21 -> source.get(BoxesRunTime.unboxToInt((Object)x$21), this.elementType()), ClassTag$.MODULE$.apply(Object.class)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> this.shuffleArrayCodeGen(ctx, ev, (String)c));
    }

    private String shuffleArrayCodeGen(CodegenContext ctx, ExprCode ev, String childName) {
        String randomClass;
        String x$1 = randomClass = RandomIndicesGenerator.class.getName();
        String x$2 = "rand";
        boolean x$3 = true;
        Function1<String, String> x$4 = ctx.addMutableState$default$3();
        boolean x$5 = ctx.addMutableState$default$5();
        String rand = ctx.addMutableState(x$1, "rand", x$4, true, x$5);
        ctx.addPartitionInitializationStatement(rand + " = new " + randomClass + "(" + this.randomSeed().get() + "L + partitionIndex);");
        String numElements = ctx.freshName("numElements");
        String arrayData = ctx.freshName("arrayData");
        String indices = ctx.freshName("indices");
        String i = ctx.freshName("i");
        String initialization = CodeGenerator$.MODULE$.createArrayData(arrayData, this.elementType(), numElements, " " + this.prettyName() + " failed.");
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(arrayData, this.elementType(), childName, i, indices + "[" + i + "]", this.resultArrayElementNullable());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |int " + numElements + " = " + childName + ".numElements();\n       |int[] " + indices + " = " + rand + ".getNextIndices(" + numElements + ");\n       |" + initialization + "\n       |for (int " + i + " = 0; " + i + " < " + numElements + "; " + i + "++) {\n       |  " + assignment + "\n       |}\n       |" + ev.value() + " = " + arrayData + ";\n     "));
    }

    @Override
    public Shuffle withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Shuffle copy(Expression child, Option<Object> randomSeed) {
        return new Shuffle(child, randomSeed);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Option<Object> copy$default$2() {
        return this.randomSeed();
    }

    @Override
    public String productPrefix() {
        return "Shuffle";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.randomSeed();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Shuffle;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "randomSeed";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Shuffle)) return false;
        boolean bl = true;
        if (!bl) return false;
        Shuffle shuffle = (Shuffle)x$1;
        Expression expression = this.child();
        Expression expression2 = shuffle.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Object> option = this.randomSeed();
        Option<Object> option2 = shuffle.randomSeed();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!shuffle.canEqual(this)) return false;
        return true;
    }

    public Shuffle(Expression child, Option<Object> randomSeed) {
        this.child = child;
        this.randomSeed = randomSeed;
        ExpectsInputTypes.$init$(this);
        Nondeterministic.$init$(this);
        ExpressionWithRandomSeed.$init$(this);
        Statics.releaseFence();
    }

    public Shuffle(Expression child) {
        this(child, (Option<Object>)None$.MODULE$);
    }
}

