/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ElementAt;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.SplitPart$;
import org.apache.spark.sql.catalyst.expressions.StringSplitSQL;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str, delimiter, partNum) - Splits `str` by delimiter and return\n      requested part of the split (1-based). If any input is null, returns null.\n      if `partNum` is out of range of split parts, returns empty string. If `partNum` is 0,\n      throws an error. If `partNum` is negative, the parts are counted backward from the\n      end of the string. If the `delimiter` is an empty string, the `str` is not split.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('11.12.13', '.', 3);\n       13\n  ", since="3.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Eg\u0001B\u0010!\u00016B\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005]!AQ\n\u0001BK\u0002\u0013\u00051\n\u0003\u0005O\u0001\tE\t\u0015!\u0003/\u0011!y\u0005A!f\u0001\n\u0003Y\u0005\u0002\u0003)\u0001\u0005#\u0005\u000b\u0011\u0002\u0018\t\u000bE\u0003A\u0011\u0001*\t\u0011]\u0003\u0001R1A\u0005B-CQ\u0001\u0017\u0001\u0005BeCQA\u0019\u0001\u0005B\rDQ!\u001c\u0001\u0005\u00029DQ\u0001\u001d\u0001\u0005\u0012EDqa\u001e\u0001\u0002\u0002\u0013\u0005\u0001\u0010C\u0004}\u0001E\u0005I\u0011A?\t\u0011\u0005E\u0001!%A\u0005\u0002uD\u0001\"a\u0005\u0001#\u0003%\t! \u0005\n\u0003+\u0001\u0011\u0011!C!\u0003/A\u0011\"a\n\u0001\u0003\u0003%\t!!\u000b\t\u0013\u0005E\u0002!!A\u0005\u0002\u0005M\u0002\"CA \u0001\u0005\u0005I\u0011IA!\u0011%\ty\u0005AA\u0001\n\u0003\t\t\u0006C\u0005\u0002\\\u0001\t\t\u0011\"\u0011\u0002^!I\u0011\u0011\r\u0001\u0002\u0002\u0013\u0005\u00131M\u0004\n\u0003\u000f\u0003\u0013\u0011!E\u0001\u0003\u00133\u0001b\b\u0011\u0002\u0002#\u0005\u00111\u0012\u0005\u0007#f!\t!a)\t\u0013\u0005\u0015\u0016$!A\u0005F\u0005\u001d\u0006\"CAU3\u0005\u0005I\u0011QAV\u0011%\t\u0019,GA\u0001\n\u0003\u000b)\fC\u0005\u0002Hf\t\t\u0011\"\u0003\u0002J\nI1\u000b\u001d7jiB\u000b'\u000f\u001e\u0006\u0003C\t\n1\"\u001a=qe\u0016\u001c8/[8og*\u00111\u0005J\u0001\tG\u0006$\u0018\r\\=ti*\u0011QEJ\u0001\u0004gFd'BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0004\u0001M1\u0001A\f\u001a6qy\u0002\"a\f\u0019\u000e\u0003\u0001J!!\r\u0011\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u00020g%\u0011A\u0007\t\u0002\u0013%VtG/[7f%\u0016\u0004H.Y2fC\ndW\r\u0005\u00020m%\u0011q\u0007\t\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\t9\u0001K]8ek\u000e$\bCA H\u001d\t\u0001UI\u0004\u0002B\t6\t!I\u0003\u0002DY\u00051AH]8pizJ\u0011aO\u0005\u0003\rj\nq\u0001]1dW\u0006<W-\u0003\u0002I\u0013\na1+\u001a:jC2L'0\u00192mK*\u0011aIO\u0001\u0004gR\u0014X#\u0001\u0018\u0002\tM$(\u000fI\u0001\nI\u0016d\u0017.\\5uKJ\f!\u0002Z3mS6LG/\u001a:!\u0003\u001d\u0001\u0018M\u001d;Ok6\f\u0001\u0002]1si:+X\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tM#VK\u0016\t\u0003_\u0001AQAS\u0004A\u00029BQ!T\u0004A\u00029BQaT\u0004A\u00029\n1B]3qY\u0006\u001cW-\\3oi\u0006Aan\u001c3f\u001d\u0006lW-F\u0001[!\tYvL\u0004\u0002];B\u0011\u0011IO\u0005\u0003=j\na\u0001\u0015:fI\u00164\u0017B\u00011b\u0005\u0019\u0019FO]5oO*\u0011aLO\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u00013\u0011\u0007}*w-\u0003\u0002g\u0013\n\u00191+Z9\u0011\u0005!\\W\"A5\u000b\u0005)$\u0013!\u0002;za\u0016\u001c\u0018B\u00017j\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005dQ&dGM]3o+\u0005y\u0007cA f]\u00059r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0003]IDQa\u001d\u0007A\u0002Q\f1B\\3x\u0007\"LG\u000e\u001a:f]B\u0019q(\u001e\u0018\n\u0005YL%AC%oI\u0016DX\rZ*fc\u0006!1m\u001c9z)\u0011\u0019\u0016P_>\t\u000f)k\u0001\u0013!a\u0001]!9Q*\u0004I\u0001\u0002\u0004q\u0003bB(\u000e!\u0003\u0005\rAL\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005q(F\u0001\u0018\u0000W\t\t\t\u0001\u0005\u0003\u0002\u0004\u00055QBAA\u0003\u0015\u0011\t9!!\u0003\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0006u\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0011Q\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u0004\t\u0005\u00037\t)#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\r\u0012\u0001\u00026bm\u0006L1\u0001YA\u000f\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tY\u0003E\u0002:\u0003[I1!a\f;\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t)$a\u000f\u0011\u0007e\n9$C\u0002\u0002:i\u00121!\u00118z\u0011%\tidEA\u0001\u0002\u0004\tY#A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0007\u0002b!!\u0012\u0002L\u0005URBAA$\u0015\r\tIEO\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA'\u0003\u000f\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111KA-!\rI\u0014QK\u0005\u0004\u0003/R$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003{)\u0012\u0011!a\u0001\u0003k\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011\u0011DA0\u0011%\tiDFA\u0001\u0002\u0004\tY#\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003'\n)\u0007C\u0005\u0002>]\t\t\u00111\u0001\u00026!\u001a\u0002!!\u001b\u0002p\u0005E\u0014QOA<\u0003w\ni(!!\u0002\u0004B\u0019q&a\u001b\n\u0007\u00055\u0004EA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005M\u0014a!\u0017\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006f\u001d;sY\u0001\"W\r\\5nSR,'\u000f\f\u0011qCJ$h*^7*A5\u00023\u000b\u001d7jiN\u0004\u0003m\u001d;sA\u0002\u0012\u0017\u0010\t3fY&l\u0017\u000e^3sA\u0005tG\r\t:fiV\u0014hN\u0003\u0011!A\u0001\u0002\u0003E]3rk\u0016\u001cH/\u001a3!a\u0006\u0014H\u000fI8gAQDW\rI:qY&$\b\u0005K\u0019.E\u0006\u001cX\rZ\u0015/A%3\u0007%\u00198zA%t\u0007/\u001e;!SN\u0004c.\u001e7mY\u0001\u0012X\r^;s]N\u0004c.\u001e7m])\u0001\u0003\u0005\t\u0011!A%4\u0007\u0005\u00199beRtU/\u001c1!SN\u0004s.\u001e;!_\u001a\u0004#/\u00198hK\u0002zg\rI:qY&$\b\u0005]1siNd\u0003E]3ukJt7\u000fI3naRL\be\u001d;sS:<g\u0006I%gA\u0001\u0004\u0018M\u001d;Ok6\u0004\u0007%[:!a1R\u0001\u0005\t\u0011!A\u0001\"\bN]8xg\u0002\ng\u000eI3se>\u0014h\u0006I%gA\u0001\u0004\u0018M\u001d;Ok6\u0004\u0007%[:!]\u0016<\u0017\r^5wK2\u0002C\u000f[3!a\u0006\u0014Ho\u001d\u0011be\u0016\u00043m\\;oi\u0016$\u0007EY1dW^\f'\u000f\u001a\u0011ge>l\u0007\u0005\u001e5f\u0015\u0001\u0002\u0003\u0005\t\u0011!K:$\u0007e\u001c4!i\",\u0007e\u001d;sS:<g\u0006I%gAQDW\r\t1eK2LW.\u001b;fe\u0002\u0004\u0013n\u001d\u0011b]\u0002*W\u000e\u001d;zAM$(/\u001b8hY\u0001\"\b.\u001a\u0011agR\u0014\b\rI5tA9|G\u000fI:qY&$hF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA=\u0003\u0019S\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ\u00192]E\u0012d&M\u001a(Y\u0001:cf\n\u0017!g%Z$\u0002\t\u0011!A\u0001\u0002\u0003%M\u001a\u000bA\u0001\nQa]5oG\u0016\f#!a \u0002\u000bMr3G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005\u0015\u0015\u0001D:ue&twm\u00184v]\u000e\u001c\u0018!C*qY&$\b+\u0019:u!\ty\u0013dE\u0003\u001a\u0003\u001b\u000bI\n\u0005\u0005\u0002\u0010\u0006UeF\f\u0018T\u001b\t\t\tJC\u0002\u0002\u0014j\nqA];oi&lW-\u0003\u0003\u0002\u0018\u0006E%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogA!\u00111TAQ\u001b\t\tiJ\u0003\u0003\u0002 \u0006\u0005\u0012AA5p\u0013\rA\u0015Q\u0014\u000b\u0003\u0003\u0013\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00033\tQ!\u00199qYf$raUAW\u0003_\u000b\t\fC\u0003K9\u0001\u0007a\u0006C\u0003N9\u0001\u0007a\u0006C\u0003P9\u0001\u0007a&A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005]\u00161\u0019\t\u0006s\u0005e\u0016QX\u0005\u0004\u0003wS$AB(qi&|g\u000e\u0005\u0004:\u0003\u007fscFL\u0005\u0004\u0003\u0003T$A\u0002+va2,7\u0007\u0003\u0005\u0002Fv\t\t\u00111\u0001T\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003\u0017\u0004B!a\u0007\u0002N&!\u0011qZA\u000f\u0005\u0019y%M[3di\u0002")
public class SplitPart
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
Serializable {
    private Expression replacement;
    private final Expression str;
    private final Expression delimiter;
    private final Expression partNum;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(SplitPart x$0) {
        return SplitPart$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, SplitPart> tupled() {
        return SplitPart$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, SplitPart>>> curried() {
        return SplitPart$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        SplitPart splitPart = this;
        synchronized (splitPart) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression str() {
        return this.str;
    }

    public Expression delimiter() {
        return this.delimiter;
    }

    public Expression partNum() {
        return this.partNum;
    }

    private Expression replacement$lzycompute() {
        SplitPart splitPart = this;
        synchronized (splitPart) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = new ElementAt(new StringSplitSQL(this.str(), this.delimiter()), this.partNum(), (Option<Literal>)new Some((Object)Literal$.MODULE$.create("", this.str().dataType())), false);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public String nodeName() {
        return "split_part";
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public Seq<Expression> children() {
        return new .colon.colon((Object)this.str(), (List)new .colon.colon((Object)this.delimiter(), (List)new .colon.colon((Object)this.partNum(), (List)Nil$.MODULE$)));
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Expression)newChildren.apply(2));
    }

    public SplitPart copy(Expression str, Expression delimiter, Expression partNum) {
        return new SplitPart(str, delimiter, partNum);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.delimiter();
    }

    public Expression copy$default$3() {
        return this.partNum();
    }

    @Override
    public String productPrefix() {
        return "SplitPart";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.str();
            }
            case 1: {
                return this.delimiter();
            }
            case 2: {
                return this.partNum();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SplitPart;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "str";
            }
            case 1: {
                return "delimiter";
            }
            case 2: {
                return "partNum";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SplitPart)) return false;
        boolean bl = true;
        if (!bl) return false;
        SplitPart splitPart = (SplitPart)x$1;
        Expression expression = this.str();
        Expression expression2 = splitPart.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.delimiter();
        Expression expression4 = splitPart.delimiter();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.partNum();
        Expression expression6 = splitPart.partNum();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!splitPart.canEqual(this)) return false;
        return true;
    }

    public SplitPart(Expression str, Expression delimiter, Expression partNum) {
        this.str = str;
        this.delimiter = delimiter;
        this.partNum = partNum;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }
}

