/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringDecode$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.GlobalValue;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(bin, charset) - Decodes the first argument using the second argument character set. If either argument is null, the result will also be null.", examples="\n    Examples:\n      > SELECT _FUNC_(encode('abc', 'utf-8'), 'utf-8');\n       abc\n  ", arguments="\n    Arguments:\n      * bin - a binary expression to decode\n      * charset - one of the charsets 'US-ASCII', 'ISO-8859-1', 'UTF-8', 'UTF-16BE', 'UTF-16LE', 'UTF-16', 'UTF-32' to decode `bin` into a STRING. It is case insensitive.\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t]b\u0001B\u0013'\u0001NB\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\t1\u0002\u0011\t\u0012)A\u0005+\"A\u0011\f\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005[\u0001\tE\t\u0015!\u0003V\u0011!Y\u0006A!f\u0001\n\u0003a\u0006\u0002\u00031\u0001\u0005#\u0005\u000b\u0011B/\t\u000b\u0005\u0004A\u0011\u00012\t\u000b\u0005\u0004A\u0011A4\t\u000b)\u0004A\u0011\t+\t\u000b-\u0004A\u0011\t+\t\u000b1\u0004A\u0011I7\t\u000bQ\u0004A\u0011I;\t\u000fq\u0004!\u0019!C\u0005{\"9\u0011Q\u0004\u0001!\u0002\u0013q\bbBA\u0010\u0001\u0011E\u0013\u0011\u0005\u0005\b\u0003c\u0001A\u0011IA\u001a\u0011\u001d\ty\u0005\u0001C)\u0003#Bq!a\u0017\u0001\t\u0003\ni\u0006C\u0005\u0002n\u0001\t\t\u0011\"\u0001\u0002p!I\u0011q\u000f\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0010\u0005\n\u0003\u001f\u0003\u0011\u0013!C\u0001\u0003sB\u0011\"!%\u0001#\u0003%\t!a%\t\u0013\u0005]\u0005!!A\u0005B\u0005e\u0005\"CAN\u0001\u0005\u0005I\u0011AAO\u0011%\t)\u000bAA\u0001\n\u0003\t9\u000bC\u0005\u0002.\u0002\t\t\u0011\"\u0011\u00020\"I\u0011\u0011\u0018\u0001\u0002\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003\u007f\u0003\u0011\u0011!C!\u0003\u0003D\u0011\"!2\u0001\u0003\u0003%\t%a2\b\u000f\u0005Eh\u0005#\u0001\u0002t\u001a1QE\nE\u0001\u0003kDa!Y\u0010\u0005\u0002\t\u001d\u0001b\u0002B\u0005?\u0011\u0005!1\u0002\u0005\n\u0005\u0013y\u0012\u0011!CA\u0005#A\u0011B!\u0007 \u0003\u0003%\tIa\u0007\t\u0013\t5r$!A\u0005\n\t=\"\u0001D*ue&tw\rR3d_\u0012,'BA\u0014)\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005%R\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005-b\u0013aA:rY*\u0011QFL\u0001\u0006gB\f'o\u001b\u0006\u0003_A\na!\u00199bG\",'\"A\u0019\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001!\u0004h\u000f\"I!\t)d'D\u0001'\u0013\t9dE\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011Q'O\u0005\u0003u\u0019\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003y}r!!N\u001f\n\u0005y2\u0013a\u00029bG.\fw-Z\u0005\u0003\u0001\u0006\u0013aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002?MA\u00111IR\u0007\u0002\t*\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\t\n9\u0001K]8ek\u000e$\bCA%Q\u001d\tQuJ\u0004\u0002L\u001d6\tAJ\u0003\u0002Ne\u00051AH]8pizJ\u0011!R\u0005\u0003}\u0011K!!\u0015*\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005y\"\u0015a\u00012j]V\tQ\u000b\u0005\u00026-&\u0011qK\n\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001\u00022j]\u0002\nqa\u00195beN,G/\u0001\u0005dQ\u0006\u00148/\u001a;!\u00039aWmZ1ds\u000eC\u0017M]:fiN,\u0012!\u0018\t\u0003\u0007zK!a\u0018#\u0003\u000f\t{w\u000e\\3b]\u0006yA.Z4bGf\u001c\u0005.\u0019:tKR\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0005G\u0012,g\r\u0005\u00026\u0001!)1k\u0002a\u0001+\")\u0011l\u0002a\u0001+\")1l\u0002a\u0001;R\u00191\r[5\t\u000bMC\u0001\u0019A+\t\u000beC\u0001\u0019A+\u0002\t1,g\r^\u0001\u0006e&<\u0007\u000e^\u0001\tI\u0006$\u0018\rV=qKV\ta\u000e\u0005\u0002pe6\t\u0001O\u0003\u0002rU\u0005)A/\u001f9fg&\u00111\u000f\u001d\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003Y\u00042!S<z\u0013\tA(KA\u0002TKF\u0004\"a\u001c>\n\u0005m\u0004(\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003E\u0019X\u000f\u001d9peR,Gm\u00115beN,Go]\u000b\u0002}B)q0!\u0003\u0002\u000e5\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!A\u0005j[6,H/\u00192mK*\u0019\u0011q\u0001#\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\f\u0005\u0005!aA*fiB!\u0011qBA\r\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011\u0001\u00027b]\u001eT!!a\u0006\u0002\t)\fg/Y\u0005\u0005\u00037\t\tB\u0001\u0004TiJLgnZ\u0001\u0013gV\u0004\bo\u001c:uK\u0012\u001c\u0005.\u0019:tKR\u001c\b%\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0004\u0002$\u0005%\u0012Q\u0006\t\u0004\u0007\u0006\u0015\u0012bAA\u0014\t\n\u0019\u0011I\\=\t\u000f\u0005-r\u00021\u0001\u0002$\u00051\u0011N\u001c9viFBq!a\f\u0010\u0001\u0004\t\u0019#\u0001\u0004j]B,HOM\u0001\nI><UM\\\"pI\u0016$b!!\u000e\u0002B\u0005-\u0003\u0003BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005mb%A\u0004d_\u0012,w-\u001a8\n\t\u0005}\u0012\u0011\b\u0002\t\u000bb\u0004(oQ8eK\"9\u00111\t\tA\u0002\u0005\u0015\u0013aA2uqB!\u0011qGA$\u0013\u0011\tI%!\u000f\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011Q\n\tA\u0002\u0005U\u0012AA3w\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003d\u0003'\n9\u0006\u0003\u0004\u0002VE\u0001\r!V\u0001\b]\u0016<H*\u001a4u\u0011\u0019\tI&\u0005a\u0001+\u0006Aa.Z<SS\u001eDG/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!a\u0018\u0011\t\u0005\u0005\u0014\u0011\u000e\b\u0005\u0003G\n)\u0007\u0005\u0002L\t&\u0019\u0011q\r#\u0002\rA\u0013X\rZ3g\u0013\u0011\tY\"a\u001b\u000b\u0007\u0005\u001dD)\u0001\u0003d_BLHcB2\u0002r\u0005M\u0014Q\u000f\u0005\b'N\u0001\n\u00111\u0001V\u0011\u001dI6\u0003%AA\u0002UCqaW\n\u0011\u0002\u0003\u0007Q,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005m$fA+\u0002~-\u0012\u0011q\u0010\t\u0005\u0003\u0003\u000bY)\u0004\u0002\u0002\u0004*!\u0011QQAD\u0003%)hn\u00195fG.,GMC\u0002\u0002\n\u0012\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ti)a!\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0013\u0016\u0004;\u0006u\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u000e\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0014\t\u0004\u0007\u0006\u0005\u0016bAAR\t\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111EAU\u0011%\tY+GA\u0001\u0002\u0004\ty*A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003c\u0003b!a-\u00026\u0006\rRBAA\u0003\u0013\u0011\t9,!\u0002\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004;\u0006u\u0006\"CAV7\u0005\u0005\t\u0019AA\u0012\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u00055\u00111\u0019\u0005\n\u0003Wc\u0012\u0011!a\u0001\u0003?\u000ba!Z9vC2\u001cHcA/\u0002J\"I\u00111V\u000f\u0002\u0002\u0003\u0007\u00111\u0005\u0015\u0018\u0001\u00055\u00171[Ak\u00033\fY.a8\u0002b\u0006\u0015\u0018q]Av\u0003[\u00042!NAh\u0013\r\t\tN\n\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t9.AA\u0015?\u001a+fjQ0)E&tG\u0006I2iCJ\u001cX\r^\u0015![\u0001\"UmY8eKN\u0004C\u000f[3!M&\u00148\u000f\u001e\u0011be\u001e,X.\u001a8uAU\u001c\u0018N\\4!i\",\u0007e]3d_:$\u0007%\u0019:hk6,g\u000e\u001e\u0011dQ\u0006\u0014\u0018m\u0019;fe\u0002\u001aX\r\u001e\u0018!\u0013\u001a\u0004S-\u001b;iKJ\u0004\u0013M]4v[\u0016tG\u000fI5tA9,H\u000e\u001c\u0017!i\",\u0007E]3tk2$\be^5mY\u0002\nGn]8!E\u0016\u0004c.\u001e7m]\u0005AQ\r_1na2,7/\t\u0002\u0002^\u0006!&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK3oG>$W\rK\u0014bE\u000e<C\u0006I\u0014vi\u001al\u0003hJ\u0015-A\u001d*HOZ\u00179O%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\u00192d\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\t\u0019/AAj\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002#-\u001b8![\u0001\n\u0007EY5oCJL\b%\u001a=qe\u0016\u001c8/[8oAQ|\u0007\u0005Z3d_\u0012,'\u0002\t\u0011!A\u0001\u0002#\u0006I2iCJ\u001cX\r\u001e\u0011.A=tW\rI8gAQDW\rI2iCJ\u001cX\r^:!OU\u001bV&Q*D\u0013&;C\u0006I\u0014J'>k\u0003\bO\u001b:[E:C\u0006I\u0014V)\u001ak\u0003h\n\u0017!OU#f)L\u00197\u0005\u0016;C\u0006I\u0014V)\u001ak\u0013G\u000e'FO1\u0002s%\u0016+G[E2t\u0005\f\u0011(+R3Uf\r\u001a(AQ|\u0007\u0005Z3d_\u0012,\u0007\u0005\u00192j]\u0002\u0004\u0013N\u001c;pA\u0005\u00043\u000b\u0016*J\u001d\u001es\u0003%\u0013;!SN\u00043-Y:fA%t7/\u001a8tSRLg/\u001a\u0018\u000bA\u0001\nQa]5oG\u0016\f#!!;\u0002\u000bErSG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005=\u0018\u0001D:ue&twm\u00184v]\u000e\u001c\u0018\u0001D*ue&tw\rR3d_\u0012,\u0007CA\u001b '\u0015y\u0012q_A\u007f!\r\u0019\u0015\u0011`\u0005\u0004\u0003w$%AB!osJ+g\r\u0005\u0003\u0002\u0000\n\u0015QB\u0001B\u0001\u0015\u0011\u0011\u0019!!\u0006\u0002\u0005%|\u0017bA)\u0003\u0002Q\u0011\u00111_\u0001\u0006CB\u0004H.\u001f\u000b\u0006G\n5!q\u0002\u0005\u0006'\u0006\u0002\r!\u0016\u0005\u00063\u0006\u0002\r!\u0016\u000b\bG\nM!Q\u0003B\f\u0011\u0015\u0019&\u00051\u0001V\u0011\u0015I&\u00051\u0001V\u0011\u0015Y&\u00051\u0001^\u0003\u001d)h.\u00199qYf$BA!\b\u0003*A)1Ia\b\u0003$%\u0019!\u0011\u0005#\u0003\r=\u0003H/[8o!\u0019\u0019%QE+V;&\u0019!q\u0005#\u0003\rQ+\b\u000f\\34\u0011!\u0011YcIA\u0001\u0002\u0004\u0019\u0017a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!\u0011\u0007\t\u0005\u0003\u001f\u0011\u0019$\u0003\u0003\u00036\u0005E!AB(cU\u0016\u001cG\u000f")
public class StringDecode
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression bin;
    private final Expression charset;
    private final boolean legacyCharsets;
    private final Set<String> supportedCharsets;

    public static Option<Tuple3<Expression, Expression, Object>> unapply(StringDecode x$0) {
        return StringDecode$.MODULE$.unapply(x$0);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression bin() {
        return this.bin;
    }

    public Expression charset() {
        return this.charset;
    }

    public boolean legacyCharsets() {
        return this.legacyCharsets;
    }

    @Override
    public Expression left() {
        return this.bin();
    }

    @Override
    public Expression right() {
        return this.charset();
    }

    @Override
    public DataType dataType() {
        return SQLConf$.MODULE$.get().defaultStringType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)Nil$.MODULE$));
    }

    private Set<String> supportedCharsets() {
        return this.supportedCharsets;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        UTF8String uTF8String;
        String fromCharset = ((UTF8String)input2).toString();
        try {
            if (!this.legacyCharsets() && !this.supportedCharsets().contains((Object)fromCharset.toUpperCase(Locale.ROOT))) {
                throw new UnsupportedEncodingException();
            }
            uTF8String = UTF8String.fromString((String)new String((byte[])input1, fromCharset));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw QueryExecutionErrors$.MODULE$.invalidCharsetError(this.prettyName(), fromCharset);
        }
        return uTF8String;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(bytes, charset) -> {
            String fromCharset = ctx.freshName("fromCharset");
            GlobalValue sc = JavaCode$.MODULE$.global(ctx.addReferenceObj("supportedCharsets", this.supportedCharsets(), ctx.addReferenceObj$default$3()), this.supportedCharsets().getClass());
            return "\n        String " + fromCharset + " = " + charset + ".toString();\n        try {\n          if (" + this.legacyCharsets() + " || " + sc + ".contains(" + fromCharset + ".toUpperCase(java.util.Locale.ROOT))) {\n            " + ev.value() + " = UTF8String.fromString(new String(" + bytes + ", " + fromCharset + "));\n          } else {\n            throw new java.io.UnsupportedEncodingException();\n          }\n        } catch (java.io.UnsupportedEncodingException e) {\n          throw QueryExecutionErrors.invalidCharsetError(\"" + this.prettyName() + "\", " + fromCharset + ");\n        }\n      ";
        });
    }

    @Override
    public StringDecode withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    @Override
    public String prettyName() {
        return "decode";
    }

    public StringDecode copy(Expression bin, Expression charset, boolean legacyCharsets) {
        return new StringDecode(bin, charset, legacyCharsets);
    }

    public Expression copy$default$1() {
        return this.bin();
    }

    public Expression copy$default$2() {
        return this.charset();
    }

    public boolean copy$default$3() {
        return this.legacyCharsets();
    }

    @Override
    public String productPrefix() {
        return "StringDecode";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.bin();
            }
            case 1: {
                return this.charset();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.legacyCharsets());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringDecode;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "bin";
            }
            case 1: {
                return "charset";
            }
            case 2: {
                return "legacyCharsets";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringDecode)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringDecode stringDecode = (StringDecode)x$1;
        if (this.legacyCharsets() != stringDecode.legacyCharsets()) return false;
        Expression expression = this.bin();
        Expression expression2 = stringDecode.bin();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.charset();
        Expression expression4 = stringDecode.charset();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!stringDecode.canEqual(this)) return false;
        return true;
    }

    public StringDecode(Expression bin, Expression charset, boolean legacyCharsets) {
        this.bin = bin;
        this.charset = charset;
        this.legacyCharsets = legacyCharsets;
        ExpectsInputTypes.$init$(this);
        this.supportedCharsets = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"US-ASCII", "ISO-8859-1", "UTF-8", "UTF-16BE", "UTF-16LE", "UTF-16", "UTF-32"}));
    }

    public StringDecode(Expression bin, Expression charset) {
        this(bin, charset, SQLConf$.MODULE$.get().legacyJavaCharsets());
    }
}

