/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringLocate$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(substr, str[, pos]) - Returns the position of the first occurrence of `substr` in `str` after position `pos`.\n      The given `pos` and return value are 1-based.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('bar', 'foobarbar');\n       4\n      > SELECT _FUNC_('bar', 'foobarbar', 5);\n       7\n      > SELECT POSITION('bar' IN 'foobarbar');\n       4\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\rb\u0001\u0002\u0014(\u0001RB\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t'\u0002\u0011\t\u0012)A\u0005!\"AA\u000b\u0001BK\u0002\u0013\u0005q\n\u0003\u0005V\u0001\tE\t\u0015!\u0003Q\u0011!1\u0006A!f\u0001\n\u0003y\u0005\u0002C,\u0001\u0005#\u0005\u000b\u0011\u0002)\t\u000ba\u0003A\u0011A-\t\u000ba\u0003A\u0011\u00010\t\u0011\u0005\u0004\u0001R1A\u0005\u0006\tDQA\u001a\u0001\u0005B=CQa\u001a\u0001\u0005B=CQ\u0001\u001b\u0001\u0005B=CQ!\u001b\u0001\u0005B)DQA\u001c\u0001\u0005B=DQA\u001e\u0001\u0005B]DQA \u0001\u0005B}Dq!a\u0005\u0001\t#\n)\u0002C\u0004\u00022\u0001!\t%a\r\t\u000f\u0005\u0015\u0003\u0001\"\u0015\u0002H!I\u0011Q\u000b\u0001\u0002\u0002\u0013\u0005\u0011q\u000b\u0005\n\u0003?\u0002\u0011\u0013!C\u0001\u0003CB\u0011\"a\u001e\u0001#\u0003%\t!!\u0019\t\u0013\u0005e\u0004!%A\u0005\u0002\u0005\u0005\u0004\"CA>\u0001\u0005\u0005I\u0011IA?\u0011!\ti\tAA\u0001\n\u0003\u0011\u0007\"CAH\u0001\u0005\u0005I\u0011AAI\u0011%\t9\nAA\u0001\n\u0003\nI\nC\u0005\u0002(\u0002\t\t\u0011\"\u0001\u0002*\"I\u0011Q\u0016\u0001\u0002\u0002\u0013\u0005\u0013q\u0016\u0005\n\u0003g\u0003\u0011\u0011!C!\u0003k;\u0011\"!7(\u0003\u0003E\t!a7\u0007\u0011\u0019:\u0013\u0011!E\u0001\u0003;Da\u0001\u0017\u0011\u0005\u0002\u0005U\b\"CA|A\u0005\u0005IQIA}\u0011%\tY\u0010IA\u0001\n\u0003\u000bi\u0010C\u0005\u0003\u0006\u0001\n\t\u0011\"!\u0003\b!I!\u0011\u0004\u0011\u0002\u0002\u0013%!1\u0004\u0002\r'R\u0014\u0018N\\4M_\u000e\fG/\u001a\u0006\u0003Q%\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011!fK\u0001\tG\u0006$\u0018\r\\=ti*\u0011A&L\u0001\u0004gFd'B\u0001\u00180\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0014'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002e\u0005\u0019qN]4\u0004\u0001M)\u0001!N\u001d=\u0005B\u0011agN\u0007\u0002O%\u0011\u0001h\n\u0002\u0012)\u0016\u0014h.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001c;\u0013\tYtE\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\ti\u0004)D\u0001?\u0015\u0005y\u0014!B:dC2\f\u0017BA!?\u0005\u001d\u0001&o\u001c3vGR\u0004\"aQ&\u000f\u0005\u0011KeBA#I\u001b\u00051%BA$4\u0003\u0019a$o\\8u}%\tq(\u0003\u0002K}\u00059\u0001/Y2lC\u001e,\u0017B\u0001'N\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tQe(\u0001\u0004tk\n\u001cHO]\u000b\u0002!B\u0011a'U\u0005\u0003%\u001e\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u001d\u0019XOY:ue\u0002\n1a\u001d;s\u0003\u0011\u0019HO\u001d\u0011\u0002\u000bM$\u0018M\u001d;\u0002\rM$\u0018M\u001d;!\u0003\u0019a\u0014N\\5u}Q!!l\u0017/^!\t1\u0004\u0001C\u0003O\u000f\u0001\u0007\u0001\u000bC\u0003U\u000f\u0001\u0007\u0001\u000bC\u0003W\u000f\u0001\u0007\u0001\u000bF\u0002[?\u0002DQA\u0014\u0005A\u0002ACQ\u0001\u0016\u0005A\u0002A\u000b1bY8mY\u0006$\u0018n\u001c8JIV\t1\r\u0005\u0002>I&\u0011QM\u0010\u0002\u0004\u0013:$\u0018!\u00024jeN$\u0018AB:fG>tG-A\u0003uQ&\u0014H-\u0001\u0005ok2d\u0017M\u00197f+\u0005Y\u0007CA\u001fm\u0013\tigHA\u0004C_>dW-\u00198\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012\u0001\u001d\t\u0003cRl\u0011A\u001d\u0006\u0003g.\nQ\u0001^=qKNL!!\u001e:\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005A\bcA\"zw&\u0011!0\u0014\u0002\u0004'\u0016\f\bCA9}\u0013\ti(O\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006!QM^1m)\u0011\t\t!a\u0002\u0011\u0007u\n\u0019!C\u0002\u0002\u0006y\u00121!\u00118z\u0011%\tI\u0001\u0005I\u0001\u0002\u0004\tY!A\u0003j]B,H\u000f\u0005\u0003\u0002\u000e\u0005=Q\"A\u0015\n\u0007\u0005E\u0011FA\u0006J]R,'O\\1m%><\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t9\"a\t\u0002.A!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001e\u001d\nqaY8eK\u001e,g.\u0003\u0003\u0002\"\u0005m!\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005\u0015\u0012\u00031\u0001\u0002(\u0005\u00191\r\u001e=\u0011\t\u0005e\u0011\u0011F\u0005\u0005\u0003W\tYB\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005=\u0012\u00031\u0001\u0002\u0018\u0005\u0011QM^\u0001\u000baJ,G\u000f^=OC6,WCAA\u001b!\u0011\t9$a\u0010\u000f\t\u0005e\u00121\b\t\u0003\u000bzJ1!!\u0010?\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011IA\"\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\b \u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGc\u0002.\u0002J\u00055\u0013\u0011\u000b\u0005\u0007\u0003\u0017\u001a\u0002\u0019\u0001)\u0002\u00119,wOR5sgRDa!a\u0014\u0014\u0001\u0004\u0001\u0016!\u00038foN+7m\u001c8e\u0011\u0019\t\u0019f\u0005a\u0001!\u0006Aa.Z<UQ&\u0014H-\u0001\u0003d_BLHc\u0002.\u0002Z\u0005m\u0013Q\f\u0005\b\u001dR\u0001\n\u00111\u0001Q\u0011\u001d!F\u0003%AA\u0002ACqA\u0016\u000b\u0011\u0002\u0003\u0007\u0001+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\r$f\u0001)\u0002f-\u0012\u0011q\r\t\u0005\u0003S\n\u0019(\u0004\u0002\u0002l)!\u0011QNA8\u0003%)hn\u00195fG.,GMC\u0002\u0002ry\n!\"\u00198o_R\fG/[8o\u0013\u0011\t)(a\u001b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a \u0011\t\u0005\u0005\u00151R\u0007\u0003\u0003\u0007SA!!\"\u0002\b\u0006!A.\u00198h\u0015\t\tI)\u0001\u0003kCZ\f\u0017\u0002BA!\u0003\u0007\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0002\u0005M\u0005\u0002CAK5\u0005\u0005\t\u0019A2\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\n\u0005\u0004\u0002\u001e\u0006\r\u0016\u0011A\u0007\u0003\u0003?S1!!)?\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003K\u000byJ\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA6\u0002,\"I\u0011Q\u0013\u000f\u0002\u0002\u0003\u0007\u0011\u0011A\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u0000\u0005E\u0006\u0002CAK;\u0005\u0005\t\u0019A2\u0002\r\u0015\fX/\u00197t)\rY\u0017q\u0017\u0005\n\u0003+s\u0012\u0011!a\u0001\u0003\u0003A3\u0003AA^\u0003\u0003\f\u0019-a2\u0002J\u00065\u0017qZAj\u0003+\u00042ANA_\u0013\r\tyl\n\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t)-AA1\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK:vEN$(\u000f\f\u0011tiJ\\F\u0006\t9pgvK\u0003%\f\u0011SKR,(O\\:!i\",\u0007\u0005]8tSRLwN\u001c\u0011pM\u0002\"\b.\u001a\u0011gSJ\u001cH\u000fI8dGV\u0014(/\u001a8dK\u0002zg\r\t1tk\n\u001cHO\u001d1!S:\u0004\u0003m\u001d;sA\u0002\ng\r^3sAA|7/\u001b;j_:\u0004\u0003\r]8tA:R\u0001\u0005\t\u0011!A\u0001\"\u0006.\u001a\u0011hSZ,g\u000e\t1q_N\u0004\u0007%\u00198eAI,G/\u001e:oAY\fG.^3!CJ,\u0007%M\u0017cCN,GM\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002L\u0006\tIG\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(E\u0006\u0014x\u0005\f\u0011(M>|'-\u0019:cCJ<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00115\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":#-\u0019:(Y\u0001:cm\\8cCJ\u0014\u0017M]\u0014-AUJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001c\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAA{5+\u0013+J\u001f:CsEY1sO\u0001Je\nI\u0014g_>\u0014\u0017M\u001d2be\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001b\u000bA\u0001\nQa]5oG\u0016\f#!!5\u0002\u000bErSG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005]\u0017\u0001D:ue&twm\u00184v]\u000e\u001c\u0018\u0001D*ue&tw\rT8dCR,\u0007C\u0001\u001c!'\u0015\u0001\u0013q\\Av!!\t\t/a:Q!BSVBAAr\u0015\r\t)OP\u0001\beVtG/[7f\u0013\u0011\tI/a9\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0005\u0003\u0002n\u0006MXBAAx\u0015\u0011\t\t0a\"\u0002\u0005%|\u0017b\u0001'\u0002pR\u0011\u00111\\\u0001\ti>\u001cFO]5oOR\u0011\u0011qP\u0001\u0006CB\u0004H.\u001f\u000b\b5\u0006}(\u0011\u0001B\u0002\u0011\u0015q5\u00051\u0001Q\u0011\u0015!6\u00051\u0001Q\u0011\u001516\u00051\u0001Q\u0003\u001d)h.\u00199qYf$BA!\u0003\u0003\u0016A)QHa\u0003\u0003\u0010%\u0019!Q\u0002 \u0003\r=\u0003H/[8o!\u0019i$\u0011\u0003)Q!&\u0019!1\u0003 \u0003\rQ+\b\u000f\\34\u0011!\u00119\u0002JA\u0001\u0002\u0004Q\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!Q\u0004\t\u0005\u0003\u0003\u0013y\"\u0003\u0003\u0003\"\u0005\r%AB(cU\u0016\u001cG\u000f")
public class StringLocate
extends TernaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private int collationId;
    private final Expression substr;
    private final Expression str;
    private final Expression start;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringLocate x$0) {
        return StringLocate$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringLocate> tupled() {
        return StringLocate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringLocate>>> curried() {
        return StringLocate$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression substr() {
        return this.substr;
    }

    public Expression str() {
        return this.str;
    }

    public Expression start() {
        return this.start;
    }

    private int collationId$lzycompute() {
        StringLocate stringLocate = this;
        synchronized (stringLocate) {
            if (!this.bitmap$0) {
                this.collationId = ((StringType)this.first().dataType()).collationId();
                this.bitmap$0 = true;
            }
        }
        return this.collationId;
    }

    public final int collationId() {
        if (!this.bitmap$0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    @Override
    public Expression first() {
        return this.substr();
    }

    @Override
    public Expression second() {
        return this.str();
    }

    @Override
    public Expression third() {
        return this.start();
    }

    @Override
    public boolean nullable() {
        return this.substr().nullable() || this.str().nullable();
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public Object eval(InternalRow input) {
        Object s = this.start().eval(input);
        if (s == null) {
            return BoxesRunTime.boxToInteger((int)0);
        }
        Object r = this.substr().eval(input);
        if (r == null) {
            return null;
        }
        Object l = this.str().eval(input);
        if (l == null) {
            return null;
        }
        int sVal = BoxesRunTime.unboxToInt((Object)s);
        if (sVal < 1) {
            return BoxesRunTime.boxToInteger((int)0);
        }
        return BoxesRunTime.boxToInteger((int)(CollationSupport.StringLocate.exec((UTF8String)((UTF8String)l), (UTF8String)((UTF8String)r), (int)(BoxesRunTime.unboxToInt((Object)s) - 1), (int)this.collationId()) + 1));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode substrGen = this.substr().genCode(ctx);
        ExprCode strGen = this.str().genCode(ctx);
        ExprCode startGen = this.start().genCode(ctx);
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      int ", " = 0;\n      boolean ", " = false;\n      ", "\n      if (!", ") {\n        ", "\n        if (!", ") {\n          ", "\n          if (!", ") {\n            if (", " > 0) {\n              ", " = CollationSupport.StringLocate.exec(", ",\n              ", ", ", " - 1, ", ") + 1;\n            }\n          } else {\n            ", " = true;\n          }\n        } else {\n          ", " = true;\n        }\n      }\n     "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), ev.isNull(), startGen.code(), startGen.isNull(), substrGen.code(), substrGen.isNull(), strGen.code(), strGen.isNull(), startGen.value(), ev.value(), strGen.value(), substrGen.value(), startGen.value(), BoxesRunTime.boxToInteger((int)this.collationId()), ev.isNull(), ev.isNull()})), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "locate");
    }

    @Override
    public StringLocate withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringLocate copy(Expression substr, Expression str, Expression start) {
        return new StringLocate(substr, str, start);
    }

    public Expression copy$default$1() {
        return this.substr();
    }

    public Expression copy$default$2() {
        return this.str();
    }

    public Expression copy$default$3() {
        return this.start();
    }

    @Override
    public String productPrefix() {
        return "StringLocate";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.substr();
            }
            case 1: {
                return this.str();
            }
            case 2: {
                return this.start();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringLocate;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "substr";
            }
            case 1: {
                return "str";
            }
            case 2: {
                return "start";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringLocate)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringLocate stringLocate = (StringLocate)x$1;
        Expression expression = this.substr();
        Expression expression2 = stringLocate.substr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.str();
        Expression expression4 = stringLocate.str();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.start();
        Expression expression6 = stringLocate.start();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringLocate.canEqual(this)) return false;
        return true;
    }

    public StringLocate(Expression substr, Expression str, Expression start) {
        this.substr = substr;
        this.str = str;
        this.start = start;
        ExpectsInputTypes.$init$(this);
    }

    public StringLocate(Expression substr, Expression str) {
        this(substr, str, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

