/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.internal.types.StringTypeBinaryLcase$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005e4Qa\u0003\u0007\u0002\u0002eAQa\u000b\u0001\u0005\u00021BQA\f\u0001\u0007\u0002=BQa\u0010\u0001\u0007\u0002\u0001CQA\u0015\u0001\u0005BMC\u0001B\u0019\u0001\t\u0006\u0004%)a\u0019\u0005\tO\u0002A)\u0019!C\u0003G\"A\u0001\u000e\u0001EC\u0002\u0013%\u0011\u000eC\u0003k\u0001\u0011E1\u000eC\u0003n\u0001\u0011Ea\u000eC\u0003q\u0001\u0011E\u0013OA\u000bTiJLgn\u001a*fO\u0016DX\t\u001f9sKN\u001c\u0018n\u001c8\u000b\u00055q\u0011aC3yaJ,7o]5p]NT!a\u0004\t\u0002\u0011\r\fG/\u00197zgRT!!\u0005\n\u0002\u0007M\fHN\u0003\u0002\u0014)\u0005)1\u000f]1sW*\u0011QCF\u0001\u0007CB\f7\r[3\u000b\u0003]\t1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u000e\u001fC!\u0002\"a\u0007\u000f\u000e\u00031I!!\b\u0007\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u000e \u0013\t\u0001CB\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t\u0011SE\u0004\u0002\u001cG%\u0011A\u0005D\u0001\ba\u0006\u001c7.Y4f\u0013\t1sE\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005\u0011b\u0001CA\u000e*\u0013\tQCBA\u0005Qe\u0016$\u0017nY1uK\u00061A(\u001b8jiz\"\u0012!\f\t\u00037\u0001\ta!Z:dCB,GC\u0001\u0019>!\t\t$H\u0004\u00023qA\u00111GN\u0007\u0002i)\u0011Q\u0007G\u0001\u0007yI|w\u000e\u001e \u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0002\rA\u0013X\rZ3g\u0013\tYDH\u0001\u0004TiJLgn\u001a\u0006\u0003sYBQA\u0010\u0002A\u0002A\n\u0011A^\u0001\b[\u0006$8\r[3t)\r\tU\t\u0015\t\u0003\u0005\u000ek\u0011AN\u0005\u0003\tZ\u0012qAQ8pY\u0016\fg\u000eC\u0003G\u0007\u0001\u0007q)A\u0003sK\u001e,\u0007\u0010\u0005\u0002I\u001d6\t\u0011J\u0003\u0002G\u0015*\u00111\nT\u0001\u0005kRLGNC\u0001N\u0003\u0011Q\u0017M^1\n\u0005=K%a\u0002)biR,'O\u001c\u0005\u0006#\u000e\u0001\r\u0001M\u0001\u0004gR\u0014\u0018AC5oaV$H+\u001f9fgV\tA\u000bE\u0002V3rs!A\u0016-\u000f\u0005M:\u0016\"A\u001c\n\u0005\u00112\u0014B\u0001.\\\u0005\r\u0019V-\u001d\u0006\u0003IY\u0002\"!\u00181\u000e\u0003yS!a\u0018\t\u0002\u000bQL\b/Z:\n\u0005\u0005t&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003-\u0019w\u000e\u001c7bi&|g.\u00133\u0016\u0003\u0011\u0004\"AQ3\n\u0005\u00194$aA%oi\u0006\u00192m\u001c7mCRLwN\u001c*fO\u0016Dh\t\\1hg\u0006)1-Y2iKV\tq)A\u0004d_6\u0004\u0018\u000e\\3\u0015\u0005\u001dc\u0007\"B)\t\u0001\u0004\u0001\u0014a\u00029biR,'O\u001c\u000b\u0003\u000f>DQ!U\u0005A\u0002A\nAB\\;mYN\u000bg-Z#wC2$2A];x!\t\u00115/\u0003\u0002um\t\u0019\u0011I\\=\t\u000bYT\u0001\u0019\u0001:\u0002\r%t\u0007/\u001e;2\u0011\u0015A(\u00021\u0001s\u0003\u0019Ig\u000e];ue\u0001")
public abstract class StringRegexExpression
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Predicate {
    private int collationId;
    private int collationRegexFlags;
    private Pattern cache;
    private volatile byte bitmap$0;

    @Override
    public DataType dataType() {
        return Predicate.dataType$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public abstract String escape(String var1);

    public abstract boolean matches(Pattern var1, String var2);

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeBinaryLcase$.MODULE$, (List)new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)Nil$.MODULE$));
    }

    private int collationId$lzycompute() {
        StringRegexExpression stringRegexExpression = this;
        synchronized (stringRegexExpression) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.collationId = ((StringType)((Expression)this.left()).dataType()).collationId();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.collationId;
    }

    public final int collationId() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    private int collationRegexFlags$lzycompute() {
        StringRegexExpression stringRegexExpression = this;
        synchronized (stringRegexExpression) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.collationRegexFlags = CollationSupport.collationAwareRegexFlags((int)this.collationId());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.collationRegexFlags;
    }

    public final int collationRegexFlags() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.collationRegexFlags$lzycompute();
        }
        return this.collationRegexFlags;
    }

    private Pattern cache$lzycompute() {
        StringRegexExpression stringRegexExpression = this;
        synchronized (stringRegexExpression) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                Expression expression;
                Expression expression2 = (Expression)this.right();
                this.cache = expression2 != null && (expression = expression2).foldable() ? this.compile(((UTF8String)expression.eval(expression.eval$default$1())).toString()) : null;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.cache;
    }

    private Pattern cache() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.cache$lzycompute();
        }
        return this.cache;
    }

    public Pattern compile(String str) {
        Pattern pattern;
        if (str == null) {
            return null;
        }
        try {
            pattern = Pattern.compile(this.escape(str), this.collationRegexFlags());
        }
        catch (PatternSyntaxException e) {
            throw QueryExecutionErrors$.MODULE$.invalidPatternError(this.prettyName(), e.getPattern(), e);
        }
        return pattern;
    }

    public Pattern pattern(String str) {
        if (this.cache() == null) {
            return this.compile(str);
        }
        return this.cache();
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        Pattern regex = this.pattern(((UTF8String)input2).toString());
        if (regex == null) {
            return null;
        }
        return BoxesRunTime.boxToBoolean((boolean)this.matches(regex, ((UTF8String)input1).toString()));
    }

    public StringRegexExpression() {
        ExpectsInputTypes.$init$(this);
        Predicate.$init$(this);
    }
}

