/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringRepeat$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str, n) - Returns the string which repeats the given string value n times.", examples="\n    Examples:\n      > SELECT _FUNC_('123', 2);\n       123123\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005}h\u0001B\u0010!\u00016B\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0012)A\u0005\u001f\"A1\u000b\u0001BK\u0002\u0013\u0005a\n\u0003\u0005U\u0001\tE\t\u0015!\u0003P\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015Q\u0006\u0001\"\u0011O\u0011\u0015Y\u0006\u0001\"\u0011O\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u0015!\u0007\u0001\"\u0011f\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u0015)\b\u0001\"\u0011w\u0011\u0019y\b\u0001\"\u0011\u0002\u0002!9\u0011Q\u0004\u0001\u0005R\u0005}\u0001\"CA\u0015\u0001\u0005\u0005I\u0011AA\u0016\u0011%\t\t\u0004AI\u0001\n\u0003\t\u0019\u0004C\u0005\u0002J\u0001\t\n\u0011\"\u0001\u00024!I\u00111\n\u0001\u0002\u0002\u0013\u0005\u0013Q\n\u0005\n\u0003;\u0002\u0011\u0011!C\u0001\u0003?B\u0011\"a\u001a\u0001\u0003\u0003%\t!!\u001b\t\u0013\u0005=\u0004!!A\u0005B\u0005E\u0004\"CA@\u0001\u0005\u0005I\u0011AAA\u0011%\tY\tAA\u0001\n\u0003\ni\tC\u0005\u0002\u0012\u0002\t\t\u0011\"\u0011\u0002\u0014\u001eI\u0011q\u0017\u0011\u0002\u0002#\u0005\u0011\u0011\u0018\u0004\t?\u0001\n\t\u0011#\u0001\u0002<\"1Q+\u0007C\u0001\u0003'D\u0011\"!6\u001a\u0003\u0003%)%a6\t\u0013\u0005e\u0017$!A\u0005\u0002\u0006m\u0007\"CAq3\u0005\u0005I\u0011QAr\u0011%\t)0GA\u0001\n\u0013\t9P\u0001\u0007TiJLgn\u001a*fa\u0016\fGO\u0003\u0002\"E\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0019C%\u0001\u0005dCR\fG._:u\u0015\t)c%A\u0002tc2T!a\n\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005%R\u0013AB1qC\u000eDWMC\u0001,\u0003\ry'oZ\u0002\u0001'\u0019\u0001aFM\u001b=\u0005B\u0011q\u0006M\u0007\u0002A%\u0011\u0011\u0007\t\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"aL\u001a\n\u0005Q\u0002#AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005YJdBA\u00188\u0013\tA\u0004%A\u0004qC\u000e\\\u0017mZ3\n\u0005iZ$A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003q\u0001\u0002\"!\u0010!\u000e\u0003yR\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003z\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002D\u0015:\u0011A)\u0013\b\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f2\na\u0001\u0010:p_Rt\u0014\"A \n\u0005ar\u0014BA&M\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tAd(A\u0002tiJ,\u0012a\u0014\t\u0003_AK!!\u0015\u0011\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0003tiJ\u0004\u0013!\u0002;j[\u0016\u001c\u0018A\u0002;j[\u0016\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0004/bK\u0006CA\u0018\u0001\u0011\u0015iU\u00011\u0001P\u0011\u0015\u0019V\u00011\u0001P\u0003\u0011aWM\u001a;\u0002\u000bILw\r\u001b;\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012A\u0018\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C\u0012\nQ\u0001^=qKNL!a\u00191\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\u00051\u0007cA\"hS&\u0011\u0001\u000e\u0014\u0002\u0004'\u0016\f\bCA0k\u0013\tY\u0007M\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0019a.]:\u0011\u0005uz\u0017B\u00019?\u0005\r\te.\u001f\u0005\u0006e*\u0001\rA\\\u0001\u0007gR\u0014\u0018N\\4\t\u000bQT\u0001\u0019\u00018\u0002\u00039\f!\u0002\u001d:fiRLh*Y7f+\u00059\bC\u0001=}\u001d\tI(\u0010\u0005\u0002F}%\u00111PP\u0001\u0007!J,G-\u001a4\n\u0005ut(AB*ue&twM\u0003\u0002|}\u0005IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003\u0007\ty!!\u0007\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003!\u0003\u001d\u0019w\u000eZ3hK:LA!!\u0004\u0002\b\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002\u00121\u0001\r!a\u0005\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\u0006\u0005U\u0011\u0002BA\f\u0003\u000f\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002\u001c1\u0001\r!a\u0001\u0002\u0005\u00154\u0018aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u00159\u0016\u0011EA\u0013\u0011\u0019\t\u0019#\u0004a\u0001\u001f\u00069a.Z<MK\u001a$\bBBA\u0014\u001b\u0001\u0007q*\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u000b]\u000bi#a\f\t\u000f5s\u0001\u0013!a\u0001\u001f\"91K\u0004I\u0001\u0002\u0004y\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003kQ3aTA\u001cW\t\tI\u0004\u0005\u0003\u0002<\u0005\u0015SBAA\u001f\u0015\u0011\ty$!\u0011\u0002\u0013Ut7\r[3dW\u0016$'bAA\"}\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0013Q\b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005=\u0003\u0003BA)\u00037j!!a\u0015\u000b\t\u0005U\u0013qK\u0001\u0005Y\u0006twM\u0003\u0002\u0002Z\u0005!!.\u0019<b\u0013\ri\u00181K\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003C\u00022!PA2\u0013\r\t)G\u0010\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004]\u0006-\u0004\"CA7'\u0005\u0005\t\u0019AA1\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u000f\t\u0006\u0003k\nYH\\\u0007\u0003\u0003oR1!!\u001f?\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003{\n9H\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAB\u0003\u0013\u00032!PAC\u0013\r\t9I\u0010\u0002\b\u0005>|G.Z1o\u0011!\ti'FA\u0001\u0002\u0004q\u0017A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u0014\u0002\u0010\"I\u0011Q\u000e\f\u0002\u0002\u0003\u0007\u0011\u0011M\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\r\u0015Q\u0013\u0005\t\u0003[:\u0012\u0011!a\u0001]\"\u001a\u0002!!'\u0002 \u0006\u0005\u0016QUAT\u0003W\u000bi+!-\u00024B\u0019q&a'\n\u0007\u0005u\u0005EA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\r\u0016!U0G+:\u001bu\fK:ue2\u0002c.\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011tiJLgn\u001a\u0011xQ&\u001c\u0007\u000e\t:fa\u0016\fGo\u001d\u0011uQ\u0016\u0004s-\u001b<f]\u0002\u001aHO]5oO\u00022\u0018\r\\;fA9\u0004C/[7fg:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003S\u000b\u0001I\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(cI\u001at\u0005\f\u00113SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013GM\u001a2eMR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003_\u000bQ!\r\u00186]A\nQa\u001a:pkB\f#!!.\u0002\u0019M$(/\u001b8h?\u001a,hnY:\u0002\u0019M#(/\u001b8h%\u0016\u0004X-\u0019;\u0011\u0005=J2#B\r\u0002>\u0006%\u0007cBA`\u0003\u000b|ujV\u0007\u0003\u0003\u0003T1!a1?\u0003\u001d\u0011XO\u001c;j[\u0016LA!a2\u0002B\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\u0005-\u0017\u0011[\u0007\u0003\u0003\u001bTA!a4\u0002X\u0005\u0011\u0011n\\\u0005\u0004\u0017\u00065GCAA]\u0003!!xn\u0015;sS:<GCAA(\u0003\u0015\t\u0007\u000f\u001d7z)\u00159\u0016Q\\Ap\u0011\u0015iE\u00041\u0001P\u0011\u0015\u0019F\u00041\u0001P\u0003\u001d)h.\u00199qYf$B!!:\u0002rB)Q(a:\u0002l&\u0019\u0011\u0011\u001e \u0003\r=\u0003H/[8o!\u0015i\u0014Q^(P\u0013\r\tyO\u0010\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005MX$!AA\u0002]\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\tI\u0010\u0005\u0003\u0002R\u0005m\u0018\u0002BA\u007f\u0003'\u0012aa\u00142kK\u000e$\b")
public class StringRepeat
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression str;
    private final Expression times;

    public static Option<Tuple2<Expression, Expression>> unapply(StringRepeat x$0) {
        return StringRepeat$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, StringRepeat> tupled() {
        return StringRepeat$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, StringRepeat>> curried() {
        return StringRepeat$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression times() {
        return this.times;
    }

    @Override
    public Expression left() {
        return this.str();
    }

    @Override
    public Expression right() {
        return this.times();
    }

    @Override
    public DataType dataType() {
        return this.str().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public Object nullSafeEval(Object string, Object n) {
        return ((UTF8String)string).repeat(Predef$.MODULE$.Integer2int((Integer)n));
    }

    @Override
    public String prettyName() {
        return "repeat";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(l, r) -> "(" + l + ").repeat(" + r + ")");
    }

    @Override
    public StringRepeat withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public StringRepeat copy(Expression str, Expression times) {
        return new StringRepeat(str, times);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.times();
    }

    @Override
    public String productPrefix() {
        return "StringRepeat";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.str();
            }
            case 1: {
                return this.times();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringRepeat;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "str";
            }
            case 1: {
                return "times";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringRepeat)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringRepeat stringRepeat = (StringRepeat)x$1;
        Expression expression = this.str();
        Expression expression2 = stringRepeat.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.times();
        Expression expression4 = stringRepeat.times();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!stringRepeat.canEqual(this)) return false;
        return true;
    }

    public StringRepeat(Expression str, Expression times) {
        this.str = str;
        this.times = times;
        ExpectsInputTypes.$init$(this);
    }
}

