/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringSplit$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.internal.types.StringTypeBinaryLcase$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str, regex, limit) - Splits `str` around occurrences that match `regex` and returns an array with a length of at most `limit`", arguments="\n    Arguments:\n      * str - a string expression to split.\n      * regex - a string representing a regular expression. The regex string should be a\n        Java regular expression.\n      * limit - an integer expression which controls the number of times the regex is applied.\n          * limit > 0: The resulting array's length will not be more than `limit`,\n            and the resulting array's last entry will contain all input\n            beyond the last matched regex.\n          * limit <= 0: `regex` will be applied as many times as possible, and\n            the resulting array can be of any size.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]');\n       [\"one\",\"two\",\"three\",\"\"]\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]', -1);\n       [\"one\",\"two\",\"three\",\"\"]\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]', 2);\n       [\"one\",\"twoBthreeC\"]\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t5b\u0001B\u0013'\u0001NB\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\t1\u0002\u0011\t\u0012)A\u0005+\"A\u0011\f\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005[\u0001\tE\t\u0015!\u0003V\u0011!Y\u0006A!f\u0001\n\u0003!\u0006\u0002\u0003/\u0001\u0005#\u0005\u000b\u0011B+\t\u000bu\u0003A\u0011\u00010\t\u000b\r\u0004A\u0011\t3\t\u000b-\u0004A\u0011\t7\t\u000bM\u0004A\u0011\t+\t\u000bQ\u0004A\u0011\t+\t\u000bU\u0004A\u0011\t+\t\u0011Y\u0004\u0001R1A\u0005\u0006]DQ!\u0018\u0001\u0005\u0002mDaa \u0001\u0005B\u0005\u0005\u0001bBA\t\u0001\u0011\u0005\u00131\u0003\u0005\b\u0003_\u0001A\u0011IA\u0019\u0011\u001d\t\u0019\u0005\u0001C)\u0003\u000bB\u0011\"a\u0015\u0001\u0003\u0003%\t!!\u0016\t\u0013\u0005u\u0003!%A\u0005\u0002\u0005}\u0003\"CA;\u0001E\u0005I\u0011AA0\u0011%\t9\bAI\u0001\n\u0003\ty\u0006C\u0005\u0002z\u0001\t\t\u0011\"\u0011\u0002|!A\u00111\u0012\u0001\u0002\u0002\u0013\u0005q\u000fC\u0005\u0002\u000e\u0002\t\t\u0011\"\u0001\u0002\u0010\"I\u0011Q\u0013\u0001\u0002\u0002\u0013\u0005\u0013q\u0013\u0005\n\u0003K\u0003\u0011\u0011!C\u0001\u0003OC\u0011\"!-\u0001\u0003\u0003%\t%a-\t\u0013\u0005]\u0006!!A\u0005B\u0005ev!CArM\u0005\u0005\t\u0012AAs\r!)c%!A\t\u0002\u0005\u001d\bBB/ \t\u0003\ty\u0010C\u0005\u0003\u0002}\t\t\u0011\"\u0012\u0003\u0004!I!QA\u0010\u0002\u0002\u0013\u0005%q\u0001\u0005\n\u0005\u001fy\u0012\u0011!CA\u0005#A\u0011Ba\t \u0003\u0003%IA!\n\u0003\u0017M#(/\u001b8h'Bd\u0017\u000e\u001e\u0006\u0003O!\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0011FK\u0001\tG\u0006$\u0018\r\\=ti*\u00111\u0006L\u0001\u0004gFd'BA\u0017/\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0003'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002c\u0005\u0019qN]4\u0004\u0001M1\u0001\u0001\u000e\u001d<\u0005\"\u0003\"!\u000e\u001c\u000e\u0003\u0019J!a\u000e\u0014\u0003#Q+'O\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00026s%\u0011!H\n\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011Ah\u0010\b\u0003kuJ!A\u0010\u0014\u0002\u000fA\f7m[1hK&\u0011\u0001)\u0011\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\tqd\u0005\u0005\u0002D\r6\tAIC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9EIA\u0004Qe>$Wo\u0019;\u0011\u0005%\u0003fB\u0001&P\u001d\tYe*D\u0001M\u0015\ti%'\u0001\u0004=e>|GOP\u0005\u0002\u000b&\u0011a\bR\u0005\u0003#J\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!A\u0010#\u0002\u0007M$(/F\u0001V!\t)d+\u0003\u0002XM\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\tM$(\u000fI\u0001\u0006e\u0016<W\r_\u0001\u0007e\u0016<W\r\u001f\u0011\u0002\u000b1LW.\u001b;\u0002\r1LW.\u001b;!\u0003\u0019a\u0014N\\5u}Q!q\fY1c!\t)\u0004\u0001C\u0003T\u000f\u0001\u0007Q\u000bC\u0003Z\u000f\u0001\u0007Q\u000bC\u0003\\\u000f\u0001\u0007Q+\u0001\u0005eCR\fG+\u001f9f+\u0005)\u0007C\u00014j\u001b\u00059'B\u00015+\u0003\u0015!\u0018\u0010]3t\u0013\tQwM\u0001\u0005ECR\fG+\u001f9f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002[B\u0019\u0011J\u001c9\n\u0005=\u0014&aA*fcB\u0011a-]\u0005\u0003e\u001e\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u000b\u0019L'o\u001d;\u0002\rM,7m\u001c8e\u0003\u0015!\b.\u001b:e\u0003-\u0019w\u000e\u001c7bi&|g.\u00133\u0016\u0003a\u0004\"aQ=\n\u0005i$%aA%oiR\u0019q\f @\t\u000but\u0001\u0019A+\u0002\u0007\u0015D\b\u000fC\u0003Z\u001d\u0001\u0007Q+\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0005\u0002\u0004\u0005%\u0011QBA\b!\r\u0019\u0015QA\u0005\u0004\u0003\u000f!%aA!os\"9\u00111B\bA\u0002\u0005\r\u0011AB:ue&tw\r\u0003\u0004Z\u001f\u0001\u0007\u00111\u0001\u0005\u00077>\u0001\r!a\u0001\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA\u000b\u0003C\tY\u0003\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tYBJ\u0001\bG>$WmZ3o\u0013\u0011\ty\"!\u0007\u0003\u0011\u0015C\bO]\"pI\u0016Dq!a\t\u0011\u0001\u0004\t)#A\u0002dib\u0004B!a\u0006\u0002(%!\u0011\u0011FA\r\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!!\f\u0011\u0001\u0004\t)\"\u0001\u0002fm\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005M\u0002\u0003BA\u001b\u0003{qA!a\u000e\u0002:A\u00111\nR\u0005\u0004\u0003w!\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002@\u0005\u0005#AB*ue&twMC\u0002\u0002<\u0011\u000bqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000f}\u000b9%a\u0013\u0002P!1\u0011\u0011\n\nA\u0002U\u000b\u0001B\\3x\r&\u00148\u000f\u001e\u0005\u0007\u0003\u001b\u0012\u0002\u0019A+\u0002\u00139,woU3d_:$\u0007BBA)%\u0001\u0007Q+\u0001\u0005oK^$\u0006.\u001b:e\u0003\u0011\u0019w\u000e]=\u0015\u000f}\u000b9&!\u0017\u0002\\!91k\u0005I\u0001\u0002\u0004)\u0006bB-\u0014!\u0003\u0005\r!\u0016\u0005\b7N\u0001\n\u00111\u0001V\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u0019+\u0007U\u000b\u0019g\u000b\u0002\u0002fA!\u0011qMA9\u001b\t\tIG\u0003\u0003\u0002l\u00055\u0014!C;oG\",7m[3e\u0015\r\ty\u0007R\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA:\u0003S\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003{\u0002B!a \u0002\n6\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b))\u0001\u0003mC:<'BAAD\u0003\u0011Q\u0017M^1\n\t\u0005}\u0012\u0011Q\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019!!%\t\u0011\u0005M\u0015$!AA\u0002a\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAM!\u0019\tY*!)\u0002\u00045\u0011\u0011Q\u0014\u0006\u0004\u0003?#\u0015AC2pY2,7\r^5p]&!\u00111UAO\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005%\u0016q\u0016\t\u0004\u0007\u0006-\u0016bAAW\t\n9!i\\8mK\u0006t\u0007\"CAJ7\u0005\u0005\t\u0019AA\u0002\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005u\u0014Q\u0017\u0005\t\u0003'c\u0012\u0011!a\u0001q\u00061Q-];bYN$B!!+\u0002<\"I\u00111S\u000f\u0002\u0002\u0003\u0007\u00111\u0001\u0015\u0018\u0001\u0005}\u0016QYAd\u0003\u0017\fi-!5\u0002T\u0006]\u0017\u0011\\Ao\u0003?\u00042!NAa\u0013\r\t\u0019M\n\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\tI-AA\u0005?\u001a+fjQ0)gR\u0014H\u0006\t:fO\u0016DH\u0006\t7j[&$\u0018\u0006I\u0017!'Bd\u0017\u000e^:!AN$(\u000f\u0019\u0011be>,h\u000e\u001a\u0011pG\u000e,(O]3oG\u0016\u001c\b\u0005\u001e5bi\u0002j\u0017\r^2iA\u0001\u0014XmZ3yA\u0002\ng\u000e\u001a\u0011sKR,(O\\:!C:\u0004\u0013M\u001d:bs\u0002:\u0018\u000e\u001e5!C\u0002bWM\\4uQ\u0002zg\rI1uA5|7\u000f\u001e\u0011aY&l\u0017\u000e\u001e1\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAAh\u0003\u0011\u0005'\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011tiJ\u0004S\u0006I1!gR\u0014\u0018N\\4!Kb\u0004(/Z:tS>t\u0007\u0005^8!gBd\u0017\u000e\u001e\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+AI,w-\u001a=![\u0001\n\u0007e\u001d;sS:<\u0007E]3qe\u0016\u001cXM\u001c;j]\u001e\u0004\u0013\r\t:fOVd\u0017M\u001d\u0011fqB\u0014Xm]:j_:t\u0003\u0005\u00165fAI,w-\u001a=!gR\u0014\u0018N\\4!g\"|W\u000f\u001c3!E\u0016\u0004\u0013M\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011KCZ\f\u0007E]3hk2\f'\u000fI3yaJ,7o]5p]:R\u0001\u0005\t\u0011!A\u0001R\u0003\u0005\\5nSR\u0004S\u0006I1oA%tG/Z4fe\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011xQ&\u001c\u0007\u000eI2p]R\u0014x\u000e\\:!i\",\u0007E\\;nE\u0016\u0014\be\u001c4!i&lWm\u001d\u0011uQ\u0016\u0004#/Z4fq\u0002J7\u000fI1qa2LW\r\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002#\u0006\t7j[&$\bE\u0010\u00111u\u0001\"\u0006.\u001a\u0011sKN,H\u000e^5oO\u0002\n'O]1zOM\u0004C.\u001a8hi\"\u0004s/\u001b7mA9|G\u000f\t2fA5|'/\u001a\u0011uQ\u0006t\u0007\u0005\u00197j[&$\b\r\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u00198eAQDW\r\t:fgVdG/\u001b8hA\u0005\u0014(/Y=(g\u0002b\u0017m\u001d;!K:$(/\u001f\u0011xS2d\u0007eY8oi\u0006Lg\u000eI1mY\u0002Jg\u000e];u\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011cKf|g\u000e\u001a\u0011uQ\u0016\u0004C.Y:uA5\fGo\u00195fI\u0002\u0012XmZ3y])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0016!Y&l\u0017\u000e\u001e\u0011={\u0001\u0002$\b\t1sK\u001e,\u0007\u0010\u0019\u0011xS2d\u0007EY3!CB\u0004H.[3eA\u0005\u001c\b%\\1os\u0002\"\u0018.\\3tA\u0005\u001c\b\u0005]8tg&\u0014G.\u001a\u0017!C:$'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"\b.\u001a\u0011sKN,H\u000e^5oO\u0002\n'O]1zA\r\fg\u000e\t2fA=4\u0007%\u00198zAML'0\u001a\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003+\f!Q\u0003\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O=tW-\u0011;x_\n#\bN]3f\u0007\u001eb\u0003eJ.B\u0005\u000ekv%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7\nzg.\u001a\u0012-EQ<xN\t\u0017#i\"\u0014X-\u001a\u0012-E\tj&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014p]\u0016\fEo^8Ci\"\u0014X-Z\"(Y\u0001:3,\u0011\"D;\u001eb\u0003%L\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001Z&e\u001c8fE1\u0012Co^8#Y\t\"\bN]3fE1\u0012#%\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O=tW-\u0011;x_\n#\bN]3f\u0007\u001eb\u0003eJ.B\u0005\u000ekv\u0005\f\u00113SmR\u0001\u0005\t\u0011!A\u0001\u00023LI8oK\nb#\u0005^<p\u0005RD'/Z3DEuS\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u00037\fQ!\r\u00186]A\nQa\u001a:pkB\f#!!9\u0002\u0019M$(/\u001b8h?\u001a,hnY:\u0002\u0017M#(/\u001b8h'Bd\u0017\u000e\u001e\t\u0003k}\u0019RaHAu\u0003k\u0004\u0002\"a;\u0002rV+VkX\u0007\u0003\u0003[T1!a<E\u0003\u001d\u0011XO\u001c;j[\u0016LA!a=\u0002n\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\u0005]\u0018Q`\u0007\u0003\u0003sTA!a?\u0002\u0006\u0006\u0011\u0011n\\\u0005\u0004#\u0006eHCAAs\u0003!!xn\u0015;sS:<GCAA?\u0003\u0015\t\u0007\u000f\u001d7z)\u001dy&\u0011\u0002B\u0006\u0005\u001bAQa\u0015\u0012A\u0002UCQ!\u0017\u0012A\u0002UCQa\u0017\u0012A\u0002U\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u0014\t}\u0001#B\"\u0003\u0016\te\u0011b\u0001B\f\t\n1q\n\u001d;j_:\u0004ba\u0011B\u000e+V+\u0016b\u0001B\u000f\t\n1A+\u001e9mKNB\u0001B!\t$\u0003\u0003\u0005\raX\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\u0014!\u0011\tyH!\u000b\n\t\t-\u0012\u0011\u0011\u0002\u0007\u001f\nTWm\u0019;")
public class StringSplit
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private int collationId;
    private final Expression str;
    private final Expression regex;
    private final Expression limit;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringSplit x$0) {
        return StringSplit$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringSplit> tupled() {
        return StringSplit$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringSplit>>> curried() {
        return StringSplit$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression regex() {
        return this.regex;
    }

    public Expression limit() {
        return this.limit;
    }

    @Override
    public DataType dataType() {
        return new ArrayType(this.str().dataType(), false);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeBinaryLcase$.MODULE$, (List)new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public Expression first() {
        return this.str();
    }

    @Override
    public Expression second() {
        return this.regex();
    }

    @Override
    public Expression third() {
        return this.limit();
    }

    private int collationId$lzycompute() {
        StringSplit stringSplit = this;
        synchronized (stringSplit) {
            if (!this.bitmap$0) {
                this.collationId = ((StringType)this.str().dataType()).collationId();
                this.bitmap$0 = true;
            }
        }
        return this.collationId;
    }

    public final int collationId() {
        if (!this.bitmap$0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    @Override
    public Object nullSafeEval(Object string, Object regex, Object limit) {
        UTF8String pattern = CollationSupport.collationAwareRegex((UTF8String)((UTF8String)regex), (int)this.collationId());
        UTF8String[] strings = ((UTF8String)string).split(pattern, BoxesRunTime.unboxToInt((Object)limit));
        return new GenericArrayData(strings);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String arrayClass = GenericArrayData.class.getName();
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(str, regex, limit) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(ev.value() + " = new " + arrayClass + "(" + str + ".split(\n         |CollationSupport.collationAwareRegex(" + regex + ", " + this.collationId() + ")," + limit + "));")));
    }

    @Override
    public String prettyName() {
        return "split";
    }

    @Override
    public StringSplit withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringSplit copy(Expression str, Expression regex, Expression limit) {
        return new StringSplit(str, regex, limit);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.regex();
    }

    public Expression copy$default$3() {
        return this.limit();
    }

    @Override
    public String productPrefix() {
        return "StringSplit";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.str();
            }
            case 1: {
                return this.regex();
            }
            case 2: {
                return this.limit();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringSplit;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "str";
            }
            case 1: {
                return "regex";
            }
            case 2: {
                return "limit";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringSplit)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringSplit stringSplit = (StringSplit)x$1;
        Expression expression = this.str();
        Expression expression2 = stringSplit.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regex();
        Expression expression4 = stringSplit.regex();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.limit();
        Expression expression6 = stringSplit.limit();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringSplit.canEqual(this)) return false;
        return true;
    }

    public StringSplit(Expression str, Expression regex, Expression limit) {
        this.str = str;
        this.regex = regex;
        this.limit = limit;
        ExpectsInputTypes.$init$(this);
    }

    public StringSplit(Expression exp, Expression regex) {
        this(exp, regex, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)-1)));
    }
}

