/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringToMap$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(text[, pairDelim[, keyValueDelim]]) - Creates a map after splitting the text into key/value pairs using delimiters. Default delimiters are ',' for `pairDelim` and ':' for `keyValueDelim`. Both `pairDelim` and `keyValueDelim` are treated as regular expressions.", examples="\n    Examples:\n      > SELECT _FUNC_('a:1,b:2,c:3', ',', ':');\n       {\"a\":\"1\",\"b\":\"2\",\"c\":\"3\"}\n      > SELECT _FUNC_('a');\n       {\"a\":null}\n  ", since="2.0.1", group="map_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0015c\u0001B\u0014)\u0001VB\u0001\"\u0016\u0001\u0003\u0016\u0004%\tA\u0016\u0005\t5\u0002\u0011\t\u0012)A\u0005/\"A1\f\u0001BK\u0002\u0013\u0005a\u000b\u0003\u0005]\u0001\tE\t\u0015!\u0003X\u0011!i\u0006A!f\u0001\n\u00031\u0006\u0002\u00030\u0001\u0005#\u0005\u000b\u0011B,\t\u000b}\u0003A\u0011\u00011\t\u000b}\u0003A\u0011A3\t\u000b}\u0003A\u0011A5\t\u000b-\u0004A\u0011\t7\t\u000bA\u0004A\u0011\t,\t\u000bE\u0004A\u0011\t,\t\u000bI\u0004A\u0011\t,\t\u000bM\u0004A\u0011\t;\t\u000by\u0004A\u0011I@\t\u0015\u0005\u001d\u0001\u0001#b\u0001\n\u0013\tI\u0001C\u0004\u0002\u0018\u0001!\t%!\u0007\t\u000f\u00055\u0002\u0001\"\u0015\u00020!9\u00111\n\u0001\u0005B\u00055\u0003bBA0\u0001\u0011E\u0013\u0011\r\u0005\n\u0003_\u0002\u0011\u0011!C\u0001\u0003cB\u0011\"!\u001f\u0001#\u0003%\t!a\u001f\t\u0013\u0005E\u0005!%A\u0005\u0002\u0005m\u0004\"CAJ\u0001E\u0005I\u0011AA>\u0011%\t)\nAA\u0001\n\u0003\n9\nC\u0005\u0002(\u0002\t\t\u0011\"\u0001\u0002*\"I\u0011\u0011\u0017\u0001\u0002\u0002\u0013\u0005\u00111\u0017\u0005\n\u0003s\u0003\u0011\u0011!C!\u0003wC\u0011\"!3\u0001\u0003\u0003%\t!a3\t\u0013\u0005=\u0007!!A\u0005B\u0005E\u0007\"CAk\u0001\u0005\u0005I\u0011IAl\u000f%\tY\u0010KA\u0001\u0012\u0003\tiP\u0002\u0005(Q\u0005\u0005\t\u0012AA\u0000\u0011\u0019y\u0016\u0005\"\u0001\u0003\u0018!I!\u0011D\u0011\u0002\u0002\u0013\u0015#1\u0004\u0005\n\u0005;\t\u0013\u0011!CA\u0005?A\u0011Ba\n\"\u0003\u0003%\tI!\u000b\t\u0013\tm\u0012%!A\u0005\n\tu\"aC*ue&tw\rV8NCBT!!\u000b\u0016\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003W1\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003[9\n1a]9m\u0015\ty\u0003'A\u0003ta\u0006\u00148N\u0003\u00022e\u00051\u0011\r]1dQ\u0016T\u0011aM\u0001\u0004_J<7\u0001A\n\u0007\u0001YRT\b\u0012&\u0011\u0005]BT\"\u0001\u0015\n\u0005eB#!\u0005+fe:\f'/_#yaJ,7o]5p]B\u0011qgO\u0005\u0003y!\u0012\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\tq\u0014I\u0004\u00028\u007f%\u0011\u0001\tK\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00115I\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005\u0001C\u0003CA#I\u001b\u00051%\"A$\u0002\u000bM\u001c\u0017\r\\1\n\u0005%3%a\u0002)s_\u0012,8\r\u001e\t\u0003\u0017Js!\u0001T)\u000f\u00055\u0003V\"\u0001(\u000b\u0005=#\u0014A\u0002\u001fs_>$h(C\u0001H\u0013\t\u0001e)\u0003\u0002T)\na1+\u001a:jC2L'0\u00192mK*\u0011\u0001IR\u0001\u0005i\u0016DH/F\u0001X!\t9\u0004,\u0003\u0002ZQ\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000bQ,\u0007\u0010\u001e\u0011\u0002\u0013A\f\u0017N\u001d#fY&l\u0017A\u00039bSJ$U\r\\5nA\u0005i1.Z=WC2,X\rR3mS6\fab[3z-\u0006dW/\u001a#fY&l\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005C\n\u001cG\r\u0005\u00028\u0001!)Qk\u0002a\u0001/\")1l\u0002a\u0001/\")Ql\u0002a\u0001/R\u0019\u0011M\u001a5\t\u000b\u001dD\u0001\u0019A,\u0002\u000b\rD\u0017\u000e\u001c3\t\u000bmC\u0001\u0019A,\u0015\u0005\u0005T\u0007\"B4\n\u0001\u00049\u0016\u0001C:uCR,g-\u001e7\u0016\u00035\u0004\"!\u00128\n\u0005=4%a\u0002\"p_2,\u0017M\\\u0001\u0006M&\u00148\u000f^\u0001\u0007g\u0016\u001cwN\u001c3\u0002\u000bQD\u0017N\u001d3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001v!\rYe\u000f_\u0005\u0003oR\u00131aU3r!\tIH0D\u0001{\u0015\tYH&A\u0003usB,7/\u0003\u0002~u\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\u0011\u0011\u0011\u0001\t\u0004s\u0006\r\u0011bAA\u0003u\nAA)\u0019;b)f\u0004X-\u0001\u0006nCB\u0014U/\u001b7eKJ,\"!a\u0003\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u0005+\u0003\u0011)H/\u001b7\n\t\u0005U\u0011q\u0002\u0002\u0015\u0003J\u0014\u0018-\u001f\"bg\u0016$W*\u00199Ck&dG-\u001a:\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0011\u0005m\u0011\u0011EA\u0013\u0003S\u00012!RA\u000f\u0013\r\tyB\u0012\u0002\u0004\u0003:L\bbBA\u0012#\u0001\u0007\u00111D\u0001\fS:\u0004X\u000f^*ue&tw\rC\u0004\u0002(E\u0001\r!a\u0007\u0002\u001fM$(/\u001b8h\t\u0016d\u0017.\\5uKJDq!a\u000b\u0012\u0001\u0004\tY\"A\tlKf4\u0016\r\\;f\t\u0016d\u0017.\\5uKJ\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005E\u0012QHA$!\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"bAA\u001cQ\u000591m\u001c3fO\u0016t\u0017\u0002BA\u001e\u0003k\u0011\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003\u007f\u0011\u0002\u0019AA!\u0003\r\u0019G\u000f\u001f\t\u0005\u0003g\t\u0019%\u0003\u0003\u0002F\u0005U\"AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003\u0013\u0012\u0002\u0019AA\u0019\u0003\t)g/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!a\u0014\u0011\t\u0005E\u0013\u0011\f\b\u0005\u0003'\n)\u0006\u0005\u0002N\r&\u0019\u0011q\u000b$\u0002\rA\u0013X\rZ3g\u0013\u0011\tY&!\u0018\u0003\rM#(/\u001b8h\u0015\r\t9FR\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$raVA2\u0003O\nY\u0007\u0003\u0004\u0002fQ\u0001\raV\u0001\t]\u0016<h)\u001b:ti\"1\u0011\u0011\u000e\u000bA\u0002]\u000b\u0011B\\3x'\u0016\u001cwN\u001c3\t\r\u00055D\u00031\u0001X\u0003!qWm\u001e+iSJ$\u0017\u0001B2paf$r!YA:\u0003k\n9\bC\u0004V+A\u0005\t\u0019A,\t\u000fm+\u0002\u0013!a\u0001/\"9Q,\u0006I\u0001\u0002\u00049\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003{R3aVA@W\t\t\t\t\u0005\u0003\u0002\u0004\u00065UBAAC\u0015\u0011\t9)!#\u0002\u0013Ut7\r[3dW\u0016$'bAAF\r\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0015Q\u0011\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u0014\t\u0005\u00037\u000b)+\u0004\u0002\u0002\u001e*!\u0011qTAQ\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\r\u0016\u0001\u00026bm\u0006LA!a\u0017\u0002\u001e\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u0016\t\u0004\u000b\u00065\u0016bAAX\r\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111DA[\u0011%\t9lGA\u0001\u0002\u0004\tY+A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003{\u0003b!a0\u0002F\u0006mQBAAa\u0015\r\t\u0019MR\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAd\u0003\u0003\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019Q.!4\t\u0013\u0005]V$!AA\u0002\u0005m\u0011A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!'\u0002T\"I\u0011q\u0017\u0010\u0002\u0002\u0003\u0007\u00111V\u0001\u0007KF,\u0018\r\\:\u0015\u00075\fI\u000eC\u0005\u00028~\t\t\u00111\u0001\u0002\u001c!\u001a\u0002!!8\u0002d\u0006\u0015\u0018\u0011^Av\u0003_\f\t0!>\u0002xB\u0019q'a8\n\u0007\u0005\u0005\bFA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\u001d\u0018Aa\u0006`\rVs5i\u0018\u0015uKb$8\f\f\u0011qC&\u0014H)\u001a7j[nc\u0003e[3z-\u0006dW/\u001a#fY&lW,X\u0015![\u0001\u001a%/Z1uKN\u0004\u0013\rI7ba\u0002\ng\r^3sAM\u0004H.\u001b;uS:<\u0007\u0005\u001e5fAQ,\u0007\u0010\u001e\u0011j]R|\u0007e[3z_Y\fG.^3!a\u0006L'o\u001d\u0011vg&tw\r\t3fY&l\u0017\u000e^3sg:\u0002C)\u001a4bk2$\b\u0005Z3mS6LG/\u001a:tA\u0005\u0014X\rI\u0014-O\u00012wN\u001d\u0011aa\u0006L'\u000fR3mS6\u0004\u0007%\u00198eA\u001dRt\u0005\t4pe\u0002\u00027.Z=WC2,X\rR3mS6\u0004g\u0006\t\"pi\"\u0004\u0003\r]1je\u0012+G.[7aA\u0005tG\r\t1lKf4\u0016\r\\;f\t\u0016d\u0017.\u001c1!CJ,\u0007\u0005\u001e:fCR,G\rI1tAI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\\:/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAw\u0003\u0005\u0005\"\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014buEb#M\u000f\u001a-Gj\u001at\u0005\f\u0011(Y\u001db\u0003e\n\u001e(SmR\u0001\u0005\t\u0011!A\u0001\u00023PI1#u\t\n$\u0005\f\u0012cEi\u0012#G\t\u0017#G\nR$e\r\u0012~\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013mJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0014\u0013M\t\u001eok2dWP\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t\u00190A\u00033]Ar\u0013'A\u0003he>,\b/\t\u0002\u0002z\u0006IQ.\u00199`MVt7m]\u0001\f'R\u0014\u0018N\\4U_6\u000b\u0007\u000f\u0005\u00028CM)\u0011E!\u0001\u0003\u000eAA!1\u0001B\u0005/^;\u0016-\u0004\u0002\u0003\u0006)\u0019!q\u0001$\u0002\u000fI,h\u000e^5nK&!!1\u0002B\u0003\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0005\u001f\u0011)\"\u0004\u0002\u0003\u0012)!!1CAQ\u0003\tIw.C\u0002T\u0005#!\"!!@\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!'\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f\u0005\u0014\tCa\t\u0003&!)Q\u000b\na\u0001/\")1\f\na\u0001/\")Q\f\na\u0001/\u00069QO\\1qa2LH\u0003\u0002B\u0016\u0005o\u0001R!\u0012B\u0017\u0005cI1Aa\fG\u0005\u0019y\u0005\u000f^5p]B1QIa\rX/^K1A!\u000eG\u0005\u0019!V\u000f\u001d7fg!A!\u0011H\u0013\u0002\u0002\u0003\u0007\u0011-A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa\u0010\u0011\t\u0005m%\u0011I\u0005\u0005\u0005\u0007\niJ\u0001\u0004PE*,7\r\u001e")
public class StringToMap
extends TernaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
Serializable {
    private ArrayBasedMapBuilder mapBuilder;
    private final Expression text;
    private final Expression pairDelim;
    private final Expression keyValueDelim;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringToMap x$0) {
        return StringToMap$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringToMap> tupled() {
        return StringToMap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringToMap>>> curried() {
        return StringToMap$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression text() {
        return this.text;
    }

    public Expression pairDelim() {
        return this.pairDelim;
    }

    public Expression keyValueDelim() {
        return this.keyValueDelim;
    }

    @Override
    public boolean stateful() {
        return true;
    }

    @Override
    public Expression first() {
        return this.text();
    }

    @Override
    public Expression second() {
        return this.pairDelim();
    }

    @Override
    public Expression third() {
        return this.keyValueDelim();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public DataType dataType() {
        return MapType$.MODULE$.apply(this.first().dataType(), this.first().dataType());
    }

    private ArrayBasedMapBuilder mapBuilder$lzycompute() {
        StringToMap stringToMap = this;
        synchronized (stringToMap) {
            if (!this.bitmap$0) {
                this.mapBuilder = new ArrayBasedMapBuilder(this.first().dataType(), this.first().dataType());
                this.bitmap$0 = true;
            }
        }
        return this.mapBuilder;
    }

    private ArrayBasedMapBuilder mapBuilder() {
        if (!this.bitmap$0) {
            return this.mapBuilder$lzycompute();
        }
        return this.mapBuilder;
    }

    @Override
    public Object nullSafeEval(Object inputString, Object stringDelimiter, Object keyValueDelimiter) {
        UTF8String[] keyValues = ((UTF8String)inputString).split((UTF8String)stringDelimiter, -1);
        UTF8String keyValueDelimiterUTF8String = (UTF8String)keyValueDelimiter;
        for (int i = 0; i < keyValues.length; ++i) {
            UTF8String[] keyValueArray = keyValues[i].split(keyValueDelimiterUTF8String, 2);
            UTF8String key = keyValueArray[0];
            UTF8String value = keyValueArray.length < 2 ? null : keyValueArray[1];
            this.mapBuilder().put(key, value);
        }
        return this.mapBuilder().build();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String builderTerm = ctx.addReferenceObj("mapBuilder", this.mapBuilder(), ctx.addReferenceObj$default$3());
        String keyValues = ctx.freshName("kvs");
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(text, pd, kvd) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |UTF8String[] " + keyValues + " = " + text + ".split(" + pd + ", -1);\n         |for(UTF8String kvEntry: " + keyValues + ") {\n         |  UTF8String[] kv = kvEntry.split(" + kvd + ", 2);\n         |  " + builderTerm + ".put(kv[0], kv.length == 2 ? kv[1] : null);\n         |}\n         |" + ev.value() + " = " + builderTerm + ".build();\n         |")));
    }

    @Override
    public String prettyName() {
        return "str_to_map";
    }

    @Override
    public Expression withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringToMap copy(Expression text, Expression pairDelim, Expression keyValueDelim) {
        return new StringToMap(text, pairDelim, keyValueDelim);
    }

    public Expression copy$default$1() {
        return this.text();
    }

    public Expression copy$default$2() {
        return this.pairDelim();
    }

    public Expression copy$default$3() {
        return this.keyValueDelim();
    }

    @Override
    public String productPrefix() {
        return "StringToMap";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.text();
            }
            case 1: {
                return this.pairDelim();
            }
            case 2: {
                return this.keyValueDelim();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringToMap;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "text";
            }
            case 1: {
                return "pairDelim";
            }
            case 2: {
                return "keyValueDelim";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringToMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringToMap stringToMap = (StringToMap)x$1;
        Expression expression = this.text();
        Expression expression2 = stringToMap.text();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pairDelim();
        Expression expression4 = stringToMap.pairDelim();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.keyValueDelim();
        Expression expression6 = stringToMap.keyValueDelim();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringToMap.canEqual(this)) return false;
        return true;
    }

    public StringToMap(Expression text, Expression pairDelim, Expression keyValueDelim) {
        this.text = text;
        this.pairDelim = pairDelim;
        this.keyValueDelim = keyValueDelim;
        ExpectsInputTypes.$init$(this);
    }

    public StringToMap(Expression child, Expression pairDelim) {
        this(child, pairDelim, Literal$.MODULE$.apply(":"));
    }

    public StringToMap(Expression child) {
        this(child, Literal$.MODULE$.apply(","), Literal$.MODULE$.apply(":"));
    }
}

