/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrim$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the leading and trailing space characters from `str`.\n\n    _FUNC_(BOTH FROM str) - Removes the leading and trailing space characters from `str`.\n\n    _FUNC_(LEADING FROM str) - Removes the leading space characters from `str`.\n\n    _FUNC_(TRAILING FROM str) - Removes the trailing space characters from `str`.\n\n    _FUNC_(trimStr FROM str) - Remove the leading and trailing `trimStr` characters from `str`.\n\n    _FUNC_(BOTH trimStr FROM str) - Remove the leading and trailing `trimStr` characters from `str`.\n\n    _FUNC_(LEADING trimStr FROM str) - Remove the leading `trimStr` characters from `str`.\n\n    _FUNC_(TRAILING trimStr FROM str) - Remove the trailing `trimStr` characters from `str`.\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n      * BOTH, FROM - these are keywords to specify trimming string characters from both ends of\n          the string\n      * LEADING, FROM - these are keywords to specify trimming string characters from the left\n          end of the string\n      * TRAILING, FROM - these are keywords to specify trimming string characters from the right\n          end of the string\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_(BOTH FROM '    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_(LEADING FROM '    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_(TRAILING FROM '    SparkSQL   ');\n           SparkSQL\n      > SELECT _FUNC_('SL' FROM 'SSparkSQLS');\n       parkSQ\n      > SELECT _FUNC_(BOTH 'SL' FROM 'SSparkSQLS');\n       parkSQ\n      > SELECT _FUNC_(LEADING 'SL' FROM 'SSparkSQLS');\n       parkSQLS\n      > SELECT _FUNC_(TRAILING 'SL' FROM 'SSparkSQLS');\n       SSparkSQ\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015x!B\u0011#\u0011\u0003yc!B\u0019#\u0011\u0003\u0011\u0004\"B!\u0002\t\u0003\u0011\u0005\"B\"\u0002\t\u0003!\u0005BB\"\u0002\t\u0003\ti\f\u0003\u0005D\u0003\u0005\u0005I\u0011QAa\u0011%\t9-AI\u0001\n\u0003\ty\u0004C\u0005\u0002J\u0006\t\t\u0011\"!\u0002L\"I\u0011\u0011\\\u0001\u0012\u0002\u0013\u0005\u0011q\b\u0005\n\u00037\f\u0011\u0011!C\u0005\u0003;4A!\r\u0012A\r\"A1L\u0003BK\u0002\u0013\u0005A\f\u0003\u0005^\u0015\tE\t\u0015!\u0003H\u0011!q&B!f\u0001\n\u0003y\u0006\u0002C2\u000b\u0005#\u0005\u000b\u0011\u00021\t\u000b\u0005SA\u0011\u00013\t\u000b\u0005SA\u0011A4\t\u000b\u0005SA\u0011\u00016\t\u000b1TA\u0011I7\t\u000bYTA\u0011K7\t\u000b]TA\u0011\t=\t\r]TA\u0011IA\u0004\u0011\u001d\tyA\u0003C)\u0003#A\u0011\"!\b\u000b\u0003\u0003%\t!a\b\t\u0013\u0005\u0015\"\"%A\u0005\u0002\u0005\u001d\u0002\"CA\u001f\u0015E\u0005I\u0011AA \u0011%\t\u0019ECA\u0001\n\u0003\n)\u0005C\u0005\u0002R)\t\t\u0011\"\u0001\u0002T!I\u00111\f\u0006\u0002\u0002\u0013\u0005\u0011Q\f\u0005\n\u0003SR\u0011\u0011!C!\u0003WB\u0011\"!\u001f\u000b\u0003\u0003%\t!a\u001f\t\u0013\u0005\u0015%\"!A\u0005B\u0005\u001d\u0005\"CAF\u0015\u0005\u0005I\u0011IAG\u0003)\u0019FO]5oOR\u0013\u0018.\u001c\u0006\u0003G\u0011\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011QEJ\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0005K\u0001\u0004gFd'BA\u0015+\u0003\u0015\u0019\b/\u0019:l\u0015\tYC&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002[\u0005\u0019qN]4\u0004\u0001A\u0011\u0001'A\u0007\u0002E\tQ1\u000b\u001e:j]\u001e$&/[7\u0014\u0007\u0005\u0019\u0014\b\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATG\u0001\u0004B]f\u0014VM\u001a\t\u0003u}j\u0011a\u000f\u0006\u0003yu\n!![8\u000b\u0003y\nAA[1wC&\u0011\u0001i\u000f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\nQ!\u00199qYf$R!RA\\\u0003w\u0003\"\u0001\r\u0006\u0014\u000b)9%*\u0014)\u0011\u0005AB\u0015BA%#\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003a-K!\u0001\u0014\u0012\u0003+M#(/\u001b8heQ\u0013\u0018.\\#yaJ,7o]5p]B\u0011AGT\u0005\u0003\u001fV\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002R3:\u0011!k\u0016\b\u0003'Zk\u0011\u0001\u0016\u0006\u0003+:\na\u0001\u0010:p_Rt\u0014\"\u0001\u001c\n\u0005a+\u0014a\u00029bG.\fw-Z\u0005\u0003\u0001jS!\u0001W\u001b\u0002\rM\u00148m\u0015;s+\u00059\u0015aB:sGN#(\u000fI\u0001\biJLWn\u0015;s+\u0005\u0001\u0007c\u0001\u001bb\u000f&\u0011!-\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0011Q\u0014\u0018.\\*ue\u0002\"2!R3g\u0011\u0015Yv\u00021\u0001H\u0011\u001dqv\u0002%AA\u0002\u0001$2!\u00125j\u0011\u0015q\u0006\u00031\u0001H\u0011\u0015Y\u0006\u00031\u0001H)\t)5\u000eC\u0003\\#\u0001\u0007q)\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012A\u001c\t\u0003_Nt!\u0001]9\u0011\u0005M+\u0014B\u0001:6\u0003\u0019\u0001&/\u001a3fM&\u0011A/\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I,\u0014!\u00033je\u0016\u001cG/[8o\u0003\u0019!w.\u0012<bYR\u0019\u00110a\u0001\u0011\u0005i|X\"A>\u000b\u0005ql\u0018!\u0002;za\u0016\u001c(B\u0001@)\u0003\u0019)hn]1gK&\u0019\u0011\u0011A>\u0003\u0015U#f\tO*ue&tw\r\u0003\u0004\u0002\u0006Q\u0001\r!_\u0001\ngJ\u001c7\u000b\u001e:j]\u001e$R!_A\u0005\u0003\u0017Aa!!\u0002\u0016\u0001\u0004I\bBBA\u0007+\u0001\u0007\u00110\u0001\u0006ue&l7\u000b\u001e:j]\u001e\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0007\u001d\u000b\u0019\u0002C\u0004\u0002\u0016Y\u0001\r!a\u0006\u0002\u00179,wo\u00115jY\u0012\u0014XM\u001c\t\u0005#\u0006eq)C\u0002\u0002\u001ci\u0013!\"\u00138eKb,GmU3r\u0003\u0011\u0019w\u000e]=\u0015\u000b\u0015\u000b\t#a\t\t\u000fm;\u0002\u0013!a\u0001\u000f\"9al\u0006I\u0001\u0002\u0004\u0001\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003SQ3aRA\u0016W\t\ti\u0003\u0005\u0003\u00020\u0005eRBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001ck\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0012\u0011\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0003R3\u0001YA\u0016\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\t\t\u0005\u0003\u0013\ny%\u0004\u0002\u0002L)\u0019\u0011QJ\u001f\u0002\t1\fgnZ\u0005\u0004i\u0006-\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA+!\r!\u0014qK\u0005\u0004\u00033*$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA0\u0003K\u00022\u0001NA1\u0013\r\t\u0019'\u000e\u0002\u0004\u0003:L\b\"CA49\u0005\u0005\t\u0019AA+\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u000e\t\u0007\u0003_\n)(a\u0018\u000e\u0005\u0005E$bAA:k\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]\u0014\u0011\u000f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002~\u0005\r\u0005c\u0001\u001b\u0002\u0000%\u0019\u0011\u0011Q\u001b\u0003\u000f\t{w\u000e\\3b]\"I\u0011q\r\u0010\u0002\u0002\u0003\u0007\u0011qL\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002H\u0005%\u0005\"CA4?\u0005\u0005\t\u0019AA+\u0003\u0019)\u0017/^1mgR!\u0011QPAH\u0011%\t9\u0007IA\u0001\u0002\u0004\ty\u0006K\f\u000b\u0003'\u000bI*a'\u0002 \u0006\u0005\u0016QUAT\u0003W\u000bi+!-\u00024B\u0019\u0001'!&\n\u0007\u0005]%EA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005u\u0015!b*\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006f\u001d;sS\u0001j\u0003EU3n_Z,7\u000f\t;iK\u0002bW-\u00193j]\u001e\u0004\u0013M\u001c3!iJ\f\u0017\u000e\\5oO\u0002\u001a\b/Y2fA\rD\u0017M]1di\u0016\u00148\u000f\t4s_6\u0004\u0003m\u001d;sA:R!\u0002\t\u0011!A}3UKT\"`Q\t{E\u000b\u0013\u0011G%>k\u0005e\u001d;sS\u0001j\u0003EU3n_Z,7\u000f\t;iK\u0002bW-\u00193j]\u001e\u0004\u0013M\u001c3!iJ\f\u0017\u000e\\5oO\u0002\u001a\b/Y2fA\rD\u0017M]1di\u0016\u00148\u000f\t4s_6\u0004\u0003m\u001d;sA:R!\u0002\t\u0011!A}3UKT\"`Q1+\u0015\tR%O\u000f\u00022%kT'!gR\u0014\u0018\u0006I\u0017!%\u0016lwN^3tAQDW\r\t7fC\u0012Lgn\u001a\u0011ta\u0006\u001cW\rI2iCJ\f7\r^3sg\u00022'o\\7!AN$(\u000f\u0019\u0018\u000b\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b+S\u0003&c\u0015JT$!\rJ{U\nI:ue&\u0002S\u0006\t*f[>4Xm\u001d\u0011uQ\u0016\u0004CO]1jY&tw\rI:qC\u000e,\u0007e\u00195be\u0006\u001cG/\u001a:tA\u0019\u0014x.\u001c\u0011agR\u0014\bM\f\u0006\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006\u0006\u001e:j[N#(\u000f\t$S\u001f6\u00033\u000f\u001e:*A5\u0002#+Z7pm\u0016\u0004C\u000f[3!Y\u0016\fG-\u001b8hA\u0005tG\r\t;sC&d\u0017N\\4!AR\u0014\u0018.\\*ue\u0002\u00043\r[1sC\u000e$XM]:!MJ|W\u000e\t1tiJ\u0004gF\u0003\u0006!A\u0001\u0002sLR+O\u0007~C#i\u0014+IAQ\u0014\u0018.\\*ue\u00022%kT'!gR\u0014\u0018\u0006I\u0017!%\u0016lwN^3!i\",\u0007\u0005\\3bI&tw\rI1oI\u0002\"(/Y5mS:<\u0007\u0005\u0019;sS6\u001cFO\u001d1!G\"\f'/Y2uKJ\u001c\bE\u001a:p[\u0002\u00027\u000f\u001e:a])Q\u0001\u0005\t\u0011!?\u001a+fjQ0)\u0019\u0016\u000bE)\u0013(HAQ\u0014\u0018.\\*ue\u00022%kT'!gR\u0014\u0018\u0006I\u0017!%\u0016lwN^3!i\",\u0007\u0005\\3bI&tw\r\t1ue&l7\u000b\u001e:aA\rD\u0017M]1di\u0016\u00148\u000f\t4s_6\u0004\u0003m\u001d;sA:R!\u0002\t\u0011!A}3UKT\"`QQ\u0013\u0016)\u0013'J\u001d\u001e\u0003CO]5n'R\u0014\bE\u0012*P\u001b\u0002\u001aHO]\u0015![\u0001\u0012V-\\8wK\u0002\"\b.\u001a\u0011ue\u0006LG.\u001b8hA\u0001$(/[7TiJ\u0004\u0007e\u00195be\u0006\u001cG/\u001a:tA\u0019\u0014x.\u001c\u0011agR\u0014\bM\f\u0006!A\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003G\u000b1q\u001f\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM$(\u000fI\u0017!C\u0002\u001aHO]5oO\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0006!A\u0001\u0002\u0003\u0005\t\u0016!iJLWn\u0015;sA5\u0002C\u000f[3!iJLW\u000eI:ue&tw\rI2iCJ\f7\r^3sg\u0002\"x\u000e\t;sS6d\u0003\u0005\u001e5fA\u0011,g-Y;mi\u00022\u0018\r\\;fA%\u001c\b%\u0019\u0011tS:<G.\u001a\u0011ta\u0006\u001cWM\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011C\u001fRCE\u0006\t$S\u001f6\u0003S\u0006\t;iKN,\u0007%\u0019:fA-,\u0017p^8sIN\u0004Co\u001c\u0011ta\u0016\u001c\u0017NZ=!iJLW.\\5oO\u0002\u001aHO]5oO\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007EY8uQ\u0002*g\u000eZ:!_\u001aT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011uQ\u0016\u00043\u000f\u001e:j]\u001eT\u0001\u0005\t\u0011!A\u0001R\u0003\u0005T#B\t&su\t\f\u0011G%>k\u0005%\f\u0011uQ\u0016\u001cX\rI1sK\u0002ZW-_<pe\u0012\u001c\b\u0005^8!gB,7-\u001b4zAQ\u0014\u0018.\\7j]\u001e\u00043\u000f\u001e:j]\u001e\u00043\r[1sC\u000e$XM]:!MJ|W\u000e\t;iK\u0002bWM\u001a;\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002SM\u001c3!_\u001a\u0004C\u000f[3!gR\u0014\u0018N\\4\u000bA\u0001\u0002\u0003\u0005\t\u0011+AQ\u0013\u0016)\u0013'J\u001d\u001ec\u0003E\u0012*P\u001b\u0002j\u0003\u0005\u001e5fg\u0016\u0004\u0013M]3!W\u0016Lxo\u001c:eg\u0002\"x\u000eI:qK\u000eLg-\u001f\u0011ue&lW.\u001b8hAM$(/\u001b8hA\rD\u0017M]1di\u0016\u00148\u000f\t4s_6\u0004C\u000f[3!e&<\u0007\u000e\u001e\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001*g\u000e\u001a\u0011pM\u0002\"\b.\u001a\u0011tiJLgn\u001a\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002*\u0006!\tG\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(A\u0001\u0002\u0003e\u00159be.\u001c\u0016\u000b\u0014\u0011!A\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I*qCJ\\7+\u0015'\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\t{E\u000b\u0013\u0011G%>k\u0005e\n\u0011!A\u0001\u001a\u0006/\u0019:l'Fc\u0005\u0005\t\u0011(SmR\u0001\u0005\t\u0011!A\u0001\u00023\u000b]1sWN\u000bFJ\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015M\u000b\u0006#\u0015JT$!\rJ{U\nI\u0014!A\u0001\u00023\u000b]1sWN\u000bF\n\t\u0011!O%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u00159be.\u001c\u0016\u000b\u0014\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0))J\u000b\u0015\nT%O\u000f\u00022%kT'!O\u0001\u0002\u0003\u0005I*qCJ\\7+\u0015'!A\u0001:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u00023\u000b]1sWN\u000bFJ\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015('2;\u0003E\u0012*P\u001b\u0002:3k\u00159be.\u001c\u0016\u000bT*(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003/\u0019:l'FS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006FQ(U\u0011\u0002:3\u000bT\u0014!\rJ{U\nI\u0014T'B\f'o[*R\u0019N;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011qCJ\\7+\u0015\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)\u0019\u0016\u000bE)\u0013(HA\u001d\u001aFj\n\u0011G%>k\u0005eJ*Ta\u0006\u00148nU)M'\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t9be.\u001c\u0016\u000bT*\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QQ\u0013\u0016)\u0013'J\u001d\u001e\u0003se\u0015'(A\u0019\u0013v*\u0014\u0011('N\u0003\u0018M]6T#2\u001bv%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!'N\u0003\u0018M]6T#*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u00020\u0006)\u0011GL\u001b/a\u0005)qM]8va\u0006\u0012\u0011QW\u0001\rgR\u0014\u0018N\\4`MVt7m\u001d\u0005\u0007\u0003s\u001b\u0001\u0019A$\u0002\u0007M$(\u000fC\u0003_\u0007\u0001\u0007q\tF\u0002F\u0003\u007fCa!!/\u0005\u0001\u00049E#B#\u0002D\u0006\u0015\u0007\"B.\u0006\u0001\u00049\u0005b\u00020\u0006!\u0003\u0005\r\u0001Y\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u00059QO\\1qa2LH\u0003BAg\u0003+\u0004B\u0001N1\u0002PB)A'!5HA&\u0019\u00111[\u001b\u0003\rQ+\b\u000f\\33\u0011!\t9nBA\u0001\u0002\u0004)\u0015a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a8\u0011\t\u0005%\u0013\u0011]\u0005\u0005\u0003G\fYE\u0001\u0004PE*,7\r\u001e")
public class StringTrim
extends Expression
implements String2TrimExpression,
Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;
    private int collationId;
    private volatile boolean bitmap$0;

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrim$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrim x$0) {
        return StringTrim$.MODULE$.unapply(x$0);
    }

    public static Option<Expression> apply$default$2() {
        return StringTrim$.MODULE$.apply$default$2();
    }

    @Override
    public /* synthetic */ String org$apache$spark$sql$catalyst$expressions$String2TrimExpression$$super$sql() {
        return super.sql();
    }

    @Override
    public Seq<Expression> children() {
        return String2TrimExpression.children$(this);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression.inputTypes$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public Object eval(InternalRow input) {
        return String2TrimExpression.eval$(this, input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return String2TrimExpression.doGenCode$(this, ctx, ev);
    }

    @Override
    public String sql() {
        return String2TrimExpression.sql$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private int collationId$lzycompute() {
        StringTrim stringTrim = this;
        synchronized (stringTrim) {
            if (!this.bitmap$0) {
                this.collationId = String2TrimExpression.collationId$(this);
                this.bitmap$0 = true;
            }
        }
        return this.collationId;
    }

    @Override
    public final int collationId() {
        if (!this.bitmap$0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    @Override
    public Expression srcStr() {
        return this.srcStr;
    }

    @Override
    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "trim";
    }

    @Override
    public String direction() {
        return "BOTH";
    }

    @Override
    public UTF8String doEval(UTF8String srcString) {
        return CollationSupport.StringTrim.exec((UTF8String)srcString, (int)this.collationId());
    }

    @Override
    public UTF8String doEval(UTF8String srcString, UTF8String trimString) {
        return CollationSupport.StringTrim.exec((UTF8String)srcString, (UTF8String)trimString, (int)this.collationId());
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.head(), (Option<Expression>)(this.trimStr().isDefined() ? new Some(newChildren.last()) : None$.MODULE$));
    }

    public StringTrim copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrim(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrim";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.srcStr();
            }
            case 1: {
                return this.trimStr();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrim;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "srcStr";
            }
            case 1: {
                return "trimStr";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrim)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrim stringTrim = (StringTrim)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrim.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrim.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrim.canEqual(this)) return false;
        return true;
    }

    public StringTrim(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
    }

    public StringTrim(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrim(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

