/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrimLeft$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the leading space characters from `str`.\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015x!B\u0011#\u0011\u0003yc!B\u0019#\u0011\u0003\u0011\u0004\"B!\u0002\t\u0003\u0011\u0005\"B\"\u0002\t\u0003!\u0005BB\"\u0002\t\u0003\ti\f\u0003\u0005D\u0003\u0005\u0005I\u0011QAa\u0011%\t9-AI\u0001\n\u0003\ty\u0004C\u0005\u0002J\u0006\t\t\u0011\"!\u0002L\"I\u0011\u0011\\\u0001\u0012\u0002\u0013\u0005\u0011q\b\u0005\n\u00037\f\u0011\u0011!C\u0005\u0003;4A!\r\u0012A\r\"A1L\u0003BK\u0002\u0013\u0005A\f\u0003\u0005^\u0015\tE\t\u0015!\u0003H\u0011!q&B!f\u0001\n\u0003y\u0006\u0002C2\u000b\u0005#\u0005\u000b\u0011\u00021\t\u000b\u0005SA\u0011\u00013\t\u000b\u0005SA\u0011A4\t\u000b\u0005SA\u0011\u00016\t\u000b1TA\u0011I7\t\u000bYTA\u0011K7\t\u000b]TA\u0011\t=\t\r]TA\u0011IA\u0004\u0011\u001d\tyA\u0003C)\u0003#A\u0011\"!\b\u000b\u0003\u0003%\t!a\b\t\u0013\u0005\u0015\"\"%A\u0005\u0002\u0005\u001d\u0002\"CA\u001f\u0015E\u0005I\u0011AA \u0011%\t\u0019ECA\u0001\n\u0003\n)\u0005C\u0005\u0002R)\t\t\u0011\"\u0001\u0002T!I\u00111\f\u0006\u0002\u0002\u0013\u0005\u0011Q\f\u0005\n\u0003SR\u0011\u0011!C!\u0003WB\u0011\"!\u001f\u000b\u0003\u0003%\t!a\u001f\t\u0013\u0005\u0015%\"!A\u0005B\u0005\u001d\u0005\"CAF\u0015\u0005\u0005I\u0011IAG\u00039\u0019FO]5oOR\u0013\u0018.\u001c'fMRT!a\t\u0013\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003K\u0019\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003O!\n1a]9m\u0015\tI#&A\u0003ta\u0006\u00148N\u0003\u0002,Y\u00051\u0011\r]1dQ\u0016T\u0011!L\u0001\u0004_J<7\u0001\u0001\t\u0003a\u0005i\u0011A\t\u0002\u000f'R\u0014\u0018N\\4Ue&lG*\u001a4u'\r\t1'\u000f\t\u0003i]j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014AA5p\u0015\u0005q\u0014\u0001\u00026bm\u0006L!\u0001Q\u001e\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005y\u0013!B1qa2LH#B#\u00028\u0006m\u0006C\u0001\u0019\u000b'\u0015QqIS'Q!\t\u0001\u0004*\u0003\u0002JE\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005AZ\u0015B\u0001'#\u0005U\u0019FO]5oOJ\"&/[7FqB\u0014Xm]:j_:\u0004\"\u0001\u000e(\n\u0005=+$a\u0002)s_\u0012,8\r\u001e\t\u0003#fs!AU,\u000f\u0005M3V\"\u0001+\u000b\u0005Us\u0013A\u0002\u001fs_>$h(C\u00017\u0013\tAV'A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0001S&B\u0001-6\u0003\u0019\u0019(oY*ueV\tq)A\u0004te\u000e\u001cFO\u001d\u0011\u0002\u000fQ\u0014\u0018.\\*ueV\t\u0001\rE\u00025C\u001eK!AY\u001b\u0003\r=\u0003H/[8o\u0003!!(/[7TiJ\u0004CcA#fM\")1l\u0004a\u0001\u000f\"9al\u0004I\u0001\u0002\u0004\u0001GcA#iS\")a\f\u0005a\u0001\u000f\")1\f\u0005a\u0001\u000fR\u0011Qi\u001b\u0005\u00067F\u0001\raR\u0001\u000baJ,G\u000f^=OC6,W#\u00018\u0011\u0005=\u001chB\u00019r!\t\u0019V'\u0003\u0002sk\u00051\u0001K]3eK\u001aL!\u0001^;\u0003\rM#(/\u001b8h\u0015\t\u0011X'A\u0005eSJ,7\r^5p]\u00061Am\\#wC2$2!_A\u0002!\tQx0D\u0001|\u0015\taX0A\u0003usB,7O\u0003\u0002\u007fQ\u00051QO\\:bM\u0016L1!!\u0001|\u0005))FK\u0012\u001dTiJLgn\u001a\u0005\u0007\u0003\u000b!\u0002\u0019A=\u0002\u0013M\u00148m\u0015;sS:<G#B=\u0002\n\u0005-\u0001BBA\u0003+\u0001\u0007\u0011\u0010\u0003\u0004\u0002\u000eU\u0001\r!_\u0001\u000biJLWn\u0015;sS:<\u0017aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\r)\u00151\u0003\u0005\b\u0003+1\u0002\u0019AA\f\u0003-qWm^\"iS2$'/\u001a8\u0011\tE\u000bIbR\u0005\u0004\u00037Q&AC%oI\u0016DX\rZ*fc\u0006!1m\u001c9z)\u0015)\u0015\u0011EA\u0012\u0011\u001dYv\u0003%AA\u0002\u001dCqAX\f\u0011\u0002\u0003\u0007\u0001-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005%\"fA$\u0002,-\u0012\u0011Q\u0006\t\u0005\u0003_\tI$\u0004\u0002\u00022)!\u00111GA\u001b\u0003%)hn\u00195fG.,GMC\u0002\u00028U\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY$!\r\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u0005#f\u00011\u0002,\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0012\u0011\t\u0005%\u0013qJ\u0007\u0003\u0003\u0017R1!!\u0014>\u0003\u0011a\u0017M\\4\n\u0007Q\fY%\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002VA\u0019A'a\u0016\n\u0007\u0005eSGA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002`\u0005\u0015\u0004c\u0001\u001b\u0002b%\u0019\u00111M\u001b\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002hq\t\t\u00111\u0001\u0002V\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u001c\u0011\r\u0005=\u0014QOA0\u001b\t\t\tHC\u0002\u0002tU\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9(!\u001d\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003{\n\u0019\tE\u00025\u0003\u007fJ1!!!6\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u001a\u001f\u0003\u0003\u0005\r!a\u0018\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u000f\nI\tC\u0005\u0002h}\t\t\u00111\u0001\u0002V\u00051Q-];bYN$B!! \u0002\u0010\"I\u0011q\r\u0011\u0002\u0002\u0003\u0007\u0011q\f\u0015\u0018\u0015\u0005M\u0015\u0011TAN\u0003?\u000b\t+!*\u0002(\u0006-\u0016QVAY\u0003g\u00032\u0001MAK\u0013\r\t9J\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ti*\u0001$\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006f\u001d;sS\u0001j\u0003EU3n_Z,7\u000f\t;iK\u0002bW-\u00193j]\u001e\u00043\u000f]1dK\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007\u0005Y:ue\u0002t#\u0002\t\u0011\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAAR\u0003\u0005u!\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011tiJ\u0004S\u0006I1!gR\u0014\u0018N\\4!Kb\u0004(/Z:tS>t'\u0002\t\u0011!A\u0001\u0002#\u0006\t;sS6\u001cFO\u001d\u0011.AQDW\r\t;sS6\u00043\u000f\u001e:j]\u001e\u00043\r[1sC\u000e$XM]:!i>\u0004CO]5nY\u0001\"\b.\u001a\u0011eK\u001a\fW\u000f\u001c;!m\u0006dW/\u001a\u0011jg\u0002\n\u0007e]5oO2,\u0007e\u001d9bG\u0016T\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011V\u0001L\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0003\u0005\t\u0011!'B\f'o[*R\u0019\u0002\u0002\u0003eJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AM\u0003\u0018M]6T#2S\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003_\u000bQ!\r\u00186]A\nQa\u001a:pkB\f#!!.\u0002\u0019M$(/\u001b8h?\u001a,hnY:\t\r\u0005e6\u00011\u0001H\u0003\r\u0019HO\u001d\u0005\u0006=\u000e\u0001\ra\u0012\u000b\u0004\u000b\u0006}\u0006BBA]\t\u0001\u0007q\tF\u0003F\u0003\u0007\f)\rC\u0003\\\u000b\u0001\u0007q\tC\u0004_\u000bA\u0005\t\u0019\u00011\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002N\u0006U\u0007\u0003\u0002\u001bb\u0003\u001f\u0004R\u0001NAi\u000f\u0002L1!a56\u0005\u0019!V\u000f\u001d7fe!A\u0011q[\u0004\u0002\u0002\u0003\u0007Q)A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAp!\u0011\tI%!9\n\t\u0005\r\u00181\n\u0002\u0007\u001f\nTWm\u0019;")
public class StringTrimLeft
extends Expression
implements String2TrimExpression,
Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;
    private int collationId;
    private volatile boolean bitmap$0;

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrimLeft$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrimLeft x$0) {
        return StringTrimLeft$.MODULE$.unapply(x$0);
    }

    public static Option<Expression> apply$default$2() {
        return StringTrimLeft$.MODULE$.apply$default$2();
    }

    @Override
    public /* synthetic */ String org$apache$spark$sql$catalyst$expressions$String2TrimExpression$$super$sql() {
        return super.sql();
    }

    @Override
    public Seq<Expression> children() {
        return String2TrimExpression.children$(this);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression.inputTypes$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public Object eval(InternalRow input) {
        return String2TrimExpression.eval$(this, input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return String2TrimExpression.doGenCode$(this, ctx, ev);
    }

    @Override
    public String sql() {
        return String2TrimExpression.sql$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private int collationId$lzycompute() {
        StringTrimLeft stringTrimLeft = this;
        synchronized (stringTrimLeft) {
            if (!this.bitmap$0) {
                this.collationId = String2TrimExpression.collationId$(this);
                this.bitmap$0 = true;
            }
        }
        return this.collationId;
    }

    @Override
    public final int collationId() {
        if (!this.bitmap$0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    @Override
    public Expression srcStr() {
        return this.srcStr;
    }

    @Override
    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "ltrim";
    }

    @Override
    public String direction() {
        return "LEADING";
    }

    @Override
    public UTF8String doEval(UTF8String srcString) {
        return CollationSupport.StringTrimLeft.exec((UTF8String)srcString, (int)this.collationId());
    }

    @Override
    public UTF8String doEval(UTF8String srcString, UTF8String trimString) {
        return CollationSupport.StringTrimLeft.exec((UTF8String)srcString, (UTF8String)trimString, (int)this.collationId());
    }

    @Override
    public StringTrimLeft withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.head(), (Option<Expression>)(this.trimStr().isDefined() ? new Some(newChildren.last()) : None$.MODULE$));
    }

    public StringTrimLeft copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrimLeft(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrimLeft";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.srcStr();
            }
            case 1: {
                return this.trimStr();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrimLeft;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "srcStr";
            }
            case 1: {
                return "trimStr";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrimLeft)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrimLeft stringTrimLeft = (StringTrimLeft)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrimLeft.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrimLeft.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrimLeft.canEqual(this)) return false;
        return true;
    }

    public StringTrimLeft(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
    }

    public StringTrimLeft(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrimLeft(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

