/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrimRight$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the trailing space characters from `str`.\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015x!B\u0011#\u0011\u0003yc!B\u0019#\u0011\u0003\u0011\u0004\"B!\u0002\t\u0003\u0011\u0005\"B\"\u0002\t\u0003!\u0005BB\"\u0002\t\u0003\ti\f\u0003\u0005D\u0003\u0005\u0005I\u0011QAa\u0011%\t9-AI\u0001\n\u0003\ty\u0004C\u0005\u0002J\u0006\t\t\u0011\"!\u0002L\"I\u0011\u0011\\\u0001\u0012\u0002\u0013\u0005\u0011q\b\u0005\n\u00037\f\u0011\u0011!C\u0005\u0003;4A!\r\u0012A\r\"A1L\u0003BK\u0002\u0013\u0005A\f\u0003\u0005^\u0015\tE\t\u0015!\u0003H\u0011!q&B!f\u0001\n\u0003y\u0006\u0002C2\u000b\u0005#\u0005\u000b\u0011\u00021\t\u000b\u0005SA\u0011\u00013\t\u000b\u0005SA\u0011A4\t\u000b\u0005SA\u0011\u00016\t\u000b1TA\u0011I7\t\u000bYTA\u0011K7\t\u000b]TA\u0011\t=\t\r]TA\u0011IA\u0004\u0011\u001d\tyA\u0003C)\u0003#A\u0011\"!\b\u000b\u0003\u0003%\t!a\b\t\u0013\u0005\u0015\"\"%A\u0005\u0002\u0005\u001d\u0002\"CA\u001f\u0015E\u0005I\u0011AA \u0011%\t\u0019ECA\u0001\n\u0003\n)\u0005C\u0005\u0002R)\t\t\u0011\"\u0001\u0002T!I\u00111\f\u0006\u0002\u0002\u0013\u0005\u0011Q\f\u0005\n\u0003SR\u0011\u0011!C!\u0003WB\u0011\"!\u001f\u000b\u0003\u0003%\t!a\u001f\t\u0013\u0005\u0015%\"!A\u0005B\u0005\u001d\u0005\"CAF\u0015\u0005\u0005I\u0011IAG\u0003=\u0019FO]5oOR\u0013\u0018.\u001c*jO\"$(BA\u0012%\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00152\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dB\u0013aA:rY*\u0011\u0011FK\u0001\u0006gB\f'o\u001b\u0006\u0003W1\na!\u00199bG\",'\"A\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005A\nQ\"\u0001\u0012\u0003\u001fM#(/\u001b8h)JLWNU5hQR\u001c2!A\u001a:!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u0019\te.\u001f*fMB\u0011!hP\u0007\u0002w)\u0011A(P\u0001\u0003S>T\u0011AP\u0001\u0005U\u00064\u0018-\u0003\u0002Aw\ta1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\"\u0012aL\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u000b\u0006]\u00161\u0018\t\u0003a)\u0019RAC$K\u001bB\u0003\"\u0001\r%\n\u0005%\u0013#AC#yaJ,7o]5p]B\u0011\u0001gS\u0005\u0003\u0019\n\u0012Qc\u0015;sS:<'\u0007\u0016:j[\u0016C\bO]3tg&|g\u000e\u0005\u00025\u001d&\u0011q*\u000e\u0002\b!J|G-^2u!\t\t\u0016L\u0004\u0002S/:\u00111KV\u0007\u0002)*\u0011QKL\u0001\u0007yI|w\u000e\u001e \n\u0003YJ!\u0001W\u001b\u0002\u000fA\f7m[1hK&\u0011\u0001I\u0017\u0006\u00031V\naa\u001d:d'R\u0014X#A$\u0002\u000fM\u00148m\u0015;sA\u00059AO]5n'R\u0014X#\u00011\u0011\u0007Q\nw)\u0003\u0002ck\t1q\n\u001d;j_:\f\u0001\u0002\u001e:j[N#(\u000f\t\u000b\u0004\u000b\u00164\u0007\"B.\u0010\u0001\u00049\u0005b\u00020\u0010!\u0003\u0005\r\u0001\u0019\u000b\u0004\u000b\"L\u0007\"\u00020\u0011\u0001\u00049\u0005\"B.\u0011\u0001\u00049ECA#l\u0011\u0015Y\u0016\u00031\u0001H\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002]B\u0011qn\u001d\b\u0003aF\u0004\"aU\u001b\n\u0005I,\u0014A\u0002)sK\u0012,g-\u0003\u0002uk\n11\u000b\u001e:j]\u001eT!A]\u001b\u0002\u0013\u0011L'/Z2uS>t\u0017A\u00023p\u000bZ\fG\u000eF\u0002z\u0003\u0007\u0001\"A_@\u000e\u0003mT!\u0001`?\u0002\u000bQL\b/Z:\u000b\u0005yD\u0013AB;og\u00064W-C\u0002\u0002\u0002m\u0014!\"\u0016+GqM#(/\u001b8h\u0011\u0019\t)\u0001\u0006a\u0001s\u0006I1O]2TiJLgn\u001a\u000b\u0006s\u0006%\u00111\u0002\u0005\u0007\u0003\u000b)\u0002\u0019A=\t\r\u00055Q\u00031\u0001z\u0003)!(/[7TiJLgnZ\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$2!RA\n\u0011\u001d\t)B\u0006a\u0001\u0003/\t1B\\3x\u0007\"LG\u000e\u001a:f]B!\u0011+!\u0007H\u0013\r\tYB\u0017\u0002\u000b\u0013:$W\r_3e'\u0016\f\u0018\u0001B2paf$R!RA\u0011\u0003GAqaW\f\u0011\u0002\u0003\u0007q\tC\u0004_/A\u0005\t\u0019\u00011\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0006\u0016\u0004\u000f\u0006-2FAA\u0017!\u0011\ty#!\u000f\u000e\u0005\u0005E\"\u0002BA\u001a\u0003k\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]R'\u0001\u0006b]:|G/\u0019;j_:LA!a\u000f\u00022\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\t\u0016\u0004A\u0006-\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002HA!\u0011\u0011JA(\u001b\t\tYEC\u0002\u0002Nu\nA\u0001\\1oO&\u0019A/a\u0013\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005U\u0003c\u0001\u001b\u0002X%\u0019\u0011\u0011L\u001b\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005}\u0013Q\r\t\u0004i\u0005\u0005\u0014bAA2k\t\u0019\u0011I\\=\t\u0013\u0005\u001dD$!AA\u0002\u0005U\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002nA1\u0011qNA;\u0003?j!!!\u001d\u000b\u0007\u0005MT'\u0001\u0006d_2dWm\u0019;j_:LA!a\u001e\u0002r\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ti(a!\u0011\u0007Q\ny(C\u0002\u0002\u0002V\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002hy\t\t\u00111\u0001\u0002`\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t9%!#\t\u0013\u0005\u001dt$!AA\u0002\u0005U\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002~\u0005=\u0005\"CA4A\u0005\u0005\t\u0019AA0Q]Q\u00111SAM\u00037\u000by*!)\u0002&\u0006\u001d\u00161VAW\u0003c\u000b\u0019\fE\u00021\u0003+K1!a&#\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!(\u0002\u000f*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015tiJL\u0003%\f\u0011SK6|g/Z:!i\",\u0007\u0005\u001e:bS2Lgn\u001a\u0011ta\u0006\u001cW\rI2iCJ\f7\r^3sg\u00022'o\\7!AN$(\u000f\u0019\u0018\u000bA\u0001\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005\r\u0016!!\b\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u001aHO\u001d\u0011.A\u0005\u00043\u000f\u001e:j]\u001e\u0004S\r\u001f9sKN\u001c\u0018n\u001c8\u000bA\u0001\u0002\u0003\u0005\t\u0011+AQ\u0014\u0018.\\*ue\u0002j\u0003\u0005\u001e5fAQ\u0014\u0018.\u001c\u0011tiJLgn\u001a\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004Co\u001c\u0011ue&lG\u0006\t;iK\u0002\"WMZ1vYR\u0004c/\u00197vK\u0002J7\u000fI1!g&tw\r\\3!gB\f7-\u001a\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002*\u0006Y%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014!A\u0001\u00023\u000b]1sWN\u000bF\n\t\u0011!O%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u00159be.\u001c\u0016\u000b\u0014\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qV\u0001\u0006c9*d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003k\u000bAb\u001d;sS:<wLZ;oGNDa!!/\u0004\u0001\u00049\u0015aA:ue\")al\u0001a\u0001\u000fR\u0019Q)a0\t\r\u0005eF\u00011\u0001H)\u0015)\u00151YAc\u0011\u0015YV\u00011\u0001H\u0011\u001dqV\u0001%AA\u0002\u0001\fq\"\u00199qYf$C-\u001a4bk2$HEM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti-!6\u0011\tQ\n\u0017q\u001a\t\u0006i\u0005Ew\tY\u0005\u0004\u0003',$A\u0002+va2,'\u0007\u0003\u0005\u0002X\u001e\t\t\u00111\u0001F\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005}\u0007\u0003BA%\u0003CLA!a9\u0002L\t1qJ\u00196fGR\u0004")
public class StringTrimRight
extends Expression
implements String2TrimExpression,
Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;
    private int collationId;
    private volatile boolean bitmap$0;

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrimRight$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrimRight x$0) {
        return StringTrimRight$.MODULE$.unapply(x$0);
    }

    public static Option<Expression> apply$default$2() {
        return StringTrimRight$.MODULE$.apply$default$2();
    }

    @Override
    public /* synthetic */ String org$apache$spark$sql$catalyst$expressions$String2TrimExpression$$super$sql() {
        return super.sql();
    }

    @Override
    public Seq<Expression> children() {
        return String2TrimExpression.children$(this);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression.inputTypes$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public Object eval(InternalRow input) {
        return String2TrimExpression.eval$(this, input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return String2TrimExpression.doGenCode$(this, ctx, ev);
    }

    @Override
    public String sql() {
        return String2TrimExpression.sql$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private int collationId$lzycompute() {
        StringTrimRight stringTrimRight = this;
        synchronized (stringTrimRight) {
            if (!this.bitmap$0) {
                this.collationId = String2TrimExpression.collationId$(this);
                this.bitmap$0 = true;
            }
        }
        return this.collationId;
    }

    @Override
    public final int collationId() {
        if (!this.bitmap$0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    @Override
    public Expression srcStr() {
        return this.srcStr;
    }

    @Override
    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "rtrim";
    }

    @Override
    public String direction() {
        return "TRAILING";
    }

    @Override
    public UTF8String doEval(UTF8String srcString) {
        return CollationSupport.StringTrimRight.exec((UTF8String)srcString, (int)this.collationId());
    }

    @Override
    public UTF8String doEval(UTF8String srcString, UTF8String trimString) {
        return CollationSupport.StringTrimRight.exec((UTF8String)srcString, (UTF8String)trimString, (int)this.collationId());
    }

    @Override
    public StringTrimRight withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.head(), (Option<Expression>)(this.trimStr().isDefined() ? new Some(newChildren.last()) : None$.MODULE$));
    }

    public StringTrimRight copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrimRight(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrimRight";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.srcStr();
            }
            case 1: {
                return this.trimStr();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrimRight;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "srcStr";
            }
            case 1: {
                return "trimStr";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrimRight)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrimRight stringTrimRight = (StringTrimRight)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrimRight.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrimRight.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrimRight.canEqual(this)) return false;
        return true;
    }

    public StringTrimRight(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
    }

    public StringTrimRight(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrimRight(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

