/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimestampDiff$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(unit, startTimestamp, endTimestamp) - Gets the difference between the timestamps `endTimestamp` and `startTimestamp` in the specified units by truncating the fraction part.", arguments="\n    Arguments:\n      * unit - this indicates the units of the difference between the given timestamps.\n        Supported string values of `unit` are (case insensitive):\n          - \"YEAR\"\n          - \"QUARTER\" - 3 months\n          - \"MONTH\"\n          - \"WEEK\" - 7 days\n          - \"DAY\"\n          - \"HOUR\"\n          - \"MINUTE\"\n          - \"SECOND\"\n          - \"MILLISECOND\"\n          - \"MICROSECOND\"\n      * startTimestamp - A timestamp which the expression subtracts from `endTimestamp`.\n      * endTimestamp - A timestamp from which the expression subtracts `startTimestamp`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(HOUR, timestamp_ntz'2022-02-11 20:30:00', timestamp_ntz'2022-02-12 04:30:00');\n       8\n      > SELECT _FUNC_(MONTH, timestamp_ltz'2022-01-01 00:00:00', timestamp_ltz'2022-02-28 00:00:00');\n       1\n      > SELECT _FUNC_(SECOND, date'2022-01-01', timestamp'2021-12-31 23:59:50');\n       -10\n      > SELECT _FUNC_(YEAR, timestamp'2000-01-01 01:02:03.123456', timestamp'2010-01-01 01:02:03.123456');\n       10\n  ", group="datetime_funcs", since="3.3.0")
@ScalaSignature(bytes="\u0006\u0005\tUd\u0001B\u0016-\u0001fB\u0001\u0002\u0018\u0001\u0003\u0016\u0004%\t!\u0018\u0005\tM\u0002\u0011\t\u0012)A\u0005=\"Aq\r\u0001BK\u0002\u0013\u0005\u0001\u000e\u0003\u0005m\u0001\tE\t\u0015!\u0003j\u0011!i\u0007A!f\u0001\n\u0003A\u0007\u0002\u00038\u0001\u0005#\u0005\u000b\u0011B5\t\u0011=\u0004!Q3A\u0005\u0002AD\u0001\u0002\u001e\u0001\u0003\u0012\u0003\u0006I!\u001d\u0005\u0006k\u0002!\tA\u001e\u0005\u0006k\u0002!\t\u0001 \u0005\u0007\u0003\u000b\u0001A\u0011\t5\t\r\u0005\u001d\u0001\u0001\"\u0011i\u0011\u001d\tI\u0001\u0001C!\u0003\u0017Aq!a\b\u0001\t\u0003\n\t\u0003C\u0004\u0002*\u0001!\t%a\u000b\t\u0015\u0005=\u0002\u0001#b\u0001\n\u0013\t\t\u0004C\u0004\u0002L\u0001!\t%!\u0014\t\u000f\u0005u\u0003\u0001\"\u0011\u0002`!1\u00111\u0010\u0001\u0005BuCQ!\r\u0001\u0005BuCq!! \u0001\t#\ny\bC\u0005\u0002\n\u0002\t\t\u0011\"\u0001\u0002\f\"I\u0011Q\u0013\u0001\u0012\u0002\u0013\u0005\u0011q\u0013\u0005\n\u0003[\u0003\u0011\u0013!C\u0001\u0003_C\u0011\"a-\u0001#\u0003%\t!a,\t\u0013\u0005U\u0006!%A\u0005\u0002\u0005]\u0006\"CA^\u0001\u0005\u0005I\u0011IA_\u0011%\tI\rAA\u0001\n\u0003\tY\rC\u0005\u0002T\u0002\t\t\u0011\"\u0001\u0002V\"I\u00111\u001c\u0001\u0002\u0002\u0013\u0005\u0013Q\u001c\u0005\n\u0003W\u0004\u0011\u0011!C\u0001\u0003[D\u0011\"a>\u0001\u0003\u0003%\t%!?\t\u0013\u0005u\b!!A\u0005B\u0005}x!\u0003B\u0015Y\u0005\u0005\t\u0012\u0001B\u0016\r!YC&!A\t\u0002\t5\u0002BB;$\t\u0003\u0011)\u0005C\u0005\u0003H\r\n\t\u0011\"\u0012\u0003J!I!1J\u0012\u0002\u0002\u0013\u0005%Q\n\u0005\n\u0005/\u001a\u0013\u0013!C\u0001\u0003oC\u0011B!\u0017$\u0003\u0003%\tIa\u0017\t\u0013\t%4%%A\u0005\u0002\u0005]\u0006\"\u0003B6G\u0005\u0005I\u0011\u0002B7\u00055!\u0016.\\3ti\u0006l\u0007\u000fR5gM*\u0011QFL\u0001\fKb\u0004(/Z:tS>t7O\u0003\u00020a\u0005A1-\u0019;bYf\u001cHO\u0003\u00022e\u0005\u00191/\u001d7\u000b\u0005M\"\u0014!B:qCJ\\'BA\u001b7\u0003\u0019\t\u0007/Y2iK*\tq'A\u0002pe\u001e\u001c\u0001aE\u0004\u0001uy\n\u0005jS)\u0011\u0005mbT\"\u0001\u0017\n\u0005ub#\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tYt(\u0003\u0002AY\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002C\u000b:\u00111hQ\u0005\u0003\t2\nq\u0001]1dW\u0006<W-\u0003\u0002G\u000f\nqa*\u001e7m\u0013:$x\u000e\\3sC:$(B\u0001#-!\tY\u0014*\u0003\u0002KY\t9B+[7f5>tW-Q<be\u0016,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003\u0019>k\u0011!\u0014\u0006\u0002\u001d\u0006)1oY1mC&\u0011\u0001+\u0014\u0002\b!J|G-^2u!\t\u0011\u0016L\u0004\u0002T1:\u0011AkV\u0007\u0002+*\u0011a\u000bO\u0001\u0007yI|w\u000e\u001e \n\u00039K!\u0001R'\n\u0005i[&\u0001D*fe&\fG.\u001b>bE2,'B\u0001#N\u0003\u0011)h.\u001b;\u0016\u0003y\u0003\"aX2\u000f\u0005\u0001\f\u0007C\u0001+N\u0013\t\u0011W*\u0001\u0004Qe\u0016$WMZ\u0005\u0003I\u0016\u0014aa\u0015;sS:<'B\u00012N\u0003\u0015)h.\u001b;!\u00039\u0019H/\u0019:u)&lWm\u001d;b[B,\u0012!\u001b\t\u0003w)L!a\u001b\u0017\u0003\u0015\u0015C\bO]3tg&|g.A\bti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9!\u00031)g\u000e\u001a+j[\u0016\u001cH/Y7q\u00035)g\u000e\u001a+j[\u0016\u001cH/Y7qA\u0005QA/[7f5>tW-\u00133\u0016\u0003E\u00042\u0001\u0014:_\u0013\t\u0019XJ\u0001\u0004PaRLwN\\\u0001\fi&lWMW8oK&#\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0006obL(p\u001f\t\u0003w\u0001AQ\u0001X\u0005A\u0002yCQaZ\u0005A\u0002%DQ!\\\u0005A\u0002%Dqa\\\u0005\u0011\u0002\u0003\u0007\u0011\u000fF\u0003x{z\f\t\u0001C\u0003]\u0015\u0001\u0007a\fC\u0003\u0000\u0015\u0001\u0007\u0011.\u0001\u0005rk\u0006tG/\u001b;z\u0011\u0019\t\u0019A\u0003a\u0001S\u0006IA/[7fgR\fW\u000e]\u0001\u0005Y\u00164G/A\u0003sS\u001eDG/\u0001\u0006j]B,H\u000fV=qKN,\"!!\u0004\u0011\u000bI\u000by!a\u0005\n\u0007\u0005E1LA\u0002TKF\u0004B!!\u0006\u0002\u001c5\u0011\u0011q\u0003\u0006\u0004\u00033\u0001\u0014!\u0002;za\u0016\u001c\u0018\u0002BA\u000f\u0003/\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!a\t\u0011\t\u0005U\u0011QE\u0005\u0005\u0003O\t9B\u0001\u0005ECR\fG+\u001f9f\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\rA\u0015Q\u0006\u0005\u0006_>\u0001\rAX\u0001\ru>tW-\u00133J]\u00163\u0018\r\\\u000b\u0003\u0003g\u0001B!!\u000e\u0002@5\u0011\u0011q\u0007\u0006\u0005\u0003s\tY$\u0001\u0003uS6,'BAA\u001f\u0003\u0011Q\u0017M^1\n\t\u0005\u0005\u0013q\u0007\u0002\u00075>tW-\u00133)\u0007A\t)\u0005E\u0002M\u0003\u000fJ1!!\u0013N\u0005%!(/\u00198tS\u0016tG/\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0004\u0002P\u0005U\u0013\u0011\f\t\u0004\u0019\u0006E\u0013bAA*\u001b\n\u0019\u0011I\\=\t\u000f\u0005]\u0013\u00031\u0001\u0002P\u0005Y1\u000f^1si6K7M]8t\u0011\u001d\tY&\u0005a\u0001\u0003\u001f\n\u0011\"\u001a8e\u001b&\u001c'o\\:\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA1\u0003[\n9\b\u0005\u0003\u0002d\u0005%TBAA3\u0015\r\t9\u0007L\u0001\bG>$WmZ3o\u0013\u0011\tY'!\u001a\u0003\u0011\u0015C\bO]\"pI\u0016Dq!a\u001c\u0013\u0001\u0004\t\t(A\u0002dib\u0004B!a\u0019\u0002t%!\u0011QOA3\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!!\u001f\u0013\u0001\u0004\t\t'\u0001\u0002fm\u0006Q\u0001O]3uift\u0015-\\3\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#B<\u0002\u0002\u0006\u0015\u0005BBAB+\u0001\u0007\u0011.A\u0004oK^dUM\u001a;\t\r\u0005\u001dU\u00031\u0001j\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$\u0012b^AG\u0003\u001f\u000b\t*a%\t\u000fq3\u0002\u0013!a\u0001=\"9qM\u0006I\u0001\u0002\u0004I\u0007bB7\u0017!\u0003\u0005\r!\u001b\u0005\b_Z\u0001\n\u00111\u0001r\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!'+\u0007y\u000bYj\u000b\u0002\u0002\u001eB!\u0011qTAU\u001b\t\t\tK\u0003\u0003\u0002$\u0006\u0015\u0016!C;oG\",7m[3e\u0015\r\t9+T\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAV\u0003C\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!-+\u0007%\fY*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011\u0011\u0018\u0016\u0004c\u0006m\u0015!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002@B!\u0011\u0011YAd\u001b\t\t\u0019M\u0003\u0003\u0002F\u0006m\u0012\u0001\u00027b]\u001eL1\u0001ZAb\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\rE\u0002M\u0003\u001fL1!!5N\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ty%a6\t\u0013\u0005eW$!AA\u0002\u00055\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002`B1\u0011\u0011]At\u0003\u001fj!!a9\u000b\u0007\u0005\u0015X*\u0001\u0006d_2dWm\u0019;j_:LA!!;\u0002d\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ty/!>\u0011\u00071\u000b\t0C\u0002\u0002t6\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002Z~\t\t\u00111\u0001\u0002P\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\ty,a?\t\u0013\u0005e\u0007%!AA\u0002\u00055\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002p\n\u0005\u0001\"CAmC\u0005\u0005\t\u0019AA(Q]\u0001!Q\u0001B\u0006\u0005\u001b\u0011\tBa\u0005\u0003\u0018\te!Q\u0004B\u0010\u0005G\u0011)\u0003E\u0002<\u0005\u000fI1A!\u0003-\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#Aa\u0004\u0002\u0003Ozf)\u0016(D?\"*h.\u001b;-AM$\u0018M\u001d;US6,7\u000f^1na2\u0002SM\u001c3US6,7\u000f^1na&\u0002S\u0006I$fiN\u0004C\u000f[3!I&4g-\u001a:f]\u000e,\u0007EY3uo\u0016,g\u000e\t;iK\u0002\"\u0018.\\3ti\u0006l\u0007o\u001d\u0011aK:$G+[7fgR\fW\u000e\u001d1!C:$\u0007\u0005Y:uCJ$H+[7fgR\fW\u000e\u001d1!S:\u0004C\u000f[3!gB,7-\u001b4jK\u0012\u0004SO\\5ug\u0002\u0012\u0017\u0010\t;sk:\u001c\u0017\r^5oO\u0002\"\b.\u001a\u0011ge\u0006\u001cG/[8oAA\f'\u000f\u001e\u0018\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018E\u0001B\u000b\u0003\u0011-%\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011v]&$\b%\f\u0011uQ&\u001c\b%\u001b8eS\u000e\fG/Z:!i\",\u0007%\u001e8jiN\u0004sN\u001a\u0011uQ\u0016\u0004C-\u001b4gKJ,gnY3!E\u0016$x/Z3oAQDW\rI4jm\u0016t\u0007\u0005^5nKN$\u0018-\u001c9t])\u0001\u0003\u0005\t\u0011!A\u0001\u00023+\u001e9q_J$X\r\u001a\u0011tiJLgn\u001a\u0011wC2,Xm\u001d\u0011pM\u0002\u0002WO\\5uA\u0002\n'/\u001a\u0011)G\u0006\u001cX\rI5og\u0016t7/\u001b;jm\u0016L#H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#%W#B%\nR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\t\nV+\u0011*U\u000bJ\u0013\u0003%\f\u00114A5|g\u000e\u001e5t\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#\u001b>sE\u000b\u0013\u0012\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012X\u000b\u0016[%\u0005I\u0017!o\u0001\"\u0017-_:\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012E\u0003f\u0013#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u0012\u0003jT+SE)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E5Ke*\u0016+FE)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!EM+5i\u0014(EE)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E5KE\nT%T\u000b\u000e{e\n\u0012\u0012\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012N\u0013\u000e\u0013vjU#D\u001f:#%E\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011ti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9![\u0001\n\u0005\u0005^5nKN$\u0018-\u001c9!o\"L7\r\u001b\u0011uQ\u0016\u0004S\r\u001f9sKN\u001c\u0018n\u001c8!gV\u0014GO]1diN\u0004cM]8nA\u0001,g\u000e\u001a+j[\u0016\u001cH/Y7qA:R\u0001\u0005\t\u0011!A\u0001R\u0003%\u001a8e)&lWm\u001d;b[B\u0004S\u0006I!!i&lWm\u001d;b[B\u0004cM]8nA]D\u0017n\u00195!i\",\u0007%\u001a=qe\u0016\u001c8/[8oAM,(\r\u001e:bGR\u001c\b\u0005Y:uCJ$H+[7fgR\fW\u000e\u001d1/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\tm\u0011aa \u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q!{UK\u0015\u0017!i&lWm\u001d;b[B|f\u000e\u001e>(eA\u0012$'\f\u00193[E\n\u0004E\r\u0019;gAR\u0004\u0007M\u0014-AQLW.Z:uC6\u0004xL\u001c;{OI\u0002$GM\u00171e5\n$\u0007\t\u00195uM\u0002$\b\r\u0019(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015N\u001f:#\u0006\n\f\u0011uS6,7\u000f^1na~cGO_\u00143aI\u0012T\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1ai\u0002\u0004g\n\u0017!i&lWm\u001d;b[B|F\u000e\u001e>(eA\u0012$'\f\u00193[IB\u0004\u0005\r\u0019;aAR\u0004\u0007M\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\n$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK*F\u0007>sE\t\f\u0011eCR,wE\r\u00193e5\u0002\u0014'\f\u00192O1\u0002C/[7fgR\fW\u000e]\u00143aI\nT&\r\u001a.gE\u0002#g\r\u001e6si*\u0004gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A5\n\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015Z\u000b\u0006\u0013F\u0006\t;j[\u0016\u001cH/Y7qOI\u0002\u0004\u0007M\u00171c5\u0002\u0014\u0007\t\u00192uA\u0012$\bM\u001a/cI\u001aD'\u000e\u001c(Y\u0001\"\u0018.\\3ti\u0006l\u0007o\n\u001a1cAj\u0003'M\u00171c\u0001\u0002\u0014G\u000f\u00193uA\u001ad&\r\u001a4iU2t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cAR\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005C\ta\u0002Z1uKRLW.Z0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0003(\u0005)1GL\u001a/a\u0005iA+[7fgR\fW\u000e\u001d#jM\u001a\u0004\"aO\u0012\u0014\u000b\r\u0012yCa\u000f\u0011\u0013\tE\"q\u00070jSF<XB\u0001B\u001a\u0015\r\u0011)$T\u0001\beVtG/[7f\u0013\u0011\u0011IDa\r\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0005\u0003\u0003>\t\rSB\u0001B \u0015\u0011\u0011\t%a\u000f\u0002\u0005%|\u0017b\u0001.\u0003@Q\u0011!1F\u0001\ti>\u001cFO]5oOR\u0011\u0011qX\u0001\u0006CB\u0004H.\u001f\u000b\no\n=#\u0011\u000bB*\u0005+BQ\u0001\u0018\u0014A\u0002yCQa\u001a\u0014A\u0002%DQ!\u001c\u0014A\u0002%Dqa\u001c\u0014\u0011\u0002\u0003\u0007\u0011/A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0003\u001d)h.\u00199qYf$BA!\u0018\u0003fA!AJ\u001dB0!\u001da%\u0011\r0jSFL1Aa\u0019N\u0005\u0019!V\u000f\u001d7fi!A!q\r\u0015\u0002\u0002\u0003\u0007q/A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B8!\u0011\t\tM!\u001d\n\t\tM\u00141\u0019\u0002\u0007\u001f\nTWm\u0019;")
public class TimestampDiff
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
TimeZoneAwareExpression,
Serializable {
    private transient ZoneId zoneIdInEval;
    private final String unit;
    private final Expression startTimestamp;
    private final Expression endTimestamp;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$4() {
        return TimestampDiff$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<String, Expression, Expression, Option<String>>> unapply(TimestampDiff x$0) {
        return TimestampDiff$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$4() {
        return TimestampDiff$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<String, Expression, Expression, Option<String>>, TimestampDiff> tupled() {
        return TimestampDiff$.MODULE$.tupled();
    }

    public static Function1<String, Function1<Expression, Function1<Expression, Function1<Option<String>, TimestampDiff>>>> curried() {
        return TimestampDiff$.MODULE$.curried();
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        TimestampDiff timestampDiff = this;
        synchronized (timestampDiff) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        TimestampDiff timestampDiff = this;
        synchronized (timestampDiff) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public String unit() {
        return this.unit;
    }

    public Expression startTimestamp() {
        return this.startTimestamp;
    }

    public Expression endTimestamp() {
        return this.endTimestamp;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.startTimestamp();
    }

    @Override
    public Expression right() {
        return this.endTimestamp();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TimestampType$.MODULE$, (List)new .colon.colon((Object)TimestampType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        String x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    private ZoneId zoneIdInEval$lzycompute() {
        TimestampDiff timestampDiff = this;
        synchronized (timestampDiff) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.zoneIdInEval = this.zoneIdForType(this.endTimestamp().dataType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.zoneIdInEval;
    }

    private ZoneId zoneIdInEval() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.zoneIdInEval$lzycompute();
        }
        return this.zoneIdInEval;
    }

    @Override
    public Object nullSafeEval(Object startMicros, Object endMicros) {
        return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff(this.unit(), BoxesRunTime.unboxToLong((Object)startMicros), BoxesRunTime.unboxToLong((Object)endMicros), this.zoneIdInEval()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName()), "$");
        String zid = ctx.addReferenceObj("zoneId", this.zoneIdInEval(), ZoneId.class.getName());
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(s, e) -> dtu + ".timestampDiff(\"" + this.unit() + "\", " + s + ", " + e + ", " + zid + ")");
    }

    @Override
    public String prettyName() {
        return "timestampdiff";
    }

    @Override
    public String sql() {
        String string = this.unit();
        String childrenSQL = ((IterableOnceOps)((SeqOps)this.children().map((Function1 & Serializable)x$13 -> x$13.sql())).$plus$colon((Object)string)).mkString(", ");
        return this.prettyName() + "(" + childrenSQL + ")";
    }

    @Override
    public TimestampDiff withNewChildrenInternal(Expression newLeft, Expression newRight) {
        Expression x$1 = newLeft;
        Expression x$2 = newRight;
        String x$3 = this.copy$default$1();
        Option<String> x$4 = this.copy$default$4();
        return this.copy(x$3, x$1, x$2, x$4);
    }

    public TimestampDiff copy(String unit, Expression startTimestamp, Expression endTimestamp, Option<String> timeZoneId) {
        return new TimestampDiff(unit, startTimestamp, endTimestamp, timeZoneId);
    }

    public String copy$default$1() {
        return this.unit();
    }

    public Expression copy$default$2() {
        return this.startTimestamp();
    }

    public Expression copy$default$3() {
        return this.endTimestamp();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "TimestampDiff";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.unit();
            }
            case 1: {
                return this.startTimestamp();
            }
            case 2: {
                return this.endTimestamp();
            }
            case 3: {
                return this.timeZoneId();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TimestampDiff;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "unit";
            }
            case 1: {
                return "startTimestamp";
            }
            case 2: {
                return "endTimestamp";
            }
            case 3: {
                return "timeZoneId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TimestampDiff)) return false;
        boolean bl = true;
        if (!bl) return false;
        TimestampDiff timestampDiff = (TimestampDiff)x$1;
        String string = this.unit();
        String string2 = timestampDiff.unit();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Expression expression = this.startTimestamp();
        Expression expression2 = timestampDiff.startTimestamp();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.endTimestamp();
        Expression expression4 = timestampDiff.endTimestamp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = timestampDiff.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!timestampDiff.canEqual(this)) return false;
        return true;
    }

    public TimestampDiff(String unit, Expression startTimestamp, Expression endTimestamp, Option<String> timeZoneId) {
        this.unit = unit;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.timeZoneId = timeZoneId;
        ExpectsInputTypes.$init$(this);
        TimeZoneAwareExpression.$init$(this);
        Statics.releaseFence();
    }

    public TimestampDiff(String unit, Expression quantity, Expression timestamp) {
        this(unit, quantity, timestamp, (Option<String>)None$.MODULE$);
    }
}

