/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.catalyst.expressions.SpecializedGettersReader;
import org.apache.spark.sql.catalyst.expressions.UnsafeDataUtils;
import org.apache.spark.sql.catalyst.expressions.UnsafeMapData;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.bitset.BitSetMethods;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.unsafe.types.VariantVal;

public final class UnsafeArrayData
extends ArrayData
implements Externalizable,
KryoSerializable {
    private Object baseObject;
    private long baseOffset;
    private int numElements;
    private int sizeInBytes;
    private long elementOffset;

    public static int calculateHeaderPortionInBytes(int numFields) {
        return (int)UnsafeArrayData.calculateHeaderPortionInBytes((long)numFields);
    }

    public static long calculateHeaderPortionInBytes(long numFields) {
        return 8L + (numFields + 63L) / 64L * 8L;
    }

    private long getElementOffset(int ordinal, int elementSize) {
        return this.elementOffset + (long)ordinal * (long)elementSize;
    }

    public Object getBaseObject() {
        return this.baseObject;
    }

    public long getBaseOffset() {
        return this.baseOffset;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    private void assertIndexIsValid(int ordinal) {
        assert (ordinal >= 0) : "ordinal (" + ordinal + ") should >= 0";
        assert (ordinal < this.numElements) : "ordinal (" + ordinal + ") should < " + this.numElements;
    }

    @Override
    public Object[] array() {
        throw SparkUnsupportedOperationException.apply();
    }

    @Override
    public int numElements() {
        return this.numElements;
    }

    public void pointTo(Object baseObject, long baseOffset, int sizeInBytes) {
        long numElements = Platform.getLong((Object)baseObject, (long)baseOffset);
        assert (numElements >= 0L) : "numElements (" + numElements + ") should >= 0";
        assert (numElements <= Integer.MAX_VALUE) : "numElements (" + numElements + ") should <= Integer.MAX_VALUE";
        this.numElements = (int)numElements;
        this.baseObject = baseObject;
        this.baseOffset = baseOffset;
        this.sizeInBytes = sizeInBytes;
        this.elementOffset = baseOffset + (long)UnsafeArrayData.calculateHeaderPortionInBytes(this.numElements);
    }

    @Override
    public boolean isNullAt(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return BitSetMethods.isSet((Object)this.baseObject, (long)(this.baseOffset + 8L), (int)ordinal);
    }

    @Override
    public Object get(int ordinal, DataType dataType) {
        return SpecializedGettersReader.read(this, ordinal, dataType, true, true);
    }

    @Override
    public boolean getBoolean(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return Platform.getBoolean((Object)this.baseObject, (long)this.getElementOffset(ordinal, 1));
    }

    @Override
    public byte getByte(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return Platform.getByte((Object)this.baseObject, (long)this.getElementOffset(ordinal, 1));
    }

    @Override
    public short getShort(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return Platform.getShort((Object)this.baseObject, (long)this.getElementOffset(ordinal, 2));
    }

    @Override
    public int getInt(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return Platform.getInt((Object)this.baseObject, (long)this.getElementOffset(ordinal, 4));
    }

    @Override
    public long getLong(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return Platform.getLong((Object)this.baseObject, (long)this.getElementOffset(ordinal, 8));
    }

    @Override
    public float getFloat(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return Platform.getFloat((Object)this.baseObject, (long)this.getElementOffset(ordinal, 4));
    }

    @Override
    public double getDouble(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return Platform.getDouble((Object)this.baseObject, (long)this.getElementOffset(ordinal, 8));
    }

    @Override
    public Decimal getDecimal(int ordinal, int precision, int scale) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        if (precision <= Decimal.MAX_LONG_DIGITS()) {
            return Decimal.apply((long)this.getLong(ordinal), (int)precision, (int)scale);
        }
        byte[] bytes = this.getBinary(ordinal);
        BigInteger bigInteger = new BigInteger(bytes);
        BigDecimal javaDecimal = new BigDecimal(bigInteger, scale);
        return Decimal.apply((scala.math.BigDecimal)new scala.math.BigDecimal(javaDecimal), (int)precision, (int)scale);
    }

    @Override
    public UTF8String getUTF8String(int ordinal) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getLong(ordinal);
        int offset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        return UTF8String.fromAddress((Object)this.baseObject, (long)(this.baseOffset + (long)offset), (int)size);
    }

    @Override
    public byte[] getBinary(int ordinal) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getLong(ordinal);
        int offset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        byte[] bytes = new byte[size];
        Platform.copyMemory((Object)this.baseObject, (long)(this.baseOffset + (long)offset), (Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, (long)size);
        return bytes;
    }

    @Override
    public CalendarInterval getInterval(int ordinal) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getLong(ordinal);
        int offset = (int)(offsetAndSize >> 32);
        int months = Platform.getInt((Object)this.baseObject, (long)(this.baseOffset + (long)offset));
        int days = Platform.getInt((Object)this.baseObject, (long)(this.baseOffset + (long)offset + 4L));
        long microseconds = Platform.getLong((Object)this.baseObject, (long)(this.baseOffset + (long)offset + 8L));
        return new CalendarInterval(months, days, microseconds);
    }

    @Override
    public VariantVal getVariant(int ordinal) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        return VariantVal.readFromUnsafeRow((long)this.getLong(ordinal), (Object)this.baseObject, (long)this.baseOffset);
    }

    @Override
    public UnsafeRow getStruct(int ordinal, int numFields) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getLong(ordinal);
        int offset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        UnsafeRow row = new UnsafeRow(numFields);
        row.pointTo(this.baseObject, this.baseOffset + (long)offset, size);
        return row;
    }

    @Override
    public UnsafeArrayData getArray(int ordinal) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getLong(ordinal);
        int offset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        UnsafeArrayData array = new UnsafeArrayData();
        array.pointTo(this.baseObject, this.baseOffset + (long)offset, size);
        return array;
    }

    @Override
    public UnsafeMapData getMap(int ordinal) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getLong(ordinal);
        int offset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        UnsafeMapData map = new UnsafeMapData();
        map.pointTo(this.baseObject, this.baseOffset + (long)offset, size);
        return map;
    }

    @Override
    public void update(int ordinal, Object value) {
        throw SparkUnsupportedOperationException.apply();
    }

    @Override
    public void setNullAt(int ordinal) {
        this.assertIndexIsValid(ordinal);
        BitSetMethods.set((Object)this.baseObject, (long)(this.baseOffset + 8L), (int)ordinal);
    }

    @Override
    public void setBoolean(int ordinal, boolean value) {
        this.assertIndexIsValid(ordinal);
        Platform.putBoolean((Object)this.baseObject, (long)this.getElementOffset(ordinal, 1), (boolean)value);
    }

    @Override
    public void setByte(int ordinal, byte value) {
        this.assertIndexIsValid(ordinal);
        Platform.putByte((Object)this.baseObject, (long)this.getElementOffset(ordinal, 1), (byte)value);
    }

    @Override
    public void setShort(int ordinal, short value) {
        this.assertIndexIsValid(ordinal);
        Platform.putShort((Object)this.baseObject, (long)this.getElementOffset(ordinal, 2), (short)value);
    }

    @Override
    public void setInt(int ordinal, int value) {
        this.assertIndexIsValid(ordinal);
        Platform.putInt((Object)this.baseObject, (long)this.getElementOffset(ordinal, 4), (int)value);
    }

    @Override
    public void setLong(int ordinal, long value) {
        this.assertIndexIsValid(ordinal);
        Platform.putLong((Object)this.baseObject, (long)this.getElementOffset(ordinal, 8), (long)value);
    }

    @Override
    public void setFloat(int ordinal, float value) {
        this.assertIndexIsValid(ordinal);
        Platform.putFloat((Object)this.baseObject, (long)this.getElementOffset(ordinal, 4), (float)value);
    }

    @Override
    public void setDouble(int ordinal, double value) {
        this.assertIndexIsValid(ordinal);
        Platform.putDouble((Object)this.baseObject, (long)this.getElementOffset(ordinal, 8), (double)value);
    }

    public int hashCode() {
        return Murmur3_x86_32.hashUnsafeBytes((Object)this.baseObject, (long)this.baseOffset, (int)this.sizeInBytes, (int)42);
    }

    public boolean equals(Object other) {
        if (other instanceof UnsafeArrayData) {
            UnsafeArrayData o = (UnsafeArrayData)other;
            return this.sizeInBytes == o.sizeInBytes && ByteArrayMethods.arrayEquals((Object)this.baseObject, (long)this.baseOffset, (Object)o.baseObject, (long)o.baseOffset, (long)this.sizeInBytes);
        }
        return false;
    }

    public void writeToMemory(Object target, long targetOffset) {
        Platform.copyMemory((Object)this.baseObject, (long)this.baseOffset, (Object)target, (long)targetOffset, (long)this.sizeInBytes);
    }

    public void writeTo(ByteBuffer buffer) {
        assert (buffer.hasArray());
        byte[] target = buffer.array();
        int offset = buffer.arrayOffset();
        int pos = buffer.position();
        this.writeToMemory(target, Platform.BYTE_ARRAY_OFFSET + offset + pos);
        buffer.position(pos + this.sizeInBytes);
    }

    @Override
    public UnsafeArrayData copy() {
        UnsafeArrayData arrayCopy = new UnsafeArrayData();
        byte[] arrayDataCopy = new byte[this.sizeInBytes];
        Platform.copyMemory((Object)this.baseObject, (long)this.baseOffset, (Object)arrayDataCopy, (long)Platform.BYTE_ARRAY_OFFSET, (long)this.sizeInBytes);
        arrayCopy.pointTo(arrayDataCopy, Platform.BYTE_ARRAY_OFFSET, this.sizeInBytes);
        return arrayCopy;
    }

    @Override
    public boolean[] toBooleanArray() {
        boolean[] values = new boolean[this.numElements];
        Platform.copyMemory((Object)this.baseObject, (long)this.elementOffset, (Object)values, (long)Platform.BOOLEAN_ARRAY_OFFSET, (long)this.numElements);
        return values;
    }

    @Override
    public byte[] toByteArray() {
        byte[] values = new byte[this.numElements];
        Platform.copyMemory((Object)this.baseObject, (long)this.elementOffset, (Object)values, (long)Platform.BYTE_ARRAY_OFFSET, (long)this.numElements);
        return values;
    }

    @Override
    public short[] toShortArray() {
        short[] values = new short[this.numElements];
        Platform.copyMemory((Object)this.baseObject, (long)this.elementOffset, (Object)values, (long)Platform.SHORT_ARRAY_OFFSET, (long)((long)this.numElements * 2L));
        return values;
    }

    @Override
    public int[] toIntArray() {
        int[] values = new int[this.numElements];
        Platform.copyMemory((Object)this.baseObject, (long)this.elementOffset, (Object)values, (long)Platform.INT_ARRAY_OFFSET, (long)((long)this.numElements * 4L));
        return values;
    }

    @Override
    public long[] toLongArray() {
        long[] values = new long[this.numElements];
        Platform.copyMemory((Object)this.baseObject, (long)this.elementOffset, (Object)values, (long)Platform.LONG_ARRAY_OFFSET, (long)((long)this.numElements * 8L));
        return values;
    }

    @Override
    public float[] toFloatArray() {
        float[] values = new float[this.numElements];
        Platform.copyMemory((Object)this.baseObject, (long)this.elementOffset, (Object)values, (long)Platform.FLOAT_ARRAY_OFFSET, (long)((long)this.numElements * 4L));
        return values;
    }

    @Override
    public double[] toDoubleArray() {
        double[] values = new double[this.numElements];
        Platform.copyMemory((Object)this.baseObject, (long)this.elementOffset, (Object)values, (long)Platform.DOUBLE_ARRAY_OFFSET, (long)((long)this.numElements * 8L));
        return values;
    }

    public static UnsafeArrayData fromPrimitiveArray(Object arr, int offset, int length, int elementSize) {
        long valueRegionInBytes;
        long headerInBytes = UnsafeArrayData.calculateHeaderPortionInBytes(length);
        long totalSizeInLongs = (headerInBytes + (valueRegionInBytes = (long)elementSize * (long)length) + 7L) / 8L;
        if (totalSizeInLongs > 0xFFFFFFFL) {
            throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3129");
        }
        long[] data = new long[(int)totalSizeInLongs];
        Platform.putLong((Object)data, (long)Platform.LONG_ARRAY_OFFSET, (long)length);
        if (arr != null) {
            Platform.copyMemory((Object)arr, (long)offset, (Object)data, (long)((long)Platform.LONG_ARRAY_OFFSET + headerInBytes), (long)valueRegionInBytes);
        }
        UnsafeArrayData result = new UnsafeArrayData();
        result.pointTo(data, Platform.LONG_ARRAY_OFFSET, (int)totalSizeInLongs * 8);
        return result;
    }

    public static UnsafeArrayData createFreshArray(int length, int elementSize) {
        long valueRegionInBytes;
        long headerInBytes = UnsafeArrayData.calculateHeaderPortionInBytes(length);
        long totalSizeInLongs = (headerInBytes + (valueRegionInBytes = (long)elementSize * (long)length) + 7L) / 8L;
        if (totalSizeInLongs > 0xFFFFFFFL) {
            throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3129");
        }
        long[] data = new long[(int)totalSizeInLongs];
        Platform.putLong((Object)data, (long)Platform.LONG_ARRAY_OFFSET, (long)length);
        UnsafeArrayData result = new UnsafeArrayData();
        result.pointTo(data, Platform.LONG_ARRAY_OFFSET, (int)totalSizeInLongs * 8);
        return result;
    }

    public static boolean shouldUseGenericArrayData(int elementSize, long length) {
        long valueRegionInBytes;
        long headerInBytes = UnsafeArrayData.calculateHeaderPortionInBytes(length);
        long totalSizeInLongs = (headerInBytes + (valueRegionInBytes = (long)elementSize * length) + 7L) / 8L;
        return totalSizeInLongs > 0xFFFFFFFL;
    }

    public static UnsafeArrayData fromPrimitiveArray(boolean[] arr) {
        return UnsafeArrayData.fromPrimitiveArray(arr, Platform.BOOLEAN_ARRAY_OFFSET, arr.length, 1);
    }

    public static UnsafeArrayData fromPrimitiveArray(byte[] arr) {
        return UnsafeArrayData.fromPrimitiveArray(arr, Platform.BYTE_ARRAY_OFFSET, arr.length, 1);
    }

    public static UnsafeArrayData fromPrimitiveArray(short[] arr) {
        return UnsafeArrayData.fromPrimitiveArray(arr, Platform.SHORT_ARRAY_OFFSET, arr.length, 2);
    }

    public static UnsafeArrayData fromPrimitiveArray(int[] arr) {
        return UnsafeArrayData.fromPrimitiveArray(arr, Platform.INT_ARRAY_OFFSET, arr.length, 4);
    }

    public static UnsafeArrayData fromPrimitiveArray(long[] arr) {
        return UnsafeArrayData.fromPrimitiveArray(arr, Platform.LONG_ARRAY_OFFSET, arr.length, 8);
    }

    public static UnsafeArrayData fromPrimitiveArray(float[] arr) {
        return UnsafeArrayData.fromPrimitiveArray(arr, Platform.FLOAT_ARRAY_OFFSET, arr.length, 4);
    }

    public static UnsafeArrayData fromPrimitiveArray(double[] arr) {
        return UnsafeArrayData.fromPrimitiveArray(arr, Platform.DOUBLE_ARRAY_OFFSET, arr.length, 8);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] bytes = UnsafeDataUtils.getBytes(this.baseObject, this.baseOffset, this.sizeInBytes);
        out.writeInt(bytes.length);
        out.writeInt(this.numElements);
        out.write(bytes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.baseOffset = Platform.BYTE_ARRAY_OFFSET;
        this.sizeInBytes = in.readInt();
        this.numElements = in.readInt();
        this.elementOffset = this.baseOffset + (long)UnsafeArrayData.calculateHeaderPortionInBytes(this.numElements);
        this.baseObject = new byte[this.sizeInBytes];
        in.readFully((byte[])this.baseObject);
    }

    public void write(Kryo kryo, Output output) {
        byte[] bytes = UnsafeDataUtils.getBytes(this.baseObject, this.baseOffset, this.sizeInBytes);
        output.writeInt(bytes.length);
        output.writeInt(this.numElements);
        output.write(bytes);
    }

    public void read(Kryo kryo, Input input) {
        this.baseOffset = Platform.BYTE_ARRAY_OFFSET;
        this.sizeInBytes = input.readInt();
        this.numElements = input.readInt();
        this.elementOffset = this.baseOffset + (long)UnsafeArrayData.calculateHeaderPortionInBytes(this.numElements);
        this.baseObject = new byte[this.sizeInBytes];
        input.read((byte[])this.baseObject);
    }
}

