/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGettersReader;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.UnsafeDataUtils;
import org.apache.spark.sql.catalyst.expressions.UnsafeMapData;
import org.apache.spark.sql.catalyst.types.PhysicalCalendarIntervalType;
import org.apache.spark.sql.catalyst.types.PhysicalDataType;
import org.apache.spark.sql.catalyst.types.PhysicalDecimalType;
import org.apache.spark.sql.catalyst.types.PhysicalPrimitiveType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.bitset.BitSetMethods;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.unsafe.types.VariantVal;

public final class UnsafeRow
extends InternalRow
implements Externalizable,
KryoSerializable {
    public static final int WORD_SIZE = 8;
    private Object baseObject;
    private long baseOffset;
    private int numFields;
    private int sizeInBytes;
    private int bitSetWidthInBytes;

    public static int calculateBitSetWidthInBytes(int numFields) {
        return (numFields + 63) / 64 * 8;
    }

    public static boolean isFixedLength(DataType dt) {
        if (dt instanceof UserDefinedType) {
            UserDefinedType udt = (UserDefinedType)dt;
            return UnsafeRow.isFixedLength(udt.sqlType());
        }
        PhysicalDataType pdt = PhysicalDataType.apply(dt);
        if (pdt instanceof PhysicalDecimalType) {
            return ((DecimalType)dt).precision() <= Decimal.MAX_LONG_DIGITS();
        }
        return pdt instanceof PhysicalPrimitiveType;
    }

    public static boolean isMutable(DataType dt) {
        if (dt instanceof UserDefinedType) {
            UserDefinedType udt = (UserDefinedType)dt;
            return UnsafeRow.isMutable(udt.sqlType());
        }
        PhysicalDataType pdt = PhysicalDataType.apply(dt);
        return pdt instanceof PhysicalPrimitiveType || pdt instanceof PhysicalDecimalType || pdt instanceof PhysicalCalendarIntervalType;
    }

    private long getFieldOffset(int ordinal) {
        return this.baseOffset + (long)this.bitSetWidthInBytes + (long)ordinal * 8L;
    }

    private void assertIndexIsValid(int index) {
        assert (index >= 0) : "index (" + index + ") should >= 0";
        assert (index < this.numFields) : "index (" + index + ") should < " + this.numFields;
    }

    public UnsafeRow(int numFields) {
        this.numFields = numFields;
        this.bitSetWidthInBytes = UnsafeRow.calculateBitSetWidthInBytes(numFields);
    }

    public UnsafeRow() {
    }

    public Object getBaseObject() {
        return this.baseObject;
    }

    public long getBaseOffset() {
        return this.baseOffset;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public int numFields() {
        return this.numFields;
    }

    public void pointTo(Object baseObject, long baseOffset, int sizeInBytes) {
        assert (this.numFields >= 0) : "numFields (" + this.numFields + ") should >= 0";
        assert (sizeInBytes % 8 == 0) : "sizeInBytes (" + sizeInBytes + ") should be a multiple of 8";
        this.baseObject = baseObject;
        this.baseOffset = baseOffset;
        this.sizeInBytes = sizeInBytes;
    }

    public void pointTo(byte[] buf, int sizeInBytes) {
        this.pointTo(buf, Platform.BYTE_ARRAY_OFFSET, sizeInBytes);
    }

    public void setTotalSize(int sizeInBytes) {
        assert (sizeInBytes % 8 == 0) : "sizeInBytes (" + sizeInBytes + ") should be a multiple of 8";
        this.sizeInBytes = sizeInBytes;
    }

    public void setNotNullAt(int i) {
        this.assertIndexIsValid(i);
        BitSetMethods.unset((Object)this.baseObject, (long)this.baseOffset, (int)i);
    }

    @Override
    public void setNullAt(int i) {
        this.assertIndexIsValid(i);
        BitSetMethods.set((Object)this.baseObject, (long)this.baseOffset, (int)i);
        Platform.putLong((Object)this.baseObject, (long)this.getFieldOffset(i), (long)0L);
    }

    @Override
    public void update(int ordinal, Object value) {
        throw SparkUnsupportedOperationException.apply();
    }

    @Override
    public void setInt(int ordinal, int value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        Platform.putInt((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (int)value);
    }

    @Override
    public void setLong(int ordinal, long value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        Platform.putLong((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (long)value);
    }

    @Override
    public void setDouble(int ordinal, double value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        Platform.putDouble((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (double)value);
    }

    @Override
    public void setBoolean(int ordinal, boolean value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        Platform.putBoolean((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (boolean)value);
    }

    @Override
    public void setShort(int ordinal, short value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        Platform.putShort((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (short)value);
    }

    @Override
    public void setByte(int ordinal, byte value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        Platform.putByte((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (byte)value);
    }

    @Override
    public void setFloat(int ordinal, float value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        Platform.putFloat((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (float)value);
    }

    @Override
    public void setDecimal(int ordinal, Decimal value, int precision) {
        this.assertIndexIsValid(ordinal);
        if (precision <= Decimal.MAX_LONG_DIGITS()) {
            if (value == null) {
                this.setNullAt(ordinal);
            } else {
                this.setLong(ordinal, value.toUnscaledLong());
            }
        } else {
            long cursor = this.getLong(ordinal) >>> 32;
            assert (cursor > 0L) : "invalid cursor " + cursor;
            Platform.putLong((Object)this.baseObject, (long)(this.baseOffset + cursor), (long)0L);
            Platform.putLong((Object)this.baseObject, (long)(this.baseOffset + cursor + 8L), (long)0L);
            if (value == null || !value.changePrecision(precision, value.scale())) {
                this.setNullAt(ordinal);
                Platform.putLong((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (long)(cursor << 32));
            } else {
                BigInteger integer = value.toJavaBigDecimal().unscaledValue();
                byte[] bytes = integer.toByteArray();
                assert (bytes.length <= 16);
                Platform.copyMemory((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, (Object)this.baseObject, (long)(this.baseOffset + cursor), (long)bytes.length);
                this.setLong(ordinal, cursor << 32 | (long)bytes.length);
            }
        }
    }

    @Override
    public void setInterval(int ordinal, CalendarInterval value) {
        this.assertIndexIsValid(ordinal);
        long cursor = this.getLong(ordinal) >>> 32;
        assert (cursor > 0L) : "invalid cursor " + cursor;
        if (value == null) {
            this.setNullAt(ordinal);
            Platform.putLong((Object)this.baseObject, (long)(this.baseOffset + cursor), (long)0L);
            Platform.putLong((Object)this.baseObject, (long)(this.baseOffset + cursor + 8L), (long)0L);
            Platform.putLong((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (long)(cursor << 32 | 0x10L));
        } else {
            long longVal = (long)value.months & 0xFFFFFFFFL | (long)value.days << 32 & 0xFFFFFFFF00000000L;
            Platform.putLong((Object)this.baseObject, (long)(this.baseOffset + cursor), (long)longVal);
            Platform.putLong((Object)this.baseObject, (long)(this.baseOffset + cursor + 8L), (long)value.microseconds);
            this.setLong(ordinal, cursor << 32 | 0x10L);
        }
    }

    @Override
    public Object get(int ordinal, DataType dataType) {
        return SpecializedGettersReader.read(this, ordinal, dataType, true, true);
    }

    @Override
    public boolean isNullAt(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return BitSetMethods.isSet((Object)this.baseObject, (long)this.baseOffset, (int)ordinal);
    }

    @Override
    public boolean getBoolean(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return Platform.getBoolean((Object)this.baseObject, (long)this.getFieldOffset(ordinal));
    }

    @Override
    public byte getByte(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return Platform.getByte((Object)this.baseObject, (long)this.getFieldOffset(ordinal));
    }

    @Override
    public short getShort(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return Platform.getShort((Object)this.baseObject, (long)this.getFieldOffset(ordinal));
    }

    @Override
    public int getInt(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return Platform.getInt((Object)this.baseObject, (long)this.getFieldOffset(ordinal));
    }

    @Override
    public long getLong(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return Platform.getLong((Object)this.baseObject, (long)this.getFieldOffset(ordinal));
    }

    @Override
    public float getFloat(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return Platform.getFloat((Object)this.baseObject, (long)this.getFieldOffset(ordinal));
    }

    @Override
    public double getDouble(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return Platform.getDouble((Object)this.baseObject, (long)this.getFieldOffset(ordinal));
    }

    @Override
    public Decimal getDecimal(int ordinal, int precision, int scale) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        if (precision <= Decimal.MAX_LONG_DIGITS()) {
            return Decimal.createUnsafe((long)this.getLong(ordinal), (int)precision, (int)scale);
        }
        byte[] bytes = this.getBinary(ordinal);
        BigInteger bigInteger = new BigInteger(bytes);
        BigDecimal javaDecimal = new BigDecimal(bigInteger, scale);
        return Decimal.apply((BigDecimal)javaDecimal, (int)precision, (int)scale);
    }

    @Override
    public UTF8String getUTF8String(int ordinal) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getLong(ordinal);
        int offset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        return UTF8String.fromAddress((Object)this.baseObject, (long)(this.baseOffset + (long)offset), (int)size);
    }

    @Override
    public byte[] getBinary(int ordinal) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getLong(ordinal);
        int offset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        byte[] bytes = new byte[size];
        Platform.copyMemory((Object)this.baseObject, (long)(this.baseOffset + (long)offset), (Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, (long)size);
        return bytes;
    }

    @Override
    public CalendarInterval getInterval(int ordinal) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getLong(ordinal);
        int offset = (int)(offsetAndSize >> 32);
        long monthAndDays = Platform.getLong((Object)this.baseObject, (long)(this.baseOffset + (long)offset));
        int months = (int)(0xFFFFFFFFL & monthAndDays);
        int days = (int)((0xFFFFFFFF00000000L & monthAndDays) >> 32);
        long microseconds = Platform.getLong((Object)this.baseObject, (long)(this.baseOffset + (long)offset + 8L));
        return new CalendarInterval(months, days, microseconds);
    }

    @Override
    public VariantVal getVariant(int ordinal) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        return VariantVal.readFromUnsafeRow((long)this.getLong(ordinal), (Object)this.baseObject, (long)this.baseOffset);
    }

    @Override
    public UnsafeRow getStruct(int ordinal, int numFields) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getLong(ordinal);
        int offset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        UnsafeRow row = new UnsafeRow(numFields);
        row.pointTo(this.baseObject, this.baseOffset + (long)offset, size);
        return row;
    }

    @Override
    public UnsafeArrayData getArray(int ordinal) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getLong(ordinal);
        int offset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        UnsafeArrayData array = new UnsafeArrayData();
        array.pointTo(this.baseObject, this.baseOffset + (long)offset, size);
        return array;
    }

    @Override
    public UnsafeMapData getMap(int ordinal) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getLong(ordinal);
        int offset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        UnsafeMapData map = new UnsafeMapData();
        map.pointTo(this.baseObject, this.baseOffset + (long)offset, size);
        return map;
    }

    @Override
    public UnsafeRow copy() {
        UnsafeRow rowCopy = new UnsafeRow(this.numFields);
        byte[] rowDataCopy = new byte[this.sizeInBytes];
        Platform.copyMemory((Object)this.baseObject, (long)this.baseOffset, (Object)rowDataCopy, (long)Platform.BYTE_ARRAY_OFFSET, (long)this.sizeInBytes);
        rowCopy.pointTo(rowDataCopy, Platform.BYTE_ARRAY_OFFSET, this.sizeInBytes);
        return rowCopy;
    }

    public static UnsafeRow createFromByteArray(int numBytes, int numFields) {
        UnsafeRow row = new UnsafeRow(numFields);
        row.pointTo(new byte[numBytes], numBytes);
        return row;
    }

    public void copyFrom(UnsafeRow row) {
        assert (this.baseObject instanceof byte[] && this.baseOffset == (long)Platform.BYTE_ARRAY_OFFSET);
        if (row.sizeInBytes > this.sizeInBytes) {
            this.baseObject = new byte[row.sizeInBytes];
        }
        Platform.copyMemory((Object)row.baseObject, (long)row.baseOffset, (Object)this.baseObject, (long)this.baseOffset, (long)row.sizeInBytes);
        this.sizeInBytes = row.sizeInBytes;
    }

    public void writeToStream(OutputStream out, byte[] writeBuffer) throws IOException {
        Object object = this.baseObject;
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            int offsetInByteArray = (int)(this.baseOffset - (long)Platform.BYTE_ARRAY_OFFSET);
            out.write(bytes, offsetInByteArray, this.sizeInBytes);
        } else {
            int toTransfer;
            long rowReadPosition = this.baseOffset;
            for (int dataRemaining = this.sizeInBytes; dataRemaining > 0; dataRemaining -= toTransfer) {
                toTransfer = Math.min(writeBuffer.length, dataRemaining);
                Platform.copyMemory((Object)this.baseObject, (long)rowReadPosition, (Object)writeBuffer, (long)Platform.BYTE_ARRAY_OFFSET, (long)toTransfer);
                out.write(writeBuffer, 0, toTransfer);
                rowReadPosition += (long)toTransfer;
            }
        }
    }

    public int hashCode() {
        return Murmur3_x86_32.hashUnsafeWords((Object)this.baseObject, (long)this.baseOffset, (int)this.sizeInBytes, (int)42);
    }

    public boolean equals(Object other) {
        if (other instanceof UnsafeRow) {
            UnsafeRow o = (UnsafeRow)other;
            return this.sizeInBytes == o.sizeInBytes && ByteArrayMethods.arrayEquals((Object)this.baseObject, (long)this.baseOffset, (Object)o.baseObject, (long)o.baseOffset, (long)this.sizeInBytes);
        }
        return false;
    }

    public byte[] getBytes() {
        return UnsafeDataUtils.getBytes(this.baseObject, this.baseOffset, this.sizeInBytes);
    }

    public String toString() {
        StringBuilder build = new StringBuilder("[");
        for (int i = 0; i < this.sizeInBytes; i += 8) {
            if (i != 0) {
                build.append(',');
            }
            build.append(Long.toHexString(Platform.getLong((Object)this.baseObject, (long)(this.baseOffset + (long)i))));
        }
        build.append(']');
        return build.toString();
    }

    @Override
    public boolean anyNull() {
        return BitSetMethods.anySet((Object)this.baseObject, (long)this.baseOffset, (long)(this.bitSetWidthInBytes / 8));
    }

    public void writeToMemory(Object target, long targetOffset) {
        Platform.copyMemory((Object)this.baseObject, (long)this.baseOffset, (Object)target, (long)targetOffset, (long)this.sizeInBytes);
    }

    public void writeTo(ByteBuffer buffer) {
        assert (buffer.hasArray());
        byte[] target = buffer.array();
        int offset = buffer.arrayOffset();
        int pos = buffer.position();
        this.writeToMemory(target, Platform.BYTE_ARRAY_OFFSET + offset + pos);
        buffer.position(pos + this.sizeInBytes);
    }

    public void writeFieldTo(int ordinal, ByteBuffer buffer) {
        long offsetAndSize = this.getLong(ordinal);
        int offset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        buffer.putInt(size);
        int pos = buffer.position();
        buffer.position(pos + size);
        Platform.copyMemory((Object)this.baseObject, (long)(this.baseOffset + (long)offset), (Object)buffer.array(), (long)(Platform.BYTE_ARRAY_OFFSET + buffer.arrayOffset() + pos), (long)size);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] bytes = this.getBytes();
        out.writeInt(bytes.length);
        out.writeInt(this.numFields);
        out.write(bytes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.baseOffset = Platform.BYTE_ARRAY_OFFSET;
        this.sizeInBytes = in.readInt();
        this.numFields = in.readInt();
        this.bitSetWidthInBytes = UnsafeRow.calculateBitSetWidthInBytes(this.numFields);
        this.baseObject = new byte[this.sizeInBytes];
        in.readFully((byte[])this.baseObject);
    }

    public void write(Kryo kryo, Output out) {
        byte[] bytes = this.getBytes();
        out.writeInt(bytes.length);
        out.writeInt(this.numFields);
        out.write(bytes);
    }

    public void read(Kryo kryo, Input in) {
        this.baseOffset = Platform.BYTE_ARRAY_OFFSET;
        this.sizeInBytes = in.readInt();
        this.numFields = in.readInt();
        this.bitSetWidthInBytes = UnsafeRow.calculateBitSetWidthInBytes(this.numFields);
        this.baseObject = new byte[this.sizeInBytes];
        in.read((byte[])this.baseObject);
    }
}

