/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.aggregate.Collect;
import org.apache.spark.sql.catalyst.expressions.aggregate.CollectSet$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Collects and returns a set of unique elements.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (1), (2), (1) AS tab(col);\n       [1,2]\n  ", note="\n    The function is non-deterministic because the order of collected results depends\n    on the order of the rows which may be non-deterministic after a shuffle.\n  ", group="agg_funcs", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0005\t]b\u0001\u0002\u0015*\u0001bB\u0001\u0002\u0019\u0001\u0003\u0016\u0004%\t!\u0019\u0005\tM\u0002\u0011\t\u0012)A\u0005E\"Aq\r\u0001BK\u0002\u0013\u0005\u0001\u000e\u0003\u0005m\u0001\tE\t\u0015!\u0003j\u0011!i\u0007A!f\u0001\n\u0003A\u0007\u0002\u00038\u0001\u0005#\u0005\u000b\u0011B5\t\u000b=\u0004A\u0011\u00019\t\u000b=\u0004A\u0011A;\t\u0011]\u0004\u0001R1A\u0005BaDaa \u0001\u0005B\u0005\u0005\u0001bBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\b\u0003\u001f\u0001A\u0011IA\t\u0011\u001d\ty\u0002\u0001C!\u0003CAq!!\f\u0001\t\u0003\ny\u0003C\u0004\u00026\u0001!\t%a\u000e\t\u000f\u0005%\u0003\u0001\"\u0011\u0002L!9\u0011Q\n\u0001\u0005R\u0005=\u0003\"CA+\u0001\u0005\u0005I\u0011AA,\u0011%\ty\u0006AI\u0001\n\u0003\t\t\u0007C\u0005\u0002x\u0001\t\n\u0011\"\u0001\u0002z!I\u0011Q\u0010\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0010\u0005\n\u0003\u007f\u0002\u0011\u0011!C!\u0003\u0003C\u0001\"!%\u0001\u0003\u0003%\t\u0001\u001b\u0005\n\u0003'\u0003\u0011\u0011!C\u0001\u0003+C\u0011\"a'\u0001\u0003\u0003%\t%!(\t\u0013\u0005\u001d\u0006!!A\u0005\u0002\u0005%\u0006\"CAZ\u0001\u0005\u0005I\u0011IA[\u0011%\tI\fAA\u0001\n\u0003\nYlB\u0005\u0002f&\n\t\u0011#\u0001\u0002h\u001aA\u0001&KA\u0001\u0012\u0003\tI\u000f\u0003\u0004p=\u0011\u0005!\u0011\u0001\u0005\n\u0005\u0007q\u0012\u0011!C#\u0005\u000bA\u0011Ba\u0002\u001f\u0003\u0003%\tI!\u0003\t\u0013\tEa$%A\u0005\u0002\u0005e\u0004\"\u0003B\n=E\u0005I\u0011AA=\u0011%\u0011)BHA\u0001\n\u0003\u00139\u0002C\u0005\u0003*y\t\n\u0011\"\u0001\u0002z!I!1\u0006\u0010\u0012\u0002\u0013\u0005\u0011\u0011\u0010\u0005\n\u0005[q\u0012\u0011!C\u0005\u0005_\u0011!bQ8mY\u0016\u001cGoU3u\u0015\tQ3&A\u0005bO\u001e\u0014XmZ1uK*\u0011A&L\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002/_\u0005A1-\u0019;bYf\u001cHO\u0003\u00021c\u0005\u00191/\u001d7\u000b\u0005I\u001a\u0014!B:qCJ\\'B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001e\u001c\u0001aE\u0003\u0001s-\u000bF\u000bE\u0002;wuj\u0011!K\u0005\u0003y%\u0012qaQ8mY\u0016\u001cG\u000fE\u0002?\u000b\u001ek\u0011a\u0010\u0006\u0003\u0001\u0006\u000bq!\\;uC\ndWM\u0003\u0002C\u0007\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR \u0003\u000f!\u000b7\u000f[*fiB\u0011\u0001*S\u0007\u0002\u0007&\u0011!j\u0011\u0002\u0004\u0003:L\bC\u0001'P\u001b\u0005i%B\u0001(0\u0003\u0019)'O]8sg&\u0011\u0001+\u0014\u0002\u0010#V,'/_#se>\u00148OQ1tKB\u0011\u0001JU\u0005\u0003'\u000e\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002V;:\u0011ak\u0017\b\u0003/jk\u0011\u0001\u0017\u0006\u00033^\na\u0001\u0010:p_Rt\u0014\"\u0001#\n\u0005q\u001b\u0015a\u00029bG.\fw-Z\u0005\u0003=~\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001X\"\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003\t\u0004\"a\u00193\u000e\u0003-J!!Z\u0016\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\u0017[V$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fiV\t\u0011\u000e\u0005\u0002IU&\u00111n\u0011\u0002\u0004\u0013:$\u0018aF7vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;!\u0003QIg\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0006)\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003reN$\bC\u0001\u001e\u0001\u0011\u0015\u0001w\u00011\u0001c\u0011\u001d9w\u0001%AA\u0002%Dq!\\\u0004\u0011\u0002\u0003\u0007\u0011\u000e\u0006\u0002rm\")\u0001\r\u0003a\u0001E\u0006\t\"-\u001e4gKJ,E.Z7f]R$\u0016\u0010]3\u0016\u0003e\u0004\"A_?\u000e\u0003mT!\u0001`\u0018\u0002\u000bQL\b/Z:\n\u0005y\\(\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002-\r|gN^3siR{')\u001e4gKJ,E.Z7f]R$2aRA\u0002\u0011\u0019\t)A\u0003a\u0001\u000f\u0006)a/\u00197vK\u0006!QM^1m)\r9\u00151\u0002\u0005\u0007\u0003\u001bY\u0001\u0019A\u001f\u0002\r\t,hMZ3s\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tI\"L\u0001\tC:\fG._:jg&!\u0011QDA\f\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018!H<ji\"tUm^'vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0015\t\u0005\r\u0012\u0011\u0006\t\u0004u\u0005\u0015\u0012bAA\u0014S\t\u0019\u0012*\u001c9fe\u0006$\u0018N^3BO\u001e\u0014XmZ1uK\"1\u00111F\u0007A\u0002%\f\u0011D\\3x\u001bV$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0006Yr/\u001b;i\u001d\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$B!a\t\u00022!1\u00111\u0007\bA\u0002%\fqC\\3x\u0013:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002:A!\u00111HA\"\u001d\u0011\ti$a\u0010\u0011\u0005]\u001b\u0015bAA!\u0007\u00061\u0001K]3eK\u001aLA!!\u0012\u0002H\t11\u000b\u001e:j]\u001eT1!!\u0011D\u0003]\u0019'/Z1uK\u0006;wM]3hCRLwN\u001c\"vM\u001a,'\u000fF\u0001>\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0019\u0011/!\u0015\t\r\u0005M\u0013\u00031\u0001c\u0003!qWm^\"iS2$\u0017\u0001B2paf$r!]A-\u00037\ni\u0006C\u0004a%A\u0005\t\u0019\u00012\t\u000f\u001d\u0014\u0002\u0013!a\u0001S\"9QN\u0005I\u0001\u0002\u0004I\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003GR3AYA3W\t\t9\u0007\u0005\u0003\u0002j\u0005MTBAA6\u0015\u0011\ti'a\u001c\u0002\u0013Ut7\r[3dW\u0016$'bAA9\u0007\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00141\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003wR3![A3\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAB!\u0011\t))a$\u000e\u0005\u0005\u001d%\u0002BAE\u0003\u0017\u000bA\u0001\\1oO*\u0011\u0011QR\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002F\u0005\u001d\u0015\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004\u000f\u0006]\u0005\u0002CAM1\u0005\u0005\t\u0019A5\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\nE\u0003\u0002\"\u0006\rv)D\u0001B\u0013\r\t)+\u0011\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002,\u0006E\u0006c\u0001%\u0002.&\u0019\u0011qV\"\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011\u0014\u000e\u0002\u0002\u0003\u0007q)\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAB\u0003oC\u0001\"!'\u001c\u0003\u0003\u0005\r![\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005-\u0016Q\u0018\u0005\t\u00033c\u0012\u0011!a\u0001\u000f\":\u0002!!1\u0002H\u0006%\u0017QZAh\u0003'\f).!7\u0002\\\u0006}\u0017\u0011\u001d\t\u0004G\u0006\r\u0017bAAcW\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAf\u0003uzf)\u0016(D?\"*\u0007\u0010\u001d:*A5\u00023i\u001c7mK\u000e$8\u000fI1oI\u0002\u0012X\r^;s]N\u0004\u0013\rI:fi\u0002zg\rI;oSF,X\rI3mK6,g\u000e^:/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAi\u0003\u0001T\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fY8mS\u00012%kT'!-\u0006cU+R*!QEJC\u0006\t\u00153S1\u0002\u0003&M\u0015!\u0003N\u0003C/\u00192)G>d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\c1\u0012TL\u0003\u0011!\u0003\u0011qw\u000e^3\"\u0005\u0005]\u0017!a\u0013\u000bA\u0001\u0002\u0003\u0005\u00165fA\u0019,hn\u0019;j_:\u0004\u0013n\u001d\u0011o_:lC-\u001a;fe6Lg.[:uS\u000e\u0004#-Z2bkN,\u0007\u0005\u001e5fA=\u0014H-\u001a:!_\u001a\u00043m\u001c7mK\u000e$X\r\u001a\u0011sKN,H\u000e^:!I\u0016\u0004XM\u001c3t\u0015\u0001\u0002\u0003\u0005I8oAQDW\rI8sI\u0016\u0014\be\u001c4!i\",\u0007E]8xg\u0002:\b.[2iA5\f\u0017\u0010\t2fA9|g.\f3fi\u0016\u0014X.\u001b8jgRL7\rI1gi\u0016\u0014\b%\u0019\u0011tQV4g\r\\3/\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAo\u0003%\twmZ0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002d\u0006)!G\f\u0019/a\u0005Q1i\u001c7mK\u000e$8+\u001a;\u0011\u0005ir2#\u0002\u0010\u0002l\u0006]\b\u0003CAw\u0003g\u0014\u0017.[9\u000e\u0005\u0005=(bAAy\u0007\u00069!/\u001e8uS6,\u0017\u0002BA{\u0003_\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\tI0a@\u000e\u0005\u0005m(\u0002BA\u007f\u0003\u0017\u000b!![8\n\u0007y\u000bY\u0010\u0006\u0002\u0002h\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0004\u0006)\u0011\r\u001d9msR9\u0011Oa\u0003\u0003\u000e\t=\u0001\"\u00021\"\u0001\u0004\u0011\u0007bB4\"!\u0003\u0005\r!\u001b\u0005\b[\u0006\u0002\n\u00111\u0001j\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0004B\u0013!\u0015A%1\u0004B\u0010\u0013\r\u0011ib\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r!\u0013\tCY5j\u0013\r\u0011\u0019c\u0011\u0002\u0007)V\u0004H.Z\u001a\t\u0011\t\u001dB%!AA\u0002E\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!\r\u0011\t\u0005\u0015%1G\u0005\u0005\u0005k\t9I\u0001\u0004PE*,7\r\u001e")
public class CollectSet
extends Collect<HashSet<Object>>
implements QueryErrorsBase,
Serializable {
    private DataType bufferElementType;
    private final Expression child;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return CollectSet$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return CollectSet$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple3<Expression, Object, Object>> unapply(CollectSet x$0) {
        return CollectSet$.MODULE$.unapply(x$0);
    }

    public static int apply$default$3() {
        return CollectSet$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return CollectSet$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple3<Expression, Object, Object>, CollectSet> tupled() {
        return CollectSet$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Function1<Object, CollectSet>>> curried() {
        return CollectSet$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private DataType bufferElementType$lzycompute() {
        CollectSet collectSet = this;
        synchronized (collectSet) {
            if (!this.bitmap$0) {
                DataType dataType = this.child().dataType();
                this.bufferElementType = BinaryType$.MODULE$.equals(dataType) ? ArrayType$.MODULE$.apply((DataType)ByteType$.MODULE$) : dataType;
                this.bitmap$0 = true;
            }
        }
        return this.bufferElementType;
    }

    @Override
    public DataType bufferElementType() {
        if (!this.bitmap$0) {
            return this.bufferElementType$lzycompute();
        }
        return this.bufferElementType;
    }

    @Override
    public Object convertToBufferElement(Object value) {
        DataType dataType = this.child().dataType();
        if (BinaryType$.MODULE$.equals(dataType)) {
            return UnsafeArrayData.fromPrimitiveArray((byte[])value);
        }
        return InternalRow$.MODULE$.copyValue(value);
    }

    @Override
    public Object eval(HashSet<Object> buffer) {
        DataType dataType = this.child().dataType();
        Object array = BinaryType$.MODULE$.equals(dataType) ? buffer.iterator().map((Function1 & Serializable)x$2 -> ((ArrayData)x$2).toByteArray()).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))) : buffer.toArray(ClassTag$.MODULE$.Any());
        return new GenericArrayData(array);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (!this.child().dataType().existsRecursively((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CollectSet.$anonfun$checkInputDataTypes$1(x$3)))) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        return new TypeCheckResult.DataTypeMismatch("UNSUPPORTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType((AbstractDataType)MapType$.MODULE$))}))));
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public String prettyName() {
        return "collect_set";
    }

    @Override
    public HashSet<Object> createAggregationBuffer() {
        return HashSet$.MODULE$.empty();
    }

    @Override
    public CollectSet withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    public CollectSet copy(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new CollectSet(child, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public int copy$default$2() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$3() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "CollectSet";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CollectSet;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "mutableAggBufferOffset";
            }
            case 2: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CollectSet)) return false;
        boolean bl = true;
        if (!bl) return false;
        CollectSet collectSet = (CollectSet)x$1;
        if (this.mutableAggBufferOffset() != collectSet.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != collectSet.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = collectSet.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!collectSet.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$1(DataType x$3) {
        return x$3 instanceof MapType;
    }

    public CollectSet(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
    }

    public CollectSet(Expression child) {
        this(child, 0, 0);
    }
}

