/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.variant;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.expressions.variant.SchemaOfVariant$;
import org.apache.spark.sql.catalyst.expressions.variant.SchemaOfVariantAgg$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.types.variant.Variant;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.unsafe.types.VariantVal;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(v) - Returns the merged schema in the SQL format of a variant column.", examples="\n    Examples:\n      > SELECT _FUNC_(parse_json(j)) FROM VALUES ('1'), ('2'), ('3') AS tab(j);\n       BIGINT\n      > SELECT _FUNC_(parse_json(j)) FROM VALUES ('{\"a\": 1}'), ('{\"b\": true}'), ('{\"c\": 1.23}') AS tab(j);\n       STRUCT<a: BIGINT, b: BOOLEAN, c: DECIMAL(3,2)>\n  ", since="4.0.0", group="variant_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0015d\u0001\u0002\u0015*\u0001bB\u0001B\u001b\u0001\u0003\u0016\u0004%\ta\u001b\u0005\tY\u0002\u0011\t\u0012)A\u0005+\"AQ\u000e\u0001BK\u0002\u0013\u0005c\u000e\u0003\u0005s\u0001\tE\t\u0015!\u0003p\u0011!\u0019\bA!f\u0001\n\u0003r\u0007\u0002\u0003;\u0001\u0005#\u0005\u000b\u0011B8\t\u000bU\u0004A\u0011\u0001<\t\u000bU\u0004A\u0011\u0001?\t\u000by\u0004A\u0011I@\t\u000f\u00055\u0001\u0001\"\u0011\u0002\u0010!9\u0011\u0011\u0003\u0001\u0005B\u0005M\u0001bBA\u000e\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003?\u0001A\u0011IA\u0011\u0011\u001d\t\u0019\u0004\u0001C!\u0003kAq!a\u000f\u0001\t\u0003\ni\u0004C\u0004\u0002H\u0001!\t%!\u0013\t\u000f\u0005e\u0003\u0001\"\u0011\u0002\\!9\u0011\u0011\r\u0001\u0005B\u0005\r\u0004bBA;\u0001\u0011\u0005\u0013q\u000f\u0005\b\u0003\u0007\u0003A\u0011IAC\u0011\u001d\tY\t\u0001C)\u0003\u001bC\u0011\"a%\u0001\u0003\u0003%\t!!&\t\u0013\u0005u\u0005!%A\u0005\u0002\u0005}\u0005\"CA[\u0001E\u0005I\u0011AA\\\u0011%\tY\fAI\u0001\n\u0003\t9\fC\u0005\u0002>\u0002\t\t\u0011\"\u0011\u0002@\"A\u0011q\u001a\u0001\u0002\u0002\u0013\u0005a\u000eC\u0005\u0002R\u0002\t\t\u0011\"\u0001\u0002T\"I\u0011\u0011\u001c\u0001\u0002\u0002\u0013\u0005\u00131\u001c\u0005\n\u0003S\u0004\u0011\u0011!C\u0001\u0003WD\u0011\"a<\u0001\u0003\u0003%\t%!=\t\u0013\u0005U\b!!A\u0005B\u0005]x!\u0003B\u000eS\u0005\u0005\t\u0012\u0001B\u000f\r!A\u0013&!A\t\u0002\t}\u0001BB;#\t\u0003\u00119\u0004C\u0005\u0003:\t\n\t\u0011\"\u0012\u0003<!I!Q\b\u0012\u0002\u0002\u0013\u0005%q\b\u0005\n\u0005\u000f\u0012\u0013\u0011!CA\u0005\u0013B\u0011Ba\u0017#\u0003\u0003%IA!\u0018\u0003%M\u001b\u0007.Z7b\u001f\u001a4\u0016M]5b]R\fum\u001a\u0006\u0003U-\nqA^1sS\u0006tGO\u0003\u0002-[\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tqs&\u0001\u0005dCR\fG._:u\u0015\t\u0001\u0014'A\u0002tc2T!AM\u001a\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q*\u0014AB1qC\u000eDWMC\u00017\u0003\ry'oZ\u0002\u0001'\u001d\u0001\u0011(R%P1z\u00032AO\u001f@\u001b\u0005Y$B\u0001\u001f,\u0003%\twm\u001a:fO\u0006$X-\u0003\u0002?w\tAB+\u001f9fI&k\u0007/\u001a:bi&4X-Q4he\u0016<\u0017\r^3\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t{\u0013!\u0002;za\u0016\u001c\u0018B\u0001#B\u0005!!\u0015\r^1UsB,\u0007C\u0001$H\u001b\u0005Y\u0013B\u0001%,\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019>\na!\u001a:s_J\u001c\u0018B\u0001(L\u0005=\tV/\u001a:z\u000bJ\u0014xN]:CCN,\u0007c\u0001)T+6\t\u0011K\u0003\u0002S[\u0005)AO]3fg&\u0011A+\u0015\u0002\n+:\f'/\u001f'jW\u0016\u0004\"A\u0012,\n\u0005][#AC#yaJ,7o]5p]B\u0011\u0011\fX\u0007\u00025*\t1,A\u0003tG\u0006d\u0017-\u0003\u0002^5\n9\u0001K]8ek\u000e$\bCA0h\u001d\t\u0001WM\u0004\u0002bI6\t!M\u0003\u0002do\u00051AH]8pizJ\u0011aW\u0005\u0003Mj\u000bq\u0001]1dW\u0006<W-\u0003\u0002iS\na1+\u001a:jC2L'0\u00192mK*\u0011aMW\u0001\u0006G\"LG\u000eZ\u000b\u0002+\u000611\r[5mI\u0002\na#\\;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u000b\u0002_B\u0011\u0011\f]\u0005\u0003cj\u00131!\u00138u\u0003]iW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b%\u0001\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u0016S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;!\u0003\u0019a\u0014N\\5u}Q!q/\u001f>|!\tA\b!D\u0001*\u0011\u0015Qw\u00011\u0001V\u0011\u0015iw\u00011\u0001p\u0011\u0015\u0019x\u00011\u0001p)\t9X\u0010C\u0003k\u0011\u0001\u0007Q+\u0001\u0006j]B,H\u000fV=qKN,\"!!\u0001\u0011\u000b}\u000b\u0019!a\u0002\n\u0007\u0005\u0015\u0011NA\u0002TKF\u00042\u0001QA\u0005\u0013\r\tY!\u0011\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002\u007f\u0005Aa.\u001e7mC\ndW-\u0006\u0002\u0002\u0016A\u0019\u0011,a\u0006\n\u0007\u0005e!LA\u0004C_>dW-\u00198\u0002/\r\u0014X-\u0019;f\u0003\u001e<'/Z4bi&|gNQ;gM\u0016\u0014H#A \u0002\rU\u0004H-\u0019;f)\u0015y\u00141EA\u0014\u0011\u0019\t)#\u0004a\u0001\u007f\u00051!-\u001e4gKJDq!!\u000b\u000e\u0001\u0004\tY#A\u0003j]B,H\u000f\u0005\u0003\u0002.\u0005=R\"A\u0017\n\u0007\u0005ERFA\u0006J]R,'O\\1m%><\u0018!B7fe\u001e,G#B \u00028\u0005e\u0002BBA\u0013\u001d\u0001\u0007q\b\u0003\u0004\u0002*9\u0001\raP\u0001\u0005KZ\fG\u000e\u0006\u0003\u0002@\u0005\u0015\u0003cA-\u0002B%\u0019\u00111\t.\u0003\u0007\u0005s\u0017\u0010\u0003\u0004\u0002&=\u0001\raP\u0001\ng\u0016\u0014\u0018.\u00197ju\u0016$B!a\u0013\u0002XA)\u0011,!\u0014\u0002R%\u0019\u0011q\n.\u0003\u000b\u0005\u0013(/Y=\u0011\u0007e\u000b\u0019&C\u0002\u0002Vi\u0013AAQ=uK\"1\u0011Q\u0005\tA\u0002}\n1\u0002Z3tKJL\u0017\r\\5{KR\u0019q(!\u0018\t\u000f\u0005}\u0013\u00031\u0001\u0002L\u0005i1\u000f^8sC\u001e,gi\u001c:nCR\f!\u0002\u001d:fiRLh*Y7f+\t\t)\u0007\u0005\u0003\u0002h\u0005=d\u0002BA5\u0003W\u0002\"!\u0019.\n\u0007\u00055$,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003c\n\u0019H\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003[R\u0016!H<ji\"tUm^'vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0015\t\u0005e\u0014q\u0010\t\u0004u\u0005m\u0014bAA?w\t\u0019\u0012*\u001c9fe\u0006$\u0018N^3BO\u001e\u0014XmZ1uK\"1\u0011\u0011Q\nA\u0002=\f\u0011D\\3x\u001bV$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0006Yr/\u001b;i\u001d\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$B!!\u001f\u0002\b\"1\u0011\u0011\u0012\u000bA\u0002=\fqC\\3x\u0013:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\r)\u0016q\u0012\u0005\u0007\u0003#+\u0002\u0019A+\u0002\u00119,wo\u00115jY\u0012\fAaY8qsR9q/a&\u0002\u001a\u0006m\u0005b\u00026\u0017!\u0003\u0005\r!\u0016\u0005\b[Z\u0001\n\u00111\u0001p\u0011\u001d\u0019h\u0003%AA\u0002=\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\"*\u001aQ+a),\u0005\u0005\u0015\u0006\u0003BAT\u0003ck!!!+\u000b\t\u0005-\u0016QV\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a,[\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003g\u000bIKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002:*\u001aq.a)\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!1\u0011\t\u0005\r\u0017QZ\u0007\u0003\u0003\u000bTA!a2\u0002J\u0006!A.\u00198h\u0015\t\tY-\u0001\u0003kCZ\f\u0017\u0002BA9\u0003\u000b\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002@\u0005U\u0007\u0002CAl9\u0005\u0005\t\u0019A8\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u000e\u0005\u0004\u0002`\u0006\u0015\u0018qH\u0007\u0003\u0003CT1!a9[\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003O\f\tO\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u000b\u0003[D\u0011\"a6\u001f\u0003\u0003\u0005\r!a\u0010\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u0003\f\u0019\u0010\u0003\u0005\u0002X~\t\t\u00111\u0001p\u0003\u0019)\u0017/^1mgR!\u0011QCA}\u0011%\t9\u000eIA\u0001\u0002\u0004\ty\u0004K\n\u0001\u0003{\u0014\u0019A!\u0002\u0003\n\t-!q\u0002B\t\u0005+\u00119\u0002E\u0002G\u0003\u007fL1A!\u0001,\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#Aa\u0002\u0002\u0019~3UKT\"`QYL\u0003%\f\u0011SKR,(O\\:!i\",\u0007%\\3sO\u0016$\u0007e]2iK6\f\u0007%\u001b8!i\",\u0007eU)MA\u0019|'/\\1uA=4\u0007%\u0019\u0011wCJL\u0017M\u001c;!G>dW/\u001c8/\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001B\u0007\u0003\t\u0005\"\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b9beN,wL[:p]\"R\u0017&\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u00142O%b\u0003\u0005K\u00143O%b\u0003\u0005K\u00144O%\u0002\u0013i\u0015\u0011uC\nD#.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u0005&;\u0015J\u0014+\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QA\f'o]3`UN|g\u000e\u000b6*S\u00012%kT'!-\u0006cU+R*!Q\u001dZ(%\u0019\u0012;AEjx%\u000b\u0017!Q\u001dZ(E\u0019\u0012;AQ\u0014X/Z?(S1\u0002\u0003fJ>#G\nR\u0004%\r\u00183gu<\u0013\u0006I!TAQ\f'\r\u000b6*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001aFKU+D)r\n'\b\t\"J\u000f&sE\u000b\f\u0011cu\u0001\u0012uj\u0014'F\u0003:c\u0003e\u0019\u001e!\t\u0016\u001b\u0015*T!MQMb#'\u000b \u000bA\u0001\nQa]5oG\u0016\f#Aa\u0005\u0002\u000bQr\u0003G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\te\u0011!\u0004<be&\fg\u000e^0gk:\u001c7/\u0001\nTG\",W.Y(g-\u0006\u0014\u0018.\u00198u\u0003\u001e<\u0007C\u0001=#'\u0015\u0011#\u0011\u0005B\u0017!!\u0011\u0019C!\u000bV_><XB\u0001B\u0013\u0015\r\u00119CW\u0001\beVtG/[7f\u0013\u0011\u0011YC!\n\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0005\u0003\u00030\tURB\u0001B\u0019\u0015\u0011\u0011\u0019$!3\u0002\u0005%|\u0017b\u00015\u00032Q\u0011!QD\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011Y\u0001\u0006CB\u0004H.\u001f\u000b\bo\n\u0005#1\tB#\u0011\u0015QW\u00051\u0001V\u0011\u0015iW\u00051\u0001p\u0011\u0015\u0019X\u00051\u0001p\u0003\u001d)h.\u00199qYf$BAa\u0013\u0003XA)\u0011L!\u0014\u0003R%\u0019!q\n.\u0003\r=\u0003H/[8o!\u0019I&1K+p_&\u0019!Q\u000b.\u0003\rQ+\b\u000f\\34\u0011!\u0011IFJA\u0001\u0002\u00049\u0018a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!q\f\t\u0005\u0003\u0007\u0014\t'\u0003\u0003\u0003d\u0005\u0015'AB(cU\u0016\u001cG\u000f")
public class SchemaOfVariantAgg
extends TypedImperativeAggregate<DataType>
implements ExpectsInputTypes,
QueryErrorsBase,
UnaryLike<Expression>,
Serializable {
    private final Expression child;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple3<Expression, Object, Object>> unapply(SchemaOfVariantAgg x$0) {
        return SchemaOfVariantAgg$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Object, Object>, SchemaOfVariantAgg> tupled() {
        return SchemaOfVariantAgg$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Function1<Object, SchemaOfVariantAgg>>> curried() {
        return SchemaOfVariantAgg$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private Seq<Expression> children$lzycompute() {
        SchemaOfVariantAgg schemaOfVariantAgg = this;
        synchronized (schemaOfVariantAgg) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)VariantType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return SQLConf$.MODULE$.get().defaultStringType();
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType createAggregationBuffer() {
        return NullType$.MODULE$;
    }

    @Override
    public DataType update(DataType buffer, InternalRow input) {
        VariantVal inputVariant = (VariantVal)this.child().eval(input);
        if (inputVariant != null) {
            Variant v = new Variant(inputVariant.getValue(), inputVariant.getMetadata());
            return SchemaOfVariant$.MODULE$.mergeSchema(buffer, SchemaOfVariant$.MODULE$.schemaOf(v));
        }
        return buffer;
    }

    @Override
    public DataType merge(DataType buffer, DataType input) {
        return SchemaOfVariant$.MODULE$.mergeSchema(buffer, input);
    }

    @Override
    public Object eval(DataType buffer) {
        return UTF8String.fromString((String)buffer.sql());
    }

    @Override
    public byte[] serialize(DataType buffer) {
        return buffer.json().getBytes("UTF-8");
    }

    @Override
    public DataType deserialize(byte[] storageFormat) {
        return DataType$.MODULE$.fromJson(new String(storageFormat, "UTF-8"));
    }

    @Override
    public String prettyName() {
        return "schema_of_variant_agg";
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public Expression withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    public SchemaOfVariantAgg copy(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new SchemaOfVariantAgg(child, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public int copy$default$2() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$3() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "SchemaOfVariantAgg";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SchemaOfVariantAgg;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "mutableAggBufferOffset";
            }
            case 2: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SchemaOfVariantAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        SchemaOfVariantAgg schemaOfVariantAgg = (SchemaOfVariantAgg)x$1;
        if (this.mutableAggBufferOffset() != schemaOfVariantAgg.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != schemaOfVariantAgg.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = schemaOfVariantAgg.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!schemaOfVariantAgg.canEqual(this)) return false;
        return true;
    }

    public SchemaOfVariantAgg(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        UnaryLike.$init$(this);
    }

    public SchemaOfVariantAgg(Expression child) {
        this(child, 0, 0);
    }
}

