/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.variant;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Generator;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.expressions.variant.VariantExplode$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.unsafe.types.VariantVal;
import scala.Enumeration;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - It separates a variant object/array into multiple rows containing its fields/elements. Its result schema is `struct<pos int, key string, value variant>`. `pos` is the position of the field/element in its parent object/array, and `value` is the field/element value. `key` is the field name when exploding a variant object, or is NULL when exploding a variant array. It ignores any input that is not a variant array/object, including SQL NULL, variant null, and any other variant values.", examples="\n    Examples:\n      > SELECT * from _FUNC_(parse_json('[\"hello\", \"world\"]'));\n       0\tNULL\t\"hello\"\n       1\tNULL\t\"world\"\n      > SELECT * from _FUNC_(parse_json('{\"a\": true, \"b\": 3.14}'));\n       0\ta\ttrue\n       1\tb\t3.14\n  ", since="4.0.0", group="variant_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005]h\u0001\u0002\u000e\u001c\u0001*B\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0013\")Q\n\u0001C\u0001\u001d\")!\u000b\u0001C!'\")Q\f\u0001C!=\")q\r\u0001C)Q\")1\u000e\u0001C!Y\")a\u000f\u0001C)o\"9\u00111\u0002\u0001\u0005B\u00055\u0001\"CA\u000b\u0001\u0005\u0005I\u0011AA\f\u0011%\tY\u0002AI\u0001\n\u0003\ti\u0002C\u0005\u00024\u0001\t\t\u0011\"\u0011\u00026!I\u0011Q\t\u0001\u0002\u0002\u0013\u0005\u0011q\t\u0005\n\u0003\u001f\u0002\u0011\u0011!C\u0001\u0003#B\u0011\"!\u0018\u0001\u0003\u0003%\t%a\u0018\t\u0013\u00055\u0004!!A\u0005\u0002\u0005=\u0004\"CA=\u0001\u0005\u0005I\u0011IA>\u0011%\ty\bAA\u0001\n\u0003\n\tiB\u0004\u0002&nA\t!a*\u0007\riY\u0002\u0012AAU\u0011\u0019iE\u0003\"\u0001\u0002<\"9\u0011Q\u0018\u000b\u0005\u0002\u0005}\u0006\"CAm)\u0005\u0005I\u0011QAn\u0011%\ty\u000eFA\u0001\n\u0003\u000b\t\u000fC\u0005\u0002nR\t\t\u0011\"\u0003\u0002p\nqa+\u0019:jC:$X\t\u001f9m_\u0012,'B\u0001\u000f\u001e\u0003\u001d1\u0018M]5b]RT!AH\u0010\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003A\u0005\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003E\r\n1a]9m\u0015\t!S%A\u0003ta\u0006\u00148N\u0003\u0002'O\u00051\u0011\r]1dQ\u0016T\u0011\u0001K\u0001\u0004_J<7\u0001A\n\u0007\u0001-z#'N\u001e\u0011\u00051jS\"A\u000f\n\u00059j\"aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u00051\u0002\u0014BA\u0019\u001e\u0005%9UM\\3sCR|'\u000f\u0005\u0002-g%\u0011A'\b\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\u001c:\u001b\u00059$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:$a\u0002)s_\u0012,8\r\u001e\t\u0003y\u0011s!!\u0010\"\u000f\u0005y\nU\"A \u000b\u0005\u0001K\u0013A\u0002\u001fs_>$h(C\u00019\u0013\t\u0019u'A\u0004qC\u000e\\\u0017mZ3\n\u0005\u00153%\u0001D*fe&\fG.\u001b>bE2,'BA\"8\u0003\u0015\u0019\u0007.\u001b7e+\u0005I\u0005C\u0001\u0017K\u0013\tYUD\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002P#B\u0011\u0001\u000bA\u0007\u00027!)qi\u0001a\u0001\u0013\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003Q\u00032\u0001P+X\u0013\t1fIA\u0002TKF\u0004\"\u0001W.\u000e\u0003eS!AW\u0011\u0002\u000bQL\b/Z:\n\u0005qK&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002?B\u0011\u0001\r\u001a\b\u0003C\n\u0004\"AP\u001c\n\u0005\r<\u0014A\u0002)sK\u0012,g-\u0003\u0002fM\n11\u000b\u001e:j]\u001eT!aY\u001c\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\ty\u0015\u000eC\u0003k\r\u0001\u0007\u0011*\u0001\u0005oK^\u001c\u0005.\u001b7e\u0003\u0011)g/\u00197\u0015\u00055$\bc\u0001\u001foa&\u0011qN\u0012\u0002\r\u0013R,'/\u00192mK>s7-\u001a\t\u0003cJl\u0011aH\u0005\u0003g~\u00111\"\u00138uKJt\u0017\r\u001c*po\"9Qo\u0002I\u0001\u0002\u0004\u0001\u0018!B5oaV$\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0011Ah0a\u0002\u0011\u0005edX\"\u0001>\u000b\u0005ml\u0012aB2pI\u0016<WM\\\u0005\u0003{j\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0007\u007f\"\u0001\r!!\u0001\u0002\u0007\r$\b\u0010E\u0002z\u0003\u0007I1!!\u0002{\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDa!!\u0003\t\u0001\u0004A\u0018AA3w\u00035)G.Z7f]R\u001c6\r[3nCV\u0011\u0011q\u0002\t\u00041\u0006E\u0011bAA\n3\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\t\r|\u0007/\u001f\u000b\u0004\u001f\u0006e\u0001bB$\u000b!\u0003\u0005\r!S\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyBK\u0002J\u0003CY#!a\t\u0011\t\u0005\u0015\u0012qF\u0007\u0003\u0003OQA!!\u000b\u0002,\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003[9\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011GA\u0014\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005]\u0002\u0003BA\u001d\u0003\u0007j!!a\u000f\u000b\t\u0005u\u0012qH\u0001\u0005Y\u0006twM\u0003\u0002\u0002B\u0005!!.\u0019<b\u0013\r)\u00171H\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u0013\u00022ANA&\u0013\r\tie\u000e\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003'\nI\u0006E\u00027\u0003+J1!a\u00168\u0005\r\te.\u001f\u0005\n\u00037r\u0011\u0011!a\u0001\u0003\u0013\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA1!\u0019\t\u0019'!\u001b\u0002T5\u0011\u0011Q\r\u0006\u0004\u0003O:\u0014AC2pY2,7\r^5p]&!\u00111NA3\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005E\u0014q\u000f\t\u0004m\u0005M\u0014bAA;o\t9!i\\8mK\u0006t\u0007\"CA.!\u0005\u0005\t\u0019AA*\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005]\u0012Q\u0010\u0005\n\u00037\n\u0012\u0011!a\u0001\u0003\u0013\na!Z9vC2\u001cH\u0003BA9\u0003\u0007C\u0011\"a\u0017\u0013\u0003\u0003\u0005\r!a\u0015)'\u0001\t9)!$\u0002\u0010\u0006M\u0015QSAM\u00037\u000by*!)\u0011\u00071\nI)C\u0002\u0002\fv\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u0012\u0006\u0019Io\u0018$V\u001d\u000e{\u0006&\u001a=qe&\u0002S\u0006I%uAM,\u0007/\u0019:bi\u0016\u001c\b%\u0019\u0011wCJL\u0017M\u001c;!_\nTWm\u0019;0CJ\u0014\u0018-\u001f\u0011j]R|\u0007%\\;mi&\u0004H.\u001a\u0011s_^\u001c\beY8oi\u0006Lg.\u001b8hA%$8\u000f\t4jK2$7oL3mK6,g\u000e^:/A%#8\u000f\t:fgVdG\u000fI:dQ\u0016l\u0017\rI5tA\u0001\u001cHO];dir\u0002xn\u001d\u0011j]Rd\u0003e[3zAM$(/\u001b8hY\u00012\u0018\r\\;fAY\f'/[1oiz\u0002g\u0006\t1q_N\u0004\u0007%[:!i\",\u0007\u0005]8tSRLwN\u001c\u0011pM\u0002\"\b.\u001a\u0011gS\u0016dGmL3mK6,g\u000e\u001e\u0011j]\u0002JGo\u001d\u0011qCJ,g\u000e\u001e\u0011pE*,7\r^\u0018beJ\f\u0017\u0010\f\u0011b]\u0012\u0004\u0003M^1mk\u0016\u0004\u0007%[:!i\",\u0007EZ5fY\u0012|S\r\\3nK:$\bE^1mk\u0016t\u0003\u0005Y6fs\u0002\u0004\u0013n\u001d\u0011uQ\u0016\u0004c-[3mI\u0002r\u0017-\\3!o\",g\u000eI3ya2|G-\u001b8hA\u0005\u0004c/\u0019:jC:$\be\u001c2kK\u000e$H\u0006I8sA%\u001c\bET+M\u0019\u0002:\b.\u001a8!Kb\u0004Hn\u001c3j]\u001e\u0004\u0013\r\t<be&\fg\u000e\u001e\u0011beJ\f\u0017P\f\u0011Ji\u0002JwM\\8sKN\u0004\u0013M\\=!S:\u0004X\u000f\u001e\u0011uQ\u0006$\b%[:!]>$\b%\u0019\u0011wCJL\u0017M\u001c;!CJ\u0014\u0018-_\u0018pE*,7\r\u001e\u0017!S:\u001cG.\u001e3j]\u001e\u00043+\u0015'!\u001dVcE\n\f\u0011wCJL\u0017M\u001c;!]VdG\u000e\f\u0011b]\u0012\u0004\u0013M\\=!_RDWM\u001d\u0011wCJL\u0017M\u001c;!m\u0006dW/Z:/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAL\u0003\u0005\r'\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t\u0016!MJ|W\u000eI0G+:\u001bu\f\u000b9beN,wL[:p]\":3L\t5fY2|'\u0005\f\u0011#o>\u0014H\u000e\u001a\u0012^O%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0019\n\u001dVcE*\u0003\u0012iK2dwN\t\u0006!A\u0001\u0002\u0003\u0005\t\u00112\u00139+F\nT\u0005#o>\u0014H\u000e\u001a\u0012\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA)\u0002cM]8nA}3UKT\"`QA\f'o]3`UN|g\u000eK\u0014|E\u0005\u0014#\b\t;sk\u0016d\u0003E\t2#u\u0001\u001ad&\r\u001b~O%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0019\nC&!(/^3\u000bA\u0001\u0002\u0003\u0005\t\u0011!c%\u0011\u0017b\r\u00182i)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002\u001e\u0006)AG\f\u0019/a\u0005)qM]8va\u0006\u0012\u00111U\u0001\u000em\u0006\u0014\u0018.\u00198u?\u001a,hnY:\u0002\u001dY\u000b'/[1oi\u0016C\b\u000f\\8eKB\u0011\u0001\u000bF\n\u0006)\u0005-\u0016\u0011\u0017\t\u0004m\u00055\u0016bAAXo\t1\u0011I\\=SK\u001a\u0004B!a-\u0002:6\u0011\u0011Q\u0017\u0006\u0005\u0003o\u000by$\u0001\u0002j_&\u0019Q)!.\u0015\u0005\u0005\u001d\u0016A\u0004<be&\fg\u000e^#ya2|G-\u001a\u000b\u0007\u0003\u0003\f)-!6\u0011\u000b\u0005\r\u00141\u00199\n\u0007Y\u000b)\u0007\u0003\u0004v-\u0001\u0007\u0011q\u0019\t\u0005\u0003\u0013\f\t.\u0004\u0002\u0002L*\u0019!,!4\u000b\u0007\u0005=7%\u0001\u0004v]N\fg-Z\u0005\u0005\u0003'\fYM\u0001\u0006WCJL\u0017M\u001c;WC2Dq!a6\u0017\u0001\u0004\t\t(\u0001\u0004jg:+H\u000e\\\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u001f\u0006u\u0007\"B$\u0018\u0001\u0004I\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003G\fI\u000f\u0005\u00037\u0003KL\u0015bAAto\t1q\n\u001d;j_:D\u0001\"a;\u0019\u0003\u0003\u0005\raT\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAy!\u0011\tI$a=\n\t\u0005U\u00181\b\u0002\u0007\u001f\nTWm\u0019;")
public class VariantExplode
extends UnaryExpression
implements Generator,
ExpectsInputTypes,
Serializable {
    private final Expression child;
    private scala.collection.immutable.Seq<Enumeration.Value> nodePatterns;

    public static Option<Expression> unapply(VariantExplode x$0) {
        return VariantExplode$.MODULE$.unapply(x$0);
    }

    public static Seq<InternalRow> variantExplode(VariantVal input, boolean isNull) {
        return VariantExplode$.MODULE$.variantExplode(input, isNull);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public DataType dataType() {
        return Generator.dataType$(this);
    }

    @Override
    public boolean foldable() {
        return Generator.foldable$(this);
    }

    @Override
    public boolean nullable() {
        return Generator.nullable$(this);
    }

    @Override
    public IterableOnce<InternalRow> terminate() {
        return Generator.terminate$(this);
    }

    @Override
    public boolean supportCodegen() {
        return Generator.supportCodegen$(this);
    }

    @Override
    public scala.collection.immutable.Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Generator$_setter_$nodePatterns_$eq(scala.collection.immutable.Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public scala.collection.immutable.Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)VariantType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public String prettyName() {
        return "variant_explode";
    }

    @Override
    public VariantExplode withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    @Override
    public IterableOnce<InternalRow> eval(InternalRow input) {
        VariantVal inputVariant;
        return VariantExplode$.MODULE$.variantExplode(inputVariant, (inputVariant = (VariantVal)this.child().eval(input)) == null);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode childCode = this.child().genCode(ctx);
        String cls = VariantExplode.class.getName();
        Block code = Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      ", "\n      scala.collection.Seq<InternalRow> ", " = ", ".variantExplode(\n          ", ", ", ");\n    "}))), (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{childCode.code(), ev.value(), cls, childCode.value(), childCode.isNull()}));
        return ev.copy(code, FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public StructType elementSchema() {
        return new StructType().add("pos", (DataType)IntegerType$.MODULE$, false).add("key", (DataType)SQLConf$.MODULE$.get().defaultStringType(), true).add("value", (DataType)VariantType$.MODULE$, false);
    }

    public VariantExplode copy(Expression child) {
        return new VariantExplode(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "VariantExplode";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof VariantExplode;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof VariantExplode)) return false;
        boolean bl = true;
        if (!bl) return false;
        VariantExplode variantExplode = (VariantExplode)x$1;
        Expression expression = this.child();
        Expression expression2 = variantExplode.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!variantExplode.canEqual(this)) return false;
        return true;
    }

    public VariantExplode(Expression child) {
        this.child = child;
        Generator.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }
}

