/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathFloat$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns a float value, the value zero if no match is found, or NaN if a match is found but the value is non-numeric.", examples="\n    Examples:\n      > SELECT _FUNC_('<a><b>1</b><b>2</b></a>', 'sum(a/b)');\n       3.0\n  ", since="2.0.0", group="xml_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001B\u000e\u001d\u0001.B\u0001\"\b\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005\u0007\"A\u0001\n\u0001BK\u0002\u0013\u0005!\t\u0003\u0005J\u0001\tE\t\u0015!\u0003D\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015A\u0007\u0001\"\u0015j\u0011\u001dq\u0007!!A\u0005\u0002=DqA\u001d\u0001\u0012\u0002\u0013\u00051\u000fC\u0004\u007f\u0001E\u0005I\u0011A:\t\u0011}\u0004\u0011\u0011!C!\u0003\u0003A\u0011\"!\u0005\u0001\u0003\u0003%\t!a\u0005\t\u0013\u0005m\u0001!!A\u0005\u0002\u0005u\u0001\"CA\u0012\u0001\u0005\u0005I\u0011IA\u0013\u0011%\t\u0019\u0004AA\u0001\n\u0003\t)\u0004C\u0005\u0002@\u0001\t\t\u0011\"\u0011\u0002B!I\u0011Q\t\u0001\u0002\u0002\u0013\u0005\u0013qI\u0004\n\u0003Wb\u0012\u0011!E\u0001\u0003[2\u0001b\u0007\u000f\u0002\u0002#\u0005\u0011q\u000e\u0005\u0007\u0015V!\t!a\"\t\u0013\u0005%U#!A\u0005F\u0005-\u0005\"CAG+\u0005\u0005I\u0011QAH\u0011%\t)*FA\u0001\n\u0003\u000b9\nC\u0005\u0002*V\t\t\u0011\"\u0003\u0002,\nQ\u0001\fU1uQ\u001acw.\u0019;\u000b\u0005uq\u0012a\u0001=nY*\u0011q\u0004I\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\"E\u0005A1-\u0019;bYf\u001cHO\u0003\u0002$I\u0005\u00191/\u001d7\u000b\u0005\u00152\u0013!B:qCJ\\'BA\u0014)\u0003\u0019\t\u0007/Y2iK*\t\u0011&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001YA2\u0004CA\u0017/\u001b\u0005a\u0012BA\u0018\u001d\u00051A\u0006+\u0019;i\u000bb$(/Y2u!\t\tD'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\u001d\u0001&o\u001c3vGR\u0004\"aN \u000f\u0005ajdBA\u001d=\u001b\u0005Q$BA\u001e+\u0003\u0019a$o\\8u}%\t1'\u0003\u0002?e\u00059\u0001/Y2lC\u001e,\u0017B\u0001!B\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tq$'F\u0001D!\t!U)D\u0001\u001f\u0013\t1eD\u0001\u0006FqB\u0014Xm]:j_:\fA\u0001_7mA\u0005!\u0001/\u0019;i\u0003\u0015\u0001\u0018\r\u001e5!\u0003\u0019a\u0014N\\5u}Q\u0019A*\u0014(\u0011\u00055\u0002\u0001\"B\u000f\u0006\u0001\u0004\u0019\u0005\"\u0002%\u0006\u0001\u0004\u0019\u0015A\u00039sKR$\u0018PT1nKV\t\u0011\u000b\u0005\u0002S-:\u00111\u000b\u0016\t\u0003sIJ!!\u0016\u001a\u0002\rA\u0013X\rZ3g\u0013\t9\u0006L\u0001\u0004TiJLgn\u001a\u0006\u0003+J\n\u0001\u0002Z1uCRK\b/Z\u000b\u00027B\u0011AlX\u0007\u0002;*\u0011aLI\u0001\u0006if\u0004Xm]\u0005\u0003Av\u0013\u0001\u0002R1uCRK\b/Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004G\u001a<\u0007CA\u0019e\u0013\t)'GA\u0002B]fDQ!\b\u0005A\u0002\rDQ\u0001\u0013\u0005A\u0002\r\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u00071SG\u000eC\u0003l\u0013\u0001\u00071)A\u0004oK^dUM\u001a;\t\u000b5L\u0001\u0019A\"\u0002\u00119,wOU5hQR\fAaY8qsR\u0019A\n]9\t\u000fuQ\u0001\u0013!a\u0001\u0007\"9\u0001J\u0003I\u0001\u0002\u0004\u0019\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0002i*\u00121)^\u0016\u0002mB\u0011q\u000f`\u0007\u0002q*\u0011\u0011P_\u0001\nk:\u001c\u0007.Z2lK\u0012T!a\u001f\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002~q\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0001\u0011\t\u0005\u0015\u0011qB\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005!A.\u00198h\u0015\t\ti!\u0001\u0003kCZ\f\u0017bA,\u0002\b\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0003\t\u0004c\u0005]\u0011bAA\re\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u00191-a\b\t\u0013\u0005\u0005r\"!AA\u0002\u0005U\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002(A)\u0011\u0011FA\u0018G6\u0011\u00111\u0006\u0006\u0004\u0003[\u0011\u0014AC2pY2,7\r^5p]&!\u0011\u0011GA\u0016\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005]\u0012Q\b\t\u0004c\u0005e\u0012bAA\u001ee\t9!i\\8mK\u0006t\u0007\u0002CA\u0011#\u0005\u0005\t\u0019A2\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u0007\t\u0019\u0005C\u0005\u0002\"I\t\t\u00111\u0001\u0002\u0016\u00051Q-];bYN$B!a\u000e\u0002J!A\u0011\u0011E\n\u0002\u0002\u0003\u00071\rK\n\u0001\u0003\u001b\n\u0019&!\u0016\u0002Z\u0005m\u0013qLA1\u0003K\n9\u0007E\u0002E\u0003\u001fJ1!!\u0015\u001f\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a\u0016\u0002\u0003'yf)\u0016(D?\"BX\u000e\u001c\u0017!qB\fG\u000f[\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\r\t4m_\u0006$\bE^1mk\u0016d\u0003\u0005\u001e5fAY\fG.^3!u\u0016\u0014x\u000eI5gA9|\u0007%\\1uG\"\u0004\u0013n\u001d\u0011g_VtG\r\f\u0011pe\u0002r\u0015M\u0014\u0011jM\u0002\n\u0007%\\1uG\"\u0004\u0013n\u001d\u0011g_VtG\r\t2vi\u0002\"\b.\u001a\u0011wC2,X\rI5tA9|g.\f8v[\u0016\u0014\u0018n\u0019\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!\u0018\u00025*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005P1?y\tt\u0014\u0007P\u0018c}q\u0012gH\r\u001f0Ezbt&\u0019 (Y\u0001:3/^7)C>\u0012\u0017fJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AMr\u0003G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t\u0019'A\u00033]Ar\u0003'A\u0003he>,\b/\t\u0002\u0002j\u0005I\u00010\u001c7`MVt7m]\u0001\u000b1B\u000bG\u000f\u001b$m_\u0006$\bCA\u0017\u0016'\u0015)\u0012\u0011OA?!\u001d\t\u0019(!\u001fD\u00072k!!!\u001e\u000b\u0007\u0005]$'A\u0004sk:$\u0018.\\3\n\t\u0005m\u0014Q\u000f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BA@\u0003\u000bk!!!!\u000b\t\u0005\r\u00151B\u0001\u0003S>L1\u0001QAA)\t\ti'\u0001\u0005u_N#(/\u001b8h)\t\t\u0019!A\u0003baBd\u0017\u0010F\u0003M\u0003#\u000b\u0019\nC\u0003\u001e1\u0001\u00071\tC\u0003I1\u0001\u00071)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005e\u0015Q\u0015\t\u0006c\u0005m\u0015qT\u0005\u0004\u0003;\u0013$AB(qi&|g\u000eE\u00032\u0003C\u001b5)C\u0002\u0002$J\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAT3\u0005\u0005\t\u0019\u0001'\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002.B!\u0011QAAX\u0013\u0011\t\t,a\u0002\u0003\r=\u0013'.Z2u\u0001")
public class XPathFloat
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Option<Tuple2<Expression, Expression>> unapply(XPathFloat x$0) {
        return XPathFloat$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, XPathFloat> tupled() {
        return XPathFloat$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathFloat>> curried() {
        return XPathFloat$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath_float";
    }

    @Override
    public DataType dataType() {
        return FloatType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        Double ret = this.xpathUtil().evalNumber(((UTF8String)xml).toString(), this.pathString());
        if (ret == null) {
            return null;
        }
        return BoxesRunTime.boxToFloat((float)ret.floatValue());
    }

    @Override
    public XPathFloat withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public XPathFloat copy(Expression xml, Expression path) {
        return new XPathFloat(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathFloat";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.xml();
            }
            case 1: {
                return this.path();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathFloat;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "xml";
            }
            case 1: {
                return "path";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathFloat)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathFloat xPathFloat = (XPathFloat)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathFloat.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathFloat.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathFloat.canEqual(this)) return false;
        return true;
    }

    public XPathFloat(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

